/*
 * Decompiled with CFR 0.152.
 */
package com.ditchoom.buffer;

import com.ditchoom.buffer.AllocationZone;
import com.ditchoom.buffer.BufferFactoryAndroid;
import com.ditchoom.buffer.BufferFactoryKt;
import com.ditchoom.buffer.ByteOrder;
import com.ditchoom.buffer.Charset;
import com.ditchoom.buffer.PlatformBuffer;
import com.ditchoom.buffer.ReadBuffer;
import java.util.Collection;
import java.util.List;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u0005\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\n\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0001\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0007H\u0016J\b\u0010\u0011\u001a\u00020\u0007H\u0016J\b\u0010\u0012\u001a\u00020\u0007H\u0016J\u0010\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u0007H\u0016J\b\u0010\u0014\u001a\u00020\u0010H\u0016J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\u0011\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u0007H\u0096\u0002J/\u0010\u0019\u001a\u0002H\u001a\"\u0004\b\u0000\u0010\u001a2\u0006\u0010\u001b\u001a\u00020\u00072\u0012\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u0002H\u001a0\u001dH\u0002\u00a2\u0006\u0002\u0010\u001eJ\b\u0010\u001f\u001a\u00020\u0001H\u0016J\u0010\u0010 \u001a\u00020!2\u0006\u0010\u001b\u001a\u00020\u0007H\u0016J\b\u0010\"\u001a\u00020#H\u0016J\b\u0010$\u001a\u00020\u0007H\u0016J\b\u0010%\u001a\u00020&H\u0016J\u0018\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020\u00072\u0006\u0010*\u001a\u00020+H\u0016J\b\u0010,\u001a\u00020-H\u0016J\u0014\u0010.\u001a\u00020\u00102\f\u0010/\u001a\b\u0012\u0004\u0012\u00020100J\u0010\u00102\u001a\u0002012\b\b\u0002\u00103\u001a\u000204J\u001a\u00105\u001a\u00020\u00102\u0012\u00106\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00100\u001dR\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\u00a8\u00067"}, d2={"Lcom/ditchoom/buffer/FragmentedReadBuffer;", "Lcom/ditchoom/buffer/ReadBuffer;", "first", "second", "<init>", "(Lcom/ditchoom/buffer/ReadBuffer;Lcom/ditchoom/buffer/ReadBuffer;)V", "firstInitialLimit", "", "secondInitialLimit", "currentPosition", "currentLimit", "byteOrder", "Lcom/ditchoom/buffer/ByteOrder;", "getByteOrder", "()Lcom/ditchoom/buffer/ByteOrder;", "setLimit", "", "limit", "position", "newPosition", "resetForRead", "readByte", "", "get", "index", "readSizeIntoBuffer", "T", "size", "block", "Lkotlin/Function1;", "(ILkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "slice", "readByteArray", "", "readShort", "", "readInt", "readLong", "", "readString", "", "length", "charset", "Lcom/ditchoom/buffer/Charset;", "readUtf8Line", "", "getBuffers", "out", "", "Lcom/ditchoom/buffer/PlatformBuffer;", "toSingleBuffer", "zone", "Lcom/ditchoom/buffer/AllocationZone;", "walk", "visitor", "buffer_release"})
public final class FragmentedReadBuffer
implements ReadBuffer {
    @NotNull
    private final ReadBuffer first;
    @NotNull
    private final ReadBuffer second;
    private final int firstInitialLimit;
    private final int secondInitialLimit;
    private int currentPosition;
    private int currentLimit;

    public FragmentedReadBuffer(@NotNull ReadBuffer first, @NotNull ReadBuffer second) {
        Intrinsics.checkNotNullParameter((Object)first, (String)"first");
        Intrinsics.checkNotNullParameter((Object)second, (String)"second");
        this.first = first;
        this.second = second;
        this.firstInitialLimit = this.first.limit();
        this.secondInitialLimit = this.second.limit();
        this.currentLimit = this.firstInitialLimit + this.secondInitialLimit;
    }

    @Override
    @NotNull
    public ByteOrder getByteOrder() {
        throw new IllegalStateException("Byte order is undefined for FragmentedReadBuffer");
    }

    @Override
    public void setLimit(int limit) {
        if (limit <= this.firstInitialLimit + this.secondInitialLimit) {
            this.currentLimit = limit;
        }
    }

    @Override
    public int limit() {
        return this.currentLimit;
    }

    @Override
    public int position() {
        return this.currentPosition;
    }

    @Override
    public void position(int newPosition) {
        this.currentPosition = newPosition;
    }

    @Override
    public void resetForRead() {
        this.currentPosition = 0;
        this.first.resetForRead();
        this.second.resetForRead();
    }

    @Override
    public byte readByte() {
        int n = this.currentPosition;
        this.currentPosition = n + 1;
        return n < this.firstInitialLimit ? this.first.readByte() : this.second.readByte();
    }

    @Override
    public byte get(int index) {
        return this.currentPosition < this.firstInitialLimit ? this.first.readByte() : this.second.readByte();
    }

    private final <T> T readSizeIntoBuffer(int size, Function1<? super ReadBuffer, ? extends T> block) {
        Object object;
        if (this.currentPosition < this.firstInitialLimit && this.currentPosition + size <= this.firstInitialLimit) {
            object = block.invoke((Object)this.first);
        } else if (this.currentPosition < this.firstInitialLimit && this.currentPosition + size > this.firstInitialLimit) {
            int firstChunkSize = this.firstInitialLimit - this.currentPosition;
            int secondChunkSize = size - firstChunkSize;
            int secondBufferLimit = this.second.limit();
            this.second.setLimit(this.second.position() + secondChunkSize);
            PlatformBuffer buffer = BufferFactoryAndroid.allocate$default(PlatformBuffer.Companion, size, null, null, 6, null);
            buffer.write(this.first);
            buffer.write(this.second);
            this.second.setLimit(secondBufferLimit);
            buffer.resetForRead();
            object = block.invoke((Object)buffer);
        } else {
            object = block.invoke((Object)this.second);
        }
        Object buffer = object;
        this.currentPosition += size;
        return (T)buffer;
    }

    @Override
    @NotNull
    public ReadBuffer slice() {
        if (this.first.position() == 0 && this.first.limit() == 0) {
            return this.second;
        }
        if (this.second.position() == 0 && this.second.limit() == 0) {
            return this.first;
        }
        ReadBuffer first = this.first.slice();
        ReadBuffer second = this.second.slice();
        PlatformBuffer buffer = BufferFactoryAndroid.allocate$default(PlatformBuffer.Companion, first.limit() + second.limit(), null, null, 6, null);
        buffer.write(first);
        buffer.write(second);
        buffer.resetForRead();
        return buffer;
    }

    @Override
    @NotNull
    public byte[] readByteArray(int size) {
        return (byte[])this.readSizeIntoBuffer(size, arg_0 -> FragmentedReadBuffer.readByteArray$lambda$0(size, arg_0));
    }

    @Override
    public short readShort() {
        return ((Number)this.readSizeIntoBuffer(2, FragmentedReadBuffer::readShort$lambda$1)).shortValue();
    }

    @Override
    public int readInt() {
        return ((Number)this.readSizeIntoBuffer(4, FragmentedReadBuffer::readInt$lambda$2)).intValue();
    }

    @Override
    public long readLong() {
        return ((Number)this.readSizeIntoBuffer(8, FragmentedReadBuffer::readLong$lambda$3)).longValue();
    }

    @Override
    @NotNull
    public String readString(int length, @NotNull Charset charset) {
        Intrinsics.checkNotNullParameter((Object)((Object)charset), (String)"charset");
        return (String)this.readSizeIntoBuffer(length, arg_0 -> FragmentedReadBuffer.readString$lambda$4(length, charset, arg_0));
    }

    @Override
    @NotNull
    public CharSequence readUtf8Line() {
        if (this.currentPosition < this.firstInitialLimit) {
            CharSequence charSequence;
            int initialFirstPosition = this.first.position();
            CharSequence firstUtf8 = this.first.readUtf8Line();
            int bytesRead = this.first.position() - initialFirstPosition;
            if ((long)BufferFactoryKt.utf8Length(((Object)firstUtf8).toString()) == (long)bytesRead) {
                this.currentPosition = this.firstInitialLimit;
                int secondInitialPosition = this.second.position();
                CharSequence secondLine = this.second.readUtf8Line();
                this.currentPosition += this.second.position() - secondInitialPosition;
                StringBuilder stringBuilder = new StringBuilder(firstUtf8).append(secondLine);
                Intrinsics.checkNotNull((Object)stringBuilder);
                charSequence = stringBuilder;
            } else {
                charSequence = firstUtf8;
            }
            return charSequence;
        }
        int secondInitialPosition = this.second.position();
        CharSequence line = this.second.readUtf8Line();
        this.currentPosition += this.second.position() - secondInitialPosition;
        return line;
    }

    public final void getBuffers(@NotNull List<PlatformBuffer> out) {
        Intrinsics.checkNotNullParameter(out, (String)"out");
        if (this.first instanceof FragmentedReadBuffer) {
            ((FragmentedReadBuffer)this.first).getBuffers(out);
        } else if (this.first instanceof PlatformBuffer) {
            ((Collection)out).add(this.first);
        }
        if (this.second instanceof FragmentedReadBuffer) {
            ((FragmentedReadBuffer)this.second).getBuffers(out);
        } else if (this.second instanceof PlatformBuffer) {
            ((Collection)out).add(this.second);
        }
    }

    @NotNull
    public final PlatformBuffer toSingleBuffer(@NotNull AllocationZone zone) {
        Intrinsics.checkNotNullParameter((Object)zone, (String)"zone");
        int firstLimit = this.firstInitialLimit;
        int secondLimit = this.secondInitialLimit;
        int initialPosition = this.position();
        PlatformBuffer buffer = BufferFactoryAndroid.allocate$default(PlatformBuffer.Companion, firstLimit + secondLimit - initialPosition, zone, null, 4, null);
        this.walk((Function1<? super ReadBuffer, Unit>)((Function1)arg_0 -> FragmentedReadBuffer.toSingleBuffer$lambda$5(buffer, arg_0)));
        buffer.position(initialPosition);
        return buffer;
    }

    public static /* synthetic */ PlatformBuffer toSingleBuffer$default(FragmentedReadBuffer fragmentedReadBuffer, AllocationZone allocationZone, int n, Object object) {
        if ((n & 1) != 0) {
            allocationZone = AllocationZone.Heap.INSTANCE;
        }
        return fragmentedReadBuffer.toSingleBuffer(allocationZone);
    }

    public final void walk(@NotNull Function1<? super ReadBuffer, Unit> visitor) {
        Intrinsics.checkNotNullParameter(visitor, (String)"visitor");
        if (this.first instanceof FragmentedReadBuffer) {
            ((FragmentedReadBuffer)this.first).walk(visitor);
        } else {
            visitor.invoke((Object)this.first);
        }
        if (this.second instanceof FragmentedReadBuffer) {
            ((FragmentedReadBuffer)this.second).walk(visitor);
        } else {
            visitor.invoke((Object)this.second);
        }
    }

    @Override
    @NotNull
    public ReadBuffer readBytes(int size) {
        return ReadBuffer.DefaultImpls.readBytes(this, size);
    }

    @Override
    public byte readUnsignedByte-w2LRezQ() {
        return ReadBuffer.DefaultImpls.readUnsignedByte-w2LRezQ(this);
    }

    @Override
    public byte getUnsignedByte-Wa3L5BU(int index) {
        return ReadBuffer.DefaultImpls.getUnsignedByte-Wa3L5BU(this, index);
    }

    @Override
    public short getShort(int index) {
        return ReadBuffer.DefaultImpls.getShort(this, index);
    }

    @Override
    public short readUnsignedShort-Mh2AYeg() {
        return ReadBuffer.DefaultImpls.readUnsignedShort-Mh2AYeg(this);
    }

    @Override
    public short getUnsignedShort-BwKQO78(int index) {
        return ReadBuffer.DefaultImpls.getUnsignedShort-BwKQO78(this, index);
    }

    @Override
    public int getInt(int index) {
        return ReadBuffer.DefaultImpls.getInt(this, index);
    }

    @Override
    public int readUnsignedInt-pVg5ArA() {
        return ReadBuffer.DefaultImpls.readUnsignedInt-pVg5ArA(this);
    }

    @Override
    public int getUnsignedInt-OGnWXxg(int index) {
        return ReadBuffer.DefaultImpls.getUnsignedInt-OGnWXxg(this, index);
    }

    @Override
    public float readFloat() {
        return ReadBuffer.DefaultImpls.readFloat(this);
    }

    @Override
    public float getFloat(int index) {
        return ReadBuffer.DefaultImpls.getFloat(this, index);
    }

    @Override
    public long getLong(int index) {
        return ReadBuffer.DefaultImpls.getLong(this, index);
    }

    @Override
    public long readUnsignedLong-s-VKNKU() {
        return ReadBuffer.DefaultImpls.readUnsignedLong-s-VKNKU(this);
    }

    @Override
    public long getUnsignedLong-I7RO_PI(int index) {
        return ReadBuffer.DefaultImpls.getUnsignedLong-I7RO_PI(this, index);
    }

    @Override
    public double readDouble() {
        return ReadBuffer.DefaultImpls.readDouble(this);
    }

    @Override
    public double getDouble(int index) {
        return ReadBuffer.DefaultImpls.getDouble(this, index);
    }

    @Override
    @Deprecated(message="Use readString instead", replaceWith=@ReplaceWith(expression="readString(bytes, Charset.UTF8)", imports={"com.ditchoom.buffer.Charset"}))
    @NotNull
    public CharSequence readUtf8-WZ4Q5Ns(int bytes) {
        return ReadBuffer.DefaultImpls.readUtf8-WZ4Q5Ns(this, bytes);
    }

    @Override
    @Deprecated(message="Use readString instead", replaceWith=@ReplaceWith(expression="readString(bytes, Charset.UTF8)", imports={"com.ditchoom.buffer.Charset"}))
    @NotNull
    public CharSequence readUtf8(int bytes) {
        return ReadBuffer.DefaultImpls.readUtf8(this, bytes);
    }

    @Override
    public long readNumberWithByteSize(int numberOfBytes) {
        return ReadBuffer.DefaultImpls.readNumberWithByteSize(this, numberOfBytes);
    }

    @Override
    public long getNumberWithStartIndexAndByteSize(int startIndex, int numberOfBytes) {
        return ReadBuffer.DefaultImpls.getNumberWithStartIndexAndByteSize(this, startIndex, numberOfBytes);
    }

    @Override
    public int remaining() {
        return ReadBuffer.DefaultImpls.remaining(this);
    }

    @Override
    public boolean hasRemaining() {
        return ReadBuffer.DefaultImpls.hasRemaining(this);
    }

    private static final byte[] readByteArray$lambda$0(int $size, ReadBuffer it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.readByteArray($size);
    }

    private static final short readShort$lambda$1(ReadBuffer it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.readShort();
    }

    private static final int readInt$lambda$2(ReadBuffer it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.readInt();
    }

    private static final long readLong$lambda$3(ReadBuffer it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.readLong();
    }

    private static final String readString$lambda$4(int $length, Charset $charset, ReadBuffer it) {
        Intrinsics.checkNotNullParameter((Object)((Object)$charset), (String)"$charset");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.readString($length, $charset);
    }

    private static final Unit toSingleBuffer$lambda$5(PlatformBuffer $buffer, ReadBuffer it) {
        Intrinsics.checkNotNullParameter((Object)$buffer, (String)"$buffer");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        $buffer.write(it);
        return Unit.INSTANCE;
    }
}

