/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.spotless.yaml;

import com.diffplug.spotless.FormatterFunc;
import com.diffplug.spotless.FormatterStep;
import com.diffplug.spotless.JarState;
import com.diffplug.spotless.Provisioner;
import com.diffplug.spotless.yaml.JacksonYamlConfig;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Objects;

public final class JacksonYamlStep
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String MAVEN_COORDINATE = "com.fasterxml.jackson.dataformat:jackson-dataformat-yaml:";
    private static final String DEFAULT_VERSION = "2.14.1";
    public static final String NAME = "jacksonYaml";
    private final JarState.Promised jarState;
    private final JacksonYamlConfig jacksonConfig;

    private JacksonYamlStep(JarState.Promised jarState, JacksonYamlConfig jacksonConfig) {
        this.jarState = jarState;
        this.jacksonConfig = jacksonConfig;
    }

    public static String defaultVersion() {
        return DEFAULT_VERSION;
    }

    public static FormatterStep create(JacksonYamlConfig jacksonConfig, String jacksonVersion, Provisioner provisioner) {
        Objects.requireNonNull(jacksonConfig, "jacksonConfig cannot be null");
        Objects.requireNonNull(provisioner, "provisioner cannot be null");
        return FormatterStep.create(NAME, new JacksonYamlStep(JarState.promise(() -> JarState.from(MAVEN_COORDINATE + jacksonVersion, provisioner)), jacksonConfig), JacksonYamlStep::equalityState, State::toFormatter);
    }

    public static FormatterStep create(Provisioner provisioner) {
        return JacksonYamlStep.create(new JacksonYamlConfig(), JacksonYamlStep.defaultVersion(), provisioner);
    }

    private State equalityState() {
        return new State(this.jarState.get(), this.jacksonConfig);
    }

    private static final class State
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final JacksonYamlConfig jacksonConfig;
        private final JarState jarState;

        State(JarState jarState, JacksonYamlConfig jacksonConfig) {
            this.jarState = jarState;
            this.jacksonConfig = jacksonConfig;
        }

        FormatterFunc toFormatter() throws ClassNotFoundException, NoSuchMethodException, InvocationTargetException, InstantiationException, IllegalAccessException {
            Class<?> formatterFunc = this.jarState.getClassLoader().loadClass("com.diffplug.spotless.glue.yaml.JacksonYamlFormatterFunc");
            Constructor<?> constructor = formatterFunc.getConstructor(JacksonYamlConfig.class);
            return (FormatterFunc)constructor.newInstance(this.jacksonConfig);
        }
    }
}

