/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.spotless.generic;

import com.diffplug.spotless.FileSignature;
import com.diffplug.spotless.FormatterFunc;
import com.diffplug.spotless.FormatterStep;
import com.diffplug.spotless.ProcessRunner;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class NativeCmdStep {
    private NativeCmdStep() {
    }

    public static FormatterStep create(String name, File pathToExe, List<String> arguments) {
        Objects.requireNonNull(name, "name");
        Objects.requireNonNull(pathToExe, "pathToExe");
        return FormatterStep.createLazy(name, () -> new State(FileSignature.promise(pathToExe), arguments), State::toRuntime, Runtime::toFunc);
    }

    static class State
    implements Serializable {
        private static final long serialVersionUID = 2L;
        final FileSignature.Promised pathToExe;
        final List<String> arguments;

        State(FileSignature.Promised pathToExe, List<String> arguments) {
            this.pathToExe = pathToExe;
            this.arguments = arguments;
        }

        Runtime toRuntime() {
            return new Runtime(this.pathToExe.get().getOnlyFile(), this.arguments);
        }
    }

    static class Runtime
    implements Serializable {
        private static final long serialVersionUID = 2L;
        final File pathToExe;
        final List<String> arguments;

        Runtime(File pathToExe, List<String> arguments) {
            this.pathToExe = pathToExe;
            this.arguments = arguments;
        }

        String format(ProcessRunner runner, String input) throws IOException, InterruptedException {
            ArrayList<String> argumentsWithPathToExe = new ArrayList<String>();
            argumentsWithPathToExe.add(this.pathToExe.getAbsolutePath());
            if (this.arguments != null) {
                argumentsWithPathToExe.addAll(this.arguments);
            }
            return runner.exec(input.getBytes(StandardCharsets.UTF_8), argumentsWithPathToExe).assertExitZero(StandardCharsets.UTF_8);
        }

        FormatterFunc.Closeable toFunc() {
            ProcessRunner runner = new ProcessRunner();
            return FormatterFunc.Closeable.of(runner, this::format);
        }
    }
}

