/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.spotless;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.Locale;
import java.util.Objects;

public abstract class GitPrePushHookInstaller {
    private static final String HOOK_HEADER = "##### SPOTLESS HOOK START #####";
    private static final String HOOK_FOOTER = "##### SPOTLESS HOOK END #####";
    private static final Object LOCK = new Object();
    private static volatile boolean installing = false;
    protected final GitPreHookLogger logger;
    protected final File root;

    public GitPrePushHookInstaller(GitPreHookLogger logger, File root) {
        this.logger = Objects.requireNonNull(logger, "logger can not be null");
        this.root = Objects.requireNonNull(root, "root file can not be null");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressFBWarnings(value={"ST_WRITE_TO_STATIC_FROM_INSTANCE_METHOD"}, justification="This is a safe usage of a static lock object")
    public void install() throws Exception {
        if (installing) {
            this.logger.warn("Parallel Spotless Git pre-push hook installation detected, skipping installation", new Object[0]);
            return;
        }
        Object object = LOCK;
        synchronized (object) {
            if (installing) {
                this.logger.warn("Parallel Spotless Git pre-push hook installation detected, skipping installation", new Object[0]);
                return;
            }
            try {
                installing = true;
                this.doInstall();
            }
            finally {
                installing = false;
            }
        }
    }

    private void doInstall() throws Exception {
        this.logger.info("Installing git pre-push hook", new Object[0]);
        if (!this.isGitInstalled()) {
            this.logger.error("Git not found in root directory", new Object[0]);
            return;
        }
        Object hookContent = "";
        File gitHookFile = this.root.toPath().resolve(".git/hooks/pre-push").toFile();
        if (!gitHookFile.exists()) {
            this.logger.info("Git pre-push hook not found, creating it", new Object[0]);
            if (!gitHookFile.getParentFile().exists() && !gitHookFile.getParentFile().mkdirs()) {
                this.logger.error("Failed to create pre-push hook directory", new Object[0]);
                return;
            }
            if (!gitHookFile.createNewFile()) {
                this.logger.error("Failed to create pre-push hook file", new Object[0]);
                return;
            }
            if (!gitHookFile.setExecutable(true, false)) {
                this.logger.error("Can not make file executable", new Object[0]);
                return;
            }
            hookContent = (String)hookContent + "#!/bin/sh\n";
        }
        if (this.isGitHookInstalled(gitHookFile)) {
            this.logger.info("Git pre-push hook already installed, reinstalling it", new Object[0]);
            this.uninstall(gitHookFile);
        }
        hookContent = (String)hookContent + this.preHookContent();
        this.writeFile(gitHookFile, (String)hookContent, true);
        this.logger.info("Git pre-push hook installed successfully to the file %s", gitHookFile.getAbsolutePath());
    }

    private void uninstall(File gitHookFile) throws Exception {
        String hook = Files.readString(gitHookFile.toPath(), StandardCharsets.UTF_8);
        int hookStart = hook.indexOf(HOOK_HEADER);
        int hookEnd = hook.indexOf(HOOK_FOOTER) + HOOK_FOOTER.length();
        Object hookScript = hook.substring(hookStart, hookEnd);
        if (hookStart >= 1 && hook.charAt(hookStart - 1) == '\n') {
            hookScript = "\n" + (String)hookScript;
        }
        if (hookStart >= 2 && hook.charAt(hookStart - 2) == '\n') {
            hookScript = "\n" + (String)hookScript;
        }
        if (hook.charAt(hookEnd) == '\n') {
            hookScript = (String)hookScript + "\n";
        }
        String uninstalledHook = hook.replace((CharSequence)hookScript, "");
        this.writeFile(gitHookFile, uninstalledHook, false);
    }

    protected abstract String preHookContent();

    protected String preHookTemplate(Executor executor, String commandCheck, String commandApply) {
        Object spotlessHook = "";
        spotlessHook = (String)spotlessHook + "\n";
        spotlessHook = (String)spotlessHook + "\n##### SPOTLESS HOOK START #####";
        spotlessHook = (String)spotlessHook + "\nSPOTLESS_EXECUTOR=" + this.executorPath(executor);
        spotlessHook = (String)spotlessHook + "\nif ! $SPOTLESS_EXECUTOR " + commandCheck + " ; then";
        spotlessHook = (String)spotlessHook + "\n    echo 1>&2 \"spotless found problems, running " + commandApply + "; commit the result and re-push\"";
        spotlessHook = (String)spotlessHook + "\n    $SPOTLESS_EXECUTOR " + commandApply;
        spotlessHook = (String)spotlessHook + "\n    exit 1";
        spotlessHook = (String)spotlessHook + "\nfi";
        spotlessHook = (String)spotlessHook + "\n##### SPOTLESS HOOK END #####";
        spotlessHook = (String)spotlessHook + "\n";
        return spotlessHook;
    }

    private String executorPath(Executor executor) {
        File wrapper = this.executorWrapperFile(executor);
        if (wrapper.exists()) {
            return "./" + wrapper.getName();
        }
        this.logger.info("Local %s wrapper (%s) not found, falling back to global command '%s'", executor.name().toLowerCase(Locale.ROOT), executor.wrapper, executor.global);
        return executor.global;
    }

    private File executorWrapperFile(Executor executor) {
        if (this.isWindows()) {
            File bat = this.root.toPath().resolve(executor.wrapper + ".bat").toFile();
            if (bat.exists()) {
                return bat;
            }
            return this.root.toPath().resolve(executor.wrapper + ".cmd").toFile();
        }
        return this.root.toPath().resolve(executor.wrapper).toFile();
    }

    private boolean isWindows() {
        return System.getProperty("os.name").toLowerCase(Locale.ROOT).startsWith("win");
    }

    private boolean isGitInstalled() {
        return this.root.toPath().resolve(".git/config").toFile().exists();
    }

    private boolean isGitHookInstalled(File gitHookFile) throws Exception {
        String hook = Files.readString(gitHookFile.toPath(), StandardCharsets.UTF_8);
        return hook.contains(HOOK_HEADER) && hook.contains(HOOK_FOOTER);
    }

    private void writeFile(File file, String content, boolean append) throws IOException {
        try (FileWriter writer = new FileWriter(file, StandardCharsets.UTF_8, append);){
            writer.write(content);
        }
    }

    public static interface GitPreHookLogger {
        public void info(String var1, Object ... var2);

        public void warn(String var1, Object ... var2);

        public void error(String var1, Object ... var2);
    }

    public static enum Executor {
        GRADLE("gradlew", "gradle"),
        MAVEN("mvnw", "mvn");

        public final String wrapper;
        public final String global;

        private Executor(String wrapper, String global) {
            this.wrapper = wrapper;
            this.global = global;
        }
    }
}

