/*
 * Decompiled with CFR 0.152.
 */
package com.devonfw.module.web.common.base.debug;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Locale;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class HttpEchoServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static final String SECURED = "****SECURED****";
    private static final String COOKIE_SECURED = "=****SECURED****";

    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String uri = request.getRequestURI();
        response.setContentType("text/html");
        PrintWriter out = response.getWriter();
        out.print("<!DOCTYPE html><html><head><title>Debugausgabe von ");
        out.print(uri);
        out.println("</title></head><body><h1>");
        out.print(request.getMethod());
        out.print(' ');
        out.print(uri);
        String query = request.getQueryString();
        if (query != null) {
            out.print('?');
            out.print(query);
        }
        out.println();
        out.println("</h1><h2>Headers:</h2><pre>");
        this.printHeaders(request, out);
        out.println("</pre><h2>Payload:</h2><pre>");
        BufferedReader in = request.getReader();
        String line = in.readLine();
        if (line == null) {
            out.println("no data");
        }
        while (line != null) {
            out.println(line);
            line = in.readLine();
        }
        out.println("</pre></body></html>");
    }

    private void printHeaders(HttpServletRequest request, PrintWriter out) {
        Enumeration headerNames = request.getHeaderNames();
        while (headerNames.hasMoreElements()) {
            String name = (String)headerNames.nextElement();
            Enumeration headerValues = request.getHeaders(name);
            while (headerValues.hasMoreElements()) {
                String value = (String)headerValues.nextElement();
                out.print(name);
                out.print(": ");
                out.print(this.getSecuredValue(name, value));
                out.println();
            }
        }
    }

    private String getSecuredValue(String originalHeaderName, String value) {
        String nameLowercase = originalHeaderName.toLowerCase(Locale.US);
        if ("authorization".equals(nameLowercase)) {
            return SECURED;
        }
        if ("proxy-authorization".equals(nameLowercase)) {
            return SECURED;
        }
        if ("cookie".equals(nameLowercase) && value != null) {
            return value.replaceAll("=[^; ]*", COOKIE_SECURED);
        }
        return value;
    }
}

