/*
 * Decompiled with CFR 0.152.
 */
package com.devonfw.module.service.common.impl.header;

import com.devonfw.module.service.common.api.header.ServiceHeaderContext;
import com.devonfw.module.service.common.api.header.ServiceHeaderCustomizer;
import java.util.Map;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;

public class ServiceHeaderCustomizerOAuth
implements ServiceHeaderCustomizer {
    @Override
    public void addHeaders(ServiceHeaderContext<?> context) {
        String auth = context.getConfig().getChildValue("auth");
        if (!"oauth".equals(auth)) {
            return;
        }
        SecurityContext securityContext = SecurityContextHolder.getContext();
        if (securityContext == null) {
            return;
        }
        Authentication authentication = securityContext.getAuthentication();
        if (authentication == null) {
            return;
        }
        Object details = authentication.getDetails();
        if (!(details instanceof Map)) {
            return;
        }
        Map map = (Map)details;
        Object oauthToken = map.get("oauth.token");
        if (oauthToken == null) {
            return;
        }
        String authorizationHeader = "Bearer " + oauthToken;
        context.setHeader("Authorization", authorizationHeader);
    }
}

