/*
 * Decompiled with CFR 0.152.
 */
package com.devonfw.module.security.common.impl.rest;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.http.server.ServletServerHttpRequest;
import org.springframework.security.authentication.AuthenticationServiceException;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.web.authentication.AbstractAuthenticationProcessingFilter;
import org.springframework.security.web.util.matcher.RequestMatcher;

public class JsonUsernamePasswordAuthenticationFilter
extends AbstractAuthenticationProcessingFilter {
    private String usernameParameter = "username";
    private String passwordParameter = "password";
    private boolean postOnly = true;
    private ObjectMapper objectMapper = new ObjectMapper();

    public JsonUsernamePasswordAuthenticationFilter(RequestMatcher requiresAuthenticationRequestMatcher) {
        super(requiresAuthenticationRequestMatcher);
    }

    public Authentication attemptAuthentication(HttpServletRequest request, HttpServletResponse response) throws AuthenticationException, IOException, ServletException {
        if (this.postOnly && !request.getMethod().equals("POST")) {
            throw new AuthenticationServiceException("Authentication method not supported: " + request.getMethod());
        }
        UsernameAndPasswordParser usernameAndPasswordParser = new UsernameAndPasswordParser(request);
        usernameAndPasswordParser.parse();
        UsernamePasswordAuthenticationToken authRequest = new UsernamePasswordAuthenticationToken((Object)usernameAndPasswordParser.getTrimmedUsername(), (Object)usernameAndPasswordParser.getPassword());
        return this.getAuthenticationManager().authenticate((Authentication)authRequest);
    }

    public String getUsernameParameter() {
        return this.usernameParameter;
    }

    public void setUsernameParameter(String usernameParameter) {
        this.usernameParameter = usernameParameter;
    }

    public String getPasswordParameter() {
        return this.passwordParameter;
    }

    public void setPasswordParameter(String passwordParameter) {
        this.passwordParameter = passwordParameter;
    }

    public boolean isPostOnly() {
        return this.postOnly;
    }

    public void setPostOnly(boolean postOnly) {
        this.postOnly = postOnly;
    }

    private class UsernameAndPasswordParser {
        private String username;
        private String password;
        private final HttpServletRequest request;
        private JsonNode credentialsNode;

        private UsernameAndPasswordParser(HttpServletRequest request) {
            this.request = request;
        }

        public void parse() {
            this.parseJsonFromRequestBody();
            if (this.jsonParsedSuccessfully()) {
                this.extractUsername();
                this.extractPassword();
            }
        }

        private void extractPassword() {
            this.password = this.extractValueByName(JsonUsernamePasswordAuthenticationFilter.this.passwordParameter);
        }

        private void extractUsername() {
            this.username = this.extractValueByName(JsonUsernamePasswordAuthenticationFilter.this.usernameParameter);
        }

        private String extractValueByName(String name) {
            JsonNode node;
            String value = null;
            if (this.credentialsNode.has(name) && (node = this.credentialsNode.get(name)) != null) {
                value = node.asText();
            }
            return value;
        }

        private boolean jsonParsedSuccessfully() {
            return this.credentialsNode != null;
        }

        private void parseJsonFromRequestBody() {
            try {
                ServletServerHttpRequest servletServerHttpRequest = new ServletServerHttpRequest(this.request);
                this.credentialsNode = JsonUsernamePasswordAuthenticationFilter.this.objectMapper.readTree(servletServerHttpRequest.getBody());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        private String getTrimmedUsername() {
            return this.username == null ? "" : this.username.trim();
        }

        private String getPassword() {
            return this.password == null ? "" : this.password;
        }
    }
}

