/*
 * Decompiled with CFR 0.152.
 */
package com.devonfw.module.json.common.base.type;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;

public class PageableJsonDeserializer
extends JsonDeserializer<Pageable> {
    static final String PROPERTY_DIRECTION = "direction";
    static final String PROPERTY_PROPERTY = "property";
    static final String PROPERTY_SORT = "sort";
    static final String PROPERTY_PAGE_SIZE = "pageSize";
    static final String PROPERTY_PAGE_NUMBER = "pageNumber";

    public Pageable deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        JsonNode sortNode;
        JsonNode node = (JsonNode)jp.getCodec().readTree(jp);
        Sort sort = null;
        int pageNumber = 0;
        int pageSize = 1;
        if (node.get(PROPERTY_PAGE_NUMBER) != null) {
            pageNumber = node.get(PROPERTY_PAGE_NUMBER).asInt();
        }
        if (node.get(PROPERTY_PAGE_SIZE) != null) {
            pageSize = node.get(PROPERTY_PAGE_SIZE).asInt();
        }
        if ((sortNode = node.get(PROPERTY_SORT)) != null && !sortNode.isNull() && sortNode.isArray()) {
            Iterator iterator = sortNode.iterator();
            ArrayList<Sort.Order> sortingOrders = new ArrayList<Sort.Order>();
            while (iterator.hasNext()) {
                JsonNode next = (JsonNode)iterator.next();
                String property = PageableJsonDeserializer.getRequiredValue(next, PROPERTY_PROPERTY);
                String direction = PageableJsonDeserializer.getRequiredValue(next, PROPERTY_DIRECTION);
                sortingOrders.add(new Sort.Order(Sort.Direction.fromString((String)direction), property));
            }
            sort = Sort.by(sortingOrders);
        }
        return PageRequest.of((int)pageNumber, (int)pageSize, sort);
    }

    private static String getRequiredValue(JsonNode node, String property) {
        String value = PageableJsonDeserializer.getValue(node, property);
        if (value == null) {
            throw new IllegalStateException("Missing required property: " + property);
        }
        return value;
    }

    private static String getValue(JsonNode node, String property) {
        JsonNode childNode = node.get(property);
        if (childNode != null && !childNode.isNull()) {
            return childNode.asText();
        }
        return null;
    }
}

