/*
 * Decompiled with CFR 0.152.
 */
package com.devonfw.module.json.common.base;

import com.devonfw.module.basic.common.api.reference.IdRef;
import com.devonfw.module.json.common.base.MixInAnnotationsModule;
import com.devonfw.module.json.common.base.type.IdRefJsonDeserializer;
import com.devonfw.module.json.common.base.type.IdRefJsonSerializer;
import com.devonfw.module.json.common.base.type.JsonPage;
import com.devonfw.module.json.common.base.type.PageableJsonDeserializer;
import com.devonfw.module.json.common.base.type.PageableJsonSerializer;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.jsontype.NamedType;
import com.fasterxml.jackson.databind.jsontype.SubtypeResolver;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;

public class ObjectMapperFactory {
    static final String GROUP_ID = "com.devonfw.java";
    static final String ARTIFACT_ID = "devon4j-rest";
    private List<Class<?>> baseClassList;
    private List<NamedType> subtypeList;
    private SimpleModule extensionModule;

    public ObjectMapperFactory() {
        this.initMapping();
    }

    public SimpleModule getExtensionModule() {
        if (this.extensionModule == null) {
            this.extensionModule = new SimpleModule("devonfw.ExtensionModule", new Version(1, 0, 0, null, GROUP_ID, ARTIFACT_ID));
        }
        return this.extensionModule;
    }

    public void setBaseClasses(Class<?> ... baseClasses) {
        this.baseClassList = Arrays.asList(baseClasses);
    }

    public void addBaseClasses(Class<?> ... baseClasses) {
        if (this.baseClassList == null) {
            this.baseClassList = new ArrayList();
        }
        this.baseClassList.addAll(Arrays.asList(baseClasses));
    }

    public void setSubtypeList(List<NamedType> subtypeList) {
        this.subtypeList = subtypeList;
    }

    public void addSubtypes(NamedType ... subtypes) {
        if (this.subtypeList == null) {
            this.subtypeList = new ArrayList<NamedType>();
        }
        this.subtypeList.addAll(Arrays.asList(subtypes));
    }

    public void setSubtypes(NamedType ... subtypeList) {
        this.setSubtypeList(Arrays.asList(subtypeList));
    }

    public ObjectMapper createInstance() {
        ObjectMapper mapper = new ObjectMapper();
        if (this.baseClassList != null && !this.baseClassList.isEmpty()) {
            Class[] baseClasses = this.baseClassList.toArray(new Class[this.baseClassList.size()]);
            MixInAnnotationsModule polymorphyModule = new MixInAnnotationsModule(baseClasses);
            mapper.registerModule((Module)polymorphyModule);
        }
        if (this.extensionModule != null) {
            mapper.registerModule((Module)this.extensionModule);
        }
        if (this.subtypeList != null) {
            SubtypeResolver subtypeResolver = mapper.getSubtypeResolver();
            for (NamedType subtype : this.subtypeList) {
                subtypeResolver.registerSubtypes(new NamedType[]{subtype});
            }
            mapper.setSubtypeResolver(subtypeResolver);
        }
        mapper.registerModule((Module)new JavaTimeModule());
        return mapper;
    }

    protected SimpleModule initMapping() {
        SimpleModule module = this.getExtensionModule();
        module.addSerializer(Pageable.class, (JsonSerializer)new PageableJsonSerializer());
        module.addDeserializer(Pageable.class, (JsonDeserializer)new PageableJsonDeserializer());
        module.addAbstractTypeMapping(Page.class, JsonPage.class);
        module.setMixInAnnotation(Page.class, JsonPage.class);
        module.addSerializer(IdRef.class, (JsonSerializer)new IdRefJsonSerializer());
        module.addDeserializer(IdRef.class, (JsonDeserializer)new IdRefJsonDeserializer());
        return module;
    }
}

