/*
 * Decompiled with CFR 0.152.
 */
package com.devonfw.module.cxf.common.impl.server.soap;

import java.util.Map;
import javax.inject.Inject;
import javax.jws.WebService;
import org.apache.cxf.Bus;
import org.apache.cxf.bus.spring.SpringBus;
import org.apache.cxf.jaxws.EndpointImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.ws.config.annotation.EnableWs;
import org.springframework.ws.config.annotation.WsConfigurerAdapter;

@Configuration
@EnableWs
public class CxfServerSoapAutoConfiguration
extends WsConfigurerAdapter {
    private static final Logger LOG = LoggerFactory.getLogger(CxfServerSoapAutoConfiguration.class);
    @Inject
    private SpringBus springBus;
    @Inject
    private ConfigurableApplicationContext applicationContext;

    @Bean
    public Object registerWebServices() {
        Map webServiceMap = this.applicationContext.getBeansWithAnnotation(WebService.class);
        if (webServiceMap.isEmpty()) {
            LOG.info("No SOAP Services have been found. SOAP Endpoint will not be enabled in CXF.");
            return null;
        }
        ConfigurableListableBeanFactory beanFactory = this.applicationContext.getBeanFactory();
        for (Map.Entry serviceEntry : webServiceMap.entrySet()) {
            EndpointImpl endpoint = new EndpointImpl((Bus)this.springBus, serviceEntry.getValue());
            endpoint.publish("/ws/" + (String)serviceEntry.getKey());
            beanFactory.registerSingleton((String)serviceEntry.getKey() + "Endpoint", (Object)endpoint);
        }
        return null;
    }
}

