/*
 * Decompiled with CFR 0.152.
 */
package com.devonfw.module.cxf.common.impl.client.ws;

import com.devonfw.module.cxf.common.impl.client.SyncServiceClientFactoryCxf;
import com.devonfw.module.service.common.api.client.context.ServiceContext;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import javax.jws.WebService;
import javax.xml.namespace.QName;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.Service;
import org.apache.cxf.endpoint.Client;
import org.apache.cxf.frontend.ClientProxy;
import org.apache.cxf.interceptor.InterceptorProvider;
import org.apache.cxf.message.Message;
import org.apache.cxf.transport.Conduit;
import org.apache.cxf.transport.http.HTTPConduit;

public class SyncServiceClientFactoryCxfWs
extends SyncServiceClientFactoryCxf {
    private static final String WSDL_SUFFIX = "?wsdl";

    protected <S> S createService(ServiceContext<S> context, String url, String serviceName) {
        Class api = context.getApi();
        WebService webService = api.getAnnotation(WebService.class);
        QName qname = new QName(this.getNamespace(api, webService), this.getLocalName(api, webService));
        boolean downloadWsdl = context.getConfig().getChild("wsdl").getChild("disable-download").getValueAsBoolean();
        URL wsdlUrl = null;
        if (downloadWsdl) {
            try {
                wsdlUrl = new URL(url);
            }
            catch (MalformedURLException e) {
                throw new IllegalArgumentException("Illegal URL: " + url, e);
            }
        }
        Object serviceClient = Service.create(wsdlUrl, (QName)qname).getPort(api);
        if (!downloadWsdl) {
            BindingProvider bindingProvider = (BindingProvider)serviceClient;
            bindingProvider.getRequestContext().put("javax.xml.ws.service.endpoint.address", url);
        }
        return (S)serviceClient;
    }

    protected <S> void applyAspects(ServiceContext<S> context, S serviceClient, String serviceName) {
        Client cxfClient = ClientProxy.getClient(serviceClient);
        this.applyInterceptors(context, (InterceptorProvider)cxfClient, serviceName);
        Conduit conduit = cxfClient.getConduit();
        if (conduit instanceof HTTPConduit) {
            HTTPConduit httpConduit = (HTTPConduit)conduit;
            this.applyClientPolicy(context, httpConduit);
        }
        this.applyHeaders(context, cxfClient);
    }

    protected String getServiceTypeFolderName() {
        return "ws";
    }

    protected String getUrl(ServiceContext<?> context) {
        String url = super.getUrl(context);
        if (!url.endsWith(WSDL_SUFFIX)) {
            String serviceName = context.getApi().getSimpleName();
            if (!url.endsWith(serviceName)) {
                if (!url.endsWith("/")) {
                    url = url + "/";
                }
                url = url + serviceName;
            }
            url = url + WSDL_SUFFIX;
        }
        return url;
    }

    private String getLocalName(Class<?> api, WebService webService) {
        String portName = webService.portName();
        if (portName.isEmpty()) {
            return api.getSimpleName();
        }
        return portName;
    }

    private String getNamespace(Class<?> api, WebService webService) {
        String targetNamespace = webService.targetNamespace();
        if (targetNamespace.isEmpty()) {
            return api.getPackage().getName();
        }
        return targetNamespace;
    }

    protected void applyHeaders(ServiceContext<?> context, Object client) {
        Collection headerNames = context.getHeaderNames();
        if (!headerNames.isEmpty()) {
            HashMap<String, List<String>> headers = new HashMap<String, List<String>>();
            for (String headerName : headerNames) {
                headers.put(headerName, Arrays.asList(context.getHeader(headerName)));
            }
            ((Client)client).getRequestContext().put(Message.PROTOCOL_HEADERS, headers);
        }
    }

    protected boolean isResponsibleForService(ServiceContext<?> context) {
        return context.getApi().isAnnotationPresent(WebService.class);
    }
}

