/*
 * Decompiled with CFR 0.152.
 */
package com.shiqi.quickjs;

import androidx.annotation.Nullable;
import com.shiqi.quickjs.JSContext;
import com.shiqi.quickjs.JSNull;
import com.shiqi.quickjs.JSUndefined;
import com.shiqi.quickjs.JSValue;
import com.shiqi.quickjs.QuickJS;
import java.lang.reflect.Type;

public abstract class TypeAdapter<T> {
    public abstract JSValue toJSValue(JSContext var1, T var2);

    public abstract T fromJSValue(JSContext var1, JSValue var2);

    public final TypeAdapter<T> nullable() {
        return new NullableTypeAdapter(this);
    }

    private static class NullableTypeAdapter<T>
    extends TypeAdapter<T> {
        private final TypeAdapter<T> delegate;

        NullableTypeAdapter(TypeAdapter<T> delegate) {
            this.delegate = delegate;
        }

        @Override
        public JSValue toJSValue(JSContext context, T value) {
            if (value == null) {
                return context.createJSNull();
            }
            return this.delegate.toJSValue(context, value);
        }

        @Override
        public T fromJSValue(JSContext context, JSValue value) {
            if (value instanceof JSNull || value instanceof JSUndefined) {
                return null;
            }
            return this.delegate.fromJSValue(context, value);
        }
    }

    public static interface Factory {
        @Nullable
        public TypeAdapter<?> create(QuickJS var1, Type var2);
    }
}

