/*
 * Decompiled with CFR 0.152.
 */
package com.shiqi.quickjs;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.Arrays;
import java.util.NoSuchElementException;

class JavaTypes {
    JavaTypes() {
    }

    public static ParameterizedType newParameterizedType(Type rawType, Type ... typeArguments) {
        return new ParameterizedTypeImpl(null, rawType, typeArguments);
    }

    public static ParameterizedType newParameterizedTypeWithOwner(Type ownerType, Type rawType, Type ... typeArguments) {
        return new ParameterizedTypeImpl(ownerType, rawType, typeArguments);
    }

    public static GenericArrayType arrayOf(Type componentType) {
        return new GenericArrayTypeImpl(componentType);
    }

    public static WildcardType subtypeOf(Type bound) {
        return new WildcardTypeImpl(new Type[]{bound}, new Type[0]);
    }

    public static WildcardType supertypeOf(Type bound) {
        return new WildcardTypeImpl(new Type[]{Object.class}, new Type[]{bound});
    }

    public static Class<?> getRawType(Type type) {
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            Type rawType = parameterizedType.getRawType();
            return (Class)rawType;
        }
        if (type instanceof GenericArrayType) {
            Type componentType = ((GenericArrayType)type).getGenericComponentType();
            return Array.newInstance(JavaTypes.getRawType(componentType), 0).getClass();
        }
        if (type instanceof TypeVariable) {
            return Object.class;
        }
        if (type instanceof WildcardType) {
            return JavaTypes.getRawType(((WildcardType)type).getUpperBounds()[0]);
        }
        String className = type == null ? "null" : type.getClass().getName();
        throw new IllegalArgumentException("Expected a Class, ParameterizedType, or GenericArrayType, but <" + type + "> is of type " + className);
    }

    static boolean equals(@Nullable Type a, @Nullable Type b) {
        if (a == b) {
            return true;
        }
        if (a instanceof Class) {
            if (b instanceof GenericArrayType) {
                return JavaTypes.equals(((Class)a).getComponentType(), ((GenericArrayType)b).getGenericComponentType());
            }
            return a.equals(b);
        }
        if (a instanceof ParameterizedType) {
            if (!(b instanceof ParameterizedType)) {
                return false;
            }
            ParameterizedType pa = (ParameterizedType)a;
            ParameterizedType pb = (ParameterizedType)b;
            Object[] aTypeArguments = pa instanceof ParameterizedTypeImpl ? ((ParameterizedTypeImpl)pa).typeArguments : pa.getActualTypeArguments();
            Object[] bTypeArguments = pb instanceof ParameterizedTypeImpl ? ((ParameterizedTypeImpl)pb).typeArguments : pb.getActualTypeArguments();
            return JavaTypes.equals(pa.getOwnerType(), pb.getOwnerType()) && pa.getRawType().equals(pb.getRawType()) && Arrays.equals(aTypeArguments, bTypeArguments);
        }
        if (a instanceof GenericArrayType) {
            if (b instanceof Class) {
                return JavaTypes.equals(((Class)b).getComponentType(), ((GenericArrayType)a).getGenericComponentType());
            }
            if (!(b instanceof GenericArrayType)) {
                return false;
            }
            GenericArrayType ga = (GenericArrayType)a;
            GenericArrayType gb = (GenericArrayType)b;
            return JavaTypes.equals(ga.getGenericComponentType(), gb.getGenericComponentType());
        }
        if (a instanceof WildcardType) {
            if (!(b instanceof WildcardType)) {
                return false;
            }
            WildcardType wa = (WildcardType)a;
            WildcardType wb = (WildcardType)b;
            return Arrays.equals(wa.getUpperBounds(), wb.getUpperBounds()) && Arrays.equals(wa.getLowerBounds(), wb.getLowerBounds());
        }
        if (a instanceof TypeVariable) {
            if (!(b instanceof TypeVariable)) {
                return false;
            }
            TypeVariable va = (TypeVariable)a;
            TypeVariable vb = (TypeVariable)b;
            return va.getGenericDeclaration() == vb.getGenericDeclaration() && va.getName().equals(vb.getName());
        }
        return false;
    }

    static Type arrayComponentType(Type type) {
        if (type instanceof GenericArrayType) {
            return ((GenericArrayType)type).getGenericComponentType();
        }
        if (type instanceof Class) {
            return ((Class)type).getComponentType();
        }
        return null;
    }

    static Type canonicalize(Type type) {
        if (type instanceof Class) {
            Class c = (Class)type;
            return c.isArray() ? new GenericArrayTypeImpl(JavaTypes.canonicalize(c.getComponentType())) : c;
        }
        if (type instanceof ParameterizedType) {
            if (type instanceof ParameterizedTypeImpl) {
                return type;
            }
            ParameterizedType p = (ParameterizedType)type;
            return new ParameterizedTypeImpl(p.getOwnerType(), p.getRawType(), p.getActualTypeArguments());
        }
        if (type instanceof GenericArrayType) {
            if (type instanceof GenericArrayTypeImpl) {
                return type;
            }
            GenericArrayType g = (GenericArrayType)type;
            return new GenericArrayTypeImpl(g.getGenericComponentType());
        }
        if (type instanceof WildcardType) {
            if (type instanceof WildcardTypeImpl) {
                return type;
            }
            WildcardType w = (WildcardType)type;
            return new WildcardTypeImpl(w.getUpperBounds(), w.getLowerBounds());
        }
        return type;
    }

    static Type removeSubtypeWildcard(Type type) {
        if (!(type instanceof WildcardType)) {
            return type;
        }
        Type[] lowerBounds = ((WildcardType)type).getLowerBounds();
        if (lowerBounds.length != 0) {
            return type;
        }
        Type[] upperBounds = ((WildcardType)type).getUpperBounds();
        if (upperBounds.length != 1) {
            throw new IllegalArgumentException();
        }
        return upperBounds[0];
    }

    static Type resolve(Type context, Class<?> contextRawType, Type toResolve) {
        Type original;
        while (toResolve instanceof TypeVariable) {
            TypeVariable typeVariable = (TypeVariable)toResolve;
            if ((toResolve = JavaTypes.resolveTypeVariable(context, contextRawType, typeVariable)) != typeVariable) continue;
            return toResolve;
        }
        if (toResolve instanceof Class && ((Class)toResolve).isArray()) {
            Type newComponentType;
            original = (Class)toResolve;
            Class<?> componentType = ((Class)original).getComponentType();
            return componentType == (newComponentType = JavaTypes.resolve(context, contextRawType, componentType)) ? original : new GenericArrayTypeImpl(newComponentType);
        }
        if (toResolve instanceof GenericArrayType) {
            Type newComponentType;
            original = (GenericArrayType)toResolve;
            Type componentType = original.getGenericComponentType();
            return componentType == (newComponentType = JavaTypes.resolve(context, contextRawType, componentType)) ? original : new GenericArrayTypeImpl(newComponentType);
        }
        if (toResolve instanceof ParameterizedType) {
            original = (ParameterizedType)toResolve;
            Type ownerType = original.getOwnerType();
            Type newOwnerType = JavaTypes.resolve(context, contextRawType, ownerType);
            boolean changed = newOwnerType != ownerType;
            Type[] args = original.getActualTypeArguments();
            int length = args.length;
            for (int t = 0; t < length; ++t) {
                Type resolvedTypeArgument = JavaTypes.resolve(context, contextRawType, args[t]);
                if (resolvedTypeArgument == args[t]) continue;
                if (!changed) {
                    args = (Type[])args.clone();
                    changed = true;
                }
                args[t] = resolvedTypeArgument;
            }
            return changed ? new ParameterizedTypeImpl(newOwnerType, original.getRawType(), args) : original;
        }
        if (toResolve instanceof WildcardType) {
            Type upperBound;
            original = (WildcardType)toResolve;
            Type[] originalLowerBound = original.getLowerBounds();
            Type[] originalUpperBound = original.getUpperBounds();
            if (originalLowerBound.length == 1) {
                Type lowerBound = JavaTypes.resolve(context, contextRawType, originalLowerBound[0]);
                if (lowerBound != originalLowerBound[0]) {
                    return new WildcardTypeImpl(new Type[]{Object.class}, new Type[]{lowerBound});
                }
            } else if (originalUpperBound.length == 1 && (upperBound = JavaTypes.resolve(context, contextRawType, originalUpperBound[0])) != originalUpperBound[0]) {
                return new WildcardTypeImpl(new Type[]{upperBound}, new Type[0]);
            }
            return original;
        }
        return toResolve;
    }

    private static Type resolveTypeVariable(Type context, Class<?> contextRawType, TypeVariable<?> unknown) {
        Class<?> declaredByRaw = JavaTypes.declaringClassOf(unknown);
        if (declaredByRaw == null) {
            return unknown;
        }
        Type declaredBy = JavaTypes.getGenericSupertype(context, contextRawType, declaredByRaw);
        if (declaredBy instanceof ParameterizedType) {
            int index = JavaTypes.indexOf(declaredByRaw.getTypeParameters(), unknown);
            return ((ParameterizedType)declaredBy).getActualTypeArguments()[index];
        }
        return unknown;
    }

    private static Type getGenericSupertype(Type context, Class<?> rawType, Class<?> toResolve) {
        if (toResolve == rawType) {
            return context;
        }
        if (toResolve.isInterface()) {
            Class<?>[] interfaces = rawType.getInterfaces();
            int length = interfaces.length;
            for (int i = 0; i < length; ++i) {
                if (interfaces[i] == toResolve) {
                    return rawType.getGenericInterfaces()[i];
                }
                if (!toResolve.isAssignableFrom(interfaces[i])) continue;
                return JavaTypes.getGenericSupertype(rawType.getGenericInterfaces()[i], interfaces[i], toResolve);
            }
        }
        if (!rawType.isInterface()) {
            while (rawType != Object.class) {
                Class<?> rawSupertype = rawType.getSuperclass();
                if (rawSupertype == toResolve) {
                    return rawType.getGenericSuperclass();
                }
                if (rawSupertype != null && toResolve.isAssignableFrom(rawSupertype)) {
                    return JavaTypes.getGenericSupertype(rawType.getGenericSuperclass(), rawSupertype, toResolve);
                }
                rawType = rawSupertype;
            }
        }
        return toResolve;
    }

    private static int hashCodeOrZero(@Nullable Object o) {
        return o != null ? o.hashCode() : 0;
    }

    private static String typeToString(Type type) {
        return type instanceof Class ? ((Class)type).getName() : type.toString();
    }

    private static int indexOf(Object[] array, Object toFind) {
        for (int i = 0; i < array.length; ++i) {
            if (!toFind.equals(array[i])) continue;
            return i;
        }
        throw new NoSuchElementException();
    }

    @Nullable
    private static Class<?> declaringClassOf(TypeVariable<?> typeVariable) {
        Object genericDeclaration = typeVariable.getGenericDeclaration();
        return genericDeclaration instanceof Class ? (Class)genericDeclaration : null;
    }

    private static void checkNotPrimitive(Type type) {
        if (type instanceof Class && ((Class)type).isPrimitive()) {
            throw new IllegalArgumentException("Unexpected primitive " + type + ". Use the boxed type.");
        }
    }

    private static final class ParameterizedTypeImpl
    implements ParameterizedType {
        @Nullable
        private final Type ownerType;
        private final Type rawType;
        final Type[] typeArguments;

        ParameterizedTypeImpl(@Nullable Type ownerType, Type rawType, Type ... typeArguments) {
            if (rawType instanceof Class) {
                Class<?> enclosingClass = ((Class)rawType).getEnclosingClass();
                if (ownerType != null) {
                    if (enclosingClass == null || JavaTypes.getRawType(ownerType) != enclosingClass) {
                        throw new IllegalArgumentException("unexpected owner type for " + rawType + ": " + ownerType);
                    }
                } else if (enclosingClass != null) {
                    throw new IllegalArgumentException("unexpected owner type for " + rawType + ": null");
                }
            }
            this.ownerType = ownerType == null ? null : JavaTypes.canonicalize(ownerType);
            this.rawType = JavaTypes.canonicalize(rawType);
            this.typeArguments = (Type[])typeArguments.clone();
            for (int t = 0; t < this.typeArguments.length; ++t) {
                if (this.typeArguments[t] == null) {
                    throw new NullPointerException();
                }
                JavaTypes.checkNotPrimitive(this.typeArguments[t]);
                this.typeArguments[t] = JavaTypes.canonicalize(this.typeArguments[t]);
            }
        }

        @Override
        @NonNull
        public Type[] getActualTypeArguments() {
            return (Type[])this.typeArguments.clone();
        }

        @Override
        @NonNull
        public Type getRawType() {
            return this.rawType;
        }

        @Override
        @Nullable
        public Type getOwnerType() {
            return this.ownerType;
        }

        public boolean equals(Object other) {
            return other instanceof ParameterizedType && JavaTypes.equals(this, (ParameterizedType)other);
        }

        public int hashCode() {
            return 31 * (31 * JavaTypes.hashCodeOrZero(this.rawType) + JavaTypes.hashCodeOrZero(this.ownerType)) + Arrays.hashCode(this.typeArguments);
        }

        public String toString() {
            StringBuilder result = new StringBuilder(30 * (this.typeArguments.length + 1));
            result.append(JavaTypes.typeToString(this.rawType));
            if (this.typeArguments.length == 0) {
                return result.toString();
            }
            result.append("<").append(JavaTypes.typeToString(this.typeArguments[0]));
            for (int i = 1; i < this.typeArguments.length; ++i) {
                result.append(", ").append(JavaTypes.typeToString(this.typeArguments[i]));
            }
            return result.append(">").toString();
        }
    }

    private static final class GenericArrayTypeImpl
    implements GenericArrayType {
        private final Type componentType;

        GenericArrayTypeImpl(Type componentType) {
            this.componentType = JavaTypes.canonicalize(componentType);
        }

        @Override
        @NonNull
        public Type getGenericComponentType() {
            return this.componentType;
        }

        public boolean equals(Object o) {
            return o instanceof GenericArrayType && JavaTypes.equals(this, (GenericArrayType)o);
        }

        public int hashCode() {
            return this.componentType.hashCode();
        }

        public String toString() {
            return JavaTypes.typeToString(this.componentType) + "[]";
        }
    }

    private static final class WildcardTypeImpl
    implements WildcardType {
        private final Type upperBound;
        @Nullable
        private final Type lowerBound;

        WildcardTypeImpl(Type[] upperBounds, Type[] lowerBounds) {
            if (lowerBounds.length > 1) {
                throw new IllegalArgumentException();
            }
            if (upperBounds.length != 1) {
                throw new IllegalArgumentException();
            }
            if (lowerBounds.length == 1) {
                if (lowerBounds[0] == null) {
                    throw new NullPointerException();
                }
                JavaTypes.checkNotPrimitive(lowerBounds[0]);
                if (upperBounds[0] != Object.class) {
                    throw new IllegalArgumentException();
                }
                this.lowerBound = JavaTypes.canonicalize(lowerBounds[0]);
                this.upperBound = Object.class;
            } else {
                if (upperBounds[0] == null) {
                    throw new NullPointerException();
                }
                JavaTypes.checkNotPrimitive(upperBounds[0]);
                this.lowerBound = null;
                this.upperBound = JavaTypes.canonicalize(upperBounds[0]);
            }
        }

        @Override
        public Type[] getUpperBounds() {
            return new Type[]{this.upperBound};
        }

        @Override
        @NonNull
        public Type[] getLowerBounds() {
            Type[] typeArray;
            if (this.lowerBound != null) {
                Type[] typeArray2 = new Type[1];
                typeArray = typeArray2;
                typeArray2[0] = this.lowerBound;
            } else {
                typeArray = new Type[]{};
            }
            return typeArray;
        }

        public boolean equals(Object other) {
            return other instanceof WildcardType && JavaTypes.equals(this, (WildcardType)other);
        }

        public int hashCode() {
            return (this.lowerBound != null ? 31 + this.lowerBound.hashCode() : 1) ^ 31 + this.upperBound.hashCode();
        }

        public String toString() {
            if (this.lowerBound != null) {
                return "? super " + JavaTypes.typeToString(this.lowerBound);
            }
            if (this.upperBound == Object.class) {
                return "?";
            }
            return "? extends " + JavaTypes.typeToString(this.upperBound);
        }
    }
}

