/*
 * Decompiled with CFR 0.152.
 */
package com.shiqi.quickjs;

import androidx.annotation.Nullable;
import com.shiqi.quickjs.JavaTypes;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.Arrays;

public final class JavaMethod {
    final Type returnType;
    final String name;
    final Type[] parameterTypes;

    @Nullable
    public static JavaMethod create(Type type, Method rawMethod) {
        Class<?> rawType = JavaTypes.getRawType(type);
        Type returnType = JavaTypes.resolve(type, rawType, rawMethod.getGenericReturnType());
        if (returnType instanceof TypeVariable) {
            return null;
        }
        String name = rawMethod.getName();
        Type[] originParameterTypes = rawMethod.getGenericParameterTypes();
        Type[] parameterTypes = new Type[originParameterTypes.length];
        for (int i = 0; i < parameterTypes.length; ++i) {
            parameterTypes[i] = JavaTypes.resolve(type, rawType, originParameterTypes[i]);
            if (!(parameterTypes[i] instanceof TypeVariable)) continue;
            return null;
        }
        return new JavaMethod(returnType, name, parameterTypes);
    }

    public JavaMethod(Type returnType, String name, Type[] parameterTypes) {
        this.returnType = JavaMethod.canonicalize(returnType);
        this.name = name;
        this.parameterTypes = new Type[parameterTypes.length];
        for (int i = 0; i < parameterTypes.length; ++i) {
            this.parameterTypes[i] = JavaMethod.canonicalize(parameterTypes[i]);
        }
    }

    private static Type canonicalize(Type type) {
        return JavaTypes.removeSubtypeWildcard(JavaTypes.canonicalize(type));
    }

    private static String getTypeSignature(Type type) {
        if (type instanceof GenericArrayType) {
            return "[" + JavaMethod.getTypeSignature(((GenericArrayType)type).getGenericComponentType());
        }
        if (type instanceof Class && ((Class)type).isPrimitive()) {
            if (type == Void.TYPE) {
                return "V";
            }
            if (type == Boolean.TYPE) {
                return "Z";
            }
            if (type == Byte.TYPE) {
                return "B";
            }
            if (type == Character.TYPE) {
                return "C";
            }
            if (type == Short.TYPE) {
                return "S";
            }
            if (type == Integer.TYPE) {
                return "I";
            }
            if (type == Long.TYPE) {
                return "J";
            }
            if (type == Float.TYPE) {
                return "F";
            }
            if (type == Double.TYPE) {
                return "D";
            }
        }
        Class<?> clazz = JavaTypes.getRawType(type);
        String name = clazz.getName();
        StringBuilder sb = new StringBuilder(name.length() + 2);
        sb.append("L");
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            sb.append(c == '.' ? (char)'/' : (char)c);
        }
        sb.append(";");
        return sb.toString();
    }

    String getSignature() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        for (Type parameterType : this.parameterTypes) {
            sb.append(JavaMethod.getTypeSignature(parameterType));
        }
        sb.append(")");
        sb.append(JavaMethod.getTypeSignature(this.returnType));
        return sb.toString();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.returnType);
        sb.append(" ");
        sb.append(this.name);
        sb.append("(");
        for (int i = 0; i < this.parameterTypes.length; ++i) {
            if (i != 0) {
                sb.append(", ");
            }
            sb.append(this.parameterTypes[i]);
        }
        sb.append(")");
        return sb.toString();
    }

    public int hashCode() {
        int result = 0;
        result = 31 * result + this.returnType.hashCode();
        result = 31 * result + this.name.hashCode();
        result = 31 * result + Arrays.hashCode(this.parameterTypes);
        return result;
    }

    public boolean equals(@Nullable Object obj) {
        if (!(obj instanceof JavaMethod)) {
            return false;
        }
        JavaMethod other = (JavaMethod)obj;
        return this.returnType.equals(other.returnType) && this.name.equals(other.name) && Arrays.equals(this.parameterTypes, other.parameterTypes);
    }
}

