/*
 * Decompiled with CFR 0.152.
 */
package com.shiqi.quickjs;

import com.shiqi.quickjs.JSContext;
import com.shiqi.quickjs.JSDataException;
import com.shiqi.quickjs.JSNumber;

final class JSFloat64
extends JSNumber {
    private final double value;

    JSFloat64(long pointer, JSContext jsContext, double value) {
        super(pointer, jsContext);
        this.value = value;
    }

    private String wrongNumberMessage(String javaType, double value) {
        return "Can't treat " + value + " as " + javaType;
    }

    @Override
    public byte getByte() {
        double value = this.value;
        byte result = (byte)value;
        if ((double)result != value) {
            throw new JSDataException(this.wrongNumberMessage("byte", value));
        }
        return result;
    }

    @Override
    public short getShort() {
        double value = this.value;
        short result = (short)value;
        if ((double)result != value) {
            throw new JSDataException(this.wrongNumberMessage("short", value));
        }
        return result;
    }

    @Override
    public int getInt() {
        double value = this.value;
        int result = (int)value;
        if ((double)result != value) {
            throw new JSDataException(this.wrongNumberMessage("int", value));
        }
        return result;
    }

    @Override
    public long getLong() {
        double value = this.value;
        long result = (long)value;
        if ((double)result != value) {
            throw new JSDataException(this.wrongNumberMessage("long", value));
        }
        return result;
    }

    @Override
    public float getFloat() {
        return (float)this.value;
    }

    @Override
    public double getDouble() {
        return this.value;
    }
}

