/*
 * Decompiled with CFR 0.152.
 */
package com.shiqi.quickjs;

import android.util.Log;
import androidx.annotation.Nullable;
import com.shiqi.quickjs.JSArray;
import com.shiqi.quickjs.JSArrayBuffer;
import com.shiqi.quickjs.JSBoolean;
import com.shiqi.quickjs.JSEvaluationException;
import com.shiqi.quickjs.JSFloat64;
import com.shiqi.quickjs.JSFunction;
import com.shiqi.quickjs.JSFunctionCallback;
import com.shiqi.quickjs.JSInt;
import com.shiqi.quickjs.JSInternal;
import com.shiqi.quickjs.JSNull;
import com.shiqi.quickjs.JSNumber;
import com.shiqi.quickjs.JSObject;
import com.shiqi.quickjs.JSRuntime;
import com.shiqi.quickjs.JSString;
import com.shiqi.quickjs.JSSymbol;
import com.shiqi.quickjs.JSUndefined;
import com.shiqi.quickjs.JSValue;
import com.shiqi.quickjs.JavaMethod;
import com.shiqi.quickjs.NativeCleaner;
import com.shiqi.quickjs.PromiseExecutor;
import com.shiqi.quickjs.QuickJS;
import com.shiqi.quickjs.TypeAdapter;
import java.io.Closeable;
import java.lang.reflect.Type;

public class JSContext
implements Closeable {
    static final int TYPE_SYMBOL = -8;
    static final int TYPE_STRING = -7;
    static final int TYPE_OBJECT = -1;
    static final int TYPE_INT = 0;
    static final int TYPE_BOOLEAN = 1;
    static final int TYPE_NULL = 2;
    static final int TYPE_UNDEFINED = 3;
    static final int TYPE_EXCEPTION = 6;
    static final int TYPE_FLOAT64 = 7;
    public static final int EVAL_TYPE_GLOBAL = 0;
    public static final int EVAL_TYPE_MODULE = 1;
    public static final int EVAL_FLAG_STRICT = 8;
    public static final int EVAL_FLAG_STRIP = 16;
    private static final int EVAL_FLAG_MASK = 24;
    long pointer;
    final QuickJS quickJS;
    final JSRuntime jsRuntime;
    private final NativeCleaner<JSValue> cleaner;
    private static final String TAG = "QuickJs JSContext";

    JSContext(long pointer, QuickJS quickJS, JSRuntime jsRuntime) {
        this.pointer = pointer;
        this.quickJS = quickJS;
        this.jsRuntime = jsRuntime;
        this.cleaner = new JSValueCleaner();
    }

    long checkClosed() {
        if (this.pointer == 0L) {
            throw new IllegalStateException("The JSContext is closed");
        }
        this.cleaner.clean();
        return this.pointer;
    }

    public QuickJS getQuickJS() {
        return this.quickJS;
    }

    public void evaluate(String script, String fileName) {
        this.evaluateInternal(script, fileName, 0, 0, null);
    }

    public void evaluateBytecode(byte[] bytecode) {
        this.evaluateBytecodeInternal(bytecode, 0, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] compileJsToBytecode(String code) {
        JSRuntime jSRuntime = this.jsRuntime;
        synchronized (jSRuntime) {
            this.checkClosed();
            return QuickJS.compileJsToBytecode(this.pointer, code);
        }
    }

    public void evaluate(String script, String fileName, int type, int flags) {
        this.evaluateInternal(script, fileName, type, flags, null);
    }

    public <T> T evaluate(String script, String fileName, Class<T> clazz) {
        return this.evaluateInternal(script, fileName, 0, 0, this.quickJS.getAdapter(clazz));
    }

    public <T> T evaluate(String script, String fileName, Type type) {
        return this.evaluateInternal(script, fileName, 0, 0, this.quickJS.getAdapter(type));
    }

    public <T> T evaluate(String script, String fileName, TypeAdapter<T> adapter) {
        return this.evaluateInternal(script, fileName, 0, 0, adapter);
    }

    public <T> T evaluate(String script, String fileName, int type, int flags, Class<T> clazz) {
        return this.evaluateInternal(script, fileName, type, flags, this.quickJS.getAdapter(clazz));
    }

    public <T> T evaluate(String script, String fileName, int type, int flags, TypeAdapter<T> adapter) {
        return this.evaluateInternal(script, fileName, type, flags, adapter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T evaluateInternal(String script, String fileName, int type, int flags, @Nullable TypeAdapter<T> adapter) {
        if (type != 0 && type != 1) {
            throw new IllegalArgumentException("Invalid type: " + type);
        }
        if ((flags & 0xFFFFFFE7) != 0) {
            throw new IllegalArgumentException("Invalid flags: " + flags);
        }
        JSRuntime jSRuntime = this.jsRuntime;
        synchronized (jSRuntime) {
            this.checkClosed();
            long value = QuickJS.evaluate(this.pointer, script, fileName, type | flags);
            if (adapter != null) {
                JSValue jsValue = this.wrapAsJSValue(value);
                return adapter.fromJSValue(this, jsValue);
            }
            try {
                if (QuickJS.getValueTag(value) == 6) {
                    throw new JSEvaluationException(QuickJS.getException(this.pointer));
                }
            }
            finally {
                QuickJS.destroyValue(this.pointer, value);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> void evaluateBytecodeInternal(byte[] bytecode, int flags, @Nullable TypeAdapter<T> adapter) {
        if ((flags & 0xFFFFFFE7) != 0) {
            throw new IllegalArgumentException("Invalid flags: " + flags);
        }
        JSRuntime jSRuntime = this.jsRuntime;
        synchronized (jSRuntime) {
            this.checkClosed();
            QuickJS.evaluateBytecode(this.pointer, bytecode, flags);
            long value = QuickJS.getGlobalObject(this.pointer);
            if (adapter != null) {
                JSValue jsValue = this.wrapAsJSValue(value);
                adapter.fromJSValue(this, jsValue);
            } else {
                try {
                    try {
                        throw new JSEvaluationException(QuickJS.getException(this.pointer));
                    }
                    catch (Exception e) {
                        Log.e((String)TAG, (String)("evaluateBytecodeInternal: " + e.getMessage()));
                        QuickJS.destroyValue(this.pointer, value);
                    }
                }
                catch (Throwable throwable) {
                    QuickJS.destroyValue(this.pointer, value);
                    throw throwable;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean executePendingJob() {
        JSRuntime jSRuntime = this.jsRuntime;
        synchronized (jSRuntime) {
            this.checkClosed();
            int code = QuickJS.executePendingJob(this.pointer);
            if (code < 0) {
                throw new JSEvaluationException(QuickJS.getException(this.pointer));
            }
            return code != 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JSObject getGlobalObject() {
        JSRuntime jSRuntime = this.jsRuntime;
        synchronized (jSRuntime) {
            this.checkClosed();
            long val = QuickJS.getGlobalObject(this.pointer);
            return this.wrapAsJSValue(val).cast(JSObject.class);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JSUndefined createJSUndefined() {
        JSRuntime jSRuntime = this.jsRuntime;
        synchronized (jSRuntime) {
            this.checkClosed();
            long val = QuickJS.createValueUndefined(this.pointer);
            return this.wrapAsJSValue(val).cast(JSUndefined.class);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JSNull createJSNull() {
        JSRuntime jSRuntime = this.jsRuntime;
        synchronized (jSRuntime) {
            this.checkClosed();
            long val = QuickJS.createValueNull(this.pointer);
            return this.wrapAsJSValue(val).cast(JSNull.class);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JSBoolean createJSBoolean(boolean value) {
        JSRuntime jSRuntime = this.jsRuntime;
        synchronized (jSRuntime) {
            this.checkClosed();
            long val = QuickJS.createValueBoolean(this.pointer, value);
            return this.wrapAsJSValue(val).cast(JSBoolean.class);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JSNumber createJSNumber(int value) {
        JSRuntime jSRuntime = this.jsRuntime;
        synchronized (jSRuntime) {
            this.checkClosed();
            long val = QuickJS.createValueInt(this.pointer, value);
            return this.wrapAsJSValue(val).cast(JSNumber.class);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JSNumber createJSNumber(double value) {
        JSRuntime jSRuntime = this.jsRuntime;
        synchronized (jSRuntime) {
            this.checkClosed();
            long val = QuickJS.createValueFloat64(this.pointer, value);
            return this.wrapAsJSValue(val).cast(JSNumber.class);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JSString createJSString(String value) {
        JSRuntime jSRuntime = this.jsRuntime;
        synchronized (jSRuntime) {
            this.checkClosed();
            long val = QuickJS.createValueString(this.pointer, value);
            return this.wrapAsJSValue(val).cast(JSString.class);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JSObject createJSObject() {
        JSRuntime jSRuntime = this.jsRuntime;
        synchronized (jSRuntime) {
            this.checkClosed();
            long val = QuickJS.createValueObject(this.pointer);
            return this.wrapAsJSValue(val).cast(JSObject.class);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JSObject createJSObject(Object object) {
        JSRuntime jSRuntime = this.jsRuntime;
        synchronized (jSRuntime) {
            this.checkClosed();
            long val = QuickJS.createValueJavaObject(this.pointer, object);
            return this.wrapAsJSValue(val).cast(JSObject.class);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JSArray createJSArray() {
        JSRuntime jSRuntime = this.jsRuntime;
        synchronized (jSRuntime) {
            this.checkClosed();
            long val = QuickJS.createValueArray(this.pointer);
            return this.wrapAsJSValue(val).cast(JSArray.class);
        }
    }

    private void checkArrayBounds(int arrayLength, int start, int length) {
        if (start < 0 || length <= 0 || start + length > arrayLength) {
            throw new IndexOutOfBoundsException("start = " + start + ", length = " + length + ", but array.length = " + arrayLength);
        }
    }

    public JSArrayBuffer createJSArrayBuffer(boolean[] array) {
        return this.createJSArrayBuffer(array, 0, array.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JSArrayBuffer createJSArrayBuffer(boolean[] array, int start, int length) {
        this.checkArrayBounds(array.length, start, length);
        JSRuntime jSRuntime = this.jsRuntime;
        synchronized (jSRuntime) {
            this.checkClosed();
            long val = QuickJS.createValueArrayBufferZ(this.pointer, array, start, length);
            return this.wrapAsJSValue(val).cast(JSArrayBuffer.class);
        }
    }

    public JSArrayBuffer createJSArrayBuffer(byte[] array) {
        return this.createJSArrayBuffer(array, 0, array.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JSArrayBuffer createJSArrayBuffer(byte[] array, int start, int length) {
        this.checkArrayBounds(array.length, start, length);
        JSRuntime jSRuntime = this.jsRuntime;
        synchronized (jSRuntime) {
            this.checkClosed();
            long val = QuickJS.createValueArrayBufferB(this.pointer, array, start, length);
            return this.wrapAsJSValue(val).cast(JSArrayBuffer.class);
        }
    }

    public JSArrayBuffer createJSArrayBuffer(char[] array) {
        return this.createJSArrayBuffer(array, 0, array.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JSArrayBuffer createJSArrayBuffer(char[] array, int start, int length) {
        this.checkArrayBounds(array.length, start, length);
        JSRuntime jSRuntime = this.jsRuntime;
        synchronized (jSRuntime) {
            this.checkClosed();
            long val = QuickJS.createValueArrayBufferC(this.pointer, array, start, length);
            return this.wrapAsJSValue(val).cast(JSArrayBuffer.class);
        }
    }

    public JSArrayBuffer createJSArrayBuffer(short[] array) {
        return this.createJSArrayBuffer(array, 0, array.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JSArrayBuffer createJSArrayBuffer(short[] array, int start, int length) {
        this.checkArrayBounds(array.length, start, length);
        JSRuntime jSRuntime = this.jsRuntime;
        synchronized (jSRuntime) {
            this.checkClosed();
            long val = QuickJS.createValueArrayBufferS(this.pointer, array, start, length);
            return this.wrapAsJSValue(val).cast(JSArrayBuffer.class);
        }
    }

    public JSArrayBuffer createJSArrayBuffer(int[] array) {
        return this.createJSArrayBuffer(array, 0, array.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JSArrayBuffer createJSArrayBuffer(int[] array, int start, int length) {
        this.checkArrayBounds(array.length, start, length);
        JSRuntime jSRuntime = this.jsRuntime;
        synchronized (jSRuntime) {
            this.checkClosed();
            long val = QuickJS.createValueArrayBufferI(this.pointer, array, start, length);
            return this.wrapAsJSValue(val).cast(JSArrayBuffer.class);
        }
    }

    public JSArrayBuffer createJSArrayBuffer(long[] array) {
        return this.createJSArrayBuffer(array, 0, array.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JSArrayBuffer createJSArrayBuffer(long[] array, int start, int length) {
        this.checkArrayBounds(array.length, start, length);
        JSRuntime jSRuntime = this.jsRuntime;
        synchronized (jSRuntime) {
            this.checkClosed();
            long val = QuickJS.createValueArrayBufferJ(this.pointer, array, start, length);
            return this.wrapAsJSValue(val).cast(JSArrayBuffer.class);
        }
    }

    public JSArrayBuffer createJSArrayBuffer(float[] array) {
        return this.createJSArrayBuffer(array, 0, array.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JSArrayBuffer createJSArrayBuffer(float[] array, int start, int length) {
        this.checkArrayBounds(array.length, start, length);
        JSRuntime jSRuntime = this.jsRuntime;
        synchronized (jSRuntime) {
            this.checkClosed();
            long val = QuickJS.createValueArrayBufferF(this.pointer, array, start, length);
            return this.wrapAsJSValue(val).cast(JSArrayBuffer.class);
        }
    }

    public JSArrayBuffer createJSArrayBuffer(double[] array) {
        return this.createJSArrayBuffer(array, 0, array.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JSArrayBuffer createJSArrayBuffer(double[] array, int start, int length) {
        this.checkArrayBounds(array.length, start, length);
        JSRuntime jSRuntime = this.jsRuntime;
        synchronized (jSRuntime) {
            this.checkClosed();
            long val = QuickJS.createValueArrayBufferD(this.pointer, array, start, length);
            return this.wrapAsJSValue(val).cast(JSArrayBuffer.class);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JSFunction createJSFunction(Object instance, JavaMethod method) {
        if (instance == null) {
            throw new NullPointerException("instance == null");
        }
        if (method == null) {
            throw new NullPointerException("method == null");
        }
        JSRuntime jSRuntime = this.jsRuntime;
        synchronized (jSRuntime) {
            this.checkClosed();
            long val = QuickJS.createValueFunction(this.pointer, this, instance, method.name, method.getSignature(), method.returnType, method.parameterTypes, false);
            return this.wrapAsJSValue(val).cast(JSFunction.class);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JSFunction createJSFunction(JSFunctionCallback callback) {
        if (callback == null) {
            throw new NullPointerException("callback == null");
        }
        JSRuntime jSRuntime = this.jsRuntime;
        synchronized (jSRuntime) {
            this.checkClosed();
            String methodName = "invoke";
            String methodSign = "(Lcom/shiqi/quickjs/JSContext;[Lcom/shiqi/quickjs/JSValue;)Lcom/shiqi/quickjs/JSValue;";
            long val = QuickJS.createValueFunction(this.pointer, this, callback, methodName, methodSign, JSValue.class, new Class[]{JSContext.class, JSValue[].class}, true);
            return this.wrapAsJSValue(val).cast(JSFunction.class);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JSFunction createJSFunctionS(Class<?> clazz, JavaMethod method) {
        if (clazz == null) {
            throw new NullPointerException("clazz == null");
        }
        if (method == null) {
            throw new NullPointerException("method == null");
        }
        String name = clazz.getName();
        StringBuilder sb = new StringBuilder(name.length());
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            sb.append(c == '.' ? (char)'/' : (char)c);
        }
        String className = sb.toString();
        JSRuntime jSRuntime = this.jsRuntime;
        synchronized (jSRuntime) {
            this.checkClosed();
            long val = QuickJS.createValueFunctionS(this.pointer, this, className, method.name, method.getSignature(), method.returnType, method.parameterTypes);
            return this.wrapAsJSValue(val).cast(JSFunction.class);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JSObject createJSPromise(PromiseExecutor executor) {
        JSValue reject;
        JSValue resolve;
        JSValue promise;
        JSRuntime jSRuntime = this.jsRuntime;
        synchronized (jSRuntime) {
            this.checkClosed();
            long[] values = QuickJS.createValuePromise(this.pointer);
            if (values == null) {
                throw new NullPointerException("result == null");
            }
            for (long value : values) {
                int type = QuickJS.getValueTag(value);
                if (type != 6) continue;
                for (long v : values) {
                    QuickJS.destroyValue(this.pointer, v);
                }
                throw new JSEvaluationException(QuickJS.getException(this.pointer));
            }
            promise = this.wrapAsJSValue(values[0]);
            resolve = this.wrapAsJSValue(values[1]);
            reject = this.wrapAsJSValue(values[2]);
        }
        executor.execute(resolve.cast(JSFunction.class), reject.cast(JSFunction.class));
        return promise.cast(JSObject.class);
    }

    JSValue wrapAsJSValue(long value) {
        JSValue jsValue;
        if (value == 0L) {
            throw new IllegalStateException("Can't wrap null pointer as JSValue");
        }
        int type = QuickJS.getValueTag(value);
        switch (type) {
            case -8: {
                jsValue = new JSSymbol(value, this);
                break;
            }
            case -7: {
                jsValue = new JSString(value, this, QuickJS.getValueString(this.pointer, value));
                break;
            }
            case -1: {
                if (QuickJS.isValueFunction(this.pointer, value)) {
                    jsValue = new JSFunction(value, this);
                    break;
                }
                if (QuickJS.isValueArray(this.pointer, value)) {
                    jsValue = new JSArray(value, this);
                    break;
                }
                if (QuickJS.isValueArrayBuffer(this.pointer, value)) {
                    jsValue = new JSArrayBuffer(value, this);
                    break;
                }
                jsValue = new JSObject(value, this, QuickJS.getValueJavaObject(this.pointer, value));
                break;
            }
            case 0: {
                jsValue = new JSInt(value, this, QuickJS.getValueInt(value));
                break;
            }
            case 1: {
                jsValue = new JSBoolean(value, this, QuickJS.getValueBoolean(value));
                break;
            }
            case 2: {
                jsValue = new JSNull(value, this);
                break;
            }
            case 3: {
                jsValue = new JSUndefined(value, this);
                break;
            }
            case 6: {
                QuickJS.destroyValue(this.pointer, value);
                throw new JSEvaluationException(QuickJS.getException(this.pointer));
            }
            case 7: {
                jsValue = new JSFloat64(value, this, QuickJS.getValueFloat64(value));
                break;
            }
            default: {
                jsValue = new JSInternal(value, this);
            }
        }
        this.cleaner.register(jsValue, value);
        return jsValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getNotRemovedJSValueCount() {
        JSRuntime jSRuntime = this.jsRuntime;
        synchronized (jSRuntime) {
            return this.cleaner.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        JSRuntime jSRuntime = this.jsRuntime;
        synchronized (jSRuntime) {
            if (this.pointer != 0L) {
                this.cleaner.forceClean();
                long contextToClose = this.pointer;
                this.pointer = 0L;
                QuickJS.destroyContext(contextToClose);
            }
        }
    }

    private class JSValueCleaner
    extends NativeCleaner<JSValue> {
        private JSValueCleaner() {
        }

        @Override
        public void onRemove(long pointer) {
            QuickJS.destroyValue(JSContext.this.pointer, pointer);
        }
    }
}

