/*
 * Decompiled with CFR 0.152.
 */
package com.devicenative.dna.utils;

import android.app.Service;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Process;
import android.webkit.WebSettings;
import android.webkit.WebView;
import com.devicenative.dna.utils.DNALogger;
import com.devicenative.dna.utils.DNAPreferences;

public class DNAConfigBuilder
extends Service {
    private static final String WEBVIEW_DIR_SUFFIX = "dna_cfg";
    private static boolean isRunning = false;

    public void onCreate() {
        super.onCreate();
        if (Build.VERSION.SDK_INT >= 28) {
            WebView.setDataDirectorySuffix((String)WEBVIEW_DIR_SUFFIX);
        }
    }

    public int onStartCommand(Intent intent, int flags, int startId) {
        if (isRunning) {
            try {
                this.stopSelf();
            }
            catch (Exception e) {
                DNALogger.i("DNAConfigFilter: Error while stopping service: " + e.getMessage());
            }
            return 2;
        }
        isRunning = true;
        new Handler(Looper.getMainLooper()).post(new Runnable(){

            @Override
            public void run() {
                try {
                    String webViewUserAgent = WebSettings.getDefaultUserAgent((Context)DNAConfigBuilder.this.getApplicationContext());
                    DNALogger.i("DNAConfigFilter: User Agent: " + webViewUserAgent);
                    DNAPreferences.setUserAgent(DNAConfigBuilder.this.getApplicationContext(), webViewUserAgent);
                    DNALogger.i("DNAConfigFilter: User Agent saved to SharedPreferences");
                }
                catch (Exception e) {
                    try {
                        DNALogger.i("DNAConfigFilter: Error while collecting User Agent: " + e.getMessage());
                    }
                    catch (Throwable throwable) {
                        new Handler(Looper.getMainLooper()).postDelayed(new Runnable(){

                            @Override
                            public void run() {
                                DNAConfigBuilder.this.stopSelf();
                                isRunning = false;
                                Process.killProcess((int)Process.myPid());
                            }
                        }, 1000L);
                        throw throwable;
                    }
                    new Handler(Looper.getMainLooper()).postDelayed(new /* invalid duplicate definition of identical inner class */, 1000L);
                }
                new Handler(Looper.getMainLooper()).postDelayed(new /* invalid duplicate definition of identical inner class */, 1000L);
            }
        });
        return 2;
    }

    public IBinder onBind(Intent intent) {
        return null;
    }

    public void onDestroy() {
        super.onDestroy();
        isRunning = false;
    }
}

