/*
 * Decompiled with CFR 0.152.
 */
package com.devicenative.dna.db;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteException;
import android.os.Process;
import android.os.UserHandle;
import android.text.TextUtils;
import com.devicenative.dna.datasource.DNASettingShortcutDataSource;
import com.devicenative.dna.db.DNAAdRecord;
import com.devicenative.dna.db.DNAAppRecord;
import com.devicenative.dna.db.DNADatabase;
import com.devicenative.dna.db.DNAEventRecord;
import com.devicenative.dna.db.DNANotifRecord;
import com.devicenative.dna.db.DNAResultEventRecord;
import com.devicenative.dna.db.DNAShortcutRecord;
import com.devicenative.dna.utils.DNALogger;
import com.devicenative.dna.utils.DNAPreferences;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;

public class DNADatabaseInterface {
    private static SQLiteDatabase database = null;

    private DNADatabaseInterface() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static SQLiteDatabase getDatabase(Context context) {
        block10: {
            if (database == null) {
                try (Cursor cursor = null;){
                    database = new DNADatabase(context).getReadableDatabase();
                    cursor = database.rawQuery("PRAGMA quick_check", null);
                    if (!cursor.moveToFirst()) break block10;
                    String result = cursor.getString(0);
                    if ("ok".equalsIgnoreCase(result)) {
                        break block10;
                    }
                    throw new SQLiteException("Integrity check failed");
                }
            }
        }
        return database;
    }

    private static void wipeOutDatabaseAndReset(Context context) {
        if (database.isOpen()) {
            database.close();
        }
        database = null;
        context.deleteDatabase("devicenative.s3db");
        DNAPreferences prefs = DNAPreferences.getInstance(context);
        prefs.resetDataLoaded();
        DNADatabaseInterface.getDatabase(context);
    }

    public static void insertStatRecord(Context context, String event, Integer value, String metadata, String packageName) {
        SQLiteDatabase db = DNADatabaseInterface.getDatabase(context);
        if (db == null) {
            return;
        }
        ContentValues values = new ContentValues();
        values.put("name", event);
        values.put("packageName", packageName);
        values.put("value", value);
        values.put("metadata", metadata);
        values.put("completedAt", Long.valueOf(System.currentTimeMillis()));
        try {
            db.insert("stats", null, values);
            if (Math.random() <= 0.01) {
                long oneWeekAgo = 604800000L;
                db.delete("stats", "completedAt < ?", new String[]{Long.toString(System.currentTimeMillis() - oneWeekAgo)});
                db.execSQL("VACUUM");
            }
        }
        catch (Exception e) {
            DNALogger.e("insertStatRecord: " + e.getMessage());
        }
    }

    public static List<DNAEventRecord> getAllStats(Context context) {
        SQLiteDatabase db = DNADatabaseInterface.getDatabase(context);
        if (db == null) {
            return new ArrayList<DNAEventRecord>();
        }
        String[] columns = new String[]{"_id", "name", "value", "metadata", "packageName", "completedAt"};
        ArrayList<DNAEventRecord> records = new ArrayList<DNAEventRecord>();
        try (Cursor cursor = db.query("stats", columns, null, null, null, null, null);){
            while (cursor.moveToNext()) {
                DNAEventRecord entry = new DNAEventRecord();
                entry.dbId = cursor.getLong(0);
                entry.name = cursor.getString(1);
                entry.value = cursor.getInt(2);
                entry.metadata = cursor.getString(3);
                entry.packageName = cursor.getString(4);
                entry.completedAt = cursor.getLong(5);
                records.add(entry);
            }
        }
        catch (Exception e) {
            DNALogger.e("getAllStats: " + e.getMessage());
            DNADatabaseInterface.wipeOutDatabaseAndReset(context);
        }
        return records;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteStats(Context context, List<Long> ids) {
        SQLiteDatabase db = DNADatabaseInterface.getDatabase(context);
        if (db == null) {
            return;
        }
        db.beginTransaction();
        try {
            for (Long id : ids) {
                db.delete("stats", "_id = ?", new String[]{Long.toString(id)});
            }
            db.setTransactionSuccessful();
        }
        catch (Exception e) {
            DNALogger.e("deleteStats: " + e.getMessage());
        }
        finally {
            db.endTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void insertOrUpdateAdRecords(Context context, List<DNAAdRecord> ads) {
        SQLiteDatabase db = DNADatabaseInterface.getDatabase(context);
        if (db == null) {
            return;
        }
        db.beginTransaction();
        try {
            for (DNAAdRecord ad : ads) {
                ContentValues values = new ContentValues();
                values.put("_id", ad.adId);
                values.put("appName", ad.name);
                values.put("packageName", ad.packageName);
                values.put("type", ad.type);
                values.put("viewThrough", Integer.valueOf(ad.viewThrough));
                values.put("notPlayStore", Integer.valueOf(ad.notPlayStore ? 1 : 0));
                values.put("creativeSource", ad.creativeSource);
                values.put("title", ad.title);
                values.put("description", ad.description);
                values.put("iconUrl", ad.iconUrl);
                values.put("clickUrl", ad.clickUrl);
                values.put("destinationUrl", ad.destinationUrl);
                values.put("impressionUrl", ad.impressionUrl);
                values.put("targetingMetadata", ad.targetingMetadata);
                int rowsAffected = db.update("ads", values, "_id = ?", new String[]{ad.adId});
                if (rowsAffected != 0) continue;
                DNALogger.i("insertAdRecords: inserting ad: " + ad.packageName);
                db.insert("ads", null, values);
            }
            db.setTransactionSuccessful();
        }
        catch (Exception e) {
            DNALogger.e("insertOrUpdateAdRecords: " + e.getMessage());
        }
        finally {
            db.endTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void partialUpdateAdRecordsFromJSON(Context context, JSONArray adsJsonArray) {
        SQLiteDatabase db = DNADatabaseInterface.getDatabase(context);
        if (db == null) {
            return;
        }
        db.beginTransaction();
        try {
            for (int i = 0; i < adsJsonArray.length(); ++i) {
                JSONObject rawAd = adsJsonArray.getJSONObject(i);
                if (!rawAd.has("id")) {
                    DNALogger.e("partialUpdateAdRecordsFromJSON: Missing 'id' in ad JSON at index " + i);
                    continue;
                }
                String adId = rawAd.optString("id");
                ContentValues values = new ContentValues();
                if (rawAd.has("appName")) {
                    values.put("appName", rawAd.optString("appName"));
                }
                if (rawAd.has("packageName")) {
                    values.put("packageName", rawAd.optString("packageName"));
                }
                if (rawAd.has("type")) {
                    values.put("type", rawAd.optString("type"));
                }
                if (rawAd.has("viewThrough")) {
                    values.put("viewThrough", Integer.valueOf(rawAd.optInt("viewThrough")));
                }
                if (rawAd.has("isPlayStore") && !rawAd.isNull("isPlayStore")) {
                    values.put("notPlayStore", Integer.valueOf(!rawAd.optBoolean("isPlayStore") ? 1 : 0));
                }
                if (rawAd.has("creativeSource")) {
                    String creativeSource = rawAd.optString("creativeSource");
                    values.put("creativeSource", TextUtils.isEmpty((CharSequence)creativeSource) || "null".equals(creativeSource) ? null : creativeSource);
                }
                if (rawAd.has("title")) {
                    String title = rawAd.optString("title");
                    values.put("title", TextUtils.isEmpty((CharSequence)title) || "null".equals(title) ? null : title);
                }
                if (rawAd.has("description")) {
                    String description = rawAd.optString("description");
                    values.put("description", TextUtils.isEmpty((CharSequence)description) || "null".equals(description) ? null : description);
                }
                if (rawAd.has("iconUrl")) {
                    String iconUrl = rawAd.optString("iconUrl");
                    values.put("iconUrl", TextUtils.isEmpty((CharSequence)iconUrl) || "null".equals(iconUrl) ? null : iconUrl);
                }
                if (rawAd.has("clickUrl")) {
                    String clickUrl = rawAd.optString("clickUrl");
                    values.put("clickUrl", TextUtils.isEmpty((CharSequence)clickUrl) || "null".equals(clickUrl) ? null : clickUrl);
                }
                if (rawAd.has("destinationUrl")) {
                    String destinationUrl = rawAd.optString("destinationUrl");
                    values.put("destinationUrl", TextUtils.isEmpty((CharSequence)destinationUrl) || "null".equals(destinationUrl) ? null : destinationUrl);
                }
                if (rawAd.has("impressionUrl")) {
                    String impressionUrl = rawAd.optString("impressionUrl");
                    values.put("impressionUrl", TextUtils.isEmpty((CharSequence)impressionUrl) || "null".equals(impressionUrl) ? null : impressionUrl);
                }
                if (rawAd.has("targetingMetadata")) {
                    String targetingMetadata = rawAd.optString("targetingMetadata");
                    values.put("targetingMetadata", TextUtils.isEmpty((CharSequence)targetingMetadata) || "null".equals(targetingMetadata) ? "{}" : targetingMetadata);
                }
                if (values.size() <= 0) continue;
                DNALogger.i("partialUpdateAdRecordsFromJSON: updating ad with ID: " + adId + " with " + values.size() + " fields");
                db.update("ads", values, "_id = ?", new String[]{adId});
            }
            db.setTransactionSuccessful();
        }
        catch (Exception e) {
            DNALogger.e("partialUpdateAdRecordsFromJSON: " + e.getMessage());
        }
        finally {
            db.endTransaction();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static DNAAdRecord getAdRecord(Context context, String adId) {
        SQLiteDatabase db = DNADatabaseInterface.getDatabase(context);
        if (db == null) {
            return null;
        }
        String[] selArgs = new String[]{adId};
        String[] columns = new String[]{"_id", "appName", "packageName", "type", "viewThrough", "notPlayStore", "creativeSource", "title", "description", "iconUrl", "clickUrl", "destinationUrl", "impressionUrl", "targetingMetadata"};
        try (Cursor cursor = db.query("ads", columns, "_id=?", selArgs, null, null, null);){
            if (!cursor.moveToNext()) return null;
            DNAAdRecord entry = new DNAAdRecord();
            DNALogger.i("getAdRecord: found ad: " + cursor.getString(2));
            entry.adId = cursor.getString(0);
            entry.name = cursor.getString(1);
            entry.packageName = cursor.getString(2);
            entry.type = cursor.getString(3);
            entry.viewThrough = cursor.getInt(4);
            entry.notPlayStore = cursor.getInt(5) == 1;
            entry.creativeSource = cursor.getString(6);
            entry.title = cursor.getString(7);
            entry.description = cursor.getString(8);
            entry.iconUrl = cursor.getString(9);
            entry.clickUrl = cursor.getString(10);
            entry.destinationUrl = cursor.getString(11);
            entry.impressionUrl = cursor.getString(12);
            entry.targetingMetadata = cursor.getString(13);
            DNAAdRecord dNAAdRecord = entry;
            return dNAAdRecord;
        }
        catch (Exception e) {
            DNALogger.e("getAdRecord: " + e.getMessage());
        }
        return null;
    }

    public static List<DNAAdRecord> getAllAdRecords(Context context) {
        SQLiteDatabase db = DNADatabaseInterface.getDatabase(context);
        if (db == null) {
            return new ArrayList<DNAAdRecord>();
        }
        String[] columns = new String[]{"_id", "appName", "packageName", "title", "type", "viewThrough", "notPlayStore", "creativeSource", "description", "iconUrl", "clickUrl", "destinationUrl", "impressionUrl", "targetingMetadata"};
        ArrayList<DNAAdRecord> records = new ArrayList<DNAAdRecord>();
        try (Cursor cursor = db.query("ads", columns, null, null, null, null, null);){
            while (cursor.moveToNext()) {
                DNAAdRecord entry = new DNAAdRecord();
                entry.adId = cursor.getString(0);
                entry.name = cursor.getString(1);
                entry.packageName = cursor.getString(2);
                entry.title = cursor.getString(3);
                entry.type = cursor.getString(4);
                entry.viewThrough = cursor.getInt(5);
                entry.notPlayStore = cursor.getInt(6) == 1;
                entry.creativeSource = cursor.getString(7);
                entry.description = cursor.getString(8);
                entry.iconUrl = cursor.getString(9);
                entry.clickUrl = cursor.getString(10);
                entry.destinationUrl = cursor.getString(11);
                entry.impressionUrl = cursor.getString(12);
                entry.targetingMetadata = cursor.getString(13);
                records.add(entry);
            }
        }
        catch (Exception e) {
            DNALogger.e("getAllAdRecords: " + e.getMessage());
            DNADatabaseInterface.wipeOutDatabaseAndReset(context);
        }
        return records;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteAdRecords(Context context, List<String> adIds) {
        SQLiteDatabase db = DNADatabaseInterface.getDatabase(context);
        if (db == null) {
            return;
        }
        db.beginTransaction();
        try {
            for (String adId : adIds) {
                DNALogger.i("deletingAdRecords: delete ad with ID: " + adId);
                db.delete("ads", "_id = ?", new String[]{adId});
            }
            db.setTransactionSuccessful();
        }
        catch (Exception e) {
            DNALogger.e("deleteAdRecords: " + e.getMessage());
        }
        finally {
            db.endTransaction();
        }
    }

    public static void insertResEventRecord(Context context, DNAResultEventRecord resEventRecord) {
        SQLiteDatabase db = DNADatabaseInterface.getDatabase(context);
        if (db == null) {
            return;
        }
        ContentValues values = new ContentValues();
        values.put("event", resEventRecord.event);
        values.put("type", resEventRecord.type);
        values.put("placement", resEventRecord.placement);
        values.put("resId", resEventRecord.resId);
        values.put("packageName", resEventRecord.packageName);
        values.put("completedAt", Long.valueOf(System.currentTimeMillis()));
        try {
            db.insert("events", null, values);
            if (Math.random() <= 0.001) {
                long threeMonthsAgo = 7776000000L;
                db.delete("events", "event = 'click' AND completedAt < ?", new String[]{Long.toString(System.currentTimeMillis() - threeMonthsAgo)});
                long oneWeekAgo = 604800000L;
                db.delete("events", "(event = 'view' OR event = 'vta') AND completedAt < ?", new String[]{Long.toString(System.currentTimeMillis() - oneWeekAgo)});
                db.execSQL("VACUUM");
            }
        }
        catch (Exception e) {
            DNALogger.e("insertEventRecord: " + e.getMessage());
        }
    }

    public static List<DNAResultEventRecord> getRecentResEventRecords(Context context) {
        SQLiteDatabase db = DNADatabaseInterface.getDatabase(context);
        if (db == null) {
            return new ArrayList<DNAResultEventRecord>();
        }
        String[] columns = new String[]{"_id", "event", "type", "placement", "resId", "packageName", "completedAt"};
        ArrayList<DNAResultEventRecord> records = new ArrayList<DNAResultEventRecord>();
        long time30D = System.currentTimeMillis() - 2592000000L;
        try (Cursor cursor = db.query("events", columns, "completedAt > ?", new String[]{Long.toString(time30D)}, null, null, null);){
            while (cursor.moveToNext()) {
                DNAResultEventRecord entry = new DNAResultEventRecord();
                entry.dbId = cursor.getLong(0);
                entry.event = cursor.getString(1);
                entry.type = cursor.getString(2);
                entry.placement = cursor.getString(3);
                entry.resId = cursor.getString(4);
                entry.packageName = cursor.getString(5);
                entry.completedAt = cursor.getLong(6);
                records.add(entry);
            }
        }
        catch (Exception e) {
            DNALogger.e("getRecentEventRecords: " + e.getMessage());
            DNADatabaseInterface.wipeOutDatabaseAndReset(context);
        }
        return records;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean hasVTABeenFired(Context context, String resId) {
        SQLiteDatabase db = DNADatabaseInterface.getDatabase(context);
        if (db == null) {
            return false;
        }
        String[] columns = new String[]{"_id"};
        ArrayList records = new ArrayList();
        long time7D = System.currentTimeMillis() - 604800000L;
        try (Cursor cursor = db.query("events", columns, "event = ? and resId = ? and completedAt > ?", new String[]{"vta", resId, Long.toString(time7D)}, null, null, null);){
            if (!cursor.moveToNext()) return false;
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            DNALogger.e("hasVTABeenFired: " + e.getMessage());
        }
        return false;
    }

    public static void insertOrUpdateAppRecord(Context context, DNAAppRecord app) {
        SQLiteDatabase db = DNADatabaseInterface.getDatabase(context);
        if (db == null) {
            return;
        }
        ContentValues values = new ContentValues();
        values.put("name", app.name);
        values.put("packageName", app.packageName);
        values.put("aliases", app.aliases);
        values.put("userId", app.userId);
        values.put("component", app.component);
        values.put("timeUsedInLast7D", Long.valueOf(app.timeUsedInLast7D));
        values.put("timeUsedInLast3D", Long.valueOf(app.timeUsedInLast3D));
        values.put("timeUsedInLast1D", Long.valueOf(app.timeUsedInLast1D));
        values.put("timeUsedInLast3Y", Long.valueOf(app.timeUsedInLast3Y));
        values.put("installedAt", Long.valueOf(app.installedAt));
        values.put("updatedAt", Long.valueOf(app.updatedAt));
        values.put("uninstalledAt", Long.valueOf(app.uninstalledAt));
        values.put("lastTimeInForeground", Long.valueOf(app.lastTimeInForeground));
        values.put("lastUsedAt", Long.valueOf(app.lastUsedAt));
        try {
            int rowsAffected = db.update("apps", values, "packageName = ? AND userId = ? AND name = ?", new String[]{app.packageName, app.userId, app.name});
            if (rowsAffected == 0) {
                db.insert("apps", null, values);
            }
        }
        catch (Exception e) {
            DNALogger.e("insertAppRecord: " + e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void insertOrUpdateAppRecords(Context context, List<DNAAppRecord> apps) {
        SQLiteDatabase db = DNADatabaseInterface.getDatabase(context);
        if (db == null) {
            return;
        }
        db.beginTransaction();
        try {
            for (DNAAppRecord app : apps) {
                ContentValues values = new ContentValues();
                values.put("name", app.name);
                values.put("packageName", app.packageName);
                values.put("userId", app.userId);
                values.put("aliases", app.aliases);
                values.put("component", app.component);
                values.put("timeUsedInLast7D", Long.valueOf(app.timeUsedInLast7D));
                values.put("timeUsedInLast3D", Long.valueOf(app.timeUsedInLast3D));
                values.put("timeUsedInLast1D", Long.valueOf(app.timeUsedInLast1D));
                values.put("timeUsedInLast3Y", Long.valueOf(app.timeUsedInLast3Y));
                values.put("installedAt", Long.valueOf(app.installedAt));
                values.put("updatedAt", Long.valueOf(app.updatedAt));
                values.put("uninstalledAt", Long.valueOf(app.uninstalledAt));
                values.put("lastTimeInForeground", Long.valueOf(app.lastTimeInForeground));
                values.put("lastUsedAt", Long.valueOf(app.lastUsedAt));
                int rowsAffected = db.update("apps", values, "packageName = ? AND userId = ? AND name = ?", new String[]{app.packageName, app.userId, app.name});
                if (rowsAffected != 0) continue;
                DNALogger.i("insertAppRecords: inserting app: " + app.packageName);
                db.insert("apps", null, values);
            }
            db.setTransactionSuccessful();
        }
        catch (Exception e) {
            DNALogger.e("insertOrUpdateAppRecords: " + e.getMessage());
        }
        finally {
            db.endTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateAliasesForApps(Context context, JSONObject packageToAliasMap) {
        SQLiteDatabase db = DNADatabaseInterface.getDatabase(context);
        if (db == null) {
            return;
        }
        db.beginTransaction();
        try {
            Iterator keys = packageToAliasMap.keys();
            while (keys.hasNext()) {
                String packageName = (String)keys.next();
                ContentValues values = new ContentValues();
                String commaSeparatedAliases = "";
                commaSeparatedAliases = packageToAliasMap.getString(packageName);
                commaSeparatedAliases = commaSeparatedAliases.replace("[", "").replace("]", "").replaceAll(" ", "");
                values.put("aliases", commaSeparatedAliases);
                int rowsAffected = db.update("apps", values, "packageName = ?", new String[]{packageName});
                if (rowsAffected != 0) continue;
                DNALogger.i("updateAliasesForApps: app not present: " + packageName);
            }
            db.setTransactionSuccessful();
        }
        catch (Exception e) {
            DNALogger.e("updateAliasesForApps: " + e.getMessage());
        }
        finally {
            db.endTransaction();
        }
    }

    public static List<DNAAppRecord> getAppRecords(Context context, String packageName, String userId) {
        SQLiteDatabase db = DNADatabaseInterface.getDatabase(context);
        if (db == null) {
            return null;
        }
        String[] selArgs = new String[]{packageName, userId};
        String[] columns = new String[]{"_id", "name", "packageName", "userId", "component", "aliases", "timeUsedInLast7D", "timeUsedInLast3D", "timeUsedInLast1D", "timeUsedInLast3Y", "installedAt", "updatedAt", "uninstalledAt", "lastTimeInForeground", "lastUsedAt"};
        ArrayList<DNAAppRecord> records = new ArrayList<DNAAppRecord>();
        try (Cursor cursor = db.query("apps", columns, "packageName = ? AND userId = ?", selArgs, null, null, null);){
            while (cursor.moveToNext()) {
                DNAAppRecord entry = new DNAAppRecord();
                entry.dbId = cursor.getLong(0);
                entry.name = cursor.getString(1);
                entry.packageName = cursor.getString(2);
                entry.userId = cursor.getString(3);
                entry.component = cursor.getString(4);
                entry.aliases = cursor.getString(5);
                entry.timeUsedInLast7D = cursor.getLong(6);
                entry.timeUsedInLast3D = cursor.getLong(7);
                entry.timeUsedInLast1D = cursor.getLong(8);
                entry.timeUsedInLast3Y = cursor.getLong(9);
                entry.installedAt = cursor.getLong(10);
                entry.updatedAt = cursor.getLong(11);
                entry.uninstalledAt = cursor.getLong(12);
                entry.lastTimeInForeground = cursor.getLong(13);
                entry.lastUsedAt = cursor.getLong(14);
                records.add(entry);
            }
        }
        catch (Exception e) {
            DNALogger.e("getAppRecord: " + e.getMessage());
        }
        return records;
    }

    public static List<DNAAppRecord> getAllAppRecords(Context context) {
        SQLiteDatabase db = DNADatabaseInterface.getDatabase(context);
        if (db == null) {
            return new ArrayList<DNAAppRecord>();
        }
        String[] columns = new String[]{"_id", "name", "packageName", "userId", "component", "aliases", "timeUsedInLast7D", "timeUsedInLast3D", "timeUsedInLast1D", "timeUsedInLast3Y", "installedAt", "updatedAt", "uninstalledAt", "lastTimeInForeground", "lastUsedAt"};
        ArrayList<DNAAppRecord> records = new ArrayList<DNAAppRecord>();
        try (Cursor cursor = db.query("apps", columns, null, null, null, null, null);){
            while (cursor.moveToNext()) {
                DNAAppRecord entry = new DNAAppRecord();
                entry.dbId = cursor.getLong(0);
                entry.name = cursor.getString(1);
                entry.packageName = cursor.getString(2);
                entry.userId = cursor.getString(3);
                entry.component = cursor.getString(4);
                entry.aliases = cursor.getString(5);
                entry.timeUsedInLast7D = cursor.getLong(6);
                entry.timeUsedInLast3D = cursor.getLong(7);
                entry.timeUsedInLast1D = cursor.getLong(8);
                entry.timeUsedInLast3Y = cursor.getLong(9);
                entry.installedAt = cursor.getLong(10);
                entry.updatedAt = cursor.getLong(11);
                entry.uninstalledAt = cursor.getLong(12);
                entry.lastTimeInForeground = cursor.getLong(13);
                entry.lastUsedAt = cursor.getLong(14);
                records.add(entry);
            }
        }
        catch (Exception e) {
            DNALogger.e("getAllAppRecords: " + e.getMessage());
            DNADatabaseInterface.wipeOutDatabaseAndReset(context);
        }
        return records;
    }

    public static boolean isAppRecordUninstalled(Context context, String packageName, String userId) {
        SQLiteDatabase db = DNADatabaseInterface.getDatabase(context);
        if (db == null) {
            return true;
        }
        String userIdToUse = userId;
        if (userIdToUse == null || userIdToUse.isEmpty()) {
            UserHandle currentUserHandle = Process.myUserHandle();
            userIdToUse = currentUserHandle.toString();
        }
        boolean isUninstalled = false;
        String[] selArgs = new String[]{packageName, userIdToUse};
        String[] columns = new String[]{"COUNT(*)"};
        try (Cursor cursor = db.query("apps", columns, "packageName = ? AND userId = ? AND uninstalledAt = 0", selArgs, null, null, null);){
            if (cursor.moveToNext()) {
                int installedCount = cursor.getInt(0);
                isUninstalled = installedCount == 0;
            }
        }
        catch (Exception e) {
            DNALogger.e("getCurrentCountOfAppRecords: " + e.getMessage());
        }
        return isUninstalled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void insertOrUpdateShortcutRecords(Context context, List<DNAShortcutRecord> shortcuts) {
        SQLiteDatabase db = DNADatabaseInterface.getDatabase(context);
        if (db == null) {
            return;
        }
        db.beginTransaction();
        try {
            for (DNAShortcutRecord shortcut : shortcuts) {
                int rowsAffected;
                ContentValues values = new ContentValues();
                values.put("name", shortcut.name);
                values.put("description", shortcut.description);
                values.put("packageName", shortcut.packageName);
                values.put("intentUri", shortcut.intentUri);
                values.put("rank", Integer.valueOf(shortcut.rank));
                values.put("source", Integer.valueOf(shortcut.source));
                values.put("updatedAt", Long.valueOf(shortcut.updatedAt));
                if (shortcut.networkId != null) {
                    values.put("networkId", shortcut.networkId);
                }
                if ((rowsAffected = db.update("shortcuts", values, "intentUri = ? and packageName = ?", new String[]{shortcut.intentUri, shortcut.packageName})) != 0) continue;
                DNALogger.i("insertShortcutRecords: inserting shortcut: " + shortcut.packageName);
                db.insert("shortcuts", null, values);
            }
            db.setTransactionSuccessful();
        }
        catch (Exception e) {
            DNALogger.e("insertOrUpdateShortcutRecords: " + e.getMessage());
        }
        finally {
            db.endTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void pruneShortcutRecords(Context context) {
        SQLiteDatabase db = DNADatabaseInterface.getDatabase(context);
        if (db == null) {
            return;
        }
        db.beginTransaction();
        try {
            Cursor cursor = db.query("shortcuts", new String[]{"_id", "packageName", "source", "updatedAt"}, null, null, null, null, "updatedAt DESC");
            cursor.moveToFirst();
            ArrayList<DNAShortcutRecord> records = new ArrayList<DNAShortcutRecord>(cursor.getCount());
            while (!cursor.isAfterLast()) {
                DNAShortcutRecord entry = new DNAShortcutRecord();
                entry.dbId = cursor.getLong(0);
                entry.packageName = cursor.getString(1);
                entry.source = cursor.getInt(2);
                entry.updatedAt = cursor.getLong(3);
                records.add(entry);
                cursor.moveToNext();
            }
            cursor.close();
            HashMap<String, Integer> packageCounts = new HashMap<String, Integer>();
            for (DNAShortcutRecord shortcut : records) {
                if (shortcut.source != 1) continue;
                Integer count = (Integer)packageCounts.get(shortcut.packageName);
                if (count == null) {
                    count = 0;
                }
                packageCounts.put(shortcut.packageName, count + 1);
                if (count < 10) continue;
                db.delete("shortcuts", "_id = ?", new String[]{Long.toString(shortcut.dbId)});
            }
            db.setTransactionSuccessful();
        }
        catch (Exception e) {
            DNALogger.e("pruneShortcutRecords: " + e.getMessage());
        }
        finally {
            db.endTransaction();
        }
    }

    public static List<DNAShortcutRecord> getAllShortcuts(Context context) {
        SQLiteDatabase db = DNADatabaseInterface.getDatabase(context);
        if (db == null) {
            return DNASettingShortcutDataSource.getSettingsShortcuts();
        }
        try {
            Cursor cursor = db.query("shortcuts", new String[]{"_id", "name", "description", "packageName", "intentUri", "rank", "source", "updatedAt"}, null, null, null, null, "updatedAt DESC");
            cursor.moveToFirst();
            List<DNAShortcutRecord> records = DNASettingShortcutDataSource.getSettingsShortcuts();
            while (!cursor.isAfterLast()) {
                DNAShortcutRecord entry = new DNAShortcutRecord();
                entry.dbId = cursor.getLong(0);
                entry.name = cursor.getString(1);
                entry.description = cursor.getString(2);
                entry.packageName = cursor.getString(3);
                entry.intentUri = cursor.getString(4);
                entry.rank = cursor.getInt(5);
                entry.source = cursor.getInt(6);
                entry.updatedAt = cursor.getLong(7);
                records.add(entry);
                cursor.moveToNext();
            }
            cursor.close();
            return records;
        }
        catch (Exception e) {
            DNALogger.e("getAllShortcuts: " + e.getMessage());
            DNADatabaseInterface.wipeOutDatabaseAndReset(context);
            return new ArrayList<DNAShortcutRecord>();
        }
    }

    public static void removeShortcuts(Context context, String packageName) {
        SQLiteDatabase db = DNADatabaseInterface.getDatabase(context);
        if (db == null) {
            return;
        }
        try {
            db.delete("shortcuts", "packageName LIKE ?", new String[]{"%" + packageName + "%"});
        }
        catch (Exception e) {
            DNALogger.e("removeShortcuts: " + e.getMessage());
        }
    }

    public static void removeShortcutsFromServer(Context context, String packageName) {
        SQLiteDatabase db = DNADatabaseInterface.getDatabase(context);
        if (db == null) {
            return;
        }
        try {
            db.delete("shortcuts", "source = 2 and packageName = ?", new String[]{packageName});
        }
        catch (Exception e) {
            DNALogger.e("removeShortcuts: " + e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteShortcutRecords(Context context, List<String> shortcutIds) {
        SQLiteDatabase db = DNADatabaseInterface.getDatabase(context);
        if (db == null) {
            return;
        }
        db.beginTransaction();
        try {
            for (String sId : shortcutIds) {
                DNALogger.i("deleteShortcutRecords: delete shortcut with ID: " + sId);
                db.delete("shortcuts", "networkId = ?", new String[]{sId});
            }
            db.setTransactionSuccessful();
        }
        catch (Exception e) {
            DNALogger.e("deleteShortcutRecords: " + e.getMessage());
        }
        finally {
            db.endTransaction();
        }
    }

    public static void removeAllShortcuts(Context context) {
        SQLiteDatabase db = DNADatabaseInterface.getDatabase(context);
        if (db == null) {
            return;
        }
        try {
            db.delete("shortcuts", null, null);
        }
        catch (Exception e) {
            DNALogger.e("removeAllShortcuts: " + e.getMessage());
        }
    }

    public static void insertNotifRecord(Context context, String name, String description, String packageName) {
        SQLiteDatabase db = DNADatabaseInterface.getDatabase(context);
        if (db == null) {
            return;
        }
        ContentValues values = new ContentValues();
        values.put("name", name);
        values.put("description", description);
        values.put("packageName", packageName);
        values.put("sentAt", Long.valueOf(System.currentTimeMillis()));
        try {
            db.insert("notifs", null, values);
            if (Math.random() <= 0.005) {
                long oneWeekAgo = 604800000L;
                db.delete("notifs", "sentAt < ?", new String[]{Long.toString(System.currentTimeMillis() - oneWeekAgo)});
                db.execSQL("VACUUM");
            }
        }
        catch (Exception e) {
            DNALogger.e("insertNotifRecord: " + e.getMessage());
        }
    }

    public static List<DNANotifRecord> getAllNotifs(Context context) {
        SQLiteDatabase db = DNADatabaseInterface.getDatabase(context);
        if (db == null) {
            return new ArrayList<DNANotifRecord>();
        }
        String[] columns = new String[]{"_id", "name", "description", "packageName", "sentAt"};
        ArrayList<DNANotifRecord> records = new ArrayList<DNANotifRecord>();
        try (Cursor cursor = db.query("notifs", columns, null, null, null, null, "sentAt DESC");){
            while (cursor.moveToNext()) {
                DNANotifRecord entry = new DNANotifRecord();
                entry.dbId = cursor.getLong(0);
                entry.name = cursor.getString(1);
                entry.description = cursor.getString(2);
                entry.packageName = cursor.getString(3);
                entry.sentAt = cursor.getLong(4);
                records.add(entry);
            }
        }
        catch (Exception e) {
            DNALogger.e("getAllNotifs: " + e.getMessage());
            DNADatabaseInterface.wipeOutDatabaseAndReset(context);
        }
        return records;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void pruneNotifsRecords(Context context) {
        SQLiteDatabase db = DNADatabaseInterface.getDatabase(context);
        if (db == null) {
            return;
        }
        db.beginTransaction();
        try {
            Cursor cursor = db.query("notifs", new String[]{"_id", "packageName", "sentAt"}, null, null, null, null, "sentAt DESC");
            cursor.moveToFirst();
            ArrayList<DNANotifRecord> records = new ArrayList<DNANotifRecord>(cursor.getCount());
            while (!cursor.isAfterLast()) {
                DNANotifRecord entry = new DNANotifRecord();
                entry.dbId = cursor.getLong(0);
                entry.packageName = cursor.getString(1);
                entry.sentAt = cursor.getLong(2);
                records.add(entry);
                cursor.moveToNext();
            }
            cursor.close();
            HashMap<String, Integer> packageCounts = new HashMap<String, Integer>();
            for (DNANotifRecord notif : records) {
                Integer count = (Integer)packageCounts.get(notif.packageName);
                if (count == null) {
                    count = 0;
                }
                packageCounts.put(notif.packageName, count + 1);
                if (count < 10) continue;
                db.delete("notifs", "_id = ?", new String[]{Long.toString(notif.dbId)});
            }
            db.setTransactionSuccessful();
        }
        catch (Exception e) {
            DNALogger.e("pruneNotifsRecords: " + e.getMessage());
        }
        finally {
            db.endTransaction();
        }
    }
}

