/*
 * Decompiled with CFR 0.152.
 */
package com.devicenative.dna.datasource.loader;

import android.app.usage.UsageStats;
import android.app.usage.UsageStatsManager;
import android.content.Context;
import com.devicenative.dna.datasource.loader.DNALoader;
import com.devicenative.dna.db.DNAAppRecord;
import com.devicenative.dna.db.DNADatabaseInterface;
import com.devicenative.dna.db.DNADatabaseQueue;
import com.devicenative.dna.utils.DNALogger;
import com.devicenative.dna.utils.DNAPreferences;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class DNAUsageStatsLoader
extends DNALoader {
    public DNAUsageStatsLoader(Context context) {
        super(context);
    }

    @Override
    public void run() {
        DNADatabaseQueue.enqueue((Context)this.context.get(), () -> this.syncUsageStats());
    }

    private void syncUsageStats() {
        Context ctx = (Context)this.context.get();
        DNAPreferences prefs = DNAPreferences.getInstance(ctx);
        boolean hasInstallDateBeenRead = prefs.getFirstUsageRead();
        UsageStatsManager usageStatsManager = (UsageStatsManager)ctx.getSystemService("usagestats");
        if (usageStatsManager == null) {
            prefs.setUsageStatsEnabled(false);
            this.runnableFinished();
            return;
        }
        long time7D = System.currentTimeMillis() - 604800000L;
        long time3D = System.currentTimeMillis() - 259200000L;
        long time1D = System.currentTimeMillis() - 86400000L;
        List queryUsageStats = null;
        try {
            queryUsageStats = usageStatsManager.queryUsageStats(0, time7D, System.currentTimeMillis());
        }
        catch (RuntimeException e) {
            DNALogger.e("DNAUsageStatsLoader: queryUsageStats failed: " + e.getMessage());
        }
        Calendar cal = Calendar.getInstance();
        cal.add(1, -2);
        List<DNAAppRecord> apps = DNADatabaseInterface.getAllAppRecords(ctx);
        Map longTermStatsMap = new HashMap();
        try {
            longTermStatsMap = usageStatsManager.queryAndAggregateUsageStats(cal.getTimeInMillis(), System.currentTimeMillis());
        }
        catch (RuntimeException e) {
            DNALogger.e("DNAUsageStatsLoader: queryAndAggregateUsageStats failed: " + e.getMessage());
        }
        if (!(queryUsageStats == null || queryUsageStats.isEmpty() || prefs.getAppUsageDisabled() || prefs.getConfigAppUsageDisabled())) {
            prefs.setUsageStatsEnabled(true);
            HashMap statsMap = new HashMap();
            for (UsageStats stats : queryUsageStats) {
                String packageName = stats.getPackageName();
                if (statsMap.containsKey(packageName)) {
                    ((List)statsMap.get(packageName)).add(stats);
                    continue;
                }
                ArrayList<UsageStats> statsList = new ArrayList<UsageStats>();
                statsList.add(stats);
                statsMap.put(packageName, statsList);
            }
            for (DNAAppRecord app : apps) {
                if (statsMap.containsKey(app.packageName)) {
                    List statsList = (List)statsMap.get(app.packageName);
                    long lastUsedAt = 0L;
                    long lastTimeInForeground = 0L;
                    long timeUsedInLast7D = 0L;
                    long timeUsedInLast3D = 0L;
                    long timeUsedInLast1D = 0L;
                    for (UsageStats stats : statsList) {
                        if (stats.getLastTimeUsed() > lastUsedAt) {
                            lastUsedAt = stats.getLastTimeUsed();
                        }
                        if (stats.getTotalTimeInForeground() > 0L && stats.getLastTimeUsed() > lastTimeInForeground) {
                            lastTimeInForeground = stats.getLastTimeUsed();
                        }
                        timeUsedInLast7D += stats.getTotalTimeInForeground() / 1000L;
                        if (stats.getLastTimeStamp() > time3D) {
                            timeUsedInLast3D += stats.getTotalTimeInForeground() / 1000L;
                        }
                        if (stats.getLastTimeStamp() <= time1D) continue;
                        timeUsedInLast1D += stats.getTotalTimeInForeground() / 1000L;
                    }
                    app.lastUsedAt = lastUsedAt;
                    app.lastTimeInForeground = lastTimeInForeground;
                    app.timeUsedInLast7D = timeUsedInLast7D;
                    app.timeUsedInLast3D = timeUsedInLast3D;
                    app.timeUsedInLast1D = timeUsedInLast1D;
                    if (!longTermStatsMap.containsKey(app.packageName)) continue;
                    app.timeUsedInLast3Y = Objects.requireNonNull((UsageStats)longTermStatsMap.get(app.packageName)).getTotalTimeInForeground() / 1000L;
                    continue;
                }
                app.timeUsedInLast7D = 0L;
                app.timeUsedInLast3D = 0L;
                app.timeUsedInLast1D = 0L;
            }
            if (!hasInstallDateBeenRead) {
                prefs.setFirstUsageRead(true);
            }
            DNADatabaseInterface.insertOrUpdateAppRecords(ctx, apps);
            prefs.setLastUsageSyncTime(System.currentTimeMillis());
        } else {
            prefs.setUsageStatsEnabled(false);
        }
        this.runnableFinished();
    }
}

