/*
 * Decompiled with CFR 0.152.
 */
package com.devicenative.dna.datasource.loader;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.LauncherApps;
import android.content.pm.PackageManager;
import android.content.pm.ShortcutInfo;
import android.os.Build;
import android.os.UserHandle;
import android.os.UserManager;
import android.text.TextUtils;
import com.devicenative.dna.datasource.loader.DNALoader;
import com.devicenative.dna.db.DNADatabaseInterface;
import com.devicenative.dna.db.DNAShortcutRecord;
import com.devicenative.dna.utils.DNALogger;
import com.devicenative.dna.utils.DNAPreferences;
import java.util.ArrayList;
import java.util.List;

public class DNAShortcutLoader
extends DNALoader {
    public DNAShortcutLoader(Context context) {
        super(context);
    }

    @Override
    public void run() {
        long start = System.currentTimeMillis();
        Context ctx = (Context)this.context.get();
        DNAPreferences prefs = DNAPreferences.getInstance(ctx);
        ArrayList<DNAShortcutRecord> shortcutRecords = new ArrayList<DNAShortcutRecord>();
        ArrayList shortcutInfoList = new ArrayList();
        if (Build.VERSION.SDK_INT >= 26) {
            try {
                UserManager manager = (UserManager)ctx.getSystemService("user");
                LauncherApps launcherApps = (LauncherApps)ctx.getSystemService("launcherapps");
                if (launcherApps.hasShortcutHostPermission()) {
                    LauncherApps.ShortcutQuery shortcutQuery = new LauncherApps.ShortcutQuery();
                    shortcutQuery.setQueryFlags(11);
                    for (UserHandle profile : manager.getUserProfiles()) {
                        List shortcutsRaw;
                        if (!manager.isUserUnlocked(profile) || (shortcutsRaw = launcherApps.getShortcuts(shortcutQuery, profile)) == null) continue;
                        shortcutInfoList.addAll(shortcutsRaw);
                    }
                }
            }
            catch (SecurityException e) {
                DNALogger.e("DNAShortcutLoader: Unable to get all shortcuts: " + e.getMessage());
            }
            PackageManager packageManager = ctx.getPackageManager();
            for (ShortcutInfo sInfo : shortcutInfoList) {
                if (Thread.currentThread().isInterrupted()) {
                    return;
                }
                DNAShortcutRecord shortcutRecord = new DNAShortcutRecord();
                shortcutRecord.intentUri = sInfo.getId();
                shortcutRecord.packageName = sInfo.getPackage();
                shortcutRecord.source = sInfo.isDynamic() ? 1 : 0;
                shortcutRecord.rank = sInfo.getRank();
                shortcutRecord.updatedAt = sInfo.getLastChangedTimestamp();
                String appName = "";
                try {
                    ApplicationInfo info = packageManager.getApplicationInfo(shortcutRecord.packageName, 128);
                    appName = packageManager.getApplicationLabel(info).toString();
                }
                catch (PackageManager.NameNotFoundException e) {
                    DNALogger.e("DNAShortcutLoader: Unable to get name of app for shortcut with package name: " + shortcutRecord.packageName);
                }
                if (sInfo.getShortLabel() != null) {
                    shortcutRecord.name = !TextUtils.isEmpty((CharSequence)appName) ? appName + ": " + sInfo.getShortLabel().toString() : sInfo.getShortLabel().toString();
                }
                if (sInfo.getLongLabel() != null) {
                    shortcutRecord.description = sInfo.getLongLabel().toString();
                }
                if (shortcutRecord.name == null || shortcutRecord.name.isEmpty()) {
                    if (!TextUtils.isEmpty((CharSequence)appName) && !TextUtils.isEmpty((CharSequence)shortcutRecord.description)) {
                        shortcutRecord.name = appName + ": " + shortcutRecord.description;
                        shortcutRecord.description = null;
                    } else if (!TextUtils.isEmpty((CharSequence)shortcutRecord.description)) {
                        shortcutRecord.name = shortcutRecord.description;
                        shortcutRecord.description = null;
                    }
                }
                if (shortcutRecord.name == null || shortcutRecord.name.isEmpty()) continue;
                shortcutRecords.add(shortcutRecord);
            }
            DNADatabaseInterface.insertOrUpdateShortcutRecords(ctx, shortcutRecords);
        }
        if (Build.VERSION.SDK_INT < 26 || shortcutRecords.size() > 0) {
            prefs.setShortcutsLoaded();
        }
        this.runnableFinished();
    }
}

