/*
 * Decompiled with CFR 0.152.
 */
package com.devicenative.dna.datasource;

import android.app.Service;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.LauncherApps;
import android.content.pm.PackageManager;
import android.content.pm.ShortcutInfo;
import android.os.Build;
import android.os.UserHandle;
import android.text.TextUtils;
import com.devicenative.dna.datasource.DNADataSource;
import com.devicenative.dna.datasource.loader.DNAShortcutLoader;
import com.devicenative.dna.db.DNADatabaseInterface;
import com.devicenative.dna.db.DNAShortcutRecord;
import com.devicenative.dna.utils.DNALauncherAppsCallback;
import com.devicenative.dna.utils.DNALogger;
import java.util.ArrayList;
import java.util.List;

public class DNAShortcutDataSource
extends DNADataSource {
    public DNAShortcutDataSource(Service service) {
        super(service);
        DNALogger.i("DNAShortcutDataSource: constructor / registering for intent changes");
        final Context context = service.getApplicationContext();
        if (Build.VERSION.SDK_INT >= 26) {
            LauncherApps launcher = (LauncherApps)context.getSystemService("launcherapps");
            if (launcher == null) {
                DNALogger.e("DNAShortcutDataSource: Unable to get launcher service");
                return;
            }
            launcher.registerCallback((LauncherApps.Callback)new DNALauncherAppsCallback(){

                @Override
                public void onShortcutsChanged(String packageName, List<ShortcutInfo> shortcuts, UserHandle user) {
                    new Thread(() -> {
                        PackageManager packageManager = context.getPackageManager();
                        ArrayList<DNAShortcutRecord> shortcutRecords = new ArrayList<DNAShortcutRecord>();
                        for (ShortcutInfo sInfo : shortcuts) {
                            DNAShortcutRecord shortcutRecord = new DNAShortcutRecord();
                            shortcutRecord.intentUri = sInfo.getId();
                            shortcutRecord.packageName = sInfo.getPackage();
                            shortcutRecord.source = sInfo.isDynamic() ? 1 : 0;
                            shortcutRecord.rank = sInfo.getRank();
                            shortcutRecord.updatedAt = sInfo.getLastChangedTimestamp();
                            String appName = "";
                            try {
                                ApplicationInfo info = packageManager.getApplicationInfo(shortcutRecord.packageName, 128);
                                appName = packageManager.getApplicationLabel(info).toString();
                            }
                            catch (PackageManager.NameNotFoundException e) {
                                DNALogger.e("DNAShortcutLoader: Unable to get name of app for shortcut with package name: " + shortcutRecord.packageName);
                            }
                            if (sInfo.getShortLabel() != null) {
                                shortcutRecord.name = !TextUtils.isEmpty((CharSequence)appName) ? appName + ": " + sInfo.getShortLabel().toString() : sInfo.getShortLabel().toString();
                            }
                            if (sInfo.getLongLabel() != null) {
                                shortcutRecord.description = sInfo.getLongLabel().toString();
                            }
                            if (shortcutRecord.name == null || shortcutRecord.name.isEmpty()) {
                                if (!TextUtils.isEmpty((CharSequence)appName) && !TextUtils.isEmpty((CharSequence)shortcutRecord.description)) {
                                    shortcutRecord.name = appName + ": " + shortcutRecord.description;
                                    shortcutRecord.description = null;
                                } else if (!TextUtils.isEmpty((CharSequence)shortcutRecord.description)) {
                                    shortcutRecord.name = shortcutRecord.description;
                                    shortcutRecord.description = null;
                                }
                            }
                            if (shortcutRecord.name == null || shortcutRecord.name.isEmpty()) continue;
                            DNALogger.i("DNAShortcutLoader: package: " + shortcutRecord.packageName + ", shortcut name: " + shortcutRecord.name);
                            shortcutRecords.add(shortcutRecord);
                        }
                        DNADatabaseInterface.insertOrUpdateShortcutRecords(context, shortcutRecords);
                        DNADatabaseInterface.pruneShortcutRecords(context);
                    }).start();
                }
            });
        }
    }

    @Override
    public void loadData() {
        super.loadData();
        this.initialize(new DNAShortcutLoader((Context)this.context.get()));
    }
}

