/*
 * Decompiled with CFR 0.152.
 */
package com.devicenative.dna.datasource;

import android.app.Service;
import android.content.Context;
import com.devicenative.dna.DNADataOrchestrator;
import com.devicenative.dna.datasource.loader.DNALoader;
import com.devicenative.dna.datasource.loader.DNALoaderUpdateListener;
import com.devicenative.dna.utils.DNALogger;
import java.lang.ref.WeakReference;

public abstract class DNADataSource {
    final WeakReference<Context> context;
    private final DNALoaderUpdateListener updateListener;
    private Thread loaderThread;
    private boolean loaded = false;
    private long start;

    public DNADataSource(Service service) {
        this.context = new WeakReference<Context>(service.getApplicationContext());
        this.updateListener = (DNADataOrchestrator)service;
    }

    void initialize(DNALoader loader) {
        this.cancelLoading();
        this.start = System.currentTimeMillis();
        loader.setProvider(this);
        this.loaderThread = new Thread(loader);
        this.loaderThread.start();
    }

    public void loadData() {
        DNALogger.i("DNADataSource: Loading data: " + this.getClass().getSimpleName());
    }

    private void cancelLoading() {
        if (this.loaderThread != null) {
            this.loaderThread.interrupt();
            this.loaderThread = null;
        }
    }

    public void setIsLoaded(boolean loaded) {
        this.loaded = loaded;
    }

    public boolean isLoaded() {
        return this.loaded;
    }

    public void loadingComplete() {
        long time = System.currentTimeMillis() - this.start;
        DNALogger.i("DNADataSource: Time to load " + this.getClass().getSimpleName() + ": " + time + "ms");
        this.loaded = true;
        this.updateListener.onLoaderUpdate(this.getClass().getSimpleName(), 1);
        this.loaderThread = null;
    }
}

