/*
 * Decompiled with CFR 0.152.
 */
package com.devicenative.dna.datasource;

import android.app.Service;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.IntentFilter;
import android.content.pm.LauncherApps;
import android.os.UserHandle;
import android.os.UserManager;
import com.devicenative.dna.broadcast.DNAPackageChangedReceiver;
import com.devicenative.dna.datasource.DNADataSource;
import com.devicenative.dna.datasource.loader.DNAAppLoader;
import com.devicenative.dna.db.DNADatabaseQueue;
import com.devicenative.dna.utils.DNALauncherAppsCallback;
import com.devicenative.dna.utils.DNALogger;

public class DNAAppDataSource
extends DNADataSource {
    public DNAAppDataSource(Service service) {
        super(service);
        Context context = service.getApplicationContext();
        UserManager manager = (UserManager)context.getSystemService("user");
        if (manager == null) {
            DNALogger.e("DNAAppDataSource: Unable to get user manager");
            return;
        }
        LauncherApps launcher = (LauncherApps)context.getSystemService("launcherapps");
        if (launcher == null) {
            DNALogger.e("DNAAppDataSource: Unable to get launcher service");
            return;
        }
        launcher.registerCallback((LauncherApps.Callback)new DNALauncherAppsCallback(){

            @Override
            public void onPackageAdded(String packageName, UserHandle user) {
                this.handleEvent("android.intent.action.PACKAGE_ADDED", packageName, null, user, false);
            }

            @Override
            public void onPackageChanged(String packageName, UserHandle user) {
                this.handleEvent("android.intent.action.PACKAGE_CHANGED", packageName, null, user, false);
            }

            @Override
            public void onPackageRemoved(String packageName, UserHandle user) {
                this.handleEvent("android.intent.action.PACKAGE_REMOVED", packageName, null, user, false);
            }

            @Override
            public void onPackagesAvailable(String[] packageNames, UserHandle user, boolean replacing) {
                this.handleEvent("android.intent.action.MEDIA_MOUNTED", null, packageNames, user, replacing);
            }

            @Override
            public void onPackagesSuspended(String[] packageNames, UserHandle user) {
                this.handleEvent("android.intent.action.PACKAGES_SUSPENDED", null, packageNames, user, false);
            }

            @Override
            public void onPackagesUnsuspended(String[] packageNames, UserHandle user) {
                this.handleEvent("android.intent.action.PACKAGES_UNSUSPENDED", null, packageNames, user, false);
            }

            @Override
            public void onPackagesUnavailable(String[] packageNames, UserHandle user, boolean replacing) {
                this.handleEvent("android.intent.action.MEDIA_UNMOUNTED", null, packageNames, user, replacing);
            }

            private void handleEvent(String action, String packageName, String[] packageList, UserHandle user, boolean replacing) {
                DNADatabaseQueue.enqueue((Context)DNAAppDataSource.this.context.get(), () -> DNAPackageChangedReceiver.handleEvent((Context)DNAAppDataSource.this.context.get(), action, packageName, packageList, user.toString(), replacing));
            }
        });
        IntentFilter appChangedFilter = new IntentFilter();
        appChangedFilter.addAction("android.intent.action.PACKAGE_ADDED");
        appChangedFilter.addAction("android.intent.action.PACKAGE_CHANGED");
        appChangedFilter.addAction("android.intent.action.PACKAGE_REMOVED");
        appChangedFilter.addDataScheme("package");
        appChangedFilter.addDataScheme("file");
        context.registerReceiver((BroadcastReceiver)new DNAPackageChangedReceiver(), appChangedFilter);
    }

    @Override
    public void loadData() {
        super.loadData();
        this.initialize(new DNAAppLoader((Context)this.context.get()));
    }
}

