/*
 * Decompiled with CFR 0.152.
 */
package com.devicenative.dna.ads;

import android.content.ActivityNotFoundException;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.LauncherActivityInfo;
import android.content.pm.LauncherApps;
import android.content.pm.ShortcutInfo;
import android.net.Uri;
import android.os.Build;
import android.os.Process;
import android.os.UserHandle;
import com.devicenative.dna.DeviceNativeClickHandler;
import com.devicenative.dna.ads.DNALinkResultCacheManager;
import com.devicenative.dna.utils.DNALogger;
import com.devicenative.dna.utils.DNAPreferences;
import com.devicenative.dna.utils.DNAStatsLogger;
import com.devicenative.dna.utils.DNAUtils;
import java.lang.reflect.Method;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import org.json.JSONObject;

public class DNAdLinkHandler {
    DNALinkResultCacheManager linkResultCacheManager_;

    public DNAdLinkHandler(int adCacheTimeLimitMs) {
        this.linkResultCacheManager_ = new DNALinkResultCacheManager(adCacheTimeLimitMs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void asyncLinkProcessor(Context context, String urlString, String adId, String adAppName, String adPackageName, String clickId, String productSource, DeviceNativeClickHandler clickHandler) {
        block14: {
            DNAPreferences prefs = DNAPreferences.getInstance(context);
            long startTime = System.currentTimeMillis();
            String completedUrlString = DNAdLinkHandler.completeMacrosInURL(prefs, urlString, clickId, productSource);
            HttpURLConnection connection = null;
            try {
                URL url = new URL(completedUrlString);
                DNALogger.i("about to start link request sync: " + completedUrlString);
                connection = (HttpURLConnection)url.openConnection();
                String userAgent = prefs.getUserAgent(context);
                if (userAgent != null && !userAgent.isEmpty()) {
                    connection.setRequestProperty("User-Agent", userAgent);
                } else {
                    connection.setRequestProperty("User-Agent", System.getProperty("http.agent"));
                }
                connection.setRequestMethod("GET");
                connection.setInstanceFollowRedirects(true);
                connection.setConnectTimeout(30000);
                connection.setReadTimeout(30000);
                connection.connect();
                int responseCode = connection.getResponseCode();
                if (responseCode == 400 || responseCode == 500 || responseCode == 404) break block14;
                if (clickHandler != null) {
                    clickHandler.onClickServerCompleted();
                }
                JSONObject statsMetadata = new JSONObject();
                try {
                    statsMetadata.put("sId", (Object)prefs.getSessionID());
                    statsMetadata.put("url", (Object)urlString);
                    statsMetadata.put("clickId", (Object)clickId);
                    statsMetadata.put("adId", (Object)adId);
                    statsMetadata.put("adAppName", (Object)adAppName);
                    statsMetadata.put("adPackageName", (Object)adPackageName);
                }
                catch (Exception je) {
                    DNALogger.e("DeviceNativeAds: Unable to create stats metadata");
                }
                long endTime = System.currentTimeMillis();
                DNAStatsLogger.logInternal(context, "Async Link Fetch", (int)(endTime - startTime), statsMetadata);
            }
            catch (Exception e) {
                if (clickHandler != null) {
                    clickHandler.onFailure(0, e.getMessage());
                }
                DNALogger.e("DeviceNativeAds: Error in asyncLinkProcessor: " + e.getMessage());
                JSONObject statsMetadata = new JSONObject();
                try {
                    statsMetadata.put("sId", (Object)prefs.getSessionID());
                    statsMetadata.put("loc", (Object)"asyncLinkProcessor");
                    statsMetadata.put("url", (Object)urlString);
                    statsMetadata.put("clickId", (Object)clickId);
                    statsMetadata.put("adId", (Object)adId);
                    statsMetadata.put("adAppName", (Object)adAppName);
                    statsMetadata.put("adPackageName", (Object)adPackageName);
                    statsMetadata.put("m", (Object)e.getMessage());
                }
                catch (Exception je) {
                    DNALogger.e("DeviceNativeAds: Unable to create stats metadata");
                }
                long endTime = System.currentTimeMillis();
                DNAStatsLogger.logInternal(context, "Error", (int)(endTime - startTime), statsMetadata);
            }
            finally {
                if (connection != null) {
                    connection.disconnect();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void linkRouter(Context context, String urlString, String destinationUrl, String adId, String adAppName, String adPackageName, String component, String userId, String clickId, String productSource, boolean doRoute, boolean earlyOpenPlayStore, String destinationUrlOverride, DeviceNativeClickHandler clickHandler) {
        DNAPreferences prefs = DNAPreferences.getInstance(context);
        if (this.linkResultCacheManager_.isRedirectionActive()) {
            if (clickHandler != null && doRoute) {
                clickHandler.onFailure(0, "Redirection already in progress");
            }
            return;
        }
        if (doRoute) {
            this.linkResultCacheManager_.setRedirectionActive(true);
        }
        long startTime = System.currentTimeMillis();
        boolean destinationUrlIsOverridden = destinationUrlOverride != null && !destinationUrlOverride.isEmpty();
        boolean didRouteAlready = false;
        if (doRoute) {
            DNALinkResultCacheManager.CacheLinkResult cacheItem = this.linkResultCacheManager_.getLinkResultCache(adId);
            if (cacheItem != null && !earlyOpenPlayStore & !destinationUrlIsOverridden) {
                DNALogger.i("Using cached link result for ad: " + adPackageName);
                JSONObject statsMetadata = cacheItem.getLastStatsMetadata();
                try {
                    if (clickHandler != null) {
                        clickHandler.onClickRouterCompleted(true);
                    }
                    this.triggerLinkRoute(context, adPackageName, component, userId, cacheItem.getFinalUrl());
                    didRouteAlready = true;
                    if (clickHandler != null) {
                        clickHandler.onClickRouterCompleted(true);
                    }
                    long endTime = System.currentTimeMillis();
                    statsMetadata.put("cached", true);
                    DNAStatsLogger.logInternal(context, "Link Route", (int)(endTime - startTime), statsMetadata);
                    this.linkResultCacheManager_.setRedirectionActive(false);
                }
                catch (Exception e) {
                    this.fallbackLinkRouter(context, adPackageName, component, adId, adAppName, userId, clickHandler);
                    long endTime = System.currentTimeMillis();
                    try {
                        statsMetadata.put("loc", (Object)"linkRouter");
                        statsMetadata.put("cached", true);
                        statsMetadata.put("m", (Object)e.getMessage());
                    }
                    catch (Exception je) {
                        DNALogger.e("DeviceNativeAds: Unable to edit stats metadata");
                    }
                    DNAStatsLogger.logInternal(context, "Error", (int)(endTime - startTime), statsMetadata);
                    this.linkResultCacheManager_.setRedirectionActive(false);
                }
                return;
            }
            if (earlyOpenPlayStore) {
                String playStoreUrl = "market://details?id=" + adPackageName;
                if (destinationUrlIsOverridden) {
                    playStoreUrl = destinationUrlOverride;
                }
                DNALogger.i("Early opening destination store for ad: " + adPackageName + " with URL: " + playStoreUrl);
                try {
                    this.triggerLinkRoute(context, adPackageName, component, userId, playStoreUrl);
                }
                catch (Exception ex) {
                    DNALogger.e("DeviceNativeAds: Error early opening Play Store: " + ex.getMessage());
                    this.fallbackLinkRouter(context, adPackageName, component, adId, adAppName, userId, clickHandler);
                }
                didRouteAlready = true;
            }
        }
        String completedUrlString = DNAdLinkHandler.completeMacrosInURL(prefs, urlString, clickId, productSource);
        HttpURLConnection connection = null;
        String currentUrl = completedUrlString;
        boolean redirect = true;
        int redirectCount = 0;
        int status = 0;
        try {
            do {
                String destinationUrlRootHost;
                DNALogger.i("about to start link request sync: " + currentUrl);
                URL url = new URL(currentUrl);
                connection = (HttpURLConnection)url.openConnection();
                String userAgent = prefs.getUserAgent(context);
                if (userAgent != null && !userAgent.isEmpty()) {
                    connection.setRequestProperty("User-Agent", userAgent);
                } else {
                    connection.setRequestProperty("User-Agent", System.getProperty("http.agent"));
                }
                connection.setConnectTimeout(prefs.getConnectTimeout());
                connection.setReadTimeout(prefs.getTimeout());
                connection.setInstanceFollowRedirects(false);
                connection.connect();
                status = connection.getResponseCode();
                DNALogger.i("link request sync response code: " + status);
                if (status != 200) {
                    if (status == 302 || status == 301 || status == 303 || status == 307 || status == 308) {
                        ++redirectCount;
                        String redirectUrl = connection.getHeaderField("Location");
                        currentUrl = redirectUrl.startsWith("/") ? url.getProtocol() + "://" + url.getHost() + redirectUrl : (redirectUrl.startsWith("http://") ? redirectUrl.replace("http://", "https://") : redirectUrl);
                        DNALogger.i("link request sync redirect url: " + currentUrl);
                    } else if (status == 400 || status == 500 || status == 404) {
                        redirect = false;
                        if (clickHandler != null && doRoute) {
                            clickHandler.onFailure(status, "Non-successful, non-redirect status code");
                        }
                    }
                }
                String newHostname = "";
                if (currentUrl.startsWith("http")) {
                    URL newUrl = new URL(currentUrl);
                    newHostname = newUrl.getHost();
                }
                if ((destinationUrlRootHost = destinationUrl) != null && !destinationUrlRootHost.isEmpty()) {
                    destinationUrlRootHost = DNAdLinkHandler.getRootDomain(destinationUrl);
                }
                if ((!redirect || !currentUrl.startsWith("market://") && !currentUrl.contains("play.google.com") && (destinationUrlRootHost == null || destinationUrlRootHost.isEmpty() || newHostname.isEmpty() || !newHostname.contains(destinationUrlRootHost)) && currentUrl.startsWith("http")) && status != 200) continue;
                DNALogger.i("Hit terminal URL at " + currentUrl);
                if (clickHandler != null && doRoute) {
                    clickHandler.onClickServerCompleted();
                }
                if (doRoute && !didRouteAlready) {
                    this.triggerLinkRoute(context, adPackageName, component, userId, currentUrl);
                }
                if (clickHandler != null && doRoute) {
                    clickHandler.onClickRouterCompleted(true);
                }
                redirect = false;
                JSONObject statsMetadata = new JSONObject();
                try {
                    statsMetadata.put("sId", (Object)prefs.getSessionID());
                    statsMetadata.put("url", (Object)urlString);
                    statsMetadata.put("lastUrl", (Object)currentUrl);
                    statsMetadata.put("redirectCount", redirectCount);
                    statsMetadata.put("doRoute", doRoute);
                    statsMetadata.put("clickId", (Object)clickId);
                    statsMetadata.put("cached", false);
                    statsMetadata.put("adId", (Object)adId);
                    statsMetadata.put("adAppName", (Object)adAppName);
                    statsMetadata.put("adPackageName", (Object)adPackageName);
                }
                catch (Exception je) {
                    DNALogger.e("DeviceNativeAds: Unable to create stats metadata");
                }
                long endTime = System.currentTimeMillis();
                DNAStatsLogger.logInternal(context, "Link Route", (int)(endTime - startTime), statsMetadata);
                this.linkResultCacheManager_.setLinkResultCache(adId, currentUrl, statsMetadata);
            } while (redirect);
            this.linkResultCacheManager_.setRedirectionActive(false);
        }
        catch (Exception e) {
            DNALogger.e("DeviceNativeAds: Error in linkRouter: " + e.getMessage());
            JSONObject statsMetadata = new JSONObject();
            try {
                statsMetadata.put("sId", (Object)prefs.getSessionID());
                statsMetadata.put("loc", (Object)"linkRouter");
                statsMetadata.put("url", (Object)urlString);
                statsMetadata.put("clickId", (Object)clickId);
                statsMetadata.put("redirectCount", redirectCount);
                statsMetadata.put("cached", false);
                statsMetadata.put("doRoute", doRoute);
                statsMetadata.put("adId", (Object)adId);
                statsMetadata.put("adAppName", (Object)adAppName);
                statsMetadata.put("adPackageName", (Object)adPackageName);
                statsMetadata.put("m", (Object)e.getMessage());
            }
            catch (Exception je) {
                DNALogger.e("DeviceNativeAds: Unable to create stats metadata");
            }
            long endTime = System.currentTimeMillis();
            DNAStatsLogger.logInternal(context, "Error", (int)(endTime - startTime), statsMetadata);
            if (doRoute && !earlyOpenPlayStore) {
                this.fallbackLinkRouter(context, adPackageName, component, adId, adAppName, userId, clickHandler);
            }
            this.linkResultCacheManager_.setRedirectionActive(false);
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
    }

    private void triggerLinkRoute(Context context, String adPackageName, String component, String userId, String finalUrl) throws Exception {
        Intent intent;
        String googlePlayUrlReplacement;
        DNAPreferences prefs = DNAPreferences.getInstance(context);
        DNALogger.i("trying to launch intent: " + finalUrl);
        boolean isMarketUrl = false;
        if (finalUrl.startsWith("market://") || finalUrl.contains("play.google.com")) {
            isMarketUrl = true;
        }
        if (prefs.getReplaceGooglePlayUrl() && (googlePlayUrlReplacement = prefs.getGooglePlayUrlReplacement()) != null && googlePlayUrlReplacement.contains("{packageName}") && isMarketUrl) {
            try {
                Uri currentUri = Uri.parse((String)finalUrl);
                String packageName = currentUri.getQueryParameter("id");
                if (packageName != null && !packageName.isEmpty()) {
                    String remappedBaseUrl = googlePlayUrlReplacement.replace("{packageName}", packageName);
                    Uri.Builder remappedUriBuilder = Uri.parse((String)remappedBaseUrl).buildUpon();
                    for (String paramName : currentUri.getQueryParameterNames()) {
                        String paramValue = currentUri.getQueryParameter(paramName);
                        if (paramValue == null) continue;
                        remappedUriBuilder.appendQueryParameter(paramName, paramValue);
                    }
                    Uri remappedUri = remappedUriBuilder.build();
                    if (remappedUri.isAbsolute()) {
                        finalUrl = remappedUri.toString();
                        DNALogger.i("Successfully remapped Google Play URL: " + finalUrl);
                    } else {
                        DNALogger.e("Remapped URL is not absolute: " + remappedUri.toString());
                    }
                } else {
                    DNALogger.w("No package name found in the original URL: " + finalUrl);
                }
            }
            catch (Exception e) {
                DNALogger.e("Error remapping Google Play URL: " + e.getMessage());
            }
        }
        if (isMarketUrl && prefs.getAutoDeepLinkEnabled()) {
            ApplicationInfo appInfo;
            boolean shouldFallback = false;
            LauncherApps la = (LauncherApps)context.getSystemService(LauncherApps.class);
            if (la == null) {
                shouldFallback = true;
            }
            UserHandle profile = userId != null && !userId.isEmpty() ? DNAUtils.getUserHandleFromFormattedString(userId) : Process.myUserHandle();
            if (!shouldFallback && !la.isPackageEnabled(adPackageName, profile)) {
                shouldFallback = true;
            }
            List launcherActivities = null;
            try {
                if (!shouldFallback && ((launcherActivities = la.getActivityList(adPackageName, profile)) == null || launcherActivities.isEmpty())) {
                    shouldFallback = true;
                }
            }
            catch (Exception e) {
                shouldFallback = true;
            }
            if (!shouldFallback && DNAUtils.isArchived(appInfo = ((LauncherActivityInfo)launcherActivities.get(0)).getApplicationInfo())) {
                shouldFallback = true;
            }
            if (!shouldFallback) {
                if (component != null && !component.isEmpty()) {
                    la.startMainActivity(new ComponentName(adPackageName, component), profile, null, null);
                } else {
                    la.startMainActivity(((LauncherActivityInfo)launcherActivities.get(0)).getComponentName(), profile, null, null);
                }
            } else {
                Intent intent2 = new Intent("android.intent.action.VIEW", Uri.parse((String)finalUrl));
                intent2.addFlags(0x10000000);
                context.startActivity(intent2);
            }
        } else if (finalUrl.startsWith("intent://")) {
            intent = Intent.parseUri((String)finalUrl, (int)1);
            intent.addCategory("android.intent.category.BROWSABLE");
            intent.setSelector(null);
            intent.setComponent(null);
            if (intent.getData() != null) {
                Intent fallbackIntent = new Intent("android.intent.action.VIEW", intent.getData());
                fallbackIntent.addCategory("android.intent.category.BROWSABLE");
                fallbackIntent.addFlags(0x10000000);
                context.startActivity(fallbackIntent);
            } else {
                intent.addFlags(0x10000000);
                context.startActivity(intent);
            }
        } else {
            intent = new Intent("android.intent.action.VIEW", Uri.parse((String)finalUrl));
            intent.addFlags(0x10000000);
            context.startActivity(intent);
        }
    }

    public void settingShortcutRouter(Context context, String intentUri, String packageName, DeviceNativeClickHandler clickHandler) {
        DNAPreferences prefs = DNAPreferences.getInstance(context);
        try {
            Intent intent = new Intent(intentUri);
            intent.addFlags(0x10000000);
            context.startActivity(intent);
            if (clickHandler != null) {
                clickHandler.onClickRouterCompleted(true);
            }
        }
        catch (Exception e) {
            Intent intent = context.getPackageManager().getLaunchIntentForPackage(packageName);
            if (intent != null) {
                intent.addFlags(0x10000000);
                context.startActivity(intent);
                if (clickHandler != null) {
                    clickHandler.onClickRouterCompleted(true);
                }
                return;
            }
            if (clickHandler != null) {
                clickHandler.onFailure(0, e.getMessage());
            }
            JSONObject statsMetadata = new JSONObject();
            try {
                statsMetadata.put("sId", (Object)prefs.getSessionID());
                statsMetadata.put("loc", (Object)"settingShortcutRouter");
                statsMetadata.put("url", (Object)packageName);
                statsMetadata.put("appName", (Object)"Settings");
                statsMetadata.put("packageName", (Object)packageName);
                statsMetadata.put("m", (Object)e.getMessage());
            }
            catch (Exception je) {
                DNALogger.e("DeviceNativeAds: Unable to create stats metadata");
            }
            DNAStatsLogger.logInternal(context, "Error", null, statsMetadata);
        }
    }

    public void shortcutRouter(Context context, String intentUri, String appName, String packageName, DeviceNativeClickHandler clickHandler) {
        long startTime = System.currentTimeMillis();
        if (Build.VERSION.SDK_INT < 26) {
            this.fallbackLinkRouter(context, packageName, null, "shortcut", appName, null, clickHandler);
            return;
        }
        try {
            LauncherApps launcherApps = (LauncherApps)context.getSystemService("launcherapps");
            if (!launcherApps.hasShortcutHostPermission()) {
                this.fallbackLinkRouter(context, packageName, null, "shortcut", appName, null, clickHandler);
                return;
            }
            LauncherApps.ShortcutQuery query = new LauncherApps.ShortcutQuery();
            query.setPackage(packageName);
            query.setShortcutIds(Collections.singletonList(intentUri));
            query.setQueryFlags(11);
            List shortcuts = launcherApps.getShortcuts(query, Process.myUserHandle());
            if (shortcuts != null) {
                for (ShortcutInfo shortcut : shortcuts) {
                    if (!shortcut.isEnabled()) continue;
                    launcherApps.startShortcut(shortcut, null, null);
                    if (clickHandler != null) {
                        clickHandler.onClickRouterCompleted(true);
                    }
                    return;
                }
            }
            this.fallbackLinkRouter(context, packageName, null, "shortcut", appName, null, clickHandler);
        }
        catch (Exception e) {
            if (clickHandler != null) {
                clickHandler.onFailure(0, e.getMessage());
            }
            DNALogger.e("DeviceNativeAds: Error in shortcutRouter: " + e.getMessage());
            DNAPreferences prefs = DNAPreferences.getInstance(context);
            JSONObject statsMetadata = new JSONObject();
            try {
                statsMetadata.put("sId", (Object)prefs.getSessionID());
                statsMetadata.put("loc", (Object)"shortcutRouter");
                statsMetadata.put("url", (Object)intentUri);
                statsMetadata.put("appName", (Object)appName);
                statsMetadata.put("packageName", (Object)packageName);
                statsMetadata.put("m", (Object)e.getMessage());
            }
            catch (Exception je) {
                DNALogger.e("DeviceNativeAds: Unable to create stats metadata");
            }
            long endTime = System.currentTimeMillis();
            DNAStatsLogger.logInternal(context, "Error", (int)(endTime - startTime), statsMetadata);
        }
    }

    public void fallbackLinkRouter(Context context, String packageName, String component, String adId, String adAppName, String userId, DeviceNativeClickHandler clickHandler) {
        DNAPreferences prefs = DNAPreferences.getInstance(context);
        try {
            ApplicationInfo appInfo;
            List activities;
            LauncherApps launcherApps;
            UserHandle userHandle = DNAdLinkHandler.getUserHandle(userId);
            if (userHandle != null && (launcherApps = (LauncherApps)context.getSystemService("launcherapps")) != null && !(activities = launcherApps.getActivityList(packageName, userHandle)).isEmpty() && !DNAUtils.isArchived(appInfo = ((LauncherActivityInfo)activities.get(0)).getApplicationInfo())) {
                if (component != null && !component.isEmpty()) {
                    launcherApps.startMainActivity(new ComponentName(packageName, component), userHandle, null, null);
                    if (clickHandler != null) {
                        clickHandler.onClickRouterCompleted(true);
                    }
                    return;
                }
                launcherApps.startMainActivity(((LauncherActivityInfo)activities.get(0)).getComponentName(), userHandle, null, null);
                if (clickHandler != null) {
                    clickHandler.onClickRouterCompleted(true);
                }
                return;
            }
            Intent intent = context.getPackageManager().getLaunchIntentForPackage(packageName);
            if (intent != null) {
                intent.addFlags(0x10000000);
                context.startActivity(intent);
            } else {
                try {
                    Intent playStoreIntent = new Intent("android.intent.action.VIEW", Uri.parse((String)("market://details?id=" + packageName)));
                    playStoreIntent.addFlags(0x10000000);
                    context.startActivity(playStoreIntent);
                }
                catch (ActivityNotFoundException anfe) {
                    Intent playStoreIntent = new Intent("android.intent.action.VIEW", Uri.parse((String)("https://play.google.com/store/apps/details?id=" + packageName)));
                    playStoreIntent.addFlags(0x10000000);
                    context.startActivity(playStoreIntent);
                }
            }
            if (clickHandler != null) {
                clickHandler.onClickRouterCompleted(true);
            }
        }
        catch (Exception e) {
            if (clickHandler != null) {
                clickHandler.onFailure(0, e.getMessage());
            }
            JSONObject statsMetadata = new JSONObject();
            try {
                statsMetadata.put("sId", (Object)prefs.getSessionID());
                statsMetadata.put("loc", (Object)"fallbackLinkRouter");
                statsMetadata.put("url", (Object)packageName);
                statsMetadata.put("adId", (Object)adId);
                statsMetadata.put("adAppName", (Object)adAppName);
                statsMetadata.put("adPackageName", (Object)packageName);
                statsMetadata.put("m", (Object)e.getMessage());
            }
            catch (Exception je) {
                DNALogger.e("DeviceNativeAds: Unable to create stats metadata");
            }
            DNAStatsLogger.logInternal(context, "Error", null, statsMetadata);
        }
    }

    private static String completeMacrosInURL(DNAPreferences prefs, String url, String clickId, String productSource) {
        url = prefs.getAdidUsageEnabled() && !prefs.getAdid().isEmpty() && !prefs.getConfigGAIDDisabled() ? url.replace("{adId}", prefs.getAdid()) : url.replace("{adId}", "");
        url = url.replace("{packageName}", prefs.getAppPackageName());
        url = url.replace("{clickId}", clickId);
        url = url.replace("{productSource}", productSource);
        return url;
    }

    public static UserHandle getUserHandle(String userHandle) {
        int userId = DNAUtils.readPidFromUserHandleString(userHandle);
        UserHandle targetUserHandle = null;
        if (userId != -1) {
            try {
                Class<?> userHandleClass = Class.forName("android.os.UserHandle");
                Method ofMethod = userHandleClass.getMethod("of", Integer.TYPE);
                targetUserHandle = (UserHandle)ofMethod.invoke(null, userId);
                DNALogger.i("DeviceNativeAds: successfully fetched UserHandle: " + targetUserHandle);
                return targetUserHandle;
            }
            catch (Exception e) {
                DNALogger.i("DeviceNativeAds: Error getting UserHandle: " + e.getMessage());
            }
        }
        return null;
    }

    public static String getRootDomain(String url) {
        String[] parts = url.split("\\.");
        if (parts.length < 2) {
            return url;
        }
        return parts[parts.length - 2] + "." + parts[parts.length - 1];
    }
}

