/*
 * Decompiled with CFR 0.152.
 */
package com.devicenative.dna.ads;

import com.devicenative.dna.DNAResultItem;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;

public class DNAdCacheManager {
    private final long blackoutTimeLimitMs;
    private final long adCacheTimeLimitMs;
    private final ConcurrentHashMap<String, Long> packageTimestamps = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, CacheItem> displayCache = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, CacheItem> searchCache = new ConcurrentHashMap();

    public DNAdCacheManager(long blackoutTimeLimitMs, long adCacheTimeLimitMs) {
        this.blackoutTimeLimitMs = blackoutTimeLimitMs;
        this.adCacheTimeLimitMs = adCacheTimeLimitMs;
    }

    public synchronized void setPackageImpressionTimestamp(String packageName) {
        this.cleanupExpiredPackageImpressionTimestamps();
        this.packageTimestamps.put(packageName, System.currentTimeMillis());
    }

    public boolean getPackageImpressionTimestampExpired(String packageName) {
        Long timestamp = this.packageTimestamps.get(packageName);
        return timestamp == null || System.currentTimeMillis() - timestamp > this.blackoutTimeLimitMs;
    }

    public synchronized void setDisplayCache(List<DNAResultItem> results) {
        this.setDispCache("org-display", results);
    }

    public synchronized void setDisplayLinkCache(List<DNAResultItem> results) {
        this.setDispCache("org-display-links", results);
    }

    public synchronized void setHotAppsCache(List<DNAResultItem> results) {
        this.setDispCache("hot-apps", results);
    }

    public synchronized void setAdsDisplayCache(List<DNAResultItem> results) {
        this.setDispCache("ads-display", results);
    }

    private void setDispCache(String key, List<DNAResultItem> results) {
        this.cleanupExpiredItems(this.displayCache);
        CacheItem item = new CacheItem(results, this.adCacheTimeLimitMs);
        this.displayCache.put(key, item);
    }

    public List<DNAResultItem> getDisplayCache() {
        return this.getDispCache("org-display");
    }

    public List<DNAResultItem> getDisplayLinksCache() {
        return this.getDispCache("org-display-links");
    }

    public List<DNAResultItem> getHotAppsCache() {
        return this.getDispCache("hot-apps");
    }

    public List<DNAResultItem> getAdsDisplayCache() {
        return this.getDispCache("ads-display");
    }

    private List<DNAResultItem> getDispCache(String key) {
        CacheItem item = this.displayCache.get(key);
        if (item != null && item.isExpired()) {
            this.displayCache.remove(key);
            return null;
        }
        if (item != null && !item.isExpired()) {
            return item.getResults();
        }
        return null;
    }

    public synchronized void clearSearchCache() {
        this.searchCache.clear();
    }

    public synchronized void setSearchCache(String query, List<DNAResultItem> results) {
        this.cleanupExpiredItems(this.searchCache);
        CacheItem item = new CacheItem(results, this.adCacheTimeLimitMs);
        this.searchCache.put(query, item);
    }

    public List<DNAResultItem> getSearchCache(String query) {
        CacheItem item = this.searchCache.get(query.toLowerCase());
        if (item != null && item.isExpired()) {
            this.searchCache.remove(query);
            return null;
        }
        if (item != null && !item.isExpired()) {
            return item.getResults();
        }
        return null;
    }

    private void cleanupExpiredPackageImpressionTimestamps() {
        long now = System.currentTimeMillis();
        this.packageTimestamps.entrySet().removeIf(entry -> now - (Long)entry.getValue() > this.blackoutTimeLimitMs);
    }

    private void cleanupExpiredItems(ConcurrentHashMap<String, CacheItem> cache) {
        cache.entrySet().removeIf(entry -> ((CacheItem)entry.getValue()).isExpired());
    }

    public static class CacheItem {
        private final long cacheTimeLimitMs;
        private final long lastLoadTime;
        private final List<DNAResultItem> results;

        public CacheItem(List<DNAResultItem> results, long cacheTimeLimitMs) {
            this.cacheTimeLimitMs = cacheTimeLimitMs;
            this.lastLoadTime = System.currentTimeMillis();
            this.results = results;
        }

        public boolean isExpired() {
            return System.currentTimeMillis() - this.lastLoadTime > this.cacheTimeLimitMs;
        }

        public List<DNAResultItem> getResults() {
            return this.results;
        }
    }
}

