/*
 * Decompiled with CFR 0.152.
 */
package com.devicenative.dna.ads;

import android.content.Context;
import android.content.Intent;
import android.os.Process;
import android.os.UserHandle;
import com.devicenative.dna.DNAResultItem;
import com.devicenative.dna.DeviceNativeClickHandler;
import com.devicenative.dna.ads.DNAAppSearchFallback;
import com.devicenative.dna.ads.DNAResultEngine;
import com.devicenative.dna.ads.DNAdCacheManager;
import com.devicenative.dna.ads.DNAdLinkHandler;
import com.devicenative.dna.db.DNAAppRecord;
import com.devicenative.dna.db.DNADatabaseInterface;
import com.devicenative.dna.db.DNAResultEventRecord;
import com.devicenative.dna.network.DNAStatSyncExecutor;
import com.devicenative.dna.utils.DNALogger;
import com.devicenative.dna.utils.DNAPreferences;
import com.devicenative.dna.utils.DNAStatsLogger;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.json.JSONObject;

public class DNAResultServer {
    private static final String[] ALPHABET_QUERIES = new String[]{"a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "n", "o", "p", "q", "r", "s", "t", "u", "v", "w", "x", "y", "z"};
    private static DNAResultServer instance_;
    private Context context_;
    private boolean isShutdown_ = true;
    private DNAPreferences dnaPreferences_;
    private DNAResultEngine resultEngine_;
    private DNAdCacheManager adCacheManager_;
    private DNAdLinkHandler adLinkHandler_;
    private DNAStatSyncExecutor statSyncExecutor_;
    private ExecutorService executorService_;
    private ExecutorService clickExecutorService_;
    private ScheduledExecutorService scheduledExecutorService_;
    private Future<?> futurePrefetchTask_;
    private Future<?> searchDebounceTask_;
    private Future<?> statsSyncTask_;
    private Future<?> usageSyncTask_;

    private DNAResultServer(Context context) {
        this.init(context);
    }

    public void init(Context context) {
        this.context_ = context;
        this.dnaPreferences_ = DNAPreferences.getInstance(context);
        this.statSyncExecutor_ = new DNAStatSyncExecutor(context);
        this.adLinkHandler_ = new DNAdLinkHandler(this.dnaPreferences_.getAdCacheTimeout());
        this.adCacheManager_ = new DNAdCacheManager(this.dnaPreferences_.getImpressionBlackoutWindow(), this.dnaPreferences_.getAdCacheTimeout());
        this.executorService_ = Executors.newFixedThreadPool(1);
        this.resultEngine_ = new DNAResultEngine(context, this.dnaPreferences_, this.executorService_);
        this.clickExecutorService_ = new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, new SynchronousQueue<Runnable>(), new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread thread = new Thread(r);
                thread.setPriority(10);
                return thread;
            }
        });
        this.scheduledExecutorService_ = Executors.newScheduledThreadPool(1);
        this.isShutdown_ = false;
    }

    public static DNAResultServer getInstance(Context context) {
        if (instance_ == null || DNAResultServer.instance_.isShutdown_) {
            instance_ = new DNAResultServer(context);
        }
        return instance_;
    }

    private synchronized void validateIsActiveAndReinitialize() {
        if (this.isShutdown_) {
            this.dnaPreferences_ = DNAPreferences.getInstance(this.context_);
            this.adLinkHandler_ = new DNAdLinkHandler(this.dnaPreferences_.getAdCacheTimeout());
            this.adCacheManager_ = new DNAdCacheManager(this.dnaPreferences_.getImpressionBlackoutWindow(), this.dnaPreferences_.getAdCacheTimeout());
            this.executorService_ = Executors.newFixedThreadPool(1);
            this.resultEngine_ = new DNAResultEngine(this.context_, this.dnaPreferences_, this.executorService_);
            this.clickExecutorService_ = new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, new SynchronousQueue<Runnable>(), new ThreadFactory(){

                @Override
                public Thread newThread(Runnable r) {
                    Thread thread = new Thread(r);
                    thread.setPriority(10);
                    return thread;
                }
            });
            this.scheduledExecutorService_ = Executors.newScheduledThreadPool(1);
            this.isShutdown_ = false;
        }
    }

    public static void shutDown() {
        DNAAppSearchFallback.clearCache();
        if (instance_ != null) {
            DNAResultServer.instance_.dnaPreferences_ = null;
            DNAResultServer.instance_.adCacheManager_ = null;
            DNAResultServer.instance_.adLinkHandler_ = null;
            DNAResultServer.instance_.executorService_.shutdown();
            DNAResultServer.instance_.executorService_ = null;
            DNAResultServer.instance_.clickExecutorService_.shutdown();
            DNAResultServer.instance_.clickExecutorService_ = null;
            DNAResultServer.instance_.scheduledExecutorService_.shutdown();
            DNAResultServer.instance_.scheduledExecutorService_ = null;
            DNAResultServer.instance_.resultEngine_ = null;
            DNAResultServer.instance_.futurePrefetchTask_ = null;
            DNAResultServer.instance_.searchDebounceTask_ = null;
            DNAResultServer.instance_.statsSyncTask_ = null;
            DNAResultServer.instance_.isShutdown_ = true;
        }
        instance_ = null;
    }

    private List<DNAResultItem> retrieveCachedDisplayAds(int count) {
        DNALogger.i("retrieveCachedDisplayAds: retrieving cached display ads");
        List<DNAResultItem> ads = this.adCacheManager_.getAdsDisplayCache();
        if (ads != null && !ads.isEmpty() && ads.size() >= count) {
            DNALogger.i("retrieveCachedDisplayAds: retrieved " + ads.size() + " cached display ads");
            return ads.subList(0, count);
        }
        return null;
    }

    private List<DNAResultItem> retrieveCachedSuggestions(int count) {
        DNALogger.i("retrieveCachedSuggestions: retrieving cached recommendations");
        List<DNAResultItem> results = this.adCacheManager_.getDisplayCache();
        if (results != null && !results.isEmpty() && results.size() >= count) {
            DNALogger.i("retrieveCachedSuggestions: retrieved " + results.size() + " cached recommendations");
            return results.subList(0, count);
        }
        return null;
    }

    private List<DNAResultItem> retrieveCachedHotApps(int count) {
        DNALogger.i("retrieveCachedHotApps: retrieving cached hot apps");
        List<DNAResultItem> results = this.adCacheManager_.getHotAppsCache();
        if (results != null && !results.isEmpty() && results.size() >= count) {
            DNALogger.i("retrieveCachedHotApps: retrieved " + results.size() + " cached hot apps");
            return results.subList(0, count);
        }
        return null;
    }

    private List<DNAResultItem> retrieveCachedLinkSuggestions(int count) {
        DNALogger.i("retrieveCachedSuggestions: retrieving cached link recommendations");
        List<DNAResultItem> results = this.adCacheManager_.getDisplayLinksCache();
        if (results != null && !results.isEmpty() && results.size() >= count) {
            DNALogger.i("retrieveCachedSuggestions: retrieved " + results.size() + " cached recommendations");
            return results.subList(0, count);
        }
        return null;
    }

    public void clearCache() {
        if (this.adCacheManager_ == null) {
            return;
        }
        this.adCacheManager_.setDisplayCache(null);
        this.adCacheManager_.clearSearchCache();
    }

    public void prefetchSuggestions() {
        Runnable prefetchRunnable = () -> {
            DNALogger.i("prefetchSuggestions: prefetching suggestions");
            this.validateIsActiveAndReinitialize();
            this.adCacheManager_.setDisplayCache(null);
            DNAResultEngine resultEngine = new DNAResultEngine(this.context_, this.dnaPreferences_, this.executorService_);
            ArrayList<DNAResultItem> results = resultEngine.fetchResultsGeneric("suggested apps", null, true, false, false, null, 4);
            this.adCacheManager_.setDisplayCache(results);
            this.adCacheManager_.clearSearchCache();
            for (String query : ALPHABET_QUERIES) {
                results = this.resultEngine_.fetchResultsGeneric("search", null, true, false, false, query, -1);
                this.adCacheManager_.setSearchCache(query, results);
            }
        };
        if (this.futurePrefetchTask_ != null && !this.futurePrefetchTask_.isDone()) {
            this.futurePrefetchTask_.cancel(true);
        }
        this.futurePrefetchTask_ = this.scheduledExecutorService_.schedule(prefetchRunnable, 1000L, TimeUnit.MILLISECONDS);
    }

    public List<DNAResultItem> fetchOrganicAppSuggestions(int count, String placementTag) {
        DNALogger.i("fetchOrganicAppSuggestions: fetching suggestions with count: " + count);
        long currentTime = System.currentTimeMillis();
        ArrayList<DNAStatsLogger.StatItem> statsItems = new ArrayList<DNAStatsLogger.StatItem>();
        ArrayList<DNAResultItem> resultItemsToImpress = new ArrayList<DNAResultItem>();
        List<DNAResultItem> resultsToReturn = this.retrieveCachedSuggestions(count);
        boolean isCache = true;
        boolean isFallback = false;
        String source = "suggested apps";
        if (resultsToReturn == null || resultsToReturn.isEmpty()) {
            resultsToReturn = this.resultEngine_.fetchResultsGeneric(source, placementTag, true, false, false, null, count);
            isCache = false;
            this.adCacheManager_.setDisplayCache(resultsToReturn);
        }
        if (resultsToReturn == null || resultsToReturn.isEmpty()) {
            DNALogger.i("fetchOrganicResultsForSearch: no search results found, triggering fallback");
            resultsToReturn = DNAAppSearchFallback.getAppResultsForDisplayFallback(this.context_, count);
            isCache = false;
            isFallback = true;
        }
        DNALogger.i("fetchOrganicAppSuggestions: retrieved " + resultsToReturn.size() + " suggestions");
        long endTime = System.currentTimeMillis();
        JSONObject statsMetadata = new JSONObject();
        try {
            statsMetadata.put("sId", (Object)this.dnaPreferences_.getSessionID());
            statsMetadata.put("cache", isCache);
            statsMetadata.put("fallback", isFallback);
            statsMetadata.put("source", (Object)source);
            if (placementTag != null && !placementTag.isEmpty()) {
                statsMetadata.put("placementTag", (Object)placementTag);
            } else {
                statsMetadata.put("placementTag", (Object)source);
            }
        }
        catch (Exception je) {
            DNALogger.e("DeviceNativeAds: Unable to create stats metadata");
        }
        statsItems.add(new DNAStatsLogger.StatItem("Ad Request: Organic Display", (int)(endTime - currentTime), statsMetadata));
        for (DNAResultItem resultItem : resultsToReturn) {
            resultItem.placementTag = placementTag;
            resultItem.source = source;
            if (isCache) {
                resultItem.updateAppInstalledState(this.context_);
            }
            if (resultItem.resultType.equals("ad")) {
                statsMetadata = new JSONObject();
                try {
                    statsMetadata.put("sId", (Object)this.dnaPreferences_.getSessionID());
                    statsMetadata.put("adId", (Object)resultItem.id);
                    statsMetadata.put("adPackageName", (Object)resultItem.packageName);
                    statsMetadata.put("adAppName", (Object)resultItem.appName);
                    statsMetadata.put("here", resultItem.isInstalled);
                    statsMetadata.put("source", (Object)source);
                    statsMetadata.put("cache", isCache);
                    if (placementTag != null && !placementTag.isEmpty()) {
                        statsMetadata.put("placementTag", (Object)placementTag);
                    } else {
                        resultItem.placementTag = source;
                        statsMetadata.put("placementTag", (Object)source);
                    }
                    if (resultItem.statMetadata != null) {
                        Iterator keys = resultItem.statMetadata.keys();
                        while (keys.hasNext()) {
                            String key = (String)keys.next();
                            statsMetadata.put(key, resultItem.statMetadata.get(key));
                        }
                    }
                }
                catch (Exception je) {
                    DNALogger.e("DeviceNativeAds: Unable to create stats metadata");
                }
                statsItems.add(new DNAStatsLogger.StatItem("Ad Request: Organic Display", (int)(endTime - currentTime), statsMetadata));
            }
            resultItemsToImpress.add(resultItem);
        }
        if (!resultItemsToImpress.isEmpty()) {
            this.registerBatchImpression(resultItemsToImpress, null, true, null);
        }
        this.attemptToExecuteRunnableAndReinit(() -> DNAStatsLogger.logBatchInternalSync(this.context_, statsItems));
        return resultsToReturn;
    }

    public List<DNAResultItem> fetchOrganicLinkSuggestions(int count, String placementTag) {
        DNALogger.i("fetchOrganicAppSuggestions: fetching suggestions with count: " + count);
        long currentTime = System.currentTimeMillis();
        ArrayList<DNAStatsLogger.StatItem> statsItems = new ArrayList<DNAStatsLogger.StatItem>();
        ArrayList<DNAResultItem> resultItemsToImpress = new ArrayList<DNAResultItem>();
        List<DNAResultItem> resultsToReturn = this.retrieveCachedLinkSuggestions(count);
        String source = "suggested links";
        boolean isCache = true;
        if (resultsToReturn == null || resultsToReturn.isEmpty()) {
            resultsToReturn = this.resultEngine_.fetchResultsGeneric(source, placementTag, true, true, false, null, count);
            isCache = false;
            this.adCacheManager_.setDisplayLinkCache(resultsToReturn);
        }
        DNALogger.i("fetchOrganicLinkSuggestions: retrieved " + resultsToReturn.size() + " suggestions");
        long endTime = System.currentTimeMillis();
        for (DNAResultItem resultItem : resultsToReturn) {
            resultItem.placementTag = placementTag;
            resultItem.source = source;
            if (isCache) {
                resultItem.updateAppInstalledState(this.context_);
            }
            if (resultItem.resultType.equals("ad")) {
                JSONObject statsMetadata = new JSONObject();
                try {
                    statsMetadata.put("sId", (Object)this.dnaPreferences_.getSessionID());
                    statsMetadata.put("adId", (Object)resultItem.id);
                    statsMetadata.put("adPackageName", (Object)resultItem.packageName);
                    statsMetadata.put("adAppName", (Object)resultItem.appName);
                    statsMetadata.put("here", resultItem.isInstalled);
                    statsMetadata.put("source", (Object)source);
                    statsMetadata.put("cache", isCache);
                    if (placementTag != null && !placementTag.isEmpty()) {
                        statsMetadata.put("placementTag", (Object)placementTag);
                    } else {
                        resultItem.placementTag = source;
                        statsMetadata.put("placementTag", (Object)source);
                    }
                    if (resultItem.statMetadata != null) {
                        Iterator keys = resultItem.statMetadata.keys();
                        while (keys.hasNext()) {
                            String key = (String)keys.next();
                            statsMetadata.put(key, resultItem.statMetadata.get(key));
                        }
                    }
                }
                catch (Exception je) {
                    DNALogger.e("DeviceNativeAds: Unable to create stats metadata");
                }
                statsItems.add(new DNAStatsLogger.StatItem("Ad Request: Organic Display Links", (int)(endTime - currentTime), statsMetadata));
            }
            resultItemsToImpress.add(resultItem);
        }
        if (!resultItemsToImpress.isEmpty()) {
            this.registerBatchImpression(resultItemsToImpress, null);
        }
        this.attemptToExecuteRunnableAndReinit(() -> DNAStatsLogger.logBatchInternalSync(this.context_, statsItems));
        return resultsToReturn;
    }

    public List<DNAResultItem> fetchOrganicResultsForSearch(String query, String placementTag, boolean forDisplay, int count) {
        DNALogger.i("fetchOrganicResultsForSearch: fetching results for query: " + query);
        long currentTime = System.currentTimeMillis();
        ArrayList<DNAStatsLogger.StatItem> statsItems = new ArrayList<DNAStatsLogger.StatItem>();
        ArrayList<DNAResultItem> resultsToImpress = new ArrayList<DNAResultItem>();
        List<DNAResultItem> resultItems = this.adCacheManager_.getSearchCache(query);
        String source = "search";
        boolean isCache = true;
        boolean isFallback = false;
        if (resultItems == null || resultItems.isEmpty()) {
            DNALogger.i("fetchOrganicResultsForSearch: no cached search results found, fetching new results");
            resultItems = this.resultEngine_.fetchResultsGeneric(source, placementTag, true, false, false, query, -1);
            isCache = false;
            this.adCacheManager_.setSearchCache(query, resultItems);
        }
        if (resultItems == null || resultItems.isEmpty()) {
            DNALogger.i("fetchOrganicResultsForSearch: no search results found, triggering fallback");
            resultItems = DNAAppSearchFallback.getAppResultsForSearchFallback(this.context_, query);
            isCache = false;
            isFallback = true;
        }
        DNALogger.i("fetchOrganicResultsForSearch: fetched " + resultItems.size() + " search results");
        long endTime = System.currentTimeMillis();
        JSONObject statsMetadata = new JSONObject();
        try {
            statsMetadata.put("sId", (Object)this.dnaPreferences_.getSessionID());
            statsMetadata.put("cache", isCache);
            statsMetadata.put("fallback", isFallback);
            statsMetadata.put("queryLength", query.length());
            statsMetadata.put("source", (Object)source);
            if (placementTag != null && !placementTag.isEmpty()) {
                statsMetadata.put("placementTag", (Object)placementTag);
            } else {
                statsMetadata.put("placementTag", (Object)source);
            }
        }
        catch (Exception je) {
            DNALogger.e("DeviceNativeAds: Unable to create stats metadata");
        }
        statsItems.add(new DNAStatsLogger.StatItem("Ad Request: Organic Search", (int)(endTime - currentTime), statsMetadata));
        int index = 0;
        for (DNAResultItem resultItem : resultItems) {
            resultItem.placementTag = placementTag;
            resultItem.source = source;
            if (isCache) {
                resultItem.updateAppInstalledState(this.context_);
            }
            if (resultItem.resultType.equals("ad")) {
                statsMetadata = new JSONObject();
                try {
                    statsMetadata.put("sId", (Object)this.dnaPreferences_.getSessionID());
                    statsMetadata.put("adId", (Object)resultItem.id);
                    statsMetadata.put("adPackageName", (Object)resultItem.packageName);
                    statsMetadata.put("adAppName", (Object)resultItem.appName);
                    statsMetadata.put("here", resultItem.isInstalled);
                    statsMetadata.put("cache", isCache);
                    statsMetadata.put("queryLength", query.length());
                    statsMetadata.put("source", (Object)source);
                    if (placementTag != null && !placementTag.isEmpty()) {
                        statsMetadata.put("placementTag", (Object)placementTag);
                    } else {
                        resultItem.placementTag = source;
                        statsMetadata.put("placementTag", (Object)source);
                    }
                    if (resultItem.statMetadata != null) {
                        Iterator keys = resultItem.statMetadata.keys();
                        while (keys.hasNext()) {
                            String key = (String)keys.next();
                            statsMetadata.put(key, resultItem.statMetadata.get(key));
                        }
                    }
                }
                catch (Exception je) {
                    DNALogger.e("DeviceNativeAds: Unable to create stats metadata");
                }
                statsItems.add(new DNAStatsLogger.StatItem("Ad Request: Organic Search", (int)(endTime - currentTime), statsMetadata));
            }
            DNALogger.i("fetchOrganicResultsForSearch: evaluating result " + resultItem.packageName);
            if ((resultItem.resultType.equals("ad") || resultItem.resultType.equals("app")) && (count > 0 && index < count || count == -1)) {
                resultsToImpress.add(resultItem);
            }
            ++index;
        }
        if (!resultsToImpress.isEmpty() && forDisplay) {
            Runnable impressionRunnable = () -> {
                DNALogger.i("fetchAdsForSearch: registering impressions for " + resultsToImpress.size() + " results");
                this.registerBatchImpression(resultsToImpress, null);
            };
            if (this.searchDebounceTask_ != null && !this.searchDebounceTask_.isDone()) {
                this.searchDebounceTask_.cancel(true);
            }
            this.searchDebounceTask_ = this.scheduledExecutorService_.schedule(impressionRunnable, 1L, TimeUnit.SECONDS);
        }
        this.attemptToExecuteRunnableAndReinit(() -> DNAStatsLogger.logBatchInternalSync(this.context_, statsItems));
        return resultItems;
    }

    public List<DNAResultItem> fetchAdsForCache(int count, String placementTag) {
        return this.fetchAdsForDisplayInternal(false, count, placementTag);
    }

    public List<DNAResultItem> fetchAdsForDisplay(int count, String placementTag) {
        return this.fetchAdsForDisplayInternal(true, count, placementTag);
    }

    private List<DNAResultItem> fetchAdsForDisplayInternal(boolean forDisplay, int count, String placementTag) {
        DNALogger.i("fetchAdsForDisplayInternal: fetching display ads for display: " + forDisplay + " with count: " + count);
        long currentTime = System.currentTimeMillis();
        ArrayList<DNAStatsLogger.StatItem> statsItems = new ArrayList<DNAStatsLogger.StatItem>();
        ArrayList<DNAResultItem> adUnitsToImpress = new ArrayList<DNAResultItem>();
        List<DNAResultItem> adsToReturn = this.retrieveCachedDisplayAds(count);
        String source = "suggested apps";
        boolean isCache = true;
        if (adsToReturn == null || adsToReturn.isEmpty()) {
            adsToReturn = this.resultEngine_.fetchResultsGeneric(source, placementTag, false, false, false, null, count);
            isCache = false;
            this.adCacheManager_.setAdsDisplayCache(adsToReturn);
        }
        if (adsToReturn == null) {
            adsToReturn = new ArrayList<DNAResultItem>();
        }
        DNALogger.i("fetchAdsForDisplayInternal: retrieved display ads from source " + source + " with count: " + count);
        long endTime = System.currentTimeMillis();
        JSONObject statsMetadata = new JSONObject();
        try {
            statsMetadata.put("sId", (Object)this.dnaPreferences_.getSessionID());
            statsMetadata.put("source", (Object)source);
            statsMetadata.put("cache", isCache);
            if (placementTag != null && !placementTag.isEmpty()) {
                statsMetadata.put("placementTag", (Object)placementTag);
            } else {
                statsMetadata.put("placementTag", (Object)source);
            }
        }
        catch (Exception je) {
            DNALogger.e("DeviceNativeAds: Unable to create stats metadata");
        }
        if (forDisplay) {
            statsItems.add(new DNAStatsLogger.StatItem("Ad Request: Display", (int)(endTime - currentTime), statsMetadata));
        } else {
            statsItems.add(new DNAStatsLogger.StatItem("Ad Request: Cache", (int)(endTime - currentTime), statsMetadata));
        }
        for (DNAResultItem adUnit : adsToReturn) {
            statsMetadata = new JSONObject();
            adUnit.placementTag = placementTag;
            adUnit.source = source;
            if (isCache) {
                adUnit.updateAppInstalledState(this.context_);
            }
            try {
                statsMetadata.put("sId", (Object)this.dnaPreferences_.getSessionID());
                statsMetadata.put("adId", (Object)adUnit.id);
                statsMetadata.put("adPackageName", (Object)adUnit.packageName);
                statsMetadata.put("adAppName", (Object)adUnit.appName);
                statsMetadata.put("source", (Object)source);
                statsMetadata.put("cache", isCache);
                statsMetadata.put("here", adUnit.isInstalled);
                if (placementTag != null && !placementTag.isEmpty()) {
                    statsMetadata.put("placementTag", (Object)placementTag);
                } else {
                    adUnit.placementTag = source;
                    statsMetadata.put("placementTag", (Object)source);
                }
                if (adUnit.statMetadata != null) {
                    Iterator keys = adUnit.statMetadata.keys();
                    while (keys.hasNext()) {
                        String key = (String)keys.next();
                        statsMetadata.put(key, adUnit.statMetadata.get(key));
                    }
                }
            }
            catch (Exception je) {
                DNALogger.e("DeviceNativeAds: Unable to create stats metadata");
            }
            if (forDisplay) {
                statsItems.add(new DNAStatsLogger.StatItem("Ad Request: Display", (int)(endTime - currentTime), statsMetadata));
            } else {
                statsItems.add(new DNAStatsLogger.StatItem("Ad Request: Cache", (int)(endTime - currentTime), statsMetadata));
            }
            adUnitsToImpress.add(adUnit);
        }
        if (!adUnitsToImpress.isEmpty() && forDisplay) {
            DNALogger.i("fetchAdsForDisplayInternal: registering impressions for " + adUnitsToImpress.size() + " ads");
            this.registerBatchImpression(adUnitsToImpress, null, true, null);
        }
        this.attemptToExecuteRunnableAndReinit(() -> DNAStatsLogger.logBatchInternalSync(this.context_, statsItems));
        return adsToReturn;
    }

    public List<DNAResultItem> fetchHotAppsList(int count, String placementTag) {
        DNALogger.i("fetchHotAppsList: fetching hot apps with count: " + count);
        long currentTime = System.currentTimeMillis();
        ArrayList<DNAStatsLogger.StatItem> statsItems = new ArrayList<DNAStatsLogger.StatItem>();
        ArrayList<DNAResultItem> resultItemsToImpress = new ArrayList<DNAResultItem>();
        List<DNAResultItem> resultsToReturn = this.retrieveCachedHotApps(count);
        String source = "hot apps";
        boolean isCache = true;
        if (resultsToReturn == null || resultsToReturn.isEmpty()) {
            resultsToReturn = this.resultEngine_.fetchResultsGeneric(source, placementTag, false, false, true, null, count);
            isCache = false;
            this.adCacheManager_.setHotAppsCache(resultsToReturn);
        }
        DNALogger.i("fetchHotAppsList: retrieved " + resultsToReturn.size() + " hot apps");
        long endTime = System.currentTimeMillis();
        for (DNAResultItem resultItem : resultsToReturn) {
            resultItem.placementTag = placementTag;
            resultItem.source = source;
            if (isCache) {
                resultItem.updateAppInstalledState(this.context_);
            }
            if (resultItem.resultType.equals("ad")) {
                JSONObject statsMetadata = new JSONObject();
                try {
                    statsMetadata.put("sId", (Object)this.dnaPreferences_.getSessionID());
                    statsMetadata.put("adId", (Object)resultItem.id);
                    statsMetadata.put("adPackageName", (Object)resultItem.packageName);
                    statsMetadata.put("adAppName", (Object)resultItem.appName);
                    statsMetadata.put("here", resultItem.isInstalled);
                    statsMetadata.put("source", (Object)source);
                    statsMetadata.put("cache", isCache);
                    if (placementTag != null && !placementTag.isEmpty()) {
                        statsMetadata.put("placementTag", (Object)placementTag);
                    } else {
                        resultItem.placementTag = source;
                        statsMetadata.put("placementTag", (Object)source);
                    }
                    if (resultItem.statMetadata != null) {
                        Iterator keys = resultItem.statMetadata.keys();
                        while (keys.hasNext()) {
                            String key = (String)keys.next();
                            statsMetadata.put(key, resultItem.statMetadata.get(key));
                        }
                    }
                }
                catch (Exception je) {
                    DNALogger.e("DeviceNativeAds: Unable to create stats metadata");
                }
                statsItems.add(new DNAStatsLogger.StatItem("Ad Request: Hot Apps", (int)(endTime - currentTime), statsMetadata));
            }
            resultItemsToImpress.add(resultItem);
        }
        if (!resultItemsToImpress.isEmpty()) {
            this.registerBatchImpression(resultItemsToImpress, null);
        }
        this.attemptToExecuteRunnableAndReinit(() -> DNAStatsLogger.logBatchInternalSync(this.context_, statsItems));
        return resultsToReturn;
    }

    public List<DNAResultItem> fetchAdsForSearch(String query, String placementTag, boolean forDisplay) {
        DNALogger.i("fetchAdsForSearch: fetching search ads for query: " + query);
        long currentTime = System.currentTimeMillis();
        ArrayList<DNAStatsLogger.StatItem> statsItems = new ArrayList<DNAStatsLogger.StatItem>();
        ArrayList<DNAResultItem> adUnitsToImpress = new ArrayList<DNAResultItem>();
        List<DNAResultItem> adUnits = this.adCacheManager_.getSearchCache(query);
        String source = "search";
        boolean isCache = true;
        if (adUnits == null || adUnits.isEmpty()) {
            DNALogger.i("fetchAdsForSearch: no cached search ads found, fetching new ads");
            adUnits = this.resultEngine_.fetchResultsGeneric(source, placementTag, false, false, false, query, -1);
            isCache = false;
            this.adCacheManager_.setSearchCache(query, adUnits);
        }
        DNALogger.i("fetchAdsForSearch: fetched " + adUnits.size() + " search ads");
        long endTime = System.currentTimeMillis();
        JSONObject statsMetadata = new JSONObject();
        try {
            statsMetadata.put("sId", (Object)this.dnaPreferences_.getSessionID());
            statsMetadata.put("cache", isCache);
            statsMetadata.put("queryLength", query.length());
            statsMetadata.put("source", (Object)source);
            if (placementTag != null && !placementTag.isEmpty()) {
                statsMetadata.put("placementTag", (Object)placementTag);
            } else {
                statsMetadata.put("placementTag", (Object)source);
            }
        }
        catch (Exception je) {
            DNALogger.e("DeviceNativeAds: Unable to create stats metadata");
        }
        statsItems.add(new DNAStatsLogger.StatItem("Ad Request: Search", (int)(endTime - currentTime), statsMetadata));
        for (DNAResultItem adUnit : adUnits) {
            statsMetadata = new JSONObject();
            adUnit.placementTag = placementTag;
            adUnit.source = source;
            if (isCache) {
                adUnit.updateAppInstalledState(this.context_);
            }
            try {
                statsMetadata.put("sId", (Object)this.dnaPreferences_.getSessionID());
                statsMetadata.put("adId", (Object)adUnit.id);
                statsMetadata.put("adPackageName", (Object)adUnit.packageName);
                statsMetadata.put("adAppName", (Object)adUnit.appName);
                statsMetadata.put("here", adUnit.isInstalled);
                statsMetadata.put("cache", isCache);
                statsMetadata.put("queryLength", query.length());
                statsMetadata.put("source", (Object)source);
                if (placementTag != null && !placementTag.isEmpty()) {
                    statsMetadata.put("placementTag", (Object)placementTag);
                } else {
                    adUnit.placementTag = source;
                    statsMetadata.put("placementTag", (Object)source);
                }
                if (adUnit.statMetadata != null) {
                    Iterator keys = adUnit.statMetadata.keys();
                    while (keys.hasNext()) {
                        String key = (String)keys.next();
                        statsMetadata.put(key, adUnit.statMetadata.get(key));
                    }
                }
            }
            catch (Exception je) {
                DNALogger.e("DeviceNativeAds: Unable to create stats metadata");
            }
            statsItems.add(new DNAStatsLogger.StatItem("Ad Request: Search", (int)(endTime - currentTime), statsMetadata));
            DNALogger.i("fetchAdsForSearch: evaluating adUnit " + adUnit.packageName);
            adUnitsToImpress.add(adUnit);
        }
        if (!adUnitsToImpress.isEmpty() && forDisplay) {
            Runnable impressionRunnable = () -> {
                DNALogger.i("fetchAdsForSearch: registering impressions for " + adUnitsToImpress.size() + " adUnits");
                this.registerBatchImpression(adUnitsToImpress, null);
            };
            if (this.searchDebounceTask_ != null && !this.searchDebounceTask_.isDone()) {
                this.searchDebounceTask_.cancel(true);
            }
            this.searchDebounceTask_ = this.scheduledExecutorService_.schedule(impressionRunnable, 1L, TimeUnit.SECONDS);
        }
        this.attemptToExecuteRunnableAndReinit(() -> DNAStatsLogger.logBatchInternalSync(this.context_, statsItems));
        return adUnits;
    }

    public void registerBatchImpression(List<DNAResultItem> resultItems, DeviceNativeClickHandler clickHandler) {
        this.registerBatchImpression(resultItems, null, false, clickHandler);
    }

    public void registerBatchImpression(List<DNAResultItem> resultItems, String updatedPlacementTag, boolean refreshUsage, DeviceNativeClickHandler clickHandler) {
        this.executorService_.submit(() -> {
            this.validateIsActiveAndReinitialize();
            ArrayList<DNAStatsLogger.StatItem> statsItems = new ArrayList<DNAStatsLogger.StatItem>();
            try {
                for (DNAResultItem resultItem : resultItems) {
                    if (!this.adCacheManager_.getPackageImpressionTimestampExpired(resultItem.packageName)) {
                        DNALogger.i("registerBatchImpression: ad " + resultItem.packageName + " in imp blackout window");
                        continue;
                    }
                    this.adCacheManager_.setPackageImpressionTimestamp(resultItem.packageName);
                    String clickId = UUID.randomUUID().toString();
                    if (updatedPlacementTag != null && !updatedPlacementTag.isEmpty()) {
                        resultItem.placementTag = updatedPlacementTag;
                    }
                    JSONObject statsMetadata = new JSONObject();
                    if (resultItem.resultType.equals("ad")) {
                        DNALogger.i("registerBatchImpression: registering batch impression for ad: " + resultItem.packageName);
                        try {
                            statsMetadata.put("sId", (Object)this.dnaPreferences_.getSessionID());
                            statsMetadata.put("clickId", (Object)clickId);
                            statsMetadata.put("adId", (Object)resultItem.id);
                            statsMetadata.put("adPackageName", (Object)resultItem.packageName);
                            statsMetadata.put("adAppName", (Object)resultItem.appName);
                            statsMetadata.put("here", resultItem.isInstalled);
                            if (resultItem.placementTag != null && !resultItem.placementTag.isEmpty()) {
                                statsMetadata.put("placementTag", (Object)resultItem.placementTag);
                            }
                            if (resultItem.source != null && !resultItem.source.isEmpty()) {
                                statsMetadata.put("source", (Object)resultItem.source);
                            }
                        }
                        catch (Exception je) {
                            DNALogger.e("DeviceNativeAds: Unable to create stats metadata");
                        }
                        statsItems.add(new DNAStatsLogger.StatItem("Ad Imp", null, statsMetadata));
                    }
                    DNAResultEventRecord eventRecord = new DNAResultEventRecord();
                    eventRecord.resId = resultItem.id;
                    eventRecord.event = "view";
                    eventRecord.type = resultItem.resultType;
                    eventRecord.placement = resultItem.placementTag != null && !resultItem.placementTag.isEmpty() ? resultItem.placementTag : "organic";
                    eventRecord.packageName = resultItem.packageName;
                    DNADatabaseInterface.insertResEventRecord(this.context_, eventRecord);
                    if (resultItem.impressionUrl != null && !resultItem.impressionUrl.isEmpty()) {
                        DNALogger.i("registerBatchImpression: firing impression URL for ad: " + resultItem.packageName);
                        this.adLinkHandler_.asyncLinkProcessor(this.context_, resultItem.impressionUrl, resultItem.id, resultItem.appName, resultItem.packageName, clickId, resultItem.source, clickHandler);
                    }
                    if (resultItem.viewThrough <= 0 || resultItem.clickUrl == null || resultItem.clickUrl.isEmpty() || !this.dnaPreferences_.getVTAEnabled() || DNADatabaseInterface.hasVTABeenFired(this.context_, resultItem.id)) continue;
                    DNALogger.i("registerBatchImpression: firing VTA for ad: " + resultItem.packageName);
                    statsMetadata = new JSONObject();
                    try {
                        statsMetadata.put("sId", (Object)this.dnaPreferences_.getSessionID());
                        statsMetadata.put("clickId", (Object)clickId);
                        statsMetadata.put("adId", (Object)resultItem.id);
                        statsMetadata.put("adPackageName", (Object)resultItem.packageName);
                        statsMetadata.put("adAppName", (Object)resultItem.appName);
                        statsMetadata.put("here", resultItem.isInstalled);
                        if (resultItem.placementTag != null && !resultItem.placementTag.isEmpty()) {
                            statsMetadata.put("placementTag", (Object)resultItem.placementTag);
                        }
                        if (resultItem.source != null && !resultItem.source.isEmpty()) {
                            statsMetadata.put("source", (Object)resultItem.source);
                        }
                    }
                    catch (Exception je) {
                        DNALogger.e("DeviceNativeAds: Unable to create stats metadata");
                    }
                    statsItems.add(new DNAStatsLogger.StatItem("Ad VTA", null, statsMetadata));
                    this.adLinkHandler_.linkRouter(this.context_, resultItem.clickUrl, resultItem.destinationUrl, resultItem.id, resultItem.appName, resultItem.packageName, resultItem.className, resultItem.userHandle, clickId, resultItem.source, false, false, null, null);
                    eventRecord = new DNAResultEventRecord();
                    eventRecord.resId = resultItem.id;
                    eventRecord.type = resultItem.resultType;
                    eventRecord.placement = resultItem.placementTag;
                    eventRecord.event = "vta";
                    eventRecord.packageName = resultItem.packageName;
                    DNADatabaseInterface.insertResEventRecord(this.context_, eventRecord);
                }
                this.fireOffTheStatsUploadRunnable();
                if (refreshUsage) {
                    this.fireOffTheUsageRefreshRunnable();
                }
            }
            catch (Exception e) {
                DNALogger.e("DeviceNativeAds: error processing batch impression ad: " + e.getMessage());
                JSONObject statsMetadata = new JSONObject();
                try {
                    statsMetadata.put("sId", (Object)this.dnaPreferences_.getSessionID());
                    statsMetadata.put("loc", (Object)"registerBatchImpression");
                    statsMetadata.put("m", (Object)e.getMessage());
                }
                catch (Exception je) {
                    DNALogger.e("DeviceNativeAds: Unable to create stats metadata");
                }
                statsItems.add(new DNAStatsLogger.StatItem("Error", null, statsMetadata));
            }
            DNAStatsLogger.logBatchInternalSync(this.context_, statsItems);
        });
    }

    public void registerClick(DNAResultItem resultItem, DeviceNativeClickHandler clickHandler) {
        String clickId = UUID.randomUUID().toString();
        if (resultItem.resultType.equals("ad") || resultItem.parentResultItem != null && resultItem.parentResultItem.resultType.equals("ad")) {
            DNAResultItem logResultItem = resultItem;
            if (resultItem.parentResultItem != null) {
                logResultItem = resultItem.parentResultItem;
            }
            JSONObject statsMetadata = new JSONObject();
            try {
                statsMetadata.put("sId", (Object)this.dnaPreferences_.getSessionID());
                statsMetadata.put("resType", (Object)logResultItem.resultType);
                statsMetadata.put("clickId", (Object)clickId);
                statsMetadata.put("adId", (Object)logResultItem.id);
                statsMetadata.put("adPackageName", (Object)logResultItem.packageName);
                statsMetadata.put("adAppName", (Object)logResultItem.appName);
                statsMetadata.put("here", logResultItem.isInstalled);
                if (resultItem.placementTag != null && !resultItem.placementTag.isEmpty()) {
                    statsMetadata.put("placementTag", (Object)resultItem.placementTag);
                }
                if (resultItem.source != null && !resultItem.source.isEmpty()) {
                    statsMetadata.put("source", (Object)resultItem.source);
                }
            }
            catch (Exception je) {
                DNALogger.e("DeviceNativeAds: Unable to create stats metadata");
            }
            DNAStatsLogger.logInternal(this.context_, "Click", null, statsMetadata);
        }
        this.fireOffTheStatsUploadRunnable();
        this.attemptToExecuteRunnableAndReinit(() -> {
            DNAResultEventRecord eventRecord = new DNAResultEventRecord();
            eventRecord.resId = resultItem.id;
            eventRecord.event = "click";
            eventRecord.type = resultItem.resultType;
            eventRecord.placement = resultItem.placementTag != null && !resultItem.placementTag.isEmpty() ? resultItem.placementTag : "organic";
            eventRecord.packageName = resultItem.packageName;
            DNADatabaseInterface.insertResEventRecord(this.context_, eventRecord);
            this.fireOffTheUsageRefreshRunnable();
            DNAResultItem logResultItem = resultItem;
            if (resultItem.parentResultItem != null) {
                logResultItem = resultItem.parentResultItem;
            }
            if (logResultItem.clickUrl != null && !logResultItem.clickUrl.isEmpty()) {
                this.adLinkHandler_.asyncLinkProcessor(this.context_, logResultItem.clickUrl, logResultItem.id, logResultItem.appName, logResultItem.packageName, clickId, resultItem.source, clickHandler);
            }
        });
    }

    public void registerClick(String packageName, String componentName, UserHandle userHandle) {
        this.attemptToExecuteRunnableAndReinit(() -> {
            String userId = null;
            if (userHandle != null) {
                userId = userHandle.toString();
            } else {
                try {
                    UserHandle currentUserHandle = Process.myUserHandle();
                    userId = currentUserHandle.toString();
                }
                catch (Exception e) {
                    DNALogger.e("registerClick: Unable to get current user handle, using null");
                }
            }
            List<DNAAppRecord> appRecords = DNADatabaseInterface.getAppRecords(this.context_, packageName, userId);
            DNAAppRecord matchingRecord = null;
            if (appRecords != null && !appRecords.isEmpty()) {
                for (DNAAppRecord record : appRecords) {
                    if (componentName != null && componentName.equals(record.component)) {
                        matchingRecord = record;
                        break;
                    }
                    if (componentName != null || record.component != null) continue;
                    matchingRecord = record;
                    break;
                }
                if (matchingRecord == null && !appRecords.isEmpty()) {
                    matchingRecord = appRecords.get(0);
                }
            }
            if (matchingRecord != null) {
                DNAResultEventRecord eventRecord = new DNAResultEventRecord();
                eventRecord.resId = String.valueOf(matchingRecord.dbId);
                eventRecord.event = "click";
                eventRecord.type = "app";
                eventRecord.placement = "organic";
                eventRecord.packageName = packageName;
                DNADatabaseInterface.insertResEventRecord(this.context_, eventRecord);
                DNALogger.i("registerClick: Registered click for package: " + packageName + ", component: " + componentName + ", user: " + userId + ", resId: " + matchingRecord.dbId);
                this.fireOffTheUsageRefreshRunnable();
            } else {
                DNALogger.e("registerClick: No matching app record found for package: " + packageName + ", component: " + componentName + ", user: " + userId);
            }
        });
    }

    public void clickAndRoute(DNAResultItem resultItem, String destinationUrlOverride, DeviceNativeClickHandler clickHandler) {
        String clickId = UUID.randomUUID().toString();
        if (resultItem.resultType.equals("shortcut") && !resultItem.clickUrl.contains("://")) {
            if (resultItem.packageName.equals("com.android.settings")) {
                DNALogger.i("DeviceNativeAds: setting shortcut router for " + resultItem.packageName + " with click url: " + resultItem.clickUrl);
                this.adLinkHandler_.settingShortcutRouter(this.context_, resultItem.clickUrl, resultItem.packageName, clickHandler);
            } else {
                this.adLinkHandler_.shortcutRouter(this.context_, resultItem.clickUrl, resultItem.appName, resultItem.packageName, clickHandler);
            }
        } else if (resultItem.clickUrl != null && !resultItem.clickUrl.isEmpty()) {
            try {
                boolean earlyOpenPlayStore = !resultItem.isInstalled && !resultItem.notPlayStore;
                this.clickExecutorService_.execute(() -> this.adLinkHandler_.linkRouter(this.context_, resultItem.clickUrl, resultItem.destinationUrl, resultItem.id, resultItem.appName, resultItem.packageName, resultItem.className, resultItem.userHandle, clickId, resultItem.source, true, earlyOpenPlayStore, destinationUrlOverride, clickHandler));
            }
            catch (Exception e) {
                DNALogger.i("DeviceNativeAds: Thread pool full, already processing link redirect!");
            }
        } else {
            this.adLinkHandler_.fallbackLinkRouter(this.context_, resultItem.packageName, resultItem.className, resultItem.id, resultItem.appName, resultItem.userHandle, clickHandler);
        }
        this.attemptToExecuteRunnableAndReinit(() -> {
            if (resultItem.resultType.equals("ad") || resultItem.parentResultItem != null && resultItem.parentResultItem.resultType.equals("ad")) {
                DNAResultItem logResultItem = resultItem;
                if (resultItem.parentResultItem != null) {
                    logResultItem = resultItem.parentResultItem;
                }
                JSONObject statsMetadata = new JSONObject();
                try {
                    statsMetadata.put("sId", (Object)this.dnaPreferences_.getSessionID());
                    statsMetadata.put("resType", (Object)logResultItem.resultType);
                    statsMetadata.put("clickId", (Object)clickId);
                    statsMetadata.put("adId", (Object)logResultItem.id);
                    statsMetadata.put("adPackageName", (Object)logResultItem.packageName);
                    statsMetadata.put("adAppName", (Object)logResultItem.appName);
                    statsMetadata.put("here", logResultItem.isInstalled);
                    if (resultItem.placementTag != null && !resultItem.placementTag.isEmpty()) {
                        statsMetadata.put("placementTag", (Object)resultItem.placementTag);
                    }
                    if (resultItem.source != null && !resultItem.source.isEmpty()) {
                        statsMetadata.put("source", (Object)resultItem.source);
                    }
                }
                catch (Exception je) {
                    DNALogger.e("DeviceNativeAds: Unable to create stats metadata");
                }
                DNAStatsLogger.logInternalSync(this.context_, "Ad Click & Route", null, statsMetadata);
                if (resultItem.parentResultItem != null) {
                    this.registerClick(resultItem.parentResultItem, null);
                }
            }
            this.fireOffTheStatsUploadRunnable();
            DNAResultEventRecord eventRecord = new DNAResultEventRecord();
            eventRecord.resId = resultItem.id;
            eventRecord.event = "click";
            eventRecord.type = resultItem.resultType;
            eventRecord.placement = resultItem.placementTag != null && !resultItem.placementTag.isEmpty() ? resultItem.placementTag : "organic";
            eventRecord.packageName = resultItem.packageName;
            DNADatabaseInterface.insertResEventRecord(this.context_, eventRecord);
            this.fireOffTheUsageRefreshRunnable();
        });
    }

    private void fireOffTheStatsUploadRunnable() {
        Runnable statsUploadRunnable = () -> {
            if (this.statSyncExecutor_ != null) {
                this.statSyncExecutor_.execute();
            }
        };
        if (this.statsSyncTask_ != null && !this.statsSyncTask_.isDone()) {
            this.statsSyncTask_.cancel(true);
        }
        this.statsSyncTask_ = this.scheduledExecutorService_.schedule(statsUploadRunnable, (long)this.dnaPreferences_.getImpressionBlackoutWindow(), TimeUnit.MILLISECONDS);
    }

    private void fireOffTheUsageRefreshRunnable() {
        Runnable usageRefreshRunnable = () -> {
            Intent wakeIntent = new Intent("com.devicenative.dna.WAKE_AND_SYNC");
            if (this.context_ != null) {
                this.context_.sendBroadcast(wakeIntent);
            }
        };
        if (this.usageSyncTask_ != null && !this.usageSyncTask_.isDone()) {
            this.usageSyncTask_.cancel(true);
        }
        this.usageSyncTask_ = this.scheduledExecutorService_.schedule(usageRefreshRunnable, 2000L, TimeUnit.MILLISECONDS);
    }

    private void attemptToExecuteRunnableAndReinit(Runnable runner) {
        this.validateIsActiveAndReinitialize();
        this.executorService_.submit(runner);
    }
}

