/*
 * Decompiled with CFR 0.152.
 */
package com.devicenative.dna.ads;

import android.content.Context;
import android.os.Process;
import android.os.UserHandle;
import android.text.TextUtils;
import com.devicenative.dna.DNAResultItem;
import com.devicenative.dna.db.DNAAdRecord;
import com.devicenative.dna.db.DNAAppRecord;
import com.devicenative.dna.db.DNADatabaseInterface;
import com.devicenative.dna.db.DNANotifRecord;
import com.devicenative.dna.db.DNAResultEventRecord;
import com.devicenative.dna.db.DNAShortcutRecord;
import com.devicenative.dna.utils.DNALogger;
import com.devicenative.dna.utils.DNAPreferences;
import com.devicenative.dna.utils.DNAStatsLogger;
import com.devicenative.dna.utils.DNAUtils;
import com.shiqi.quickjs.JSArray;
import com.shiqi.quickjs.JSContext;
import com.shiqi.quickjs.JSObject;
import com.shiqi.quickjs.JSRuntime;
import com.shiqi.quickjs.JSUndefined;
import com.shiqi.quickjs.JSValue;
import com.shiqi.quickjs.QuickJS;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ExecutorService;
import org.json.JSONArray;
import org.json.JSONObject;

public class DNAResultEngine {
    private final Context context_;
    private final DNAPreferences dnaPreferences_;
    private final ExecutorService executorService_;

    public DNAResultEngine(Context context, DNAPreferences preferences, ExecutorService executorService) {
        this.context_ = context;
        this.dnaPreferences_ = preferences;
        this.executorService_ = executorService;
        QuickJS quickJS = new QuickJS.Builder().build();
        try (JSRuntime runtime = quickJS.createJSRuntime();
             JSContext jsContext = runtime.createJSContext();){
            this.populateJSContext(jsContext, null);
            jsContext.evaluate("'make'+'$'", "warmup.js", String.class);
        }
    }

    private static int mapCodePoint(int cp) {
        switch (cp) {
            case 2373: 
            case 2374: {
                return 2375;
            }
            case 2377: 
            case 2378: {
                return 2379;
            }
            case 2758: {
                return 2759;
            }
            case 2762: {
                return 2763;
            }
            case 3635: {
                return 3634;
            }
            case 3656: 
            case 3657: 
            case 3658: 
            case 3659: 
            case 3660: 
            case 3661: 
            case 3662: {
                return -1;
            }
            case 3763: {
                return 3762;
            }
            case 3784: 
            case 3785: 
            case 3786: 
            case 3787: 
            case 3788: 
            case 3789: {
                return -1;
            }
            case 4154: {
                return 4153;
            }
        }
        return cp;
    }

    public static String normalizeText(String text) {
        int cp;
        if (text == null || text.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder(text.length());
        for (int i = 0; i < text.length(); i += Character.charCount(cp)) {
            cp = text.codePointAt(i);
            int mapped = DNAResultEngine.mapCodePoint(cp);
            if (mapped < 0) continue;
            sb.appendCodePoint(mapped);
        }
        return Normalizer.normalize(sb, Normalizer.Form.NFC);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public ArrayList<DNAResultItem> fetchResultsGeneric(String source, String placement, Boolean fetchOrganic, Boolean linksOnly, Boolean installOnly, String query, int count) {
        ArrayList<DNAResultItem> resultItems = new ArrayList<DNAResultItem>();
        ArrayList<DNAStatsLogger.StatItem> statsItems = new ArrayList<DNAStatsLogger.StatItem>();
        String jsData = "[]";
        long startTime = System.currentTimeMillis();
        long endTime = System.currentTimeMillis();
        QuickJS quickJS = new QuickJS.Builder().build();
        try (JSRuntime runtime = quickJS.createJSRuntime();
             JSContext context = runtime.createJSContext();){
            this.populateJSContext(context, source);
            if (query != null && !query.isEmpty()) {
                String normalizedQuery = DNAResultEngine.normalizeText(query);
                context.getGlobalObject().setProperty("query", (JSValue)context.createJSString(normalizedQuery));
            } else {
                context.getGlobalObject().setProperty("query", (JSValue)context.createJSString(""));
            }
            context.getGlobalObject().setProperty("organicRequest", (JSValue)context.createJSBoolean(fetchOrganic.booleanValue()));
            context.getGlobalObject().setProperty("linksOnly", (JSValue)context.createJSBoolean(linksOnly.booleanValue()));
            context.getGlobalObject().setProperty("installOnly", (JSValue)context.createJSBoolean(installOnly.booleanValue()));
            context.getGlobalObject().setProperty("count", (JSValue)context.createJSNumber(count));
            if (placement != null && !placement.isEmpty()) {
                context.getGlobalObject().setProperty("placement", (JSValue)context.createJSString(placement));
            } else {
                context.getGlobalObject().setProperty("placement", (JSValue)context.createJSString(""));
            }
            context.getGlobalObject().setProperty("source", (JSValue)context.createJSString(source));
            context.getGlobalObject().setProperty("device", (JSValue)context.createJSString(this.dnaPreferences_.getDeviceModel()));
            String adSelectionScript = this.dnaPreferences_.getAdSelectionCode();
            jsData = (String)context.evaluate(adSelectionScript, "ads.js", String.class);
            DNALogger.i("DeviceNativeAds: ad data report: " + jsData);
            if (jsData == null || jsData.isEmpty()) {
                ArrayList<DNAResultItem> arrayList = new ArrayList<DNAResultItem>();
                return arrayList;
            }
            endTime = System.currentTimeMillis();
            JSONArray dataArray = new JSONArray(jsData);
            for (int i = 0; i < dataArray.length(); ++i) {
                DNAResultItem parentResultItem;
                JSONObject resDataObject = dataArray.getJSONObject(i);
                if (resDataObject.has("ad")) {
                    JSONObject ad = resDataObject.getJSONObject("ad");
                    parentResultItem = new DNAResultItem(ad, "ad");
                    if (resDataObject.has("app")) {
                        parentResultItem.userHandle = resDataObject.getJSONObject("app").getString("userId");
                        parentResultItem.uId = DNAUtils.readPidFromUserHandleString(parentResultItem.userHandle);
                        parentResultItem.className = resDataObject.getJSONObject("app").getString("component");
                    }
                    parentResultItem.updateAppInstalledState(this.context_);
                    if (ad.has("log")) {
                        JSONObject log = ad.getJSONObject("log");
                        parentResultItem.statMetadata = new JSONObject();
                        Iterator keys = log.keys();
                        while (keys.hasNext()) {
                            String key = (String)keys.next();
                            parentResultItem.statMetadata.put(key, log.get(key));
                        }
                        parentResultItem.statMetadata.put("duration", endTime - startTime);
                    }
                    resultItems.add(parentResultItem);
                } else if (resDataObject.has("shortcut") || resDataObject.has("notif")) {
                    parentResultItem = resDataObject.has("shortcut") ? new DNAResultItem(resDataObject.getJSONObject("shortcut"), "shortcut") : new DNAResultItem(resDataObject.getJSONObject("notif"), "notification");
                    if (resDataObject.has("app")) {
                        parentResultItem.userHandle = resDataObject.getJSONObject("app").getString("userId");
                        parentResultItem.uId = DNAUtils.readPidFromUserHandleString(parentResultItem.userHandle);
                        parentResultItem.className = resDataObject.getJSONObject("app").getString("component");
                    }
                    parentResultItem.updateAppInstalledState(this.context_);
                    resultItems.add(parentResultItem);
                } else {
                    parentResultItem = new DNAResultItem(resDataObject.getJSONObject("app"), "app");
                    parentResultItem.updateAppInstalledState(this.context_);
                    resultItems.add(parentResultItem);
                }
                if (!resDataObject.has("sublinks")) continue;
                JSONArray sublinks = resDataObject.getJSONArray("sublinks");
                for (int j = 0; j < sublinks.length(); ++j) {
                    JSONObject sublink = sublinks.getJSONObject(j);
                    if (sublink.optString("type").equals("notif")) {
                        DNAResultItem notifResult = new DNAResultItem(sublink, "notification");
                        notifResult.updateAppInstalledState(this.context_);
                        notifResult.setParentResultItem(parentResultItem);
                        resultItems.add(notifResult);
                        continue;
                    }
                    if (!sublink.optString("type").equals("shortcut")) continue;
                    DNAResultItem shortcutResult = new DNAResultItem(sublink, "shortcut");
                    shortcutResult.updateAppInstalledState(this.context_);
                    shortcutResult.setParentResultItem(parentResultItem);
                    resultItems.add(shortcutResult);
                }
            }
        }
        catch (Exception e) {
            DNALogger.e("DeviceNativeAds: error fetching ad: " + e.getMessage());
            JSONObject statsMetadata = new JSONObject();
            try {
                statsMetadata.put("sId", (Object)this.dnaPreferences_.getSessionID());
                statsMetadata.put("loc", (Object)"fetchResultsGeneric");
                statsMetadata.put("source", (Object)source);
                statsMetadata.put("organicRequest", (Object)fetchOrganic);
                statsMetadata.put("m", (Object)e.getMessage());
            }
            catch (Exception je) {
                DNALogger.e("DeviceNativeAds: Unable to create stats metadata");
            }
            statsItems.add(new DNAStatsLogger.StatItem("Error", null, statsMetadata));
        }
        DNALogger.i("DeviceNativeAds: ad request time: " + (endTime - startTime) + " milliseconds");
        if (statsItems.size() > 0) {
            this.executorService_.execute(() -> DNAStatsLogger.logBatchInternalSync(this.context_, statsItems));
        }
        return resultItems;
    }

    private void populateJSContext(JSContext jsContext, String source) {
        List<DNAAppRecord> apps = DNADatabaseInterface.getAllAppRecords(this.context_);
        List<DNAAdRecord> ads = DNADatabaseInterface.getAllAdRecords(this.context_);
        List<DNAShortcutRecord> shortcuts = DNADatabaseInterface.getAllShortcuts(this.context_);
        List<DNANotifRecord> notifs = DNADatabaseInterface.getAllNotifs(this.context_);
        List<DNAResultEventRecord> adEvents = DNADatabaseInterface.getRecentResEventRecords(this.context_);
        boolean usageStatsEnabled = this.dnaPreferences_.getUsageStatsEnabled();
        boolean adsEnabled = !this.dnaPreferences_.getConfigAdsDisabled();
        boolean installAdsEnabled = this.dnaPreferences_.getInstallAdsEnabled();
        boolean webAdsEnabled = this.dnaPreferences_.getWebAdsEnabled();
        boolean organicAdsEnabled = this.dnaPreferences_.getOrganicAdsEnabled();
        boolean organicAdsBoostEnabled = this.dnaPreferences_.getPaidOrganicBoostEnabled();
        boolean pureOrganicAdsEnabled = this.dnaPreferences_.getOrganicAdsOnly();
        String currPackageName = this.context_.getPackageName();
        if (source != null) {
            if (source.equals("search")) {
                adsEnabled = adsEnabled && !this.dnaPreferences_.getSearchAdsDisabled();
                installAdsEnabled = installAdsEnabled && !this.dnaPreferences_.getSearchInstallAdsDisabled();
            } else if (source.equals("suggested apps")) {
                adsEnabled = adsEnabled && !this.dnaPreferences_.getRecomAdsDisabled();
                installAdsEnabled = installAdsEnabled && !this.dnaPreferences_.getRecomInstallAdsDisabled();
            }
        }
        jsContext.getGlobalObject().setProperty("webAdsEnabled", (JSValue)jsContext.createJSBoolean(webAdsEnabled));
        jsContext.getGlobalObject().setProperty("usageStatsEnabled", (JSValue)jsContext.createJSBoolean(usageStatsEnabled));
        jsContext.getGlobalObject().setProperty("installAdsEnabled", (JSValue)jsContext.createJSBoolean(installAdsEnabled));
        jsContext.getGlobalObject().setProperty("organicAdsEnabled", (JSValue)jsContext.createJSBoolean(organicAdsEnabled));
        jsContext.getGlobalObject().setProperty("organicAdsBoostEnabled", (JSValue)jsContext.createJSBoolean(organicAdsBoostEnabled));
        jsContext.getGlobalObject().setProperty("pureOrganicAdsEnabled", (JSValue)jsContext.createJSBoolean(pureOrganicAdsEnabled));
        jsContext.getGlobalObject().setProperty("currentTime", (JSValue)jsContext.createJSNumber((double)System.currentTimeMillis()));
        jsContext.getGlobalObject().setProperty("currentPackage", (JSValue)jsContext.createJSString(currPackageName));
        jsContext.getGlobalObject().setProperty("userId", (JSValue)jsContext.createJSString(Process.myUserHandle().toString()));
        JSArray jsAppBlacklist = jsContext.createJSArray();
        List<String> appBlacklist = this.dnaPreferences_.getBlacklistPackages();
        if (appBlacklist != null) {
            for (int i = 0; i < appBlacklist.size(); ++i) {
                jsAppBlacklist.setProperty(i, (JSValue)jsContext.createJSString(appBlacklist.get(i)));
            }
        }
        jsContext.getGlobalObject().setProperty("blacklist", (JSValue)jsAppBlacklist);
        JSObject jsMultiActivityApps = jsContext.createJSObject();
        JSObject jsDualApps = jsContext.createJSObject();
        JSObject jsApps = jsContext.createJSObject();
        for (DNAAppRecord app : apps) {
            if ("suggested apps".equals(source)) {
                boolean isHidden = false;
                if (app.component != null && !app.component.isEmpty() && this.dnaPreferences_.isComponentHidden(app.component, app.userId)) {
                    isHidden = true;
                }
                if (!isHidden && app.packageName != null && !app.packageName.isEmpty() && this.dnaPreferences_.isPackageHidden(app.packageName, app.userId)) {
                    isHidden = true;
                }
                if (isHidden) continue;
            }
            JSObject jsApp = jsContext.createJSObject();
            jsApp.setProperty("id", (JSValue)jsContext.createJSString(String.valueOf(app.dbId)));
            jsApp.setProperty("packageName", (JSValue)jsContext.createJSString(app.packageName));
            jsApp.setProperty("appName", (JSValue)jsContext.createJSString(app.name));
            jsApp.setProperty("normAppName", (JSValue)jsContext.createJSString(DNAResultEngine.normalizeText(app.name)));
            if (app.aliases != null && !app.aliases.isEmpty()) {
                jsApp.setProperty("aliases", (JSValue)jsContext.createJSString(app.aliases));
            }
            jsApp.setProperty("userId", (JSValue)jsContext.createJSString(app.userId));
            if (app.component != null) {
                jsApp.setProperty("component", (JSValue)jsContext.createJSString(app.component));
            }
            jsApp.setProperty("timeUsedInLast7D", (JSValue)jsContext.createJSNumber((double)app.timeUsedInLast7D));
            jsApp.setProperty("timeUsedInLast3D", (JSValue)jsContext.createJSNumber((double)app.timeUsedInLast3D));
            jsApp.setProperty("timeUsedInLast1D", (JSValue)jsContext.createJSNumber((double)app.timeUsedInLast1D));
            jsApp.setProperty("timeUsedInLast3Y", (JSValue)jsContext.createJSNumber((double)app.timeUsedInLast3Y));
            jsApp.setProperty("installedAt", (JSValue)jsContext.createJSNumber((double)app.installedAt));
            jsApp.setProperty("updatedAt", (JSValue)jsContext.createJSNumber((double)app.updatedAt));
            jsApp.setProperty("uninstalledAt", (JSValue)jsContext.createJSNumber((double)app.uninstalledAt));
            jsApp.setProperty("lastTimeInForeground", (JSValue)jsContext.createJSNumber((double)app.lastTimeInForeground));
            jsApp.setProperty("lastUsedAt", (JSValue)jsContext.createJSNumber((double)app.lastUsedAt));
            if (jsApps.getProperty(app.packageName).getClass().equals(JSObject.class)) {
                JSArray jsMultiActivityApp;
                JSArray jsDualApp;
                UserHandle userHandle = Process.myUserHandle();
                int length = 1;
                if (jsDualApps.getProperty(app.packageName).getClass().equals(JSArray.class)) {
                    jsDualApp = (JSArray)jsDualApps.getProperty(app.packageName);
                    length = jsDualApp.getLength();
                } else {
                    jsDualApp = jsContext.createJSArray();
                    jsDualApp.setProperty(0, jsApps.getProperty(app.packageName));
                }
                jsDualApp.setProperty(length, (JSValue)jsApp);
                jsDualApps.setProperty(app.packageName, (JSValue)jsDualApp);
                if (!app.userId.equals(userHandle.toString())) continue;
                length = 1;
                if (jsMultiActivityApps.getProperty(app.packageName).getClass().equals(JSArray.class)) {
                    jsMultiActivityApp = (JSArray)jsMultiActivityApps.getProperty(app.packageName);
                    length = jsMultiActivityApp.getLength();
                } else {
                    jsMultiActivityApp = jsContext.createJSArray();
                    jsMultiActivityApp.setProperty(0, jsApps.getProperty(app.packageName));
                }
                jsMultiActivityApp.setProperty(length, (JSValue)jsApp);
                jsApps.setProperty(app.packageName, (JSValue)jsApp);
                jsMultiActivityApps.setProperty(app.packageName, (JSValue)jsMultiActivityApp);
                continue;
            }
            jsApps.setProperty(app.packageName, (JSValue)jsApp);
        }
        jsContext.getGlobalObject().setProperty("apps", (JSValue)jsApps);
        jsContext.getGlobalObject().setProperty("dualApps", (JSValue)jsDualApps);
        jsContext.getGlobalObject().setProperty("multiActivityApps", (JSValue)jsMultiActivityApps);
        JSArray jsAds = jsContext.createJSArray();
        int i = 0;
        if (adsEnabled) {
            for (DNAAdRecord dNAAdRecord : ads) {
                JSObject jsAd = jsContext.createJSObject();
                jsAd.setProperty("id", (JSValue)jsContext.createJSString(String.valueOf(dNAAdRecord.adId)));
                jsAd.setProperty("packageName", (JSValue)jsContext.createJSString(dNAAdRecord.packageName));
                jsAd.setProperty("appName", (JSValue)jsContext.createJSString(dNAAdRecord.name));
                jsAd.setProperty("normAppName", (JSValue)jsContext.createJSString(DNAResultEngine.normalizeText(dNAAdRecord.name)));
                jsAd.setProperty("type", (JSValue)jsContext.createJSString(!TextUtils.isEmpty((CharSequence)dNAAdRecord.type) ? dNAAdRecord.type : ""));
                jsAd.setProperty("creativeSource", (JSValue)jsContext.createJSString(!TextUtils.isEmpty((CharSequence)dNAAdRecord.creativeSource) ? dNAAdRecord.creativeSource : ""));
                jsAd.setProperty("destinationUrl", (JSValue)jsContext.createJSString(!TextUtils.isEmpty((CharSequence)dNAAdRecord.destinationUrl) ? dNAAdRecord.destinationUrl : ""));
                jsAd.setProperty("viewThrough", (JSValue)jsContext.createJSNumber(dNAAdRecord.viewThrough));
                jsAd.setProperty("notPlayStore", (JSValue)jsContext.createJSBoolean(dNAAdRecord.notPlayStore));
                jsAd.setProperty("title", (JSValue)jsContext.createJSString(!TextUtils.isEmpty((CharSequence)dNAAdRecord.title) ? dNAAdRecord.title : dNAAdRecord.name));
                jsAd.setProperty("description", (JSValue)jsContext.createJSString(!TextUtils.isEmpty((CharSequence)dNAAdRecord.description) ? dNAAdRecord.description : ""));
                jsAd.setProperty("iconUrl", (JSValue)jsContext.createJSString(!TextUtils.isEmpty((CharSequence)dNAAdRecord.iconUrl) ? dNAAdRecord.iconUrl : ""));
                jsAd.setProperty("clickUrl", (JSValue)jsContext.createJSString(!TextUtils.isEmpty((CharSequence)dNAAdRecord.clickUrl) ? dNAAdRecord.clickUrl : ""));
                jsAd.setProperty("destinationUrl", (JSValue)jsContext.createJSString(!TextUtils.isEmpty((CharSequence)dNAAdRecord.destinationUrl) ? dNAAdRecord.destinationUrl : ""));
                jsAd.setProperty("impressionUrl", (JSValue)jsContext.createJSString(!TextUtils.isEmpty((CharSequence)dNAAdRecord.impressionUrl) ? dNAAdRecord.impressionUrl : ""));
                jsAd.setProperty("viewThrough", (JSValue)jsContext.createJSNumber(dNAAdRecord.viewThrough));
                jsAd.setProperty("targetingMetadata", (JSValue)jsContext.createJSString(!TextUtils.isEmpty((CharSequence)dNAAdRecord.targetingMetadata) ? dNAAdRecord.targetingMetadata : "{}"));
                jsAds.setProperty(i, (JSValue)jsAd);
                ++i;
            }
        }
        jsContext.getGlobalObject().setProperty("ads", (JSValue)jsAds);
        JSObject jsEvents = jsContext.createJSObject();
        for (DNAResultEventRecord adRecord : adEvents) {
            JSObject jsAdRecord = jsContext.createJSObject();
            jsAdRecord.setProperty("resId", (JSValue)jsContext.createJSString(String.valueOf(adRecord.resId)));
            jsAdRecord.setProperty("packageName", (JSValue)jsContext.createJSString(adRecord.packageName));
            jsAdRecord.setProperty("event", (JSValue)jsContext.createJSString(adRecord.event));
            jsAdRecord.setProperty("type", (JSValue)jsContext.createJSString(adRecord.type));
            jsAdRecord.setProperty("placement", (JSValue)jsContext.createJSString(adRecord.placement));
            jsAdRecord.setProperty("completedAt", (JSValue)jsContext.createJSNumber((double)adRecord.completedAt));
            int j = 0;
            JSValue currPackageList = jsEvents.getProperty(adRecord.packageName);
            if (currPackageList.getClass().equals(JSUndefined.class)) {
                currPackageList = jsContext.createJSArray();
                jsEvents.setProperty(adRecord.packageName, currPackageList);
            }
            j = ((JSArray)currPackageList).getLength();
            ((JSArray)currPackageList).setProperty(j, (JSValue)jsAdRecord);
        }
        jsContext.getGlobalObject().setProperty("events", (JSValue)jsEvents);
        JSObject jSObject = jsContext.createJSObject();
        jsContext.getGlobalObject().setProperty("shortcuts", (JSValue)jSObject);
        JSObject jsNotifs = jsContext.createJSObject();
        jsContext.getGlobalObject().setProperty("notifs", (JSValue)jsNotifs);
        apps.clear();
        ads.clear();
        adEvents.clear();
    }
}

