/*
 * Decompiled with CFR 0.152.
 */
package com.devicenative.dna;

import android.app.ActivityManager;
import android.app.KeyguardManager;
import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.ServiceConnection;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import android.os.Handler;
import android.os.IBinder;
import android.os.UserHandle;
import android.service.notification.StatusBarNotification;
import com.devicenative.dna.DNADataOrchestrator;
import com.devicenative.dna.DNAResultItem;
import com.devicenative.dna.DeviceNativeClickHandler;
import com.devicenative.dna.ads.DNAResultServer;
import com.devicenative.dna.utils.DNALogger;
import com.devicenative.dna.utils.DNAPreferences;
import com.devicenative.dna.utils.DNAStatsLogger;
import com.devicenative.dna.utils.DNAUtils;
import java.util.List;
import java.util.UUID;
import org.json.JSONObject;

public class DeviceNativeAds {
    private static DeviceNativeAds instance_ = null;
    private Context context_;
    private boolean isActive_ = false;
    private DNADataOrchestrator dnaDataOrchestrator_;
    private ServiceConnection dataServiceConnection_;
    private boolean isBindingInProgress_ = false;
    private final DNAPreferences dnaPreferences_;
    private final DNAResultServer resultServer_;
    private static final long UPDATE_DEBOUNCE_INTERVAL_MS = 5000L;
    private long lastUpdateTriggerTimestamp = 0L;

    private DeviceNativeAds(Context context) {
        this.context_ = context;
        this.dnaPreferences_ = DNAPreferences.getInstance(context);
        this.resultServer_ = DNAResultServer.getInstance(context);
        this.isActive_ = true;
        this.dataServiceConnection_ = new ServiceConnection(){

            public void onServiceConnected(ComponentName className, IBinder service) {
                if (!(service instanceof DNADataOrchestrator.LocalBinder)) {
                    DNALogger.i("DeviceNativeAds: Ignoring cross-process binder for " + className);
                    DeviceNativeAds.this.isBindingInProgress_ = false;
                    return;
                }
                DNADataOrchestrator.LocalBinder binder = (DNADataOrchestrator.LocalBinder)service;
                DeviceNativeAds.this.dnaDataOrchestrator_ = binder.getService();
                DeviceNativeAds.this.isBindingInProgress_ = false;
                DNALogger.i("DeviceNativeAds: Connected to data orchestrator.");
            }

            public void onServiceDisconnected(ComponentName name) {
                DNALogger.w("DeviceNativeAds: Disconnected from " + name + ". Cleaning up connection state.");
                DeviceNativeAds.this.dnaDataOrchestrator_ = null;
                DeviceNativeAds.this.isBindingInProgress_ = false;
            }
        };
    }

    public static synchronized DeviceNativeAds getInstance(Context context) {
        if (instance_ == null || !DeviceNativeAds.instance_.isActive_) {
            instance_ = new DeviceNativeAds(context.getApplicationContext());
        }
        return instance_;
    }

    private synchronized void validateIsActiveAndReinitialize() {
        if (!this.isActive_) {
            this.dnaPreferences_.init(this.context_);
            this.resultServer_.init(this.context_);
            this.isActive_ = true;
        }
    }

    public synchronized void init(String deviceKey) {
        this.init(deviceKey, null);
    }

    public synchronized void init(String deviceKey, DNAConfig config) {
        DNALogger.i("DeviceNativeAds init called");
        this.validateIsActiveAndReinitialize();
        this.dnaPreferences_.setDeviceKey(deviceKey);
        if (config != null) {
            this.updateConfig(config);
        } else {
            this.dnaPreferences_.setDebugMode(false);
            this.dnaPreferences_.setConfigCountryOverride(null);
            this.dnaPreferences_.setConfigGAIDDisabled(false);
            this.dnaPreferences_.setConfigAppUsageDisabled(false);
            this.dnaPreferences_.setConfigAdsDisabled(false);
            this.dnaPreferences_.setRecomInstallAdsDisabled(false);
            this.dnaPreferences_.setRecomAdsDisabled(false);
            this.dnaPreferences_.setSearchInstallAdsDisabled(false);
            this.dnaPreferences_.setSearchAdsDisabled(false);
        }
        this.dnaPreferences_.setSessionID(UUID.randomUUID().toString());
        this.dnaPreferences_.setAppPackageName(this.context_.getPackageName());
        this.dnaPreferences_.setAndroidVersion(String.valueOf(Build.VERSION.SDK_INT));
        this.dnaPreferences_.setDeviceModel(Build.MODEL);
        this.dnaPreferences_.setDeviceStartTime(Build.TIME);
        this.dnaPreferences_.setCPUCount(Runtime.getRuntime().availableProcessors());
        ActivityManager activityManager = (ActivityManager)this.context_.getSystemService("activity");
        ActivityManager.MemoryInfo memoryInfo = new ActivityManager.MemoryInfo();
        activityManager.getMemoryInfo(memoryInfo);
        long totalMemory = memoryInfo.totalMem;
        this.dnaPreferences_.setMaxMemory(totalMemory / 0x100000L);
        try {
            PackageInfo packageInfo = this.context_.getPackageManager().getPackageInfo(this.context_.getPackageName(), 0);
            this.dnaPreferences_.setAppVersion(packageInfo.versionName);
        }
        catch (PackageManager.NameNotFoundException e) {
            DNALogger.e("DeviceNativeAds: Unable to get app version");
        }
        JSONObject statsMetadata = new JSONObject();
        try {
            statsMetadata.put("sId", (Object)this.dnaPreferences_.getSessionID());
        }
        catch (Exception e) {
            DNALogger.e("DeviceNativeAds: Unable to create stats metadata");
        }
        DNAStatsLogger.logInternal(this.context_, "Session Start", null, statsMetadata);
        this.triggerUpdateCheck(false);
    }

    private boolean isDataOrchestratorRunning() {
        ActivityManager manager = (ActivityManager)this.context_.getSystemService("activity");
        if (manager != null) {
            for (ActivityManager.RunningServiceInfo service : manager.getRunningServices(Integer.MAX_VALUE)) {
                if (!DNADataOrchestrator.class.getName().equals(service.service.getClassName())) continue;
                return true;
            }
        }
        return false;
    }

    private void initAndConnectToDataProvider(final int counter) {
        if (this.dnaDataOrchestrator_ != null) {
            DNALogger.i("DeviceNativeAds: Already connected to data orchestrator.");
            return;
        }
        if (this.isBindingInProgress_) {
            DNALogger.i("DeviceNativeAds: Binding already in progress.");
            return;
        }
        DNALogger.i("DeviceNativeAds: Attempting to start and connect to data orchestrator.");
        Intent intent = new Intent(this.context_, DNADataOrchestrator.class);
        try {
            this.context_.startService(intent);
        }
        catch (IllegalStateException e) {
            DNALogger.w("DeviceNativeAds: Unable to start data service from background. Setting up retry.");
            if (counter > 20) {
                DNALogger.e("DeviceNativeAds: Already tried and failed twenty times to start service. Giving up.");
                return;
            }
            IntentFilter intentFilter = new IntentFilter();
            intentFilter.addAction("android.intent.action.SCREEN_ON");
            intentFilter.addAction("android.intent.action.USER_PRESENT");
            this.context_.registerReceiver(new BroadcastReceiver(){

                public void onReceive(Context context, Intent intent) {
                    KeyguardManager myKM = (KeyguardManager)context.getSystemService("keyguard");
                    if (myKM != null && !myKM.inKeyguardRestrictedInputMode()) {
                        context.unregisterReceiver((BroadcastReceiver)this);
                        new Handler().postDelayed(() -> {
                            DNALogger.i("DeviceNativeAds: Screen unlocked, retrying to start background services");
                            DeviceNativeAds.this.initAndConnectToDataProvider(counter + 1);
                        }, 10L);
                    }
                }
            }, intentFilter);
            return;
        }
        DNALogger.i("DeviceNativeAds: Binding to the service");
        this.isBindingInProgress_ = true;
        boolean isBinding = this.context_.bindService(intent, this.dataServiceConnection_, 1);
        if (!isBinding) {
            DNALogger.e("DeviceNativeAds: bindService returned false. Service may not be available or binding is not possible at this time.");
            this.isBindingInProgress_ = false;
        }
    }

    public synchronized void destroy() {
        DNALogger.i("DeviceNativeAds destroy called");
        JSONObject statsMetadata = new JSONObject();
        try {
            statsMetadata.put("sId", (Object)this.dnaPreferences_.getSessionID());
        }
        catch (Exception e) {
            DNALogger.e("DeviceNativeAds: Unable to create stats metadata");
        }
        DNAStatsLogger.logInternal(this.context_, "Session Stop", null, statsMetadata);
        if (this.dnaDataOrchestrator_ != null || this.isBindingInProgress_) {
            try {
                this.context_.unbindService(this.dataServiceConnection_);
            }
            catch (IllegalArgumentException e) {
                DNALogger.i("DeviceNativeAds: Service was not bound during cleanup: " + e.getMessage());
            }
        }
        if (this.dnaDataOrchestrator_ != null) {
            this.context_.stopService(new Intent(this.context_, DNADataOrchestrator.class));
        }
        this.dnaDataOrchestrator_ = null;
        this.isBindingInProgress_ = false;
        this.isActive_ = false;
        DNAResultServer.shutDown();
    }

    public synchronized void updateConfig(DNAConfig config) {
        this.triggerUpdateCheck(false);
        if (config != null && this.dnaPreferences_ != null) {
            if (config.debugMode != null) {
                this.dnaPreferences_.setDebugMode(config.debugMode);
            }
            if (config.carrierValue != null) {
                this.dnaPreferences_.setCarrierValue(config.carrierValue);
            }
            if (config.disableGAID != null) {
                this.dnaPreferences_.setConfigGAIDDisabled(config.disableGAID);
            }
            if (config.disableAppUsage != null) {
                this.dnaPreferences_.setConfigAppUsageDisabled(config.disableAppUsage);
            }
            if (config.disableAds != null) {
                this.dnaPreferences_.setConfigAdsDisabled(config.disableAds);
            }
            if (config.disableSearchAds != null) {
                this.dnaPreferences_.setSearchAdsDisabled(config.disableSearchAds);
            }
            if (config.disableSearchInstallAds != null) {
                this.dnaPreferences_.setSearchInstallAdsDisabled(config.disableSearchInstallAds);
            }
            if (config.disableRecomAds != null) {
                this.dnaPreferences_.setRecomAdsDisabled(config.disableRecomAds);
            }
            if (config.disableRecomInstallAds != null) {
                this.dnaPreferences_.setRecomInstallAdsDisabled(config.disableRecomInstallAds);
            }
            if (config.countryOverride != null) {
                this.dnaPreferences_.setConfigCountryOverride(config.countryOverride);
            }
        }
    }

    public synchronized void onNotificationPosted(StatusBarNotification sbn) {
    }

    public synchronized void setPackageSuggestionVisibility(String packageName, UserHandle userId, boolean visible) {
        this.triggerUpdateCheck(false);
        if (packageName == null || packageName.isEmpty()) {
            return;
        }
        String userIdStr = userId != null ? userId.toString() : null;
        this.dnaPreferences_.setPackageHidden(packageName, userIdStr, !visible);
        this.resultServer_.clearCache();
    }

    public synchronized void setComponentSuggestionVisibility(String componentName, UserHandle userId, boolean visible) {
        this.triggerUpdateCheck(false);
        if (componentName == null || componentName.isEmpty()) {
            return;
        }
        String activityName = DNAUtils.extractActivityName(componentName);
        String userIdStr = userId != null ? userId.toString() : null;
        this.dnaPreferences_.setComponentHidden(activityName, userIdStr, !visible);
        this.resultServer_.clearCache();
    }

    public synchronized List<DNAResultItem> getOrganicAppSuggestions(int count) {
        this.triggerUpdateCheck(false);
        return this.resultServer_.fetchOrganicAppSuggestions(count, null);
    }

    public synchronized List<DNAResultItem> getOrganicAppSuggestions(int count, String placementTag) {
        this.triggerUpdateCheck(false);
        return this.resultServer_.fetchOrganicAppSuggestions(count, placementTag);
    }

    public synchronized List<DNAResultItem> getOrganicLinkSuggestions(int count) {
        this.triggerUpdateCheck(false);
        return this.resultServer_.fetchOrganicLinkSuggestions(count, null);
    }

    public synchronized List<DNAResultItem> getOrganicLinkSuggestions(int count, String placementTag) {
        this.triggerUpdateCheck(false);
        return this.resultServer_.fetchOrganicLinkSuggestions(count, placementTag);
    }

    public synchronized List<DNAResultItem> getHotAppsList(int count) {
        this.triggerUpdateCheck(false);
        return this.resultServer_.fetchHotAppsList(count, null);
    }

    public synchronized List<DNAResultItem> getHotAppsList(int count, String placementTag) {
        this.triggerUpdateCheck(false);
        return this.resultServer_.fetchHotAppsList(count, placementTag);
    }

    public synchronized List<DNAResultItem> getOrganicResultsForSearch(String query) {
        this.triggerUpdateCheck(false);
        return this.resultServer_.fetchOrganicResultsForSearch(query, null, true, -1);
    }

    public synchronized List<DNAResultItem> getOrganicResultsForSearch(String query, String placementTag) {
        this.triggerUpdateCheck(false);
        return this.resultServer_.fetchOrganicResultsForSearch(query, placementTag, true, -1);
    }

    public synchronized List<DNAResultItem> getOrganicResultsForSearch(String query, String placementTag, int count) {
        this.triggerUpdateCheck(false);
        return this.resultServer_.fetchOrganicResultsForSearch(query, placementTag, true, count);
    }

    public synchronized List<DNAResultItem> getOrganicResultsForSearchForCache(String query, String placementTag) {
        this.triggerUpdateCheck(false);
        return this.resultServer_.fetchOrganicResultsForSearch(query, placementTag, false, -1);
    }

    public synchronized List<DNAResultItem> getAdsForDisplay(int count) {
        this.triggerUpdateCheck(false);
        return this.resultServer_.fetchAdsForDisplay(count, null);
    }

    public synchronized List<DNAResultItem> getAdsForDisplay(int count, String placementTag) {
        this.triggerUpdateCheck(false);
        return this.resultServer_.fetchAdsForDisplay(count, placementTag);
    }

    public synchronized List<DNAResultItem> getAdsForSearch(String query) {
        this.triggerUpdateCheck(false);
        return this.resultServer_.fetchAdsForSearch(query, null, true);
    }

    public synchronized List<DNAResultItem> getAdsForSearch(String query, String placementTag) {
        this.triggerUpdateCheck(false);
        return this.resultServer_.fetchAdsForSearch(query, placementTag, true);
    }

    public synchronized List<DNAResultItem> getAdsForSearchForCache(String query) {
        this.triggerUpdateCheck(false);
        return this.resultServer_.fetchAdsForSearch(query, null, false);
    }

    public synchronized List<DNAResultItem> getAdsForSearchForCache(String query, String placementTag) {
        this.triggerUpdateCheck(false);
        return this.resultServer_.fetchAdsForSearch(query, placementTag, false);
    }

    public synchronized List<DNAResultItem> getAdsForCache(int count) {
        this.triggerUpdateCheck(false);
        return this.resultServer_.fetchAdsForCache(count, null);
    }

    public synchronized List<DNAResultItem> getAdsForCache(int count, String placementTag) {
        this.triggerUpdateCheck(false);
        return this.resultServer_.fetchAdsForCache(count, placementTag);
    }

    public synchronized void fireImpressions(List<DNAResultItem> resultItems, DeviceNativeClickHandler clickHandler) {
        this.triggerUpdateCheck(false);
        this.resultServer_.registerBatchImpression(resultItems, clickHandler);
    }

    public synchronized void fireImpressions(List<DNAResultItem> resultItems, String placementTag, DeviceNativeClickHandler clickHandler) {
        this.triggerUpdateCheck(false);
        this.resultServer_.registerBatchImpression(resultItems, placementTag, false, clickHandler);
    }

    public synchronized void fireClickWithoutRouting(DNAResultItem resultItem, DeviceNativeClickHandler clickHandler) {
        this.triggerUpdateCheck(false);
        this.resultServer_.registerClick(resultItem, clickHandler);
    }

    public synchronized void fireClickWithoutRouting(String packageName, String componentName, UserHandle userHandle) {
        this.triggerUpdateCheck(false);
        String activityName = DNAUtils.extractActivityName(componentName);
        this.resultServer_.clearCache();
        this.resultServer_.registerClick(packageName, activityName, userHandle);
    }

    public synchronized void fireClickAndRoute(DNAResultItem resultItem, DeviceNativeClickHandler clickHandler) {
        this.triggerUpdateCheck(false);
        this.resultServer_.clickAndRoute(resultItem, null, clickHandler);
    }

    public synchronized void fireClickAndRoute(DNAResultItem resultItem, String destinationUrlOverride, DeviceNativeClickHandler clickHandler) {
        this.triggerUpdateCheck(false);
        this.resultServer_.clickAndRoute(resultItem, destinationUrlOverride, clickHandler);
    }

    public synchronized void triggerDataRefresh() {
        this.triggerUpdateCheck(true);
    }

    private void triggerUpdateCheck(boolean force) {
        long now = System.currentTimeMillis();
        if (!force && now - this.lastUpdateTriggerTimestamp < 5000L) {
            DNALogger.i("DeviceNativeAds: Debouncing update trigger.");
            return;
        }
        this.lastUpdateTriggerTimestamp = now;
        DNALogger.i("DeviceNativeAds: triggerUpdateCheck called with force: " + force);
        this.initAndConnectToDataProvider(0);
        if (force) {
            try {
                Intent svc = new Intent(this.context_, DNADataOrchestrator.class).setAction("com.devicenative.dna.WAKE_AND_SYNC");
                this.context_.startService(svc);
            }
            catch (Exception e) {
                DNALogger.e("DeviceNativeAds: Error firing wake broadcast: " + e.getMessage());
            }
        }
    }

    public static class DNAConfig {
        public Boolean debugMode = null;
        public Boolean disableGAID = null;
        public Boolean disableAppUsage = null;
        public String countryOverride = null;
        public Boolean disableAds = null;
        public Boolean disableSearchInstallAds = null;
        public Boolean disableSearchAds = null;
        public Boolean disableRecomInstallAds = null;
        public Boolean disableRecomAds = null;
        public String carrierValue = null;
    }
}

