/*
 * Decompiled with CFR 0.152.
 */
package com.devicenative.dna;

import android.app.Activity;
import android.app.AlarmManager;
import android.app.Application;
import android.app.PendingIntent;
import android.app.Service;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Binder;
import android.os.Build;
import android.os.Bundle;
import android.os.IBinder;
import com.devicenative.dna.ads.DNAResultServer;
import com.devicenative.dna.broadcast.DNAProfileChangeReceiver;
import com.devicenative.dna.datasource.DNAAppDataSource;
import com.devicenative.dna.datasource.DNAServerSyncDataSource;
import com.devicenative.dna.datasource.DNAShortcutDataSource;
import com.devicenative.dna.datasource.DNAStatsSyncDataUploader;
import com.devicenative.dna.datasource.DNAUsageStatsDataSource;
import com.devicenative.dna.datasource.loader.DNALoaderUpdateListener;
import com.devicenative.dna.utils.DNAConfigBuilder;
import com.devicenative.dna.utils.DNALogger;
import com.devicenative.dna.utils.DNAPreferences;
import com.devicenative.dna.utils.DNAStatsLogger;
import com.devicenative.dna.utils.DNAWakeScheduleReceiver;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import org.json.JSONObject;

public class DNADataOrchestrator
extends Service
implements DNALoaderUpdateListener,
DNAWakeScheduleReceiver.Listener,
Application.ActivityLifecycleCallbacks {
    private static final String SERVICE_LOCK_FILE = "DNAServiceLock";
    private static FileLock serviceLock = null;
    private DNAAppDataSource appDataSource;
    private DNAServerSyncDataSource serverSyncDataSource;
    private DNAStatsSyncDataUploader statsSyncDataSource;
    private DNAShortcutDataSource shortcutDataSource;
    private DNAUsageStatsDataSource usageStatsDataSource;
    private static DNAWakeScheduleReceiver wakeScheduleReceiver;
    public boolean isLoading = false;
    public boolean allSourcesHaveLoaded = false;
    private boolean isActivityChangingConfigurations = false;
    private int activityReferences = 0;
    private long start;
    private final IBinder binder = new LocalBinder();

    public void onCreate() {
        super.onCreate();
        DNALogger.i("DNADataOrchestrator: onCreate called");
        if (!this.acquireServiceLock()) {
            this.stopSelf();
        }
        this.start = System.currentTimeMillis();
        DNAProfileChangeReceiver profileChangedHandler = new DNAProfileChangeReceiver();
        profileChangedHandler.register(this.getApplicationContext());
        this.activityReferences = 1;
        ((Application)this.getApplicationContext()).registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this);
        wakeScheduleReceiver = new DNAWakeScheduleReceiver(this);
        IntentFilter filter = new IntentFilter("com.devicenative.dna.WAKE_AND_SYNC");
        if (Build.VERSION.SDK_INT >= 33) {
            this.registerReceiver(wakeScheduleReceiver, filter, 2);
        } else {
            this.registerReceiver(wakeScheduleReceiver, filter);
        }
        this.configureWakeAndSync();
        this.appDataSource = new DNAAppDataSource(this);
        this.serverSyncDataSource = new DNAServerSyncDataSource(this);
        this.statsSyncDataSource = new DNAStatsSyncDataUploader(this);
        if (Build.VERSION.SDK_INT >= 26) {
            this.shortcutDataSource = new DNAShortcutDataSource(this);
        }
        this.usageStatsDataSource = new DNAUsageStatsDataSource(this);
        this.loadAllData();
        if (DNAPreferences.getInstance(this.getApplicationContext()).getUserAgent(this.getApplicationContext()).isEmpty()) {
            try {
                Intent intent = new Intent((Context)this, DNAConfigBuilder.class);
                this.startService(intent);
            }
            catch (Exception e) {
                DNALogger.e("DNADataOrchestrator: Error starting DNAConfigBuilder: " + e.getMessage());
            }
        }
    }

    private void loadAllData() {
        long timeSinceLastSync;
        long lastSyncTime;
        if (this.isLoading) {
            return;
        }
        this.isLoading = true;
        DNALogger.i("DNADataOrchestrator: Loading all data");
        DNAPreferences prefs = DNAPreferences.getInstance((Context)this);
        long now = System.currentTimeMillis();
        if (this.appDataSource != null) {
            this.appDataSource.loadData();
        }
        if (prefs.areAppsLoaded()) {
            this.appDataSource.setIsLoaded(true);
            this.handleProviderLoaded();
            this.usageStatsDataSource.loadData();
        }
        if (this.serverSyncDataSource != null) {
            lastSyncTime = prefs.getLastApiSyncTime();
            timeSinceLastSync = now - lastSyncTime;
            if (timeSinceLastSync > (long)prefs.getRefreshInterval()) {
                this.serverSyncDataSource.loadData();
            } else {
                this.serverSyncDataSource.setIsLoaded(true);
                this.handleProviderLoaded();
            }
        }
        if (this.statsSyncDataSource != null) {
            lastSyncTime = prefs.getLastApiSyncTime();
            timeSinceLastSync = now - lastSyncTime;
            if (timeSinceLastSync > (long)prefs.getRefreshInterval()) {
                this.statsSyncDataSource.loadData();
            } else {
                this.statsSyncDataSource.setIsLoaded(true);
                this.handleProviderLoaded();
            }
        }
        if (this.shortcutDataSource != null && !prefs.areShortcutsLoaded()) {
            this.shortcutDataSource.loadData();
        } else if (prefs.areShortcutsLoaded()) {
            this.shortcutDataSource.setIsLoaded(true);
            this.handleProviderLoaded();
        }
    }

    private void configureWakeAndSync() {
        DNALogger.i("DNADataOrchestrator: Configuring next wake and sync");
        Intent intent = new Intent(this.getApplicationContext(), DNADataOrchestrator.class).setAction("com.devicenative.dna.WAKE_AND_SYNC");
        AlarmManager alarmManager = (AlarmManager)this.getApplicationContext().getSystemService("alarm");
        try {
            PendingIntent alarmIntent = PendingIntent.getService((Context)this.getApplicationContext(), (int)0, (Intent)intent, (int)0xC000000);
            DNAPreferences prefs = DNAPreferences.getInstance((Context)this);
            long interval = prefs.getLocalRefreshInterval();
            alarmManager.setInexactRepeating(0, System.currentTimeMillis() + interval, interval, alarmIntent);
        }
        catch (Exception e) {
            DNALogger.e("DNADataOrchestrator: Error setting alarm: " + e.getMessage());
            DNAPreferences prefs = DNAPreferences.getInstance((Context)this);
            JSONObject statsMetadata = new JSONObject();
            try {
                statsMetadata.put("sId", (Object)prefs.getSessionID());
                statsMetadata.put("loc", (Object)"configureWakeAndSync");
                statsMetadata.put("m", (Object)e.getMessage());
            }
            catch (Exception je) {
                DNALogger.e("DeviceNativeAds: Unable to create stats metadata");
            }
            DNAStatsLogger.logInternal((Context)this, "Error", null, statsMetadata);
        }
    }

    private void handleProviderLoaded() {
        DNALogger.i("DNADataOrchestrator: Provider loaded triggered");
        if (this.allSourcesHaveLoaded) {
            return;
        }
        if (!this.appDataSource.isLoaded() || !this.serverSyncDataSource.isLoaded() || Build.VERSION.SDK_INT >= 26 && !this.shortcutDataSource.isLoaded() || !this.usageStatsDataSource.isLoaded()) {
            return;
        }
        long time = System.currentTimeMillis() - this.start;
        DNALogger.i("DNADataOrchestrator: Time to load all providers: " + time + "ms");
        this.allSourcesHaveLoaded = true;
        this.isLoading = false;
        DNAResultServer adServer = DNAResultServer.getInstance((Context)this);
        adServer.prefetchSuggestions();
    }

    @Override
    public void onBroadcastReceived(Intent intent) {
        long lastUsageSyncTime;
        long timeSinceLastUsageSync;
        if (intent != null) {
            DNALogger.i("DNADataOrchestrator: Wake broadcast received: " + intent.getAction());
        } else {
            DNALogger.i("DNADataOrchestrator: Wake broadcast received: null");
        }
        DNAPreferences prefs = DNAPreferences.getInstance((Context)this);
        long now = System.currentTimeMillis();
        prefs.setLastWakeTime(now);
        this.start = System.currentTimeMillis();
        if (this.serverSyncDataSource != null && !this.isLoading) {
            long lastSyncTime = prefs.getLastApiSyncTime();
            long timeSinceLastSync = now - lastSyncTime;
            if (timeSinceLastSync > (long)prefs.getRefreshInterval()) {
                this.isLoading = true;
                this.allSourcesHaveLoaded = false;
                this.serverSyncDataSource.setIsLoaded(false);
                this.serverSyncDataSource.loadData();
                if (this.statsSyncDataSource != null) {
                    this.statsSyncDataSource.setIsLoaded(false);
                    this.statsSyncDataSource.loadData();
                }
                if (this.appDataSource != null) {
                    this.appDataSource.setIsLoaded(false);
                    this.appDataSource.loadData();
                }
            } else if (prefs.getAppsNeedReload() && this.appDataSource != null) {
                this.appDataSource.setIsLoaded(false);
                this.appDataSource.loadData();
            }
        }
        if (this.usageStatsDataSource != null && (timeSinceLastUsageSync = now - (lastUsageSyncTime = prefs.getLastUsageSyncTime())) > 2000L) {
            this.allSourcesHaveLoaded = false;
            this.usageStatsDataSource.setIsLoaded(false);
            this.usageStatsDataSource.loadData();
        }
    }

    @Override
    public void onLoaderUpdate(String loaderName, int updateType) {
        DNALogger.i("DNADataOrchestrator: Loader update triggered: " + loaderName + " " + updateType);
        if (loaderName.equals(this.serverSyncDataSource.getClass().getSimpleName()) && updateType == 1) {
            this.configureWakeAndSync();
        }
        if (loaderName.equals(this.appDataSource.getClass().getSimpleName()) && updateType == 1) {
            DNAPreferences prefs = DNAPreferences.getInstance((Context)this);
            DNALogger.i("DNADataOrchestrator: Setting apps loaded");
            prefs.setAppsLoaded();
            prefs.setAppsReloaded();
            if (this.usageStatsDataSource != null) {
                this.usageStatsDataSource.loadData();
            }
        }
        if (updateType == 1) {
            this.handleProviderLoaded();
        }
    }

    public int onStartCommand(Intent intent, int flags, int startId) {
        DNALogger.i("DNADataOrchestrator: onStartCommand with WAKE_AND_SYNC");
        this.onBroadcastReceived(intent);
        return 2;
    }

    public IBinder onBind(Intent intent) {
        return this.binder;
    }

    private boolean acquireServiceLock() {
        File lockFile = new File(this.getFilesDir(), SERVICE_LOCK_FILE);
        try {
            FileChannel channel = new RandomAccessFile(lockFile, "rw").getChannel();
            serviceLock = channel.tryLock();
            return serviceLock != null;
        }
        catch (IOException | OverlappingFileLockException e) {
            return false;
        }
    }

    private void releaseServiceLock() {
        if (serviceLock != null) {
            try {
                serviceLock.release();
                serviceLock = null;
            }
            catch (IOException e) {
                DNALogger.i("DNADataOrchestrator: Error releasing service lock: " + e.getMessage());
            }
        }
    }

    public void onDestroy() {
        super.onDestroy();
        DNALogger.i("DNADataOrchestrator: onDestroy called");
        this.unregisterReceiver(wakeScheduleReceiver);
        this.releaseServiceLock();
    }

    public void onActivityCreated(Activity activity, Bundle savedInstanceState) {
    }

    public void onActivityStarted(Activity activity) {
        DNALogger.i("DNADataOrchestrator: Activity started, and reference count is " + this.activityReferences + " and isChangingConfigurations is " + this.isActivityChangingConfigurations);
        if (this.activityReferences == 0 && !this.isActivityChangingConfigurations && this.allSourcesHaveLoaded) {
            this.onBroadcastReceived(new Intent("com.devicenative.dna.WAKE_AND_SYNC"));
        }
        ++this.activityReferences;
    }

    public void onActivityResumed(Activity activity) {
    }

    public void onActivityPaused(Activity activity) {
    }

    public void onActivityStopped(Activity activity) {
        DNALogger.i("DNADataOrchestrator: Activity stopped, and reference count is " + this.activityReferences + " and isChangingConfigurations is " + this.isActivityChangingConfigurations);
        this.isActivityChangingConfigurations = activity.isChangingConfigurations();
        this.activityReferences = Math.max(0, this.activityReferences - 1);
    }

    public void onActivitySaveInstanceState(Activity activity, Bundle outState) {
    }

    public void onActivityDestroyed(Activity activity) {
    }

    public class LocalBinder
    extends Binder {
        public DNADataOrchestrator getService() {
            return DNADataOrchestrator.this;
        }
    }
}

