package com.devicenative.dna.utils;

public class DNAError {
    String errorMessage_ = "";
    /* Error while creating share options. */
    public static final int ERR_DNA_REQ_TIMED_OUT = -111;
    /* Request failed due to poor connectivity */
    public static final int ERR_DNA_NO_CONNECTIVITY = -113;
    /* DNA request is invalid */
    public static final int ERR_DNA_INVALID_REQUEST = -116;
    /* Request task timed out before completing*/
    public static final int ERR_DNA_TASK_TIMEOUT = -120;
    /* Error when network request is made on main thread */
    public static final int ERR_NETWORK_ON_MAIN = -121;
    /* General error reporting */
    public static final int ERR_OTHER = -122;

    /**
     * <p>Returns the message explaining the error.</p>
     *
     * @return A {@link String} value that can be used in error logging or for dialog display
     * to the user.
     */
    public String getMessage() {
        return errorMessage_;
    }

    /**
     * <p>Overridden toString method for this object; returns the error message rather than the
     * object's address.</p>
     *
     * @return A {@link String} value representing the object's current state.
     */
    @Override
    public String toString() {
        return getMessage();
    }

}