package com.devicenative.dna.notification;

import android.app.Notification;
import android.content.Context;
import android.service.notification.StatusBarNotification;
import android.text.SpannableString;

import com.devicenative.dna.db.DNADatabaseInterface;
import com.devicenative.dna.utils.DNALogger;

public class DNANotificationListener {

    public DNANotificationListener() {
    }


    public void onNotificationPosted(Context context, StatusBarNotification sbn) {
        if (isNotificationTrivial(sbn)) {
            return;
        }
        String packageName = sbn.getPackageName();
        String title = sbn.getNotification().extras.getString(Notification.EXTRA_TITLE);
        Object textObj = sbn.getNotification().extras.get(Notification.EXTRA_TEXT);

        if (title == null || title.isEmpty()) {
            return;
        }

        String text = "";
        if (textObj != null) {
            if (textObj instanceof SpannableString) {
                // Convert SpannableString to String
                text = textObj.toString();
            } else if (textObj instanceof String) {
                // It's already a String
                text = (String) textObj;
            } else {
                // Handle other unexpected types if necessary
                text = textObj.toString();
            }
        }

        DNALogger.i("DNANotificationListener: onNotificationPosted: " + packageName + ", " + title + ", " + text);

        DNADatabaseInterface.insertNotifRecord(context, title, text, packageName);
        DNADatabaseInterface.pruneNotifsRecords(context);
    }

    public boolean isNotificationTrivial(StatusBarNotification sbn) {
        Notification notification = sbn.getNotification();
        return notification.priority <= Notification.PRIORITY_MIN || (notification.flags & Notification.FLAG_ONGOING_EVENT) != 0 || isGroupHeader(notification);
    }

    private boolean isGroupHeader(Notification notification) {
        return (notification.flags & Notification.FLAG_GROUP_SUMMARY) != 0;
    }

}
