package com.devicenative.dna.db;

import android.text.TextUtils;

import org.json.JSONObject;
import org.w3c.dom.Text;

public class DNAAdRecord extends DNARecord {
    public String adId;

    public String type;

    public int viewThrough;

    public boolean notPlayStore;

    public String title;

    public String creativeSource;

    public String description;

    public String iconUrl;

    public String clickUrl;

    public String destinationUrl;

    public String impressionUrl;

    public String targetingMetadata;

    public DNAAdRecord() {
    }

    public DNAAdRecord(JSONObject rawAd) {
        this.adId = rawAd.optString("id");
        this.name = rawAd.optString("appName");
        this.packageName = rawAd.optString("packageName");
        this.viewThrough = rawAd.optInt("viewThrough");
        this.type = rawAd.optString("type");

        if (rawAd.has("isPlayStore") && !rawAd.isNull("isPlayStore")) {
            this.notPlayStore = !rawAd.optBoolean("isPlayStore");
        } else {
            this.notPlayStore = false;
        }

        this.creativeSource = rawAd.optString("creativeSource");
        if (TextUtils.isEmpty(this.creativeSource) || this.creativeSource.equals("null")) {
            this.creativeSource = null;
        }
        this.title = rawAd.optString("title");
        if (TextUtils.isEmpty(this.title) || this.title.equals("null")) {
            this.title = null;
        }
        this.description = rawAd.optString("description");
        if (TextUtils.isEmpty(this.description) || this.description.equals("null")) {
            this.description = null;
        }
        this.iconUrl = rawAd.optString("iconUrl");
        if (TextUtils.isEmpty(this.iconUrl) || this.iconUrl.equals("null")) {
            this.iconUrl = null;
        }
        this.clickUrl = rawAd.optString("clickUrl");
        if (TextUtils.isEmpty(this.clickUrl) || this.clickUrl.equals("null")) {
            this.clickUrl = null;
        }
        this.destinationUrl = rawAd.optString("destinationUrl");
        if (TextUtils.isEmpty(this.destinationUrl) || this.destinationUrl.equals("null")) {
            this.destinationUrl = null;
        }
        this.impressionUrl = rawAd.optString("impressionUrl");
        if (TextUtils.isEmpty(this.impressionUrl) || this.impressionUrl.equals("null")) {
            this.impressionUrl = null;
        }
        this.targetingMetadata = rawAd.optString("targetingMetadata");
        if (TextUtils.isEmpty(this.targetingMetadata) || this.targetingMetadata.equals("null")) {
            this.targetingMetadata = "{}";
        }
    }
}
