package com.devicenative.dna;

public interface DeviceNativeClickHandler {
    /**
     * This method is called when the click server process is completed.
     * Implement this method to define what should happen after the ad click server process is completed.
     */
    public void onClickServerCompleted();

    /**
     * This method is called when the click routing process is completed.
     * @param didRoute A boolean indicating whether the routing was successful.
     * Implement this method to define what should happen after the ad click routing process is completed.
     */
    public void onClickRouterCompleted(boolean didRoute);

    /**
     * This method is called when there is a failure in the ad click process.
     * @param errorCode An integer representing the error code of the failure.
     * @param errorMessage A string representing the error message of the failure.
     * Implement this method to define what should happen when there is a failure in the ad click process.
     */
    public void onFailure(int errorCode, String errorMessage);
}
