/*
 * Decompiled with CFR 0.152.
 */
package com.deepl.api;

import com.deepl.api.ConnectionException;
import com.deepl.api.DeepLException;
import com.deepl.api.http.HttpContent;
import com.deepl.api.http.HttpResponse;
import com.deepl.api.http.HttpResponseStream;
import com.deepl.api.utils.BackoffTimer;
import com.deepl.api.utils.KeyValuePair;
import com.deepl.api.utils.NamedStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.Proxy;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPatch;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.jetbrains.annotations.Nullable;

class HttpClientWrapper {
    private static final String CONTENT_TYPE = "Content-Type";
    private static final String GET = "GET";
    private static final String POST = "POST";
    private static final String DELETE = "DELETE";
    private static final String PUT = "PUT";
    private final String serverUrl;
    private final Map<String, String> headers;
    private final Duration minTimeout;
    @Nullable
    private final Proxy proxy;
    private final int maxRetries;

    public HttpClientWrapper(String serverUrl, Map<String, String> headers, Duration minTimeout, @Nullable Proxy proxy, int maxRetries) {
        this.serverUrl = serverUrl;
        this.headers = headers;
        this.minTimeout = minTimeout;
        this.proxy = proxy;
        this.maxRetries = maxRetries;
    }

    public HttpResponse sendGetRequestWithBackoff(String relativeUrl) throws InterruptedException, DeepLException {
        return this.sendRequestWithBackoff(GET, relativeUrl, null).toStringResponse();
    }

    public HttpResponse sendDeleteRequestWithBackoff(String relativeUrl, @Nullable Iterable<KeyValuePair<String, String>> params) throws InterruptedException, DeepLException {
        HttpContent content = HttpContent.buildFormURLEncodedContent(params);
        return this.sendRequestWithBackoff(DELETE, relativeUrl, content).toStringResponse();
    }

    public HttpResponse sendDeleteRequestWithBackoff(String relativeUrl) throws InterruptedException, DeepLException {
        return this.sendDeleteRequestWithBackoff(relativeUrl, null);
    }

    public HttpResponse sendRequestWithBackoff(String relativeUrl) throws InterruptedException, DeepLException {
        return this.sendRequestWithBackoff(POST, relativeUrl, null).toStringResponse();
    }

    public HttpResponse sendRequestWithBackoff(String relativeUrl, @Nullable Iterable<KeyValuePair<String, String>> params) throws InterruptedException, DeepLException {
        HttpContent content = HttpContent.buildFormURLEncodedContent(params);
        return this.sendRequestWithBackoff(POST, relativeUrl, content).toStringResponse();
    }

    public HttpResponse sendPutRequestWithBackoff(String relativeUrl, @Nullable Iterable<KeyValuePair<String, String>> params) throws InterruptedException, DeepLException {
        HttpContent content = HttpContent.buildFormURLEncodedContent(params);
        return this.sendRequestWithBackoff(PUT, relativeUrl, content).toStringResponse();
    }

    public HttpResponse sendPatchRequestWithBackoff(String relativeUrl, @Nullable Iterable<KeyValuePair<String, String>> params) throws DeepLException {
        HttpResponse httpResponse;
        block10: {
            CloseableHttpClient httpClient = HttpClients.createDefault();
            try {
                HttpContent content = HttpContent.buildFormURLEncodedContent(params);
                HttpPatch request = new HttpPatch(this.serverUrl + relativeUrl);
                BackoffTimer backoffTimer = new BackoffTimer(this.minTimeout);
                RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout((int)backoffTimer.getTimeoutMillis()).setSocketTimeout((int)backoffTimer.getTimeoutMillis()).build();
                request.setConfig(requestConfig);
                for (Map.Entry<String, String> entry : this.headers.entrySet()) {
                    request.setHeader(entry.getKey(), entry.getValue());
                }
                request.setHeader(CONTENT_TYPE, content.getContentType());
                request.setEntity((HttpEntity)new ByteArrayEntity(content.getContent()));
                CloseableHttpResponse response = httpClient.execute((HttpUriRequest)request);
                ByteArrayInputStream responseStream = response.getStatusLine().getStatusCode() >= 200 && response.getStatusLine().getStatusCode() < 400 ? response.getEntity().getContent() : new ByteArrayInputStream(EntityUtils.toByteArray((HttpEntity)response.getEntity()));
                httpResponse = new HttpResponseStream(response.getStatusLine().getStatusCode(), responseStream).toStringResponse();
                if (httpClient == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (httpClient != null) {
                        try {
                            httpClient.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SocketTimeoutException e) {
                    throw new ConnectionException(e.getMessage(), true, e);
                }
                catch (IOException | RuntimeException e) {
                    throw new ConnectionException(e.getMessage(), false, e);
                }
            }
            httpClient.close();
        }
        return httpResponse;
    }

    public HttpResponseStream downloadWithBackoff(String relativeUrl, @Nullable Iterable<KeyValuePair<String, String>> params) throws InterruptedException, DeepLException {
        HttpContent content = HttpContent.buildFormURLEncodedContent(params);
        return this.sendRequestWithBackoff(POST, relativeUrl, content);
    }

    public HttpResponse uploadWithBackoff(String relativeUrl, @Nullable Iterable<KeyValuePair<String, String>> params, String fileName, InputStream inputStream) throws InterruptedException, DeepLException {
        HttpContent content;
        ArrayList<KeyValuePair<String, Object>> fields = new ArrayList<KeyValuePair<String, Object>>();
        fields.add(new KeyValuePair<String, NamedStream>("file", new NamedStream(fileName, inputStream)));
        if (params != null) {
            params.forEach(entry -> fields.add(new KeyValuePair((String)entry.getKey(), entry.getValue())));
        }
        try {
            content = HttpContent.buildMultipartFormDataContent(fields);
        }
        catch (Exception e) {
            throw new DeepLException("Failed building request", e);
        }
        return this.sendRequestWithBackoff(POST, relativeUrl, content).toStringResponse();
    }

    private HttpResponseStream sendRequestWithBackoff(String method, String relativeUrl, HttpContent content) throws InterruptedException, DeepLException {
        BackoffTimer backoffTimer = new BackoffTimer(this.minTimeout);
        while (true) {
            block5: {
                try {
                    HttpResponseStream response = this.sendRequest(method, this.serverUrl + relativeUrl, backoffTimer.getTimeoutMillis(), content);
                    if (backoffTimer.getNumRetries() >= this.maxRetries) {
                        return response;
                    }
                    if (response.getCode() != 429 && response.getCode() < 500) {
                        return response;
                    }
                    response.close();
                }
                catch (ConnectionException exception) {
                    if (exception.getShouldRetry() && backoffTimer.getNumRetries() < this.maxRetries) break block5;
                    throw exception;
                }
            }
            backoffTimer.sleepUntilRetry();
        }
    }

    private HttpResponseStream sendRequest(String method, String urlString, long timeoutMs, HttpContent content) throws ConnectionException {
        try {
            int responseCode;
            URL url = new URL(urlString);
            HttpURLConnection connection = (HttpURLConnection)(this.proxy != null ? url.openConnection(this.proxy) : url.openConnection());
            connection.setRequestMethod(method);
            connection.setConnectTimeout((int)timeoutMs);
            connection.setReadTimeout((int)timeoutMs);
            connection.setUseCaches(false);
            for (Map.Entry<String, String> entry : this.headers.entrySet()) {
                connection.setRequestProperty(entry.getKey(), entry.getValue());
            }
            if (content != null) {
                connection.setDoOutput(true);
                connection.setRequestProperty(CONTENT_TYPE, content.getContentType());
                try (OutputStream output = connection.getOutputStream();){
                    output.write(content.getContent());
                }
            }
            InputStream responseStream = (responseCode = connection.getResponseCode()) >= 200 && responseCode < 400 ? connection.getInputStream() : connection.getErrorStream();
            return new HttpResponseStream(responseCode, responseStream);
        }
        catch (SocketTimeoutException e) {
            throw new ConnectionException(e.getMessage(), true, e);
        }
        catch (IOException | RuntimeException e) {
            throw new ConnectionException(e.getMessage(), false, e);
        }
    }
}

