/*
 * Decompiled with CFR 0.152.
 */
package com.day.jcr.vault.maven.mgr;

import com.day.jcr.vault.maven.mgr.AbstractPackageManagerMojo;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.httpclient.methods.multipart.FilePart;
import org.apache.commons.httpclient.methods.multipart.Part;
import org.apache.commons.httpclient.methods.multipart.StringPart;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.metadata.ArtifactMetadataSource;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.ArtifactRepositoryFactory;
import org.apache.maven.artifact.repository.ArtifactRepositoryPolicy;
import org.apache.maven.artifact.repository.layout.ArtifactRepositoryLayout;
import org.apache.maven.artifact.resolver.AbstractArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.impl.VersionRangeResolver;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.VersionRangeRequest;
import org.eclipse.aether.resolution.VersionRangeResolutionException;
import org.eclipse.aether.resolution.VersionRangeResult;
import org.eclipse.aether.version.Version;

@Mojo(name="install", defaultPhase=LifecyclePhase.INSTALL, requiresProject=false)
public class PackageInstallMojo
extends AbstractPackageManagerMojo {
    @Parameter(property="project", required=true, readonly=true)
    private MavenProject project;
    @Parameter(property="vault.file", defaultValue="${project.build.directory}/${project.build.finalName}.zip")
    private File packageFile;
    @Parameter(property="vault.name", defaultValue="${project.artifactId}")
    private String name;
    @Parameter(property="vault.install", defaultValue="true")
    private boolean install;
    @Parameter(property="vault.groupId")
    private String groupId;
    @Parameter(property="vault.artifactId")
    private String artifactId;
    @Parameter(property="vault.version")
    private String version;
    @Parameter(property="vault.packaging", defaultValue="zip")
    private String packaging = "zip";
    @Parameter(property="vault.artifact")
    private String artifact;
    @Parameter(property="project.remoteArtifactRepositories", readonly=true, required=true)
    private List pomRemoteRepositories;
    @Parameter(property="vault.repoId", defaultValue="temp")
    private String repositoryId;
    @Parameter(property="vault.repoUrl")
    private String repositoryUrl;
    @Component
    private ArtifactFactory artifactFactory;
    @Component
    private ArtifactResolver artifactResolver;
    @Component
    private VersionRangeResolver vRangeResolver;
    @Component
    private ArtifactRepositoryFactory artifactRepositoryFactory;
    @Component(hint="default")
    private ArtifactRepositoryLayout repositoryLayout;
    @Component
    private ArtifactMetadataSource source;
    @Parameter(property="localRepository", readonly=true)
    private ArtifactRepository localRepository;
    @Parameter(property="session", readonly=true, required=true)
    private MavenSession mavenSession;
    @Parameter(property="vault.failOnError", defaultValue="false")
    private boolean failOnError;
    @Parameter(property="vault.maxUploadAttemps", defaultValue="10")
    private short maxUploadAttemps;
    @Parameter(property="vault.waitingTimeForPackagesService", defaultValue="3")
    private short waitingTimeForPackagesService;

    @Override
    public void execute() throws MojoExecutionException, MojoFailureException {
        super.execute();
        File file = null;
        if (this.artifact != null || this.artifactId != null && this.groupId != null && this.version != null) {
            file = this.resolvePackageFileFromArtifact();
        }
        if (file == null) {
            file = this.getProjectArtifactFile();
        }
        if (file != null) {
            this.packageFile = file;
        }
        if (this.packageFile == null) {
            throw new MojoExecutionException("Missing artifact to install.");
        }
        if (!this.packageFile.canRead()) {
            throw new MojoExecutionException("Cannot access package file " + this.packageFile);
        }
        this.uploadPackage();
    }

    protected File getProjectArtifactFile() {
        return this.project.getArtifact().getFile();
    }

    private File resolvePackageFileFromArtifact() throws MojoFailureException, MojoExecutionException {
        if (this.artifactId == null && this.artifact == null) {
            return null;
        }
        if (this.artifactId == null) {
            String[] tokens = StringUtils.split((String)this.artifact, (String)":");
            if (tokens.length != 3 && tokens.length != 4) {
                throw new MojoFailureException("Invalid artifact, you must specify groupId:artifactId:version[:packaging] " + this.artifact);
            }
            this.groupId = tokens[0];
            this.artifactId = tokens[1];
            this.version = tokens[2];
            if (tokens.length == 4) {
                this.packaging = tokens[3];
            }
        }
        org.apache.maven.artifact.Artifact packageArtifact = this.artifactFactory.createBuildArtifact(this.groupId, this.artifactId, this.version, this.packaging);
        if (this.pomRemoteRepositories == null) {
            this.pomRemoteRepositories = new ArrayList();
        }
        ArrayList<ArtifactRepository> repoList = new ArrayList<ArtifactRepository>(this.pomRemoteRepositories);
        if (this.repositoryUrl != null) {
            ArtifactRepositoryPolicy policy = new ArtifactRepositoryPolicy(true, "always", "warn");
            ArtifactRepository remoteRepo = this.artifactRepositoryFactory.createArtifactRepository(this.repositoryId, this.repositoryUrl, this.repositoryLayout, policy, policy);
            repoList.add(remoteRepo);
        }
        try {
            VersionRangeRequest rangeRequest = new VersionRangeRequest();
            rangeRequest.setArtifact((Artifact)new DefaultArtifact(packageArtifact.getGroupId(), packageArtifact.getArtifactId(), packageArtifact.getClassifier(), packageArtifact.getType(), packageArtifact.getVersion()));
            for (Object e : repoList) {
                ArtifactRepository aRepo = (ArtifactRepository)e;
                RemoteRepository remoteRepo = new RemoteRepository.Builder(aRepo.getId(), "default", aRepo.getUrl()).build();
                rangeRequest.addRepository(remoteRepo);
            }
            try {
                VersionRangeResult result = this.vRangeResolver.resolveVersionRange(this.mavenSession.getRepositorySession(), rangeRequest);
                List list = result.getVersions();
                Version toUse = (Version)list.get(list.size() - 1);
                packageArtifact.setVersion(toUse.toString());
            }
            catch (VersionRangeResolutionException versionRangeResolutionException) {
                throw new MojoExecutionException(versionRangeResolutionException.getMessage(), (Exception)((Object)versionRangeResolutionException));
            }
            this.artifactResolver.resolve(packageArtifact, repoList, this.localRepository);
            this.getLog().info((CharSequence)("Resolved artifact to " + packageArtifact.getFile().getAbsolutePath()));
        }
        catch (AbstractArtifactResolutionException e) {
            throw new MojoExecutionException("Couldn't download artifact: " + e.getMessage(), (Exception)((Object)e));
        }
        return packageArtifact.getFile();
    }

    private void uploadPackage() throws MojoExecutionException, MojoFailureException {
        String task = this.install ? "Installing" : "Uploading";
        this.getLog().info((CharSequence)(task + " " + this.name + " (" + this.packageFile + ") to " + this.getTargetURL()));
        boolean installed = false;
        short attempts = 0;
        while (!installed && attempts < this.maxUploadAttemps) {
            Xpp3Dom result;
            ArrayList<Part> parts = new ArrayList<Part>();
            try {
                parts.add((Part)new FilePart("file", this.packageFile));
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
            if (this.install) {
                parts.add((Part)new StringPart("install", "true"));
            }
            if (installed = this.checkStatus(result = this.postRequest(null, parts))) {
                Xpp3Dom log;
                Xpp3Dom pkg = this.getNestedChild(result, "response/data/package");
                this.logPackage(pkg);
                if (this.isVerbose() && (log = this.getNestedChild(result, "response/data/log")) != null) {
                    this.getLog().info((CharSequence)this.getText(log, null));
                }
            } else {
                this.getLog().info((CharSequence)("Looks like the " + this.packageFile + " package was not installed, checking the list..."));
                try {
                    Thread.sleep(this.waitingTimeForPackagesService * 1000);
                }
                catch (InterruptedException pkg) {
                    // empty catch block
                }
                result = this.postRequest("ls", (Collection<Part>)null);
                if (this.checkStatus(result)) {
                    Xpp3Dom packages = this.getNestedChild(result, "response/data/packages");
                    if (packages != null) {
                        Xpp3Dom[] installedPackages = packages.getChildren("package");
                        if (installedPackages != null) {
                            for (Xpp3Dom installedPackage : installedPackages) {
                                if (!this.packageFile.getName().equals(this.getText(installedPackage, "downloadName"))) continue;
                                installed = true;
                                this.getLog().info((CharSequence)(this.packageFile + " package successfully installed and found in the packages list."));
                                this.logPackage(installedPackage);
                            }
                        } else {
                            this.getLog().warn((CharSequence)"Impossible to access to the installed packages list, data not available on server");
                        }
                    } else {
                        this.getLog().warn((CharSequence)"Impossible to access to the installed packages list, data not available on server");
                    }
                }
            }
            if (installed) continue;
            this.getLog().info((CharSequence)(this.packageFile + " package not installed, re-uploading it..."));
            attempts = (short)(attempts + 1);
        }
        if (!installed && this.failOnError) {
            throw new MojoFailureException("Error while installing package. Check log for details.");
        }
    }
}

