/*
 * Decompiled with CFR 0.152.
 */
package com.day.jcr.vault.maven.pack.impl;

import com.day.jcr.vault.maven.pack.impl.Filter;
import com.day.jcr.vault.maven.pack.impl.ImportMode;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class FilterSet<E extends Filter> {
    private String root;
    private String rootPattern;
    private List<Entry<E>> entries;
    private boolean sealed;
    private ImportMode mode = ImportMode.REPLACE;

    public FilterSet() {
        this("");
    }

    public FilterSet(String root) {
        this.setRoot(root);
    }

    public String getRoot() {
        return this.root.equals("") ? "/" : this.root;
    }

    public void setRoot(String path) {
        if (this.sealed) {
            throw new UnsupportedOperationException("FilterSet is sealed.");
        }
        if (path.endsWith("/")) {
            this.rootPattern = path;
            this.root = path.substring(0, path.length() - 1);
        } else {
            this.rootPattern = path + "/";
            this.root = path;
        }
    }

    public ImportMode getImportMode() {
        return this.mode;
    }

    public void setImportMode(ImportMode mode) {
        if (this.sealed) {
            throw new UnsupportedOperationException("FilterSet is sealed.");
        }
        this.mode = mode;
    }

    public FilterSet seal() {
        if (!this.sealed) {
            this.entries = this.entries == null ? Collections.emptyList() : Collections.unmodifiableList(this.entries);
            this.sealed = true;
        }
        return this;
    }

    public boolean isSealed() {
        return this.sealed;
    }

    public FilterSet addAll(FilterSet<E> set) {
        if (this.sealed) {
            throw new UnsupportedOperationException("FilterSet is sealed.");
        }
        if (this.entries == null) {
            this.entries = new LinkedList<Entry<Entry<E>>>(set.entries);
        } else {
            this.entries.clear();
            this.entries.addAll(set.entries);
        }
        return this;
    }

    public FilterSet addInclude(E filter) {
        this.addEntry(new Entry<E>(filter, true));
        return this;
    }

    public FilterSet addExclude(E filter) {
        this.addEntry(new Entry<E>(filter, false));
        return this;
    }

    private void addEntry(Entry<E> e) {
        if (this.sealed) {
            throw new UnsupportedOperationException("FilterSet is sealed.");
        }
        if (this.entries == null) {
            this.entries = new LinkedList<Entry<E>>();
        }
        this.entries.add(e);
    }

    public List<Entry<E>> getEntries() {
        this.seal();
        return this.entries;
    }

    public boolean isEmpty() {
        return this.entries == null || this.entries.isEmpty();
    }

    public boolean covers(String path) {
        return path.equals(this.root) || path.startsWith(this.rootPattern);
    }

    public boolean isAncestor(String path) {
        return path.equals(this.root) || this.root.startsWith(path + "/") || path.equals("/");
    }

    public int hashCode() {
        return 0;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof FilterSet) {
            return this.entries.equals(((FilterSet)obj).entries);
        }
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Entry<E extends Filter> {
        protected final E filter;
        protected final boolean include;

        public Entry(E filter, boolean include) {
            this.filter = filter;
            this.include = include;
        }

        public E getFilter() {
            return this.filter;
        }

        public boolean isInclude() {
            return this.include;
        }

        public int hashCode() {
            return 0;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof Entry) {
                return ((Entry)obj).include == this.include && ((Entry)obj).filter.equals(this.filter);
            }
            return false;
        }
    }
}

