/*
 * Decompiled with CFR 0.152.
 */
package com.day.jcr.vault.maven.pack;

import com.day.jcr.vault.maven.pack.AbstractEmbeddedsMojo;
import com.day.jcr.vault.maven.pack.ContentPackageArchiver;
import com.day.jcr.vault.maven.pack.Dependency;
import com.day.jcr.vault.maven.pack.Embedded;
import com.day.jcr.vault.maven.pack.PackageId;
import com.day.jcr.vault.maven.pack.SubPackage;
import com.day.jcr.vault.maven.pack.impl.DefaultWorkspaceFilter;
import com.day.jcr.vault.maven.pack.impl.PathFilterSet;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.maven.archiver.ManifestConfiguration;
import org.apache.maven.archiver.MavenArchiveConfiguration;
import org.apache.maven.archiver.MavenArchiver;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.handler.manager.ArtifactHandlerManager;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.codehaus.plexus.archiver.jar.JarArchiver;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.IOUtil;
import org.slf4j.impl.StaticLoggerBinder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VaultMojo
extends AbstractEmbeddedsMojo {
    private static final String JCR_ROOT = "jcr_root/";
    private static final String VAULT_DIR = "META-INF/vault";
    private static final DateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
    private static final String PACKAGE_TYPE = "zip";
    private static final String PACKAGE_EXT = ".zip";
    private static final String README_CLASSIFIER = "readme";
    private static final String README_TYPE = "txt";
    private static final String README_EXT = "-readme.txt";
    private ArtifactHandlerManager artifactHandlerManager;
    private File builtContentDirectory;
    private String finalName;
    private File outputDirectory;
    private File filterSource;
    private File workDirectory;
    private MavenArchiveConfiguration archive;
    private String prefix;
    private String group;
    private String name;
    private String version;
    private boolean requiresRoot;
    private final DefaultWorkspaceFilter filters = new DefaultWorkspaceFilter();
    private final List<Dependency> dependencies = new ArrayList<Dependency>();
    private final List<SubPackage> subPackages = new ArrayList<SubPackage>();
    private final Map properties = new HashMap();
    private String embeddedTarget;

    public void addDependency(Dependency dependency) {
        this.dependencies.add(dependency);
    }

    public void addPackage(SubPackage jcrPackage) {
        this.subPackages.add(jcrPackage);
    }

    public void setEmbeddedTarget(String embeddedTarget) {
        this.embeddedTarget = embeddedTarget.endsWith("/") ? embeddedTarget : embeddedTarget + "/";
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        StaticLoggerBinder.getSingleton().setMavenLog(this.getLog());
        if (this.prefix == null) {
            this.prefix = "";
        } else if (!this.prefix.endsWith("/")) {
            this.prefix = this.prefix + "/";
        }
        File vaultDir = new File(this.workDirectory, VAULT_DIR);
        File definitionDir = new File(vaultDir, "definition");
        File finalFile = new File(this.outputDirectory, this.finalName + PACKAGE_EXT);
        try {
            DefaultWorkspaceFilter oldFilter;
            vaultDir.mkdirs();
            definitionDir.mkdirs();
            Map<String, File> embeddedFiles = this.copyEmbeddeds();
            embeddedFiles.putAll(this.copySubPackages());
            this.writeProperties(new File(vaultDir, "properties.xml"));
            File filterFile = new File(vaultDir, "filter.xml");
            if (this.filterSource == null || !this.filterSource.exists()) {
                oldFilter = null;
                if (filterFile.exists()) {
                    oldFilter = new DefaultWorkspaceFilter();
                    oldFilter.load(filterFile);
                    filterFile = this.filters.getSourceAsString().equals(oldFilter.getSourceAsString()) ? null : new File(vaultDir, "filter-plugin-generated.xml");
                } else if (this.filters.getFilterSets().isEmpty() && this.prefix.length() > 0) {
                    this.addWorkspaceFilter(this.prefix);
                }
            } else {
                this.getLog().info((CharSequence)("Merging " + this.filterSource.getPath() + " with inlined filter specifications."));
                oldFilter = new DefaultWorkspaceFilter();
                oldFilter.load(this.filterSource);
                oldFilter.merge(this.filters);
                this.filters.getFilterSets().clear();
                this.filters.getFilterSets().addAll(oldFilter.getFilterSets());
                if (this.filters.getFilterSets().isEmpty() && this.prefix.length() > 0) {
                    this.addWorkspaceFilter(this.prefix);
                }
            }
            if (filterFile != null) {
                FileUtils.fileWrite((String)filterFile.getAbsolutePath(), (String)this.filters.getSourceAsString());
            }
            this.copyFile("/vault/config.xml", new File(vaultDir, "config.xml"));
            this.copyFile("/vault/settings.xml", new File(vaultDir, "settings.xml"));
            this.copyFile("/vault/content.xml", new File(definitionDir, ".content.xml"));
            this.copyFile("/vault/package.thumbnail.png", new File(definitionDir, "thumbnail.png"));
            ContentPackageArchiver contentPackageArchiver = new ContentPackageArchiver();
            contentPackageArchiver.addDirectory(this.workDirectory);
            if (this.builtContentDirectory.exists()) {
                contentPackageArchiver.addDirectory(this.builtContentDirectory, FileUtils.normalize((String)(JCR_ROOT + this.prefix)));
            }
            for (Map.Entry<String, File> entry : embeddedFiles.entrySet()) {
                contentPackageArchiver.addFile(entry.getValue(), entry.getKey());
            }
            contentPackageArchiver.setIncludeEmptyDirs(true);
            MavenArchiver mavenArchiver = new MavenArchiver();
            mavenArchiver.setArchiver((JarArchiver)contentPackageArchiver);
            mavenArchiver.setOutputFile(finalFile);
            mavenArchiver.createArchive(this.project, this.getMavenArchiveConfiguration());
            Artifact projectArtifact = this.project.getArtifact();
            projectArtifact.setFile(finalFile);
            projectArtifact.setArtifactHandler(this.artifactHandlerManager.getArtifactHandler(PACKAGE_TYPE));
        }
        catch (Exception drre) {
            throw new MojoExecutionException(drre.toString(), drre);
        }
    }

    private MavenArchiveConfiguration getMavenArchiveConfiguration() {
        if (this.archive == null) {
            this.archive = new MavenArchiveConfiguration();
            this.archive.setManifest(new ManifestConfiguration());
            this.archive.setAddMavenDescriptor(true);
            this.archive.setCompress(true);
            this.archive.setIndex(false);
            this.archive.getManifest().setAddDefaultSpecificationEntries(true);
            this.archive.getManifest().setAddDefaultImplementationEntries(true);
        }
        return this.archive;
    }

    private void writeProperties(File propsFile) throws IOException {
        Properties props = new Properties();
        String description = this.project.getDescription();
        if (description == null && (description = this.project.getName()) == null) {
            description = this.project.getArtifactId();
        }
        props.put("description", description);
        props.putAll((Map<?, ?>)this.properties);
        props.put("group", this.group);
        props.put("name", this.name);
        props.put("version", this.version);
        props.put("groupId", this.project.getGroupId());
        props.put("artifactId", this.project.getArtifactId());
        if (!this.dependencies.isEmpty()) {
            props.put("dependencies", Dependency.toString(this.dependencies));
        }
        if (!props.containsKey("createdBy")) {
            props.put("createdBy", System.getProperty("user.name"));
        }
        props.put("created", DATE_FORMAT.format(new Date()));
        props.put("requiresRoot", String.valueOf(this.requiresRoot));
        props.put("path", "/etc/packages/" + this.group + "/" + this.name + PACKAGE_EXT);
        FileOutputStream fos = new FileOutputStream(propsFile);
        props.storeToXML(fos, this.project.getName());
        fos.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyFile(String source, File target) throws IOException {
        if (target.exists()) {
            return;
        }
        target.getParentFile().mkdirs();
        InputStream ins = ((Object)((Object)this)).getClass().getResourceAsStream(source);
        if (ins != null) {
            FileOutputStream out = null;
            try {
                out = new FileOutputStream(target);
                IOUtil.copy((InputStream)ins, (OutputStream)out);
            }
            finally {
                IOUtil.close((InputStream)ins);
                IOUtil.close((OutputStream)out);
            }
        }
    }

    private Map<String, File> copyEmbeddeds() throws IOException, MojoFailureException {
        HashMap<String, File> fileMap = new HashMap<String, File>();
        for (Embedded emb : this.embeddeds) {
            String targetPath;
            List<Artifact> artifacts = emb.getMatchingArtifacts(this.project);
            if (artifacts.isEmpty()) {
                if (this.failOnMissingEmbed) {
                    throw new MojoFailureException("Embedded artifact specified " + emb + ", but no matching dependency artifact found. Add the missing dependency or fix the embed definition.");
                }
                this.getLog().warn((CharSequence)("No matching artifacts for " + emb));
                continue;
            }
            if (emb.getDestFileName() != null && artifacts.size() > 1) {
                this.getLog().warn((CharSequence)("destFileName defined but several artifacts match for " + emb));
            }
            if ((targetPath = emb.getTarget()) == null && (targetPath = this.embeddedTarget) == null) {
                String loc = this.prefix.length() == 0 ? "/apps/" : this.prefix;
                targetPath = loc + "bundles/install/";
                this.getLog().info((CharSequence)("No target path set on " + emb + "; assuming default " + targetPath));
            }
            targetPath = this.makeAbsolutePath(targetPath);
            targetPath = JCR_ROOT + targetPath;
            targetPath = FileUtils.normalize((String)targetPath);
            this.getLog().info((CharSequence)("Embedding --- " + emb + " ---"));
            Iterator<Artifact> i$ = artifacts.iterator();
            while (i$.hasNext()) {
                Artifact artifact1;
                Artifact artifact = artifact1 = i$.next();
                File source = artifact.getFile();
                String destFileName = emb.getDestFileName();
                if (destFileName == null) {
                    destFileName = source.getName();
                }
                String targetPathName = targetPath + destFileName;
                String targetNodePathName = targetPathName.substring(JCR_ROOT.length() - 1);
                fileMap.put(targetPathName, source);
                this.getLog().info((CharSequence)String.format("Embedding %s (from %s) -> %s", artifact.getId(), source.getAbsolutePath(), targetPathName));
                if (!emb.isFilter()) continue;
                this.addWorkspaceFilter(targetNodePathName);
            }
        }
        return fileMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, File> copySubPackages() throws IOException {
        HashMap<String, File> fileMap = new HashMap<String, File>();
        for (SubPackage pack : this.subPackages) {
            List<Artifact> artifacts = pack.getMatchingArtifacts(this.project);
            if (artifacts.isEmpty()) {
                this.getLog().warn((CharSequence)("No matching artifacts for " + pack));
                continue;
            }
            this.getLog().info((CharSequence)("Embedding --- " + pack + " ---"));
            Iterator<Artifact> i$ = artifacts.iterator();
            while (i$.hasNext()) {
                Artifact artifact1;
                Artifact artifact = artifact1 = i$.next();
                File source = artifact.getFile();
                ZipFile zip = null;
                InputStream in = null;
                Properties props = new Properties();
                try {
                    zip = new ZipFile(source, 1);
                    ZipEntry e = zip.getEntry("META-INF/vault/properties.xml");
                    if (e == null) {
                        this.getLog().error((CharSequence)"Package does not contain properties.xml");
                        throw new IOException("properties.xml missing");
                    }
                    in = zip.getInputStream(e);
                    props.loadFromXML(in);
                }
                catch (Throwable throwable) {
                    IOUtil.close(in);
                    if (zip != null) {
                        zip.close();
                    }
                    throw throwable;
                }
                IOUtil.close((InputStream)in);
                if (zip != null) {
                    zip.close();
                }
                PackageId pid = new PackageId(props.getProperty("group"), props.getProperty("name"), props.getProperty("version"));
                String targetNodePathName = pid.getInstallationPath() + PACKAGE_EXT;
                String targetPathName = "jcr_root" + targetNodePathName;
                fileMap.put(targetPathName, source);
                this.getLog().info((CharSequence)("Embedding " + artifact.getId() + " -> " + targetPathName));
                if (!pack.isFilter()) continue;
                this.addWorkspaceFilter(targetNodePathName);
            }
        }
        return fileMap;
    }

    private void addWorkspaceFilter(String filterRoot) {
        this.filters.add(new PathFilterSet(filterRoot));
    }

    private String makeAbsolutePath(String relPath) {
        String absPath;
        if (!relPath.startsWith("/")) {
            absPath = (this.prefix.length() == 0 ? "/" : this.prefix) + relPath;
            this.getLog().info((CharSequence)("Relative path resolved to " + absPath));
        } else {
            absPath = relPath;
        }
        return absPath;
    }
}

