/*
 * Decompiled with CFR 0.152.
 */
package com.day.jcr.vault.maven.pack;

import com.day.jcr.vault.maven.pack.AbstractEmbeddedsMojo;
import com.day.jcr.vault.maven.pack.Embedded;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.AbstractArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.codehaus.mojo.animal_sniffer.ClassListBuilder;
import org.codehaus.mojo.animal_sniffer.SignatureChecker;
import org.codehaus.mojo.animal_sniffer.logging.Logger;
import org.codehaus.mojo.animal_sniffer.maven.MavenLogger;
import org.codehaus.mojo.animal_sniffer.maven.Signature;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CheckSignatureMojo
extends AbstractEmbeddedsMojo {
    private ArtifactFactory artifactFactory;
    private List classpathElements;
    private String[] ignores;
    private ArtifactRepository localRepository;
    private ArtifactResolver resolver;
    private Signature signature;

    private Set buildPackageList() throws IOException {
        ClassListBuilder plb = new ClassListBuilder((Logger)new MavenLogger(this.getLog()));
        for (String path : this.classpathElements) {
            plb.process(new File(path));
        }
        return plb.getPackages();
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.signature == null) {
            this.getLog().info((CharSequence)"No signature defined. Skipping signature check.");
            return;
        }
        try {
            this.getLog().info((CharSequence)("Checking unresolved references to " + this.signature));
            Artifact a = this.signature.createArtifact(this.artifactFactory);
            this.resolver.resolve(a, this.project.getRemoteArtifactRepositories(), this.localRepository);
            Set ignoredPackages = this.buildPackageList();
            if (this.ignores != null) {
                for (int i = 0; i < this.ignores.length; ++i) {
                    String ignore = this.ignores[i];
                    if (ignore == null) continue;
                    ignoredPackages.add(ignore.replace('.', '/'));
                }
            }
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)ignoredPackages.toString());
            }
            SignatureChecker signatureChecker = new SignatureChecker((InputStream)new FileInputStream(a.getFile()), ignoredPackages, (Logger)new MavenLogger(this.getLog()));
            signatureChecker.setCheckJars(true);
            signatureChecker.process(this.getEmbeddeds().toArray(new File[0]));
            if (signatureChecker.isSignatureBroken()) {
                throw new MojoFailureException("Signature errors found. Verify them and put @IgnoreJRERequirement on them.");
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to check signatures", (Exception)e);
        }
        catch (AbstractArtifactResolutionException e) {
            throw new MojoExecutionException("Failed to obtain signature: " + this.signature, (Exception)((Object)e));
        }
    }

    private Collection<File> getEmbeddeds() throws MojoFailureException {
        HashSet<File> files = new HashSet<File>();
        for (Embedded emb : this.embeddeds) {
            List<Artifact> artifacts = emb.getMatchingArtifacts(this.project);
            if (artifacts.isEmpty()) {
                if (this.failOnMissingEmbed) {
                    throw new MojoFailureException("Embedded artifact specified " + emb + ", but no matching dependency artifact found. Add the missing dependency or fix the embed definition.");
                }
                this.getLog().warn((CharSequence)("No matching artifacts for " + emb));
                continue;
            }
            for (Artifact artifact : artifacts) {
                File source = artifact.getFile();
                files.add(source);
            }
        }
        return files;
    }
}

