/*
 * Decompiled with CFR 0.152.
 */
package com.day.crx.statistics.keyword;

import com.day.crx.statistics.Report;
import com.day.crx.statistics.query.MostPopularQueriesReport;
import com.day.crx.statistics.result.ResultsByQueryReport;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.jcr.RepositoryException;
import javax.jcr.Session;

public class ExtractKeywordsReport
extends Report {
    private int size = 100;
    private int period = 90;
    private final String resultDataPath;

    public ExtractKeywordsReport(String queryDataPath, String resultDataPath) {
        super(queryDataPath);
        this.resultDataPath = resultDataPath;
    }

    public Iterator getResult(Session session) throws RepositoryException {
        MostPopularQueriesReport mpqr = new MostPopularQueriesReport(this.getDataPath());
        mpqr.setSize(this.getSize());
        mpqr.setPeriod(this.getPeriod());
        Iterator popularQueries = mpqr.getResult(session);
        LinkedHashMap pathToKeywords = new LinkedHashMap();
        block0: while (popularQueries.hasNext()) {
            Object[] data = (Object[])popularQueries.next();
            String query = (String)data[0];
            ResultsByQueryReport rr = new ResultsByQueryReport(this.resultDataPath, query);
            long threshold = -1L;
            Iterator it = rr.getResult(session);
            while (it.hasNext()) {
                Object[] rrData = (Object[])it.next();
                String path = (String)rrData[0];
                long count = (Long)rrData[1];
                if (threshold == -1L) {
                    threshold = Math.max(count / 2L, 2L);
                }
                if (count < threshold) continue block0;
                ArrayList<Object> keywords = (ArrayList<Object>)pathToKeywords.get(path);
                if (keywords == null) {
                    keywords = new ArrayList<Object>(3);
                    keywords.add(new Long(0L));
                    pathToKeywords.put(path, keywords);
                }
                if (!keywords.contains(query = query.toLowerCase())) {
                    keywords.add(query);
                }
                keywords.set(0, new Long((Long)keywords.get(0) + count));
            }
        }
        ArrayList<Object[]> result = new ArrayList<Object[]>();
        for (Map.Entry entry : pathToKeywords.entrySet()) {
            String path = (String)entry.getKey();
            List keywords = (List)entry.getValue();
            Long count = (Long)keywords.get(0);
            keywords = keywords.subList(1, keywords.size());
            result.add(new Object[]{path, count, keywords});
        }
        return result.iterator();
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public int getPeriod() {
        return this.period;
    }

    public void setPeriod(int period) {
        this.period = period;
    }
}

