/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.tools.dbm;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.w3c.tools.dbm.jdbm;
import org.w3c.tools.dbm.jdbmBucketElement;

class jdbmBucket {
    private static final boolean debug = false;
    private static final int AVAIL_SIZE = 6;
    private static final int IGNORE_SIZE = 8;
    static final int fsize = 60;
    int bits = 0;
    int count = 0;
    jdbmBucketElement[] elements = null;
    int avail_count = 0;
    int[] avail_size = null;
    int[] avail_ptr = null;
    jdbm db = null;
    boolean modified = false;
    int fileptr = -1;

    private final boolean arrayStartsWith(byte[] a, byte[] s) {
        int len = Math.min(a.length, s.length);
        for (int i = 0; i < len; ++i) {
            if (a[i] == s[i]) continue;
            return false;
        }
        return true;
    }

    private final boolean arrayEquals(byte[] a1, byte[] a2) {
        if (a1.length == a2.length) {
            int len = a1.length;
            for (int i = 0; i < len; ++i) {
                if (a1[i] == a2[i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    void save(DataOutputStream out) throws IOException {
        int i;
        out.writeInt(this.bits);
        out.writeInt(this.count);
        for (i = 0; i < this.elements.length; ++i) {
            this.elements[i].save(out);
        }
        out.writeInt(this.avail_count);
        for (i = 0; i < this.avail_size.length; ++i) {
            out.writeInt(this.avail_size[i]);
            out.writeInt(this.avail_ptr[i]);
        }
        this.modified = false;
    }

    static jdbmBucket restore(DataInputStream in, int fileptr, jdbmBucket into) throws IOException {
        int i;
        into.fileptr = fileptr;
        into.bits = in.readInt();
        into.count = in.readInt();
        for (i = 0; i < into.elements.length; ++i) {
            jdbmBucketElement.restore(in, into.elements[i]);
        }
        into.avail_count = in.readInt();
        for (i = 0; i < into.avail_size.length; ++i) {
            into.avail_size[i] = in.readInt();
            into.avail_ptr[i] = in.readInt();
        }
        return into;
    }

    protected jdbmBucketElement lookup(byte[] key, int hashval) throws IOException {
        int iloc;
        int hloc = iloc = hashval % this.db.bucket_elems;
        do {
            byte[] filekey;
            jdbmBucketElement el = this.elements[iloc];
            if (el.hashval == -1) {
                return null;
            }
            if (el.hashval != hashval || !this.arrayStartsWith(key, el.keystart) || !this.arrayEquals(filekey = this.db.readKey(el), key)) continue;
            return el;
        } while ((iloc = (iloc + 1) % this.elements.length) != hloc);
        return null;
    }

    protected void add(int hashval, byte[] key, byte[] value) throws IOException {
        if (this.count >= this.db.bucket_elems) {
            throw new RuntimeException("implementation error.");
        }
        int iloc = hashval % this.db.bucket_elems;
        while (true) {
            jdbmBucketElement el = this.elements[iloc];
            if (el.hashval == -1) {
                el.hashval = hashval;
                System.arraycopy(key, 0, el.keystart, 0, key.length <= 4 ? key.length : 4);
                el.key_size = key.length;
                el.data_size = value.length;
                el.fileptr = this.db.write(this, key, value);
                this.modified = true;
                ++this.count;
                return;
            }
            iloc = (iloc + 1) % this.elements.length;
        }
    }

    private final void removeAvailable(int idx) {
        this.modified = true;
        --this.avail_count;
        if (idx == this.avail_count) {
            return;
        }
        System.arraycopy(this.avail_size, idx + 1, this.avail_size, idx, this.avail_count - idx);
        System.arraycopy(this.avail_ptr, idx + 1, this.avail_ptr, idx, this.avail_count - idx);
    }

    private void markAvailable(int ptr, int size) {
        this.modified = true;
        for (int i = 0; i < this.avail_count; ++i) {
            if (this.avail_size[i] < size) continue;
            System.arraycopy(this.avail_size, i, this.avail_size, i + 1, this.avail_count - i);
            System.arraycopy(this.avail_ptr, i, this.avail_ptr, i + 1, this.avail_count - i);
            ++this.avail_count;
            this.avail_size[i] = size;
            this.avail_ptr[i] = ptr;
            return;
        }
        this.avail_size[this.avail_count] = size;
        this.avail_ptr[this.avail_count] = ptr;
        ++this.avail_count;
    }

    private int fixAvailable(int idx, int size) {
        this.modified = true;
        int fileptr = this.avail_ptr[idx];
        int n = idx;
        int n2 = this.avail_size[n] - size;
        this.avail_size[n] = n2;
        int nsize = n2;
        int n3 = idx;
        int n4 = this.avail_ptr[n3] + size;
        this.avail_ptr[n3] = n4;
        int nptr = n4;
        this.removeAvailable(idx);
        if (nsize <= 8) {
            return fileptr;
        }
        if (nsize >= this.db.block_size) {
            this.db.markAvailable(nptr, nsize);
        } else {
            this.markAvailable(nptr, nsize);
        }
        return fileptr;
    }

    protected void delete(jdbmBucketElement el) {
        int size = el.key_size + el.data_size;
        if (size >= this.db.block_size || this.avail_count + 1 >= 6) {
            this.db.markAvailable(el.fileptr, size);
        } else {
            this.markAvailable(el.fileptr, el.key_size + el.data_size);
        }
        int elem_loc = el.hashval % this.db.bucket_elems;
        while (this.elements[elem_loc] != el) {
            elem_loc = (elem_loc + 1) % this.db.bucket_elems;
        }
        el.hashval = -1;
        --this.count;
        int last_loc = elem_loc;
        elem_loc = (elem_loc + 1) % this.db.bucket_elems;
        while (elem_loc != last_loc && this.elements[elem_loc].hashval != -1) {
            int h = this.elements[elem_loc].hashval % this.db.bucket_elems;
            if (last_loc < elem_loc && (h <= last_loc || h > elem_loc) || last_loc > elem_loc && h <= last_loc && h > elem_loc) {
                this.elements[last_loc] = this.elements[elem_loc];
                this.elements[elem_loc] = new jdbmBucketElement();
                last_loc = elem_loc;
            }
            elem_loc = (elem_loc + 1) % this.db.bucket_elems;
        }
        this.modified = true;
    }

    protected int allocateSpace(int size) {
        for (int i = 0; i < this.avail_count; ++i) {
            if (this.avail_size[i] < size) continue;
            return this.fixAvailable(i, size);
        }
        return -1;
    }

    jdbmBucket(jdbm db, int fileptr, int availblock) {
        this.db = db;
        this.fileptr = fileptr;
        this.elements = new jdbmBucketElement[db.bucket_elems];
        for (int i = 0; i < this.elements.length; ++i) {
            this.elements[i] = new jdbmBucketElement();
        }
        this.avail_count = 0;
        this.avail_size = new int[6];
        this.avail_ptr = new int[6];
        if (availblock >= 0) {
            this.avail_count = 1;
            this.avail_size[0] = db.block_size;
            this.avail_ptr[0] = availblock * db.block_size;
        }
    }
}

