/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.tools.dbm;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.io.RandomAccessFile;
import java.util.Enumeration;
import org.w3c.tools.dbm.FastByteArrayOutputStream;
import org.w3c.tools.dbm.LRUEntry;
import org.w3c.tools.dbm.LRUList;
import org.w3c.tools.dbm.jdbmBucket;
import org.w3c.tools.dbm.jdbmBucketElement;
import org.w3c.tools.dbm.jdbmEnumerator;

public class jdbm {
    private static final int IGNORE_SIZE = 8;
    private static final boolean debug = false;
    public static final int STORE_REPLACE = 1;
    public static final int STORE_INSERT = 2;
    protected static final int BLOCK_SIZE = 1024;
    protected static final int DIR_BITS = 3;
    protected static final int CACHE_SIZE = 32;
    private static final int fsize = 36;
    int block_size = 1024;
    int dir_bits = 3;
    int dir_size = 0;
    int dir_adr = 0;
    int cache_size = 32;
    int bucket_elems = 0;
    int next_block = 0;
    int avail_count = 0;
    int avail_length = 0;
    int[] avail_size = null;
    int[] avail_ptr = null;
    File file = null;
    RandomAccessFile fd = null;
    int[] diridx = null;
    private byte[] buffer = null;
    private boolean dir_changed = false;
    private boolean header_changed = false;
    private LRUList list = null;
    private int loaded_buckets = 0;

    protected final void trace(String msg) {
    }

    private static final int hash(byte[] key) {
        int value = 596579247 * key.length;
        for (int i = 0; i < key.length; ++i) {
            value = value + (key[i] << i * 5 % 24) & Integer.MAX_VALUE;
        }
        return 1103515243 * value + 12345 & Integer.MAX_VALUE;
    }

    private void splitBucket(int hashval, jdbmBucket bucket) throws IOException {
        jdbmBucket select = null;
        this.trace("split bucket: " + bucket.fileptr);
        while (bucket.count == this.bucket_elems) {
            int i;
            int newbits;
            this.list.removeBucket(bucket);
            --this.loaded_buckets;
            this.markAvailable(bucket.fileptr, this.block_size);
            int a0 = this.allocateSpace(this.block_size);
            int a1 = this.allocateSpace(this.block_size);
            jdbmBucket b0 = new jdbmBucket(this, a0, -1);
            jdbmBucket b1 = new jdbmBucket(this, a1, -1);
            LRUEntry lru0 = this.list.addEntry(b0);
            LRUEntry lru1 = this.list.addEntry(b1);
            this.trace("splited b0=" + a0);
            this.trace("splited b1=" + a1);
            this.loaded_buckets += 2;
            b0.bits = newbits = bucket.bits + 1;
            b1.bits = newbits;
            if (this.dir_bits == bucket.bits) {
                this.dir_size <<= 1;
                this.dir_adr = this.allocateSpace(this.dir_size * 4);
                int[] ndiridx = new int[this.dir_size];
                for (int i2 = 0; i2 < this.dir_size / 2; ++i2) {
                    ndiridx[2 * i2] = this.diridx[i2];
                    ndiridx[2 * i2 + 1] = this.diridx[i2];
                }
                this.diridx = ndiridx;
                this.dir_bits = newbits;
                this.dir_changed = true;
            }
            for (int i3 = 0; i3 < this.bucket_elems; ++i3) {
                jdbmBucketElement el = bucket.elements[i3];
                int nsel = el.hashval >> 31 - newbits & 1;
                int nloc = el.hashval % this.bucket_elems;
                jdbmBucket jdbmBucket2 = select = nsel == 0 ? b0 : b1;
                while (select.elements[nloc].hashval != -1) {
                    nloc = (nloc + 1) % this.bucket_elems;
                }
                select.elements[nloc] = el;
                ++select.count;
            }
            b1.avail_count = bucket.avail_count;
            b1.avail_size = bucket.avail_size;
            b1.avail_ptr = bucket.avail_ptr;
            int dir_idx = hashval >>> 31 - this.dir_bits;
            int dir_start1 = dir_idx >> this.dir_bits - newbits | 1;
            int dir_end = dir_start1 + 1 << this.dir_bits - newbits;
            int dir_start0 = (dir_start1 <<= this.dir_bits - newbits) - (dir_end - dir_start1);
            this.trace("updating dir from " + dir_start0 + " to " + dir_start1);
            for (i = dir_start0; i < dir_start1; ++i) {
                this.diridx[i] = a0;
            }
            this.trace("updating dir from " + dir_start1 + " to " + dir_end);
            for (i = dir_start1; i < dir_end; ++i) {
                this.diridx[i] = a1;
            }
            b0.modified = true;
            b1.modified = true;
            this.dir_changed = true;
            this.saveBucket(b0);
            this.saveBucket(b1);
            bucket = this.lookupBucket(hashval);
        }
    }

    private void saveHeader(DataOutputStream out) throws IOException {
        out.writeInt(this.block_size);
        out.writeInt(this.dir_bits);
        out.writeInt(this.dir_size);
        out.writeInt(this.dir_adr);
        out.writeInt(this.cache_size);
        out.writeInt(this.bucket_elems);
        out.writeInt(this.next_block);
        out.writeInt(this.avail_length);
        out.writeInt(this.avail_count);
        for (int i = 0; i < this.avail_length; ++i) {
            out.writeInt(this.avail_size[i]);
            out.writeInt(this.avail_ptr[i]);
        }
    }

    private void restoreHeader(DataInputStream in) throws IOException {
        this.block_size = in.readInt();
        this.dir_bits = in.readInt();
        this.dir_size = in.readInt();
        this.dir_adr = in.readInt();
        this.cache_size = in.readInt();
        this.bucket_elems = in.readInt();
        this.next_block = in.readInt();
        this.avail_length = in.readInt();
        this.avail_count = in.readInt();
        this.avail_size = new int[this.avail_length];
        this.avail_ptr = new int[this.avail_length];
        for (int i = 0; i < this.avail_length; ++i) {
            this.avail_size[i] = in.readInt();
            this.avail_ptr[i] = in.readInt();
        }
    }

    public void printHeader(PrintStream out) {
        out.println("Options for " + this.file.getAbsolutePath() + ":");
        out.println("\tblock_size   = " + this.block_size);
        out.println("\tdir_bits     = " + this.dir_bits);
        out.println("\tdir_size     = " + this.dir_size);
        out.println("\tdir_adr      = " + this.dir_adr);
        out.println("\tcache_size   = " + this.cache_size);
        out.println("\tdir_size     = " + (1 << this.dir_bits));
        out.println("\tbucket_elems = " + this.bucket_elems);
        out.println("\tnext_block   = " + this.next_block);
        out.println("\tavail_count  = " + this.avail_count);
        out.println("\tavail_length = " + this.avail_length);
    }

    public void printAvail(PrintStream out) {
        out.println("avail_count=" + this.avail_count + "/" + this.avail_size.length);
        for (int i = 0; i < this.avail_count; ++i) {
            out.println("\tsize=" + this.avail_size[i] + " ,ptr=" + this.avail_ptr[i]);
        }
    }

    void saveBucket(jdbmBucket bucket) throws IOException {
        DataOutputStream out = new DataOutputStream(new FastByteArrayOutputStream(this.buffer));
        bucket.save(out);
        this.fd.seek(bucket.fileptr);
        this.fd.write(this.buffer);
    }

    private void saveDirectory(DataOutputStream out) throws IOException {
        for (int i = 0; i < this.diridx.length; ++i) {
            out.writeInt(this.diridx[i]);
        }
    }

    private void restoreDirectory(DataInputStream in) throws IOException {
        this.diridx = new int[this.dir_size];
        for (int i = 0; i < this.diridx.length; ++i) {
            this.diridx[i] = in.readInt();
        }
    }

    void markAvailable(int ptr, int size) {
        if (this.avail_count + 1 >= this.avail_size.length) {
            return;
        }
        this.header_changed = true;
        for (int i = 0; i < this.avail_count; ++i) {
            if (this.avail_size[i] < size) continue;
            System.arraycopy(this.avail_size, i, this.avail_size, i + 1, this.avail_count - i);
            System.arraycopy(this.avail_ptr, i, this.avail_ptr, i + 1, this.avail_count - i);
            ++this.avail_count;
            this.avail_size[i] = size;
            this.avail_ptr[i] = ptr;
            return;
        }
        this.avail_size[this.avail_count] = size;
        this.avail_ptr[this.avail_count] = ptr;
        ++this.avail_count;
    }

    final void removeAvailable(int idx) {
        this.header_changed = true;
        --this.avail_count;
        if (idx == this.avail_count) {
            return;
        }
        System.arraycopy(this.avail_size, idx + 1, this.avail_size, idx, this.avail_count - idx);
        System.arraycopy(this.avail_ptr, idx + 1, this.avail_ptr, idx, this.avail_count - idx);
    }

    int fixAvailable(int idx, int size) {
        this.header_changed = true;
        int fileptr = this.avail_ptr[idx];
        int n = idx;
        int n2 = this.avail_size[n] - size;
        this.avail_size[n] = n2;
        int nsize = n2;
        int n3 = idx;
        int n4 = this.avail_ptr[n3] + size;
        this.avail_ptr[n3] = n4;
        int nptr = n4;
        this.removeAvailable(idx);
        if (nsize <= 8) {
            return fileptr;
        }
        this.markAvailable(nptr, nsize);
        return fileptr;
    }

    protected int allocateSpace(int size) {
        int totalAllocation;
        this.header_changed = true;
        this.trace("allocateSpace: avail_count=" + this.avail_count);
        for (int i = 0; i < this.avail_count; ++i) {
            if (this.avail_size[i] < size) continue;
            return this.fixAvailable(i, size);
        }
        int newblock = this.next_block++;
        int fileptr = newblock * this.block_size;
        while ((totalAllocation = (this.next_block - newblock) * this.block_size) < size) {
            ++this.next_block;
        }
        int spaceLeftOver = totalAllocation - size;
        if (spaceLeftOver >= 8) {
            this.markAvailable(fileptr + size, spaceLeftOver);
        }
        return fileptr;
    }

    protected int write(jdbmBucket bucket, byte[] key, byte[] data) throws IOException {
        int size = key.length + data.length;
        int fileptr = bucket.allocateSpace(size);
        if (fileptr < 0) {
            fileptr = this.allocateSpace(size);
        }
        this.trace("write: @" + fileptr);
        this.fd.seek(fileptr);
        this.fd.write(key);
        this.fd.write(data);
        return fileptr;
    }

    byte[] readKey(jdbmBucketElement el) throws IOException {
        this.trace("read: @" + el.fileptr);
        byte[] key = new byte[el.key_size];
        this.fd.seek(el.fileptr);
        if (this.fd.read(key) != el.key_size) {
            throw new RuntimeException("invalid key read.");
        }
        return key;
    }

    byte[] readData(jdbmBucketElement el) throws IOException {
        byte[] data = new byte[el.data_size];
        this.fd.seek(el.fileptr + el.key_size);
        if (this.fd.read(data) != el.data_size) {
            throw new RuntimeException("invalid data read.");
        }
        return data;
    }

    protected synchronized jdbmBucket unloadBucket() throws IOException {
        LRUEntry lru = this.list.getLRU();
        if (lru == null) {
            return null;
        }
        jdbmBucket bucket = lru.bucket;
        if (bucket.modified) {
            this.saveBucket(bucket);
        }
        --this.loaded_buckets;
        return bucket;
    }

    protected synchronized LRUEntry loadBucket(int fileptr) throws IOException {
        jdbmBucket bucket = null;
        if (this.loaded_buckets >= this.cache_size) {
            this.trace("*** removing bucket from cache !");
            bucket = this.unloadBucket();
        } else {
            this.trace("*** filling cache.");
            ++this.loaded_buckets;
            bucket = new jdbmBucket(this, fileptr, -1);
        }
        this.fd.seek(fileptr);
        if (this.fd.read(this.buffer, 0, this.buffer.length) != this.buffer.length) {
            throw new IOException("invalid read length.");
        }
        jdbmBucket.restore(new DataInputStream(new ByteArrayInputStream(this.buffer)), fileptr, bucket);
        return this.list.addEntry(bucket);
    }

    private synchronized jdbmBucket lookupBucket(int hashval) throws IOException {
        int didx = hashval >>> 31 - this.dir_bits;
        int fptr = this.diridx[didx];
        int dptr = fptr / this.block_size;
        LRUEntry lru = this.list.lookupBucket(fptr);
        if (lru == null) {
            lru = this.loadBucket(fptr);
        }
        this.list.notifyUses(lru);
        return lru.bucket;
    }

    public void store(byte[] key, byte[] value, int mode) throws IOException {
        int hashval = jdbm.hash(key);
        jdbmBucket bucket = this.lookupBucket(hashval);
        jdbmBucketElement el = bucket.lookup(key, hashval);
        if (el != null) {
            if (mode == 1) {
                bucket.delete(el);
            } else {
                return;
            }
        }
        if (bucket.count >= this.bucket_elems) {
            this.splitBucket(hashval, bucket);
            bucket = this.lookupBucket(hashval);
        }
        bucket.add(hashval, key, value);
    }

    public void store(String key, byte[] data, int mode) throws IOException {
        this.store(key.getBytes(), data, mode);
    }

    public void store(String key, String data, int mode) throws IOException {
        this.store(key.getBytes(), data.getBytes(), mode);
    }

    public byte[] lookup(byte[] key) throws IOException {
        int hashval = jdbm.hash(key);
        jdbmBucket bucket = this.lookupBucket(hashval);
        jdbmBucketElement el = bucket.lookup(key, hashval);
        return el != null ? this.readData(el) : null;
    }

    public byte[] fetch(byte[] key) throws IOException {
        return this.lookup(key);
    }

    public String fetch(String key) throws IOException {
        byte[] buf = this.lookup(key.getBytes());
        if (buf != null) {
            return new String(buf);
        }
        return null;
    }

    public byte[] fetchBytes(String key) throws IOException {
        return this.lookup(key.getBytes());
    }

    public String fetchString(byte[] key) throws IOException {
        byte[] buf = this.lookup(key);
        if (buf != null) {
            return new String(buf);
        }
        return null;
    }

    public boolean delete(byte[] key) throws IOException {
        int hashval = jdbm.hash(key);
        jdbmBucket bucket = this.lookupBucket(hashval);
        jdbmBucketElement el = bucket.lookup(key, hashval);
        if (el != null) {
            bucket.delete(el);
            return true;
        }
        return false;
    }

    public void save() throws IOException {
        if (this.header_changed) {
            this.trace("saving header.");
            DataOutputStream out = new DataOutputStream(new FastByteArrayOutputStream(this.buffer));
            this.saveHeader(out);
            this.fd.seek(0L);
            this.fd.write(this.buffer);
            this.header_changed = false;
        }
        if (this.dir_changed) {
            this.trace("saving directory.");
            byte[] dir_buffer = new byte[this.dir_size * 4];
            DataOutputStream out = new DataOutputStream(new FastByteArrayOutputStream(dir_buffer));
            this.saveDirectory(out);
            this.fd.seek(this.dir_adr);
            this.fd.write(dir_buffer);
            this.dir_changed = false;
        }
        this.list.saveModified(this);
    }

    public jdbm(String filename) throws IOException {
        this(new File(filename));
    }

    public jdbm(File file) throws IOException {
        boolean exists = file.exists();
        this.file = file;
        this.fd = new RandomAccessFile(file, "rw");
        this.buffer = new byte[this.block_size];
        this.list = new LRUList();
        if (exists) {
            this.fd.seek(0L);
            if (this.fd.read(this.buffer) != this.buffer.length) {
                throw new IOException("unable to restore DB header.");
            }
            this.restoreHeader(new DataInputStream(new ByteArrayInputStream(this.buffer)));
            this.fd.seek(this.dir_adr);
            byte[] dir_buffer = new byte[this.dir_size * 4];
            this.fd.readFully(dir_buffer);
            if (this.fd.read(this.buffer) != this.buffer.length) {
                throw new IOException("unable to restore DB directory.");
            }
            this.restoreDirectory(new DataInputStream(new ByteArrayInputStream(dir_buffer)));
            int dir_size = 1 << this.dir_bits;
            this.loaded_buckets = 0;
        } else {
            this.block_size = 1024;
            this.dir_bits = 3;
            this.dir_adr = this.block_size;
            this.bucket_elems = (this.block_size - 60) / 24 + 1;
            this.dir_size = 1 << this.dir_bits;
            while (this.dir_size * 4 < this.block_size) {
                this.dir_size <<= 1;
                ++this.dir_bits;
            }
            if (this.dir_size * 4 != this.block_size) {
                throw new RuntimeException("block_size can't match dir_size");
            }
            this.cache_size = 32;
            this.loaded_buckets = 1;
            this.diridx = new int[this.dir_size];
            int bucket_adr = 2 * this.block_size;
            LRUEntry b = this.list.addEntry(new jdbmBucket(this, bucket_adr, 3));
            for (int i = 0; i < this.dir_size; ++i) {
                this.diridx[i] = bucket_adr;
            }
            this.avail_length = (this.block_size - 36) / 8;
            this.avail_size = new int[this.avail_length];
            this.avail_ptr = new int[this.avail_length];
            this.avail_count = 0;
            this.next_block = 4;
            DataOutputStream out = null;
            out = new DataOutputStream(new FastByteArrayOutputStream(this.buffer));
            this.saveHeader(out);
            this.fd.seek(0L);
            this.fd.write(this.buffer);
            out = new DataOutputStream(new FastByteArrayOutputStream(this.buffer));
            this.saveDirectory(out);
            this.fd.seek(this.dir_adr);
            this.fd.write(this.buffer);
            out = new DataOutputStream(new FastByteArrayOutputStream(this.buffer));
            b.bucket.save(out);
            this.fd.seek(2 * this.block_size);
            this.fd.write(this.buffer);
        }
    }

    protected boolean getNextBucket(jdbmEnumerator enum1) throws IOException {
        int fptr = -1;
        int last = -1;
        int didx = -1;
        if (enum1.didx < 0) {
            didx = 0;
            last = -1;
            fptr = this.diridx[0];
        } else if (enum1.didx + 1 < this.dir_size) {
            didx = enum1.didx;
            last = this.diridx[didx++];
            fptr = this.diridx[didx];
        } else {
            return false;
        }
        while (fptr == last && didx < this.dir_size) {
            fptr = this.diridx[didx + 1 == this.dir_size ? didx++ : ++didx];
        }
        if (didx < this.dir_size) {
            LRUEntry lru = this.list.lookupBucket(fptr);
            if (lru == null) {
                lru = this.loadBucket(fptr);
            }
            this.list.notifyUses(lru);
            enum1.bucket = lru.bucket;
            enum1.didx = didx;
            enum1.bidx = 0;
            return true;
        }
        return false;
    }

    public Enumeration keys() {
        return new jdbmEnumerator(this, true, -1);
    }

    public Enumeration elements() {
        return new jdbmEnumerator(this, false, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public jdbm reorganize(boolean trace) {
        Enumeration e = this.keys();
        int count = 0;
        File tmpfile = new File(this.file.getParent(), this.file.getName() + ".tmp");
        jdbm clean = null;
        jdbm ret = null;
        long time = -1L;
        try {
            this.save();
            clean = new jdbm(tmpfile);
            if (trace) {
                System.out.println("using temp file: " + tmpfile);
                time = System.currentTimeMillis();
            }
            while (e.hasMoreElements()) {
                byte[] key = (byte[])e.nextElement();
                byte[] val = this.lookup(key);
                if (val != null) {
                    clean.store(key, val, 1);
                } else if (trace) {
                    System.out.println("no value for [" + new String(key) + "]");
                }
                if (!trace || ++count % 100 != 0) continue;
                System.out.println(count + " elements reindexed.");
            }
            clean.save();
            if (trace) {
                System.out.println("reorganization done (" + (System.currentTimeMillis() - time) + "ms)");
            }
        }
        catch (Exception ex) {
            tmpfile.delete();
            tmpfile = null;
            ex.printStackTrace();
        }
        finally {
            if (tmpfile != null) {
                try {
                    clean.fd.close();
                    this.fd.close();
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
                this.file.delete();
                tmpfile.renameTo(this.file);
                try {
                    ret = new jdbm(this.file);
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            }
        }
        return ret;
    }
}

