/*
 * Decompiled with CFR 0.152.
 */
package com.day.crx.query.lucene;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Executor;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.core.id.ItemId;
import org.apache.jackrabbit.core.id.NodeId;
import org.apache.jackrabbit.core.query.lucene.NamespaceMappings;
import org.apache.jackrabbit.core.state.ChildNodeEntry;
import org.apache.jackrabbit.core.state.ItemStateException;
import org.apache.jackrabbit.core.state.ItemStateManager;
import org.apache.jackrabbit.core.state.NodeState;
import org.apache.jackrabbit.core.value.InternalValue;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.commons.name.NameConstants;
import org.apache.jackrabbit.spi.commons.name.NameFactoryImpl;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.apache.tika.Tika;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.Parser;
import org.apache.tika.sax.BodyContentHandler;
import org.apache.tika.sax.Link;
import org.apache.tika.sax.LinkContentHandler;
import org.apache.tika.sax.TeeContentHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.ContentHandler;

class NodeIndexer
extends org.apache.jackrabbit.core.query.lucene.NodeIndexer {
    private static final Logger log = LoggerFactory.getLogger(NodeIndexer.class);
    private static final Name NAME_FUNCTION = NameFactoryImpl.getInstance().create("", "name()");
    private static final Tika TIKA = new Tika();
    private static final int MAX_STRING_LENGTH = 0x100000;

    static void setDefaultMaxSize(String mimeType, int value) {
        String k = "crx.index.maxSize." + mimeType;
        if (System.getProperty(k) == null) {
            System.setProperty(k, "" + value);
        }
    }

    NodeIndexer(NodeState node, ItemStateManager stateProvider, NamespaceMappings mappings, Executor executor, Parser parser) {
        super(node, stateProvider, mappings, executor, parser);
    }

    public Document createDoc() throws RepositoryException {
        Document doc = super.createDoc();
        if (this.isIndexed(NAME_FUNCTION)) {
            try {
                NodeState parent;
                ChildNodeEntry nodeEntry;
                NodeId parentId = this.node.getParentId();
                if (parentId != null && (nodeEntry = (parent = (NodeState)this.stateProvider.getItemState((ItemId)parentId)).getChildNodeEntry(this.node.getNodeId())) != null) {
                    doc.add((Fieldable)this.createFulltextField(nodeEntry.getName().getLocalName(), false, false, false));
                }
            }
            catch (ItemStateException e) {
                throw new RepositoryException("Unable to index node name: " + (Object)((Object)e), (Throwable)e);
            }
        }
        return doc;
    }

    protected void addStringValue(Document doc, String fieldName, String stringValue, boolean tokenized, boolean includeInNodeIndex, float boost, boolean useInExcerpt) {
        if (stringValue.length() < 0x100000) {
            doc.add((Fieldable)this.createFieldWithoutNorms(fieldName, stringValue, 1));
            if (tokenized) {
                Extract extract = new Extract(stringValue);
                stringValue = extract.getText();
                int idx = fieldName.indexOf(58);
                fieldName = fieldName.substring(0, idx + 1) + "FULL:" + fieldName.substring(idx + 1);
                boolean hasNorms = boost != 1.0f;
                Field.Index indexType = hasNorms ? Field.Index.ANALYZED : Field.Index.ANALYZED_NO_NORMS;
                Field f = new Field(fieldName, stringValue, Field.Store.NO, indexType, Field.TermVector.NO);
                f.setBoost(boost);
                doc.add((Fieldable)f);
                if (includeInNodeIndex) {
                    boolean store = this.supportHighlighting && useInExcerpt;
                    f = this.createFulltextField(stringValue, store, this.supportHighlighting, hasNorms);
                    if (useInExcerpt) {
                        doc.add((Fieldable)f);
                    } else {
                        this.doNotUseInExcerpt.add(f);
                    }
                    for (String link : extract.getLinks()) {
                        f = this.createFulltextField(link, false, this.supportHighlighting, hasNorms);
                        this.doNotUseInExcerpt.add(f);
                    }
                }
            }
        }
    }

    protected void addBinaryValue(Document doc, String fieldName, InternalValue internalValue) {
        String mimeType = null;
        String encoding = null;
        long size = 0L;
        long maxSize = 0L;
        boolean doIndex = true;
        try {
            InternalValue v;
            String jcrData = this.mappings.getPrefix("http://www.jcp.org/jcr/1.0") + ":data";
            if (jcrData.equals(fieldName) && (v = this.getValue(NameConstants.JCR_MIMETYPE)) != null) {
                mimeType = v.getString();
                v = this.getValue(NameConstants.JCR_ENCODING);
                if (v != null) {
                    encoding = v.getString();
                }
                size = internalValue.getLength();
                String max = System.getProperty("crx.index.maxSize." + mimeType, null);
                if (max != null) {
                    try {
                        maxSize = Long.parseLong(max) * 1024L * 1024L;
                        doIndex = size <= maxSize;
                    }
                    catch (Exception e) {}
                }
            }
        }
        catch (Throwable t) {
            log.warn(this.getIndexMessage(mimeType, encoding, size, maxSize), t);
        }
        if (doIndex) {
            if (size > 0x100000L) {
                log.info(this.getIndexMessage(mimeType, encoding, size, maxSize));
            } else {
                log.debug(this.getIndexMessage(mimeType, encoding, size, maxSize));
            }
            super.addBinaryValue(doc, fieldName, internalValue);
        } else {
            log.warn(this.getIndexMessage(mimeType, encoding, size, maxSize) + " skipped (file too large)");
        }
    }

    private String getIndexMessage(String mimeType, String encoding, long size, long maxSize) {
        StringBuilder buff = new StringBuilder();
        buff.append("Index document");
        buff.append(" node ").append(this.getNodeId());
        buff.append(" mimeType:").append(mimeType);
        if (encoding != null) {
            buff.append(" encoding:").append(encoding);
        }
        buff.append(" size:");
        if (size > 0x100000L) {
            buff.append(size / 1024L / 1024L).append(" MB");
        } else if (size > 1024L) {
            buff.append(size / 1024L).append(" KB");
        } else {
            buff.append(size).append(" bytes");
        }
        if (maxSize > 0L) {
            buff.append(" maxSize:").append(maxSize / 1024L / 1024L).append(" MB");
        }
        return buff.toString();
    }

    static {
        NodeIndexer.setDefaultMaxSize("application/postscript", 1000);
        NodeIndexer.setDefaultMaxSize("application/octet-stream", 1000);
        NodeIndexer.setDefaultMaxSize("application/pdf", 1000);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class Extract {
        private String text;
        private List<String> links = new ArrayList<String>();

        Extract(String text) {
            this.text = text;
            if (text.indexOf(60) != -1) {
                try {
                    BodyContentHandler bodyHandler = new BodyContentHandler();
                    LinkContentHandler linkHandler = new LinkContentHandler();
                    Metadata metadata = new Metadata();
                    metadata.set("Content-Type", "text/html; charset=UTF-8");
                    TIKA.getParser().parse((InputStream)new ByteArrayInputStream(text.getBytes("UTF-8")), (ContentHandler)new TeeContentHandler(new ContentHandler[]{linkHandler, bodyHandler}), metadata, new ParseContext());
                    String body = bodyHandler.toString().trim();
                    List links = linkHandler.getLinks();
                    if (body.length() > 0 || !links.isEmpty()) {
                        this.text = body;
                        for (Link link : links) {
                            this.links.add(link.getUri());
                        }
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }

        String getText() {
            return this.text;
        }

        List<String> getLinks() {
            if (this.links != null) {
                return this.links;
            }
            return Collections.emptyList();
        }
    }
}

