/*
 * Decompiled with CFR 0.152.
 */
package com.day.crx.persistence.tar.utils;

import com.day.crx.persistence.tar.PersistenceManagerUtils;
import com.day.crx.persistence.tar.TarPersistenceStringIndex;
import com.day.crx.persistence.tar.file.TarFile;
import com.day.crx.persistence.tar.index.IndexEntry;
import com.day.crx.persistence.tar.index.IndexEntryVisitor;
import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.core.data.AbstractDataRecord;
import org.apache.jackrabbit.core.data.AbstractDataStore;
import org.apache.jackrabbit.core.data.DataIdentifier;
import org.apache.jackrabbit.core.data.DataRecord;
import org.apache.jackrabbit.core.data.DataStore;
import org.apache.jackrabbit.core.data.DataStoreException;
import org.apache.jackrabbit.core.id.NodeId;
import org.apache.jackrabbit.core.id.PropertyId;
import org.apache.jackrabbit.core.persistence.util.BLOBStore;
import org.apache.jackrabbit.core.persistence.util.BundleBinding;
import org.apache.jackrabbit.core.persistence.util.ErrorHandling;
import org.apache.jackrabbit.core.persistence.util.NodePropBundle;
import org.apache.jackrabbit.core.util.StringIndex;
import org.apache.jackrabbit.core.value.InternalValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataStoreGarbageCollector {
    static final Logger log = LoggerFactory.getLogger(DataStoreGarbageCollector.class);
    private final File repoDir;
    private final int threadCount;
    private final int delay;
    private boolean logSystemOut;
    private ArrayList<TarFile> tarFiles = new ArrayList();
    private PrintWriter writer;
    private long totalBytes;
    private long remainingBytes;
    private long startProgress;
    private long lastLogProgress;
    private volatile boolean stop;
    private HashMap<NodeId, Integer> largeNodes = new HashMap();
    final int prefetchKB;

    public DataStoreGarbageCollector(String repoDir, int threadCount, int delay, int prefetchKB) {
        this.repoDir = new File(repoDir);
        this.threadCount = threadCount;
        this.delay = delay;
        this.prefetchKB = prefetchKB;
    }

    public void setLogSystemOut(boolean log) {
        this.logSystemOut = log;
    }

    public void init() throws IOException {
        File version = new File(this.repoDir, "version");
        File workspaces = new File(this.repoDir, "workspaces");
        if (!this.repoDir.exists()) {
            throw new IllegalArgumentException("Did not find expected directory " + this.repoDir.getAbsolutePath());
        }
        if (!version.exists()) {
            throw new IllegalArgumentException("Did not find expected directory " + version.getAbsolutePath());
        }
        if (!workspaces.exists()) {
            throw new IllegalArgumentException("Did not find expected directory " + version.getAbsolutePath());
        }
        ArrayList<File> tarDirs = new ArrayList<File>();
        tarDirs.add(version);
        for (File f : workspaces.listFiles()) {
            tarDirs.add(f);
            tarDirs.add(new File(f, "copy"));
        }
        for (File dir : tarDirs) {
            if (dir.listFiles() == null) continue;
            for (File f : dir.listFiles()) {
                String name = f.getName().toLowerCase();
                if (!f.getName().endsWith(".tar") || !f.getName().startsWith("data_")) continue;
                int id = -1;
                String idName = name.substring("data_".length(), name.indexOf(".tar"));
                try {
                    id = Integer.parseInt(idName);
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
                if (id < 0) continue;
                TarFile tar = new TarFile(f.getAbsolutePath(), id, false, "r");
                this.tarFiles.add(tar);
                this.log("Found " + f.getAbsolutePath());
                this.remainingBytes += f.length();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scanRepository() throws IOException {
        this.log("Scan started");
        if (this.threadCount > 1) {
            this.log("Using " + this.threadCount + " threads");
        }
        if (this.delay > 0) {
            this.log("Using " + this.delay + " delay");
        }
        this.writer = new PrintWriter(new BufferedWriter(new FileWriter(new File(this.repoDir, "dataStoreTouch.sh"))));
        this.totalBytes = this.remainingBytes;
        try {
            this.lastLogProgress = this.startProgress = System.currentTimeMillis();
            ArrayList<Thread> threads = new ArrayList<Thread>();
            for (int i = 0; i < this.threadCount; ++i) {
                Thread t = new Thread((Runnable)new Scanner(), "GC scan thread " + i);
                t.setDaemon(true);
                t.start();
                threads.add(t);
            }
            for (Thread t : threads) {
                t.join();
            }
        }
        catch (InterruptedException e) {
            this.onException("Interrupted", e);
        }
        finally {
            this.writer.close();
        }
        this.lastLogProgress = 0L;
        this.logProgress(0L);
        this.log("Scan completed");
    }

    synchronized void onLargeNode(NodeId nodeId, long len) {
        Integer count = this.largeNodes.get(nodeId);
        int newCount = count == null ? 1 : count + 1;
        this.largeNodes.put(nodeId, newCount);
        if (newCount == 1 || newCount % 50 == 0) {
            this.log("Warning: large node detected; node identifier: " + nodeId + " length: " + len + " count: " + newCount);
        }
    }

    synchronized void onException(String message, Exception e) {
        if (this.logSystemOut) {
            System.out.println("Exception occurred: " + message);
            e.printStackTrace(System.out);
        } else {
            log.error("Exception occurred: " + message, (Throwable)e);
        }
        this.stop = true;
    }

    synchronized void log(String message) {
        if (this.logSystemOut) {
            System.out.println(message);
        } else {
            log.info(message);
        }
    }

    boolean isStopped() {
        return this.stop;
    }

    void sleep() {
        if (this.delay > 0) {
            try {
                Thread.sleep(0L, this.delay);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void visitBinary(String id) {
        String s = id.toString();
        s = s.substring(0, 2) + "/" + s.substring(2, 4) + "/" + s.substring(4, 6) + "/" + s;
        PrintWriter printWriter = this.writer;
        synchronized (printWriter) {
            this.writer.println("touch " + s);
        }
    }

    synchronized TarFile getNextFileToScan() {
        if (this.tarFiles.size() == 0) {
            return null;
        }
        return this.tarFiles.remove(0);
    }

    synchronized void logProgress(long scannedBytes) {
        this.remainingBytes -= scannedBytes;
        long time = System.currentTimeMillis();
        if (time - this.lastLogProgress < 5000L) {
            return;
        }
        this.lastLogProgress = time;
        long scanned = this.totalBytes - this.remainingBytes;
        long seconds = (time - this.startProgress) / 1000L;
        if (seconds == 0L) {
            seconds = 1L;
        }
        long eta = 0L;
        if (scanned > 0L && seconds > 10L) {
            eta = seconds * this.totalBytes / scanned - seconds;
        }
        this.log(seconds + " seconds, " + 100L * scanned / this.totalBytes + "% scanned " + "(" + scanned / 1024L / 1024L / seconds + " MB/s)" + (eta == 0L ? "" : ", ETA " + eta + " seconds"));
    }

    class Scanner
    implements Runnable {
        private final BundleBinding binding;
        private long lastPos;
        String lastFile = "";

        public void run() {
            try {
                TarFile tarFile;
                while (!DataStoreGarbageCollector.this.isStopped() && (tarFile = DataStoreGarbageCollector.this.getNextFileToScan()) != null) {
                    this.lastFile = tarFile.getFileName();
                    this.lastPos = 0L;
                    long length = tarFile.getFileLength();
                    this.scan(tarFile);
                    DataStoreGarbageCollector.this.logProgress(length - this.lastPos);
                }
            }
            catch (Exception e) {
                DataStoreGarbageCollector.this.onException("Scanning " + this.lastFile, e);
            }
        }

        Scanner() {
            ErrorHandling errorHandling = new ErrorHandling();
            BLOBStore blobStore = new BLOBStore(){

                public String createId(PropertyId arg0, int arg1) {
                    return null;
                }

                public InputStream get(String arg0) throws Exception {
                    return null;
                }

                public void put(String arg0, InputStream arg1, long arg2) {
                }

                public boolean remove(String arg0) throws Exception {
                    return false;
                }
            };
            StringIndex nsIndex = new StringIndex(){

                public String indexToString(int index) {
                    return Integer.toString(index);
                }

                public int stringToIndex(String string) {
                    return Integer.parseInt(string);
                }
            };
            AbstractDataStore ds = new AbstractDataStore(){

                public DataRecord addRecord(InputStream arg0) {
                    return null;
                }

                public void clearInUse() {
                }

                public void close() throws DataStoreException {
                }

                public int deleteAllOlderThan(long arg0) throws DataStoreException {
                    return 0;
                }

                public Iterator<DataIdentifier> getAllIdentifiers() throws DataStoreException {
                    return null;
                }

                public int getMinRecordLength() {
                    return 0;
                }

                public DataRecord getRecord(DataIdentifier id) throws DataStoreException {
                    return this.getRecordIfStored(id);
                }

                public DataRecord getRecordIfStored(DataIdentifier id) throws DataStoreException {
                    DataStoreGarbageCollector.this.visitBinary(id.toString());
                    return new AbstractDataRecord(this, id){

                        public long getLastModified() {
                            return 0L;
                        }

                        public long getLength() throws DataStoreException {
                            return 0L;
                        }

                        public InputStream getStream() throws DataStoreException {
                            return null;
                        }
                    };
                }

                public void init(String arg0) throws RepositoryException {
                }

                public void updateModifiedDateOnAccess(long arg0) {
                }
            };
            this.binding = new BundleBinding(errorHandling, blobStore, nsIndex, nsIndex, (DataStore)ds);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void scan(TarFile tarFile) throws IOException {
            try {
                tarFile.scanIndex(0L, new IndexEntryVisitor(){
                    long nextPrefetchPos;
                    byte[] prefetchBuff;
                    {
                        this.prefetchBuff = new byte[DataStoreGarbageCollector.this.prefetchKB * 1024];
                    }

                    public void visitEntry(TarFile file, IndexEntry entry) throws IOException {
                        long pos = entry.getPos();
                        if (DataStoreGarbageCollector.this.prefetchKB > 0 && pos >= this.nextPrefetchPos) {
                            int l;
                            int len = DataStoreGarbageCollector.this.prefetchKB * 1024;
                            this.nextPrefetchPos += (long)len;
                            InputStream in = file.getInputStream(pos, len);
                            int off = 0;
                            for (len = (int)Math.min((long)len, file.getFileLength() - pos - 1024L); len > 0 && (l = in.read(this.prefetchBuff, off, len)) >= 0; len -= l) {
                            }
                        }
                        Scanner.this.scan(file, entry);
                    }

                    public void visitEndOfFile(TarFile file) throws IOException {
                    }

                    public void visitTransaction(TarFile file, String transactionName) {
                    }

                    public boolean getFailOnError() {
                        return false;
                    }

                    public boolean isStopped() {
                        return DataStoreGarbageCollector.this.isStopped();
                    }
                }, true);
            }
            finally {
                tarFile.close();
            }
        }

        public void scan(TarFile file, IndexEntry entry) throws IOException {
            DataStoreGarbageCollector.this.sleep();
            long scanned = entry.getPos() - this.lastPos;
            if (scanned > 16384L) {
                DataStoreGarbageCollector.this.logProgress(scanned);
                this.lastPos = entry.getPos();
            }
            if (entry.getType() != 0) {
                return;
            }
            if (entry.getLength() == 0L) {
                return;
            }
            if (entry.getLength() > 262144L) {
                DataStoreGarbageCollector.this.onLargeNode(entry.getUUID(), entry.getLength());
            }
            BufferedInputStream in = new BufferedInputStream(file.getInputStream(entry.getPos(), entry.getLength()), 16384);
            NodeId id = new NodeId(0L, 0L);
            try {
                NodePropBundle b = PersistenceManagerUtils.deserializeBundle(this.binding, id, in);
                for (NodePropBundle.PropertyEntry e : b.getPropertyEntries()) {
                    for (InternalValue v : e.getValues()) {
                        if (v.getType() != 2) continue;
                        v.getLength();
                    }
                }
            }
            catch (Exception e) {
                if (TarPersistenceStringIndex.MAGIC_NAME_INDEX_ID.equals((Object)entry.getUUID()) || TarPersistenceStringIndex.MAGIC_NS_INDEX_ID.equals((Object)entry.getUUID())) {
                    log.info("ignoring error in special entry: " + entry);
                }
                DataStoreGarbageCollector.this.onException("Error deserializing " + entry.toString() + " " + this.lastFile, e);
                throw new IOException(e);
            }
        }
    }
}

