/*
 * Decompiled with CFR 0.152.
 */
package com.day.crx.persistence.tar.index;

import com.day.crx.persistence.tar.OptimizeThread;
import com.day.crx.persistence.tar.TarSet;
import com.day.crx.persistence.tar.TarSetConfig;
import com.day.crx.persistence.tar.TarUtils;
import com.day.crx.persistence.tar.index.Cache;
import com.day.crx.persistence.tar.index.EndMark;
import com.day.crx.persistence.tar.index.InMemoryIndex;
import com.day.crx.persistence.tar.index.Index;
import com.day.crx.persistence.tar.index.IndexEntry;
import com.day.crx.persistence.tar.index.IndexFile;
import com.day.crx.persistence.tar.index.IndexMerger;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import org.apache.jackrabbit.core.id.NodeId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IndexSet
implements Index {
    public static final String INDEX_DIR_SETTING = "com.day.crx.persistence.tar.IndexDir";
    public static final int DEFAULT_MERGE_WHEN_CLOSING = 500;
    public static final int REOPEN_CHECK_EVERY = 5000;
    protected static Logger log = LoggerFactory.getLogger(IndexSet.class);
    private static final long MAX_MERGING_AGE = 21600000L;
    private static final int LOG_DELAY = 10000;
    protected final String directory;
    private InMemoryIndex uncommitted;
    private InMemoryIndex committed;
    private InMemoryIndex readOnly;
    private Cache cache;
    private ArrayList<IndexFile> indexFiles;
    private int memoryBufferSize;
    private final int cacheSize;
    private int maxFileEntrySize;
    private int mergeBlockSize = 64;
    private final EndMark pos = new EndMark();
    private final TarSet tarset;
    private int mergeWhenClosing = 500;
    private IndexMerger merger;
    private boolean deleteFiles = true;
    private long lastReopenCheck;
    private boolean isOpen;

    public IndexSet(TarSet tarset, String directory) throws IOException {
        this(tarset, tarset.getConfig(), directory);
    }

    public IndexSet(TarSet tarset, TarSetConfig config, String directory) throws IOException {
        this.tarset = tarset;
        this.directory = directory + System.getProperty(INDEX_DIR_SETTING, "");
        this.cacheSize = config.getIndexCacheSize();
        this.memoryBufferSize = config.getIndexMemoryBufferSize();
        this.maxFileEntrySize = config.getIndexMaxFileEntrySize();
    }

    public void setDeleteFiles(boolean delete) {
        this.deleteFiles = delete;
    }

    boolean getDeleteFiles() {
        return this.deleteFiles;
    }

    public synchronized void setMergeBlockSize(int size) {
        this.mergeBlockSize = size;
    }

    public boolean isInMemory() {
        return this.tarset != null && this.tarset.getConfig().isIndexInMemory();
    }

    public synchronized void open() throws IOException {
        File[] list;
        this.uncommitted = new InMemoryIndex();
        this.committed = new InMemoryIndex();
        this.readOnly = new InMemoryIndex();
        this.cache = new Cache(this.cacheSize);
        this.indexFiles = new ArrayList();
        File dir = new File(this.directory);
        dir.mkdirs();
        for (File file : list = dir.listFiles()) {
            int minor;
            int major;
            String id;
            int idx;
            long age;
            String name = file.getName();
            if (name.endsWith(".merging") && (age = System.currentTimeMillis() - file.lastModified()) > 21600000L) {
                file.delete();
                continue;
            }
            if (!name.startsWith("index_")) continue;
            if (name.endsWith(".new") && this.deleteFiles) {
                TarUtils.deleteFileWithRetry(file);
            }
            if (!name.endsWith(".tar") || (idx = (id = name.substring("index_".length(), name.length() - ".tar".length())).indexOf(95)) < 0) continue;
            try {
                major = Integer.parseInt(id.substring(0, idx));
                minor = Integer.parseInt(id.substring(idx + 1, id.length()));
            }
            catch (NumberFormatException e) {
                continue;
            }
            IndexFile f = IndexFile.openIndexFile(this, major, minor);
            try {
                f.openForReading(this.isInMemory());
                this.pos.add(f.getToFile(), f.getToPos());
                this.indexFiles.add(f);
            }
            catch (IOException e) {
                if (!(e instanceof FileNotFoundException)) {
                    log.warn("Error opening index file " + name + ": " + e.toString());
                }
                if (this.deleteFiles) {
                    try {
                        f.delete();
                    }
                    catch (IOException e2) {
                        log.debug("Can not delete file " + f.toString(), (Throwable)e);
                    }
                    continue;
                }
                f.close();
            }
        }
        Collections.sort(this.indexFiles);
        ArrayList<IndexFile> old = new ArrayList<IndexFile>();
        IndexFile last = null;
        for (int i = 0; i < this.indexFiles.size(); ++i) {
            IndexFile f = this.indexFiles.get(i);
            if (last == null) {
                last = f;
                continue;
            }
            if (last.getMajor() == f.getMajor() && last.getMinor() < f.getMinor()) {
                old.add(last);
                last = f;
                continue;
            }
            if (last.getToFile() > f.getToFile() || last.getToFile() == f.getToFile() && last.getToPos() > f.getToPos()) {
                old.add(f);
                continue;
            }
            last = f;
        }
        for (IndexFile o : old) {
            this.removeIndex(o, this.deleteFiles);
        }
        this.isOpen = true;
    }

    protected void checkSorted() throws IOException {
        int invalid = 0;
        if (this.indexFiles.size() > 1) {
            for (int i = 1; i < this.indexFiles.size(); ++i) {
                IndexFile f1 = this.indexFiles.get(i - 1);
                IndexFile f2 = this.indexFiles.get(i);
                if (f1.getMajor() > f2.getMajor()) {
                    ++invalid;
                } else if (f1.getMajor() == f2.getMajor() && f1.getMinor() > f2.getMinor()) {
                    ++invalid;
                }
                if (f1.getToFile() > f2.getToFile()) {
                    ++invalid;
                    continue;
                }
                if (f1.getToFile() != f2.getToFile() || f1.getToPos() <= f2.getToPos()) continue;
                ++invalid;
            }
        }
        if (invalid > 0) {
            String msg = "Invalid order detected, " + invalid + " case(s) in " + this.indexFiles;
            log.error(msg, (Throwable)new Exception());
            throw new IOException(msg);
        }
    }

    @Override
    public synchronized void addOrUpdateEntry(boolean autoCommit, IndexEntry entry) throws IOException {
        this.addOrUpdateEntry(autoCommit, true, entry);
    }

    private void addOrUpdateEntry(boolean autoCommit, boolean canMerge, IndexEntry entry) throws IOException {
        this.pos.add(entry);
        this.cache.remove(entry);
        if (!autoCommit) {
            this.uncommitted.addOrUpdateEntry(true, entry);
        } else {
            this.committed.addOrUpdateEntry(true, entry);
            if (canMerge && this.committed.size() > this.memoryBufferSize) {
                if (this.uncommitted.size() > 0) {
                    log.warn("Merging with uncommitted changes: " + this.uncommitted.size());
                }
                this.mergeIndex();
            }
        }
        this.mergeBlockIfRequired();
    }

    private void reopenIfRequired() throws IOException {
        if (this.uncommitted.size() > 0) {
            return;
        }
        if (System.currentTimeMillis() < this.lastReopenCheck + 5000L) {
            return;
        }
        File reopenFlag = new File(this.directory, "indexMerged.tar");
        if (reopenFlag.exists() && reopenFlag.delete()) {
            this.reopen();
        }
        this.lastReopenCheck = System.currentTimeMillis();
    }

    public void reopen() throws IOException {
        this.close(true);
        this.tarset.deleteOldFiles(this.directory);
        this.open();
    }

    @Override
    public void close() {
        try {
            this.close(true);
        }
        catch (IOException e) {
            log.warn("Could not merge index when closing", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void close(boolean alwaysMerge) throws IOException {
        try {
            this.mergeIndexComplete();
            if (this.committed.size() > 0 && (alwaysMerge || this.committed.size() > this.mergeWhenClosing)) {
                this.mergeIndex();
                this.mergeIndexComplete();
            }
        }
        finally {
            this.isOpen = false;
            this.uncommitted.close();
            this.committed.close();
            for (IndexFile index : this.indexFiles) {
                index.close();
            }
            this.indexFiles.clear();
            this.pos.reset();
        }
    }

    @Override
    public synchronized void commit() throws IOException {
        Iterator<IndexEntry> it = this.uncommitted.getAllEntries(null);
        while (it.hasNext()) {
            IndexEntry entry = it.next();
            this.addOrUpdateEntry(true, false, entry);
        }
        this.uncommitted.clear();
        if (this.committed.size() > this.memoryBufferSize) {
            this.mergeIndex();
        }
        this.reopenIfRequired();
    }

    @Override
    public synchronized Iterator<IndexEntry> getAllEntries(NodeId after) throws IOException {
        this.reopenIfRequired();
        ArrayList<Iterator<IndexEntry>> list = new ArrayList<Iterator<IndexEntry>>();
        list.add(this.uncommitted.getAllEntries(after));
        list.add(this.committed.getAllEntries(after));
        list.add(this.readOnly.getAllEntries(after));
        for (int i = this.indexFiles.size() - 1; i >= 0; --i) {
            IndexFile index = this.indexFiles.get(i);
            list.add(index.getAllEntries(after));
        }
        Iterator[] array = new Iterator[list.size()];
        list.toArray(array);
        MergingIterator it = new MergingIterator(array);
        FilterDeletedIterator it2 = new FilterDeletedIterator(it);
        return it2;
    }

    private IndexEntry getEntryFromFile(NodeId uuid, int type) throws IOException {
        for (int i = this.indexFiles.size() - 1; i >= 0; --i) {
            IndexFile index = this.indexFiles.get(i);
            IndexEntry found = index.getEntry(uuid, type, false);
            if (found == null) continue;
            return found;
        }
        return null;
    }

    @Override
    public synchronized IndexEntry getEntry(NodeId uuid, int type, boolean returnNext) throws IOException {
        IndexEntry found = this.getEntryIncludingDeleted(uuid, type, returnNext);
        if (found == null || found.getLength() == 0L) {
            return null;
        }
        return found;
    }

    public synchronized IndexEntry getEntryIncludingDeleted(NodeId uuid, int type, boolean returnNext) throws IOException {
        this.reopenIfRequired();
        IndexEntry search = new IndexEntry(uuid, type);
        IndexEntry found = this.uncommitted.get(search);
        if (found == null && (found = this.committed.get(search)) == null && (found = this.readOnly.get(search)) == null && (found = (IndexEntry)this.cache.get(search)) == null && (found = this.getEntryFromFile(uuid, type)) != null) {
            this.cache.put(search, found);
        }
        return found;
    }

    @Override
    public synchronized void rollback() {
        this.uncommitted.clear();
    }

    public String getDirectory() {
        return this.directory;
    }

    private IndexMerger createIndexMerger(boolean deleteFiles, boolean openNew) throws IOException {
        int size = this.indexFiles.size();
        if (!deleteFiles) {
            --size;
        }
        if (size <= 1) {
            return null;
        }
        ArrayList<Index> mergeFrom = new ArrayList<Index>();
        int major = Integer.MAX_VALUE;
        for (int i = size - 1; i >= 0; --i) {
            IndexFile f = this.indexFiles.get(i);
            if (f.getMajor() < major) {
                major = f.getMajor();
            }
            if (openNew) {
                f = IndexFile.openIndexFile(this, f.getMajor(), f.getMinor());
                if (!deleteFiles) {
                    f.setDeleteFiles(false);
                }
                f.openForReading(false);
            }
            mergeFrom.add(f);
        }
        int minor = 0;
        for (IndexFile f : this.indexFiles) {
            if (f.getMajor() != major || f.getMinor() < minor) continue;
            minor = f.getMinor() + 1;
        }
        IndexFile mergeTo = IndexFile.openIndexFile(this, major, minor);
        boolean writeDeleted = false;
        return new IndexMerger(this, mergeFrom, mergeTo, writeDeleted);
    }

    public synchronized void mergeTopIndexFiles() throws IOException {
        if (OptimizeThread.INDEX_MERGE_DELAY > 0) {
            this.mergeTopIndexFilesStart();
            return;
        }
        this.mergeTopIndexFilesSynchronous();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void mergeTopIndexFilesSynchronous() throws IOException {
        Map<String, IndexMerger> map;
        log.info("Merging index files for " + this.directory + " (synchronous)");
        Map<String, IndexMerger> map2 = map = OptimizeThread.getInstance().getIndexMergerMap();
        synchronized (map2) {
            if (map.containsKey(this.directory)) {
                return;
            }
        }
        this.reopenIfRequired();
        IndexMerger merger = this.createIndexMerger(this.deleteFiles, false);
        if (merger == null) {
            return;
        }
        long last = System.currentTimeMillis();
        merger.start();
        while (merger.mergeBlock(this.mergeBlockSize)) {
            long now = System.currentTimeMillis();
            if (now <= last + 10000L) continue;
            log.info("Merging index: " + merger.toString());
            last = now;
        }
        log.info("Merging index files completed");
        merger.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void mergeTopIndexFilesStart() throws IOException {
        IndexMerger m;
        Map<String, IndexMerger> map;
        log.info("Merging index files for " + this.directory + " (in separate thread)");
        Map<String, IndexMerger> map2 = map = OptimizeThread.getInstance().getIndexMergerMap();
        synchronized (map2) {
            if (map.containsKey(this.directory)) {
                log.info("Merging index files aborted: A previous index merge task is already running");
                return;
            }
            m = this.createIndexMerger(false, true);
            if (m == null) {
                log.info("Merging index files aborted: Nothing to merge");
                return;
            }
            map.put(this.directory, m);
        }
        final IndexMerger concurrentMerger = m;
        concurrentMerger.getMergeTo().setSuffix(".merging");
        concurrentMerger.start();
        final int blockSize = this.mergeBlockSize;
        final int delay = OptimizeThread.INDEX_MERGE_DELAY;
        Thread thread = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    IndexSet indexSet;
                    long lastSleep;
                    long lastLog = lastSleep = System.currentTimeMillis();
                    while (true) {
                        long sleep;
                        indexSet = IndexSet.this;
                        synchronized (indexSet) {
                            if (!concurrentMerger.mergeBlock(blockSize)) {
                                break;
                            }
                        }
                        long now = System.currentTimeMillis();
                        if (delay > 1) {
                            Thread.sleep(delay);
                        } else if (delay == 1 && (sleep = now - lastSleep) > 0L) {
                            Thread.sleep(sleep);
                            lastSleep = System.currentTimeMillis();
                        }
                        if (now <= lastLog + 10000L) continue;
                        log.info("Merging index: " + concurrentMerger.toString());
                        lastLog = now;
                    }
                    log.info("Merging index files completed");
                    indexSet = IndexSet.this;
                    synchronized (indexSet) {
                        concurrentMerger.close();
                        File reopenFlag = new File(IndexSet.this.directory, "indexMerged.tar");
                        reopenFlag.createNewFile();
                    }
                }
                catch (IOException e) {
                    log.error("Merging index files failed", (Throwable)e);
                }
                catch (InterruptedException e) {
                    log.warn("Merging index files was interrupted", (Throwable)e);
                }
                finally {
                    concurrentMerger.close();
                    Map e = map;
                    synchronized (e) {
                        map.remove(IndexSet.this.directory);
                    }
                }
            }
        };
        thread.setName("Tar PM Index Merge");
        thread.setDaemon(true);
        thread.start();
    }

    @Override
    public synchronized void mergeIndex() throws IOException {
        log.debug("mergeIndex");
        if (this.merger == null) {
            IndexFile mergeTo;
            this.committed.setReadOnly(true);
            this.readOnly = this.committed;
            this.committed = new InMemoryIndex();
            int last = this.indexFiles.size() - 1;
            int major = 0;
            int minor = 0;
            ArrayList<Index> mergeFrom = new ArrayList<Index>();
            mergeFrom.add(this.readOnly);
            IndexFile lastFile = null;
            if (last >= 0) {
                lastFile = this.indexFiles.get(last);
                major = lastFile.getMajor();
                minor = lastFile.getMinor();
            }
            if (lastFile == null || lastFile.size() > this.maxFileEntrySize) {
                mergeTo = IndexFile.openIndexFile(this, major + 1, 0);
            } else {
                mergeFrom.add(lastFile);
                mergeTo = IndexFile.openIndexFile(this, major, minor + 1);
            }
            boolean writeDeleted = mergeTo.getMajor() > 1;
            this.merger = new IndexMerger(this, mergeFrom, mergeTo, writeDeleted);
            this.merger.start();
            if (this.tarset != null) {
                this.tarset.indexMergeStarted();
            }
        }
        this.mergeBlockIfRequired();
    }

    private void mergeBlockIfRequired() throws IOException {
        if (this.merger != null && !this.merger.mergeBlock(this.mergeBlockSize)) {
            this.merger = null;
        }
    }

    private void mergeIndexComplete() throws IOException {
        if (this.merger != null) {
            this.merger.mergeIndexComplete();
            this.merger = null;
        }
    }

    @Override
    public int getToFile() {
        return this.pos.getToFile();
    }

    @Override
    public long getToPos() {
        return this.pos.getToPos();
    }

    public synchronized void addIndex(IndexFile index) {
        if (this.isOpen) {
            this.indexFiles.add(index);
            Collections.sort(this.indexFiles);
        } else {
            index.close();
        }
    }

    public synchronized void removeIndex(Index old, boolean delete) throws IOException {
        if (!(old instanceof IndexFile)) {
            return;
        }
        IndexFile oldFile = (IndexFile)old;
        for (int i = 0; i < this.indexFiles.size(); ++i) {
            IndexFile f = this.indexFiles.get(i);
            if (f.getMajor() != oldFile.getMajor() || f.getMinor() != oldFile.getMinor()) continue;
            this.indexFiles.remove(i);
            if (delete) {
                f.delete();
                break;
            }
            f.close();
            break;
        }
        if (delete) {
            old.delete();
        } else {
            old.close();
        }
    }

    public ArrayList<IndexFile> getIndexFiles() {
        return this.indexFiles;
    }

    @Override
    public synchronized int size() {
        int size = this.uncommitted.size();
        size += this.committed.size();
        size += this.readOnly.size();
        for (IndexFile file : this.indexFiles) {
            size += file.size();
        }
        return size;
    }

    @Override
    public void delete() throws IOException {
        if (this.deleteFiles) {
            for (IndexFile file : this.indexFiles) {
                file.delete();
            }
        }
    }

    public synchronized void kill() {
        for (IndexFile file : this.indexFiles) {
            file.close();
        }
        if (this.merger != null) {
            this.merger.close();
        }
    }

    public void setMergeWhenClosing(int mergeWhenClosing) {
        log.debug("setMergeIndexWhenClosing: " + mergeWhenClosing);
        this.mergeWhenClosing = mergeWhenClosing;
    }

    public synchronized void readFiles() throws IOException {
        if (this.indexFiles != null) {
            for (IndexFile f : this.indexFiles) {
                f.readFully();
            }
        }
    }

    public synchronized void truncate(int fileId, long pos) throws IOException {
        boolean deleted;
        do {
            deleted = false;
            if (this.indexFiles != null) {
                for (IndexFile f : new ArrayList<IndexFile>(this.indexFiles)) {
                    boolean remove = false;
                    if (f.getToFile() > fileId) {
                        remove = true;
                    } else if (f.getToFile() == fileId && f.getToPos() >= pos) {
                        remove = true;
                    }
                    if (remove) {
                        deleted = true;
                        log.info("Truncating to transaction: deleting " + f.toString());
                        String fileName = f.getFileName(false);
                        this.removeIndex(f, false);
                        TarUtils.deleteFileWithRetry(new File(fileName));
                        continue;
                    }
                    log.info("Truncating to transaction: keeping " + f.toString());
                }
            }
            this.cache.clear();
            this.committed.clear();
            this.reopen();
        } while (deleted);
    }

    public void setMaxFileEntrySize(int x) {
        this.maxFileEntrySize = x;
    }

    public void setMemoryBufferSize(int x) {
        this.memoryBufferSize = x;
    }

    public static void deleteAll(String directory) throws IOException {
        File[] list;
        log.info("Deleting all index files in " + directory);
        OptimizeThread.getInstance().waitForPendingOperations();
        File dir = new File(directory);
        dir.mkdirs();
        for (File file : list = dir.listFiles()) {
            String name = file.getName();
            if (!name.startsWith("index_") || !name.endsWith(".tar")) continue;
            log.info("Deleting index file " + file.getAbsolutePath());
            TarUtils.deleteFileWithRetry(file);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class MergingIterator
    implements Iterator<IndexEntry> {
        private final IndexEntry[] current;
        private final Iterator<IndexEntry>[] list;
        private IndexEntry next;
        private int pos;

        MergingIterator(Iterator<IndexEntry>[] list) {
            this.list = list;
            this.current = new IndexEntry[list.length];
            for (int i = 0; i < this.current.length; ++i) {
                this.loadNext(i);
            }
            this.next = this.getNextOrNull();
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public IndexEntry next() {
            IndexEntry o = this.next;
            this.next = this.getNextOrNull();
            return o;
        }

        private void loadNext(int index) {
            Iterator<IndexEntry> it = this.list[index];
            this.current[index] = it.hasNext() ? it.next() : null;
        }

        private IndexEntry getNextOrNull() {
            IndexEntry lowest = null;
            int lowestIndex = 0;
            for (int i = 0; i < this.current.length; ++i) {
                IndexEntry x = this.current[i];
                if (x == null) continue;
                if (lowest != null) {
                    int comp = x.compareTo(lowest);
                    if (comp > 0) continue;
                    if (comp == 0) {
                        this.loadNext(i);
                        continue;
                    }
                }
                lowest = x;
                lowestIndex = i;
            }
            if (lowest == null) {
                return null;
            }
            this.loadNext(lowestIndex);
            ++this.pos;
            return lowest;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class FilterDeletedIterator
    implements Iterator<IndexEntry> {
        private final Iterator<IndexEntry> it;
        private IndexEntry current;

        FilterDeletedIterator(Iterator<IndexEntry> it) {
            this.it = it;
            this.loadNext();
        }

        private void loadNext() {
            do {
                if (!this.it.hasNext()) {
                    this.current = null;
                    break;
                }
                this.current = this.it.next();
            } while (this.current.getLength() <= 0L);
        }

        @Override
        public boolean hasNext() {
            return this.current != null;
        }

        @Override
        public IndexEntry next() {
            IndexEntry result = this.current;
            this.loadNext();
            return result;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

