/*
 * Decompiled with CFR 0.152.
 */
package com.day.crx.persistence.tar.index;

import com.day.crx.persistence.tar.file.FileEntry;
import com.day.crx.persistence.tar.file.FileEntryVisitor;
import com.day.crx.persistence.tar.file.TarFile;
import com.day.crx.persistence.tar.index.IndexEntry;
import com.day.crx.persistence.tar.index.IndexEntryVisitor;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedList;
import java.util.zip.Adler32;
import org.apache.jackrabbit.core.id.NodeId;

public class IndexScanner
implements FileEntryVisitor {
    private static final int BUFFER_SIZE = 4096;
    private final Adler32 adler = new Adler32();
    private final byte[] buffer = new byte[4096];
    private final LinkedList<IndexEntry> uncommittedTransaction = new LinkedList();
    private final IndexEntryVisitor indexVisitor;
    private String lastUncommitted;

    public IndexScanner(IndexEntryVisitor indexVisitor) {
        this.indexVisitor = indexVisitor;
    }

    public boolean isTransactionPending() {
        return this.uncommittedTransaction.size() > 0;
    }

    public void visitEntry(TarFile tar, FileEntry entry) throws IOException {
        int type;
        boolean adlerChecksum;
        String fileName = entry.getEntryName();
        if (fileName.equals("eof")) {
            this.indexVisitor.visitEndOfFile(tar);
            return;
        }
        if (fileName.endsWith("a")) {
            adlerChecksum = true;
            fileName = fileName.substring(0, fileName.length() - "a".length());
        } else {
            adlerChecksum = false;
        }
        if (fileName.endsWith(".n")) {
            type = 0;
        } else if (fileName.endsWith(".r")) {
            type = 1;
        } else if (fileName.endsWith(".sh")) {
            type = 2;
        } else {
            return;
        }
        int dot = fileName.indexOf(46);
        if (dot < 0) {
            return;
        }
        fileName = fileName.substring(0, dot);
        String transactionName = "";
        int slash = fileName.indexOf(47);
        if (slash > 0) {
            transactionName = fileName.substring(0, slash);
            fileName = fileName.substring(slash + 1);
        }
        if (fileName.startsWith("commit-")) {
            transactionName = fileName.substring("commit-".length(), dot);
            if (transactionName.equals(this.lastUncommitted) || this.lastUncommitted == null) {
                for (IndexEntry uncommittedEntry : this.uncommittedTransaction) {
                    this.indexVisitor.visitEntry(tar, uncommittedEntry);
                }
            } else {
                throw new IOException("Expected commit for " + this.lastUncommitted + " but got " + transactionName + " (" + fileName + ")  in file: " + tar.getFileName());
            }
            this.uncommittedTransaction.clear();
            this.lastUncommitted = null;
        } else if (fileName.startsWith("rollback-")) {
            transactionName = fileName.substring("rollback-".length(), dot);
            if (!transactionName.equals(this.lastUncommitted) && this.lastUncommitted != null) {
                throw new IOException("Expected rollback for " + this.lastUncommitted + " but got " + transactionName + " (" + fileName + ")  in file: " + tar.getFileName());
            }
            this.uncommittedTransaction.clear();
            this.lastUncommitted = null;
        } else {
            NodeId id = this.parseId(fileName);
            if (id == null) {
                throw new IOException("UUID parse error: " + fileName + " in file: " + tar.getFileName());
            }
            IndexEntry indexEntry = new IndexEntry(id, type);
            indexEntry.setFileId(tar.getId());
            indexEntry.setPos(entry.getPos());
            long len = entry.getLength();
            if (adlerChecksum) {
                int l;
                this.adler.reset();
                InputStream in = entry.getInputStream();
                for (long remaining = len -= 8L; remaining > 0L; remaining -= (long)l) {
                    l = (int)Math.min(remaining, 4096L);
                    l = in.read(this.buffer, 0, l);
                    this.adler.update(this.buffer, 0, l);
                }
                long real = this.adler.getValue();
                DataInputStream din = new DataInputStream(in);
                long check = din.readLong();
                in.close();
                if (check != real) {
                    throw new IOException("Checksum mismatch expected " + check + " got  " + real + " at " + entry.toString());
                }
            }
            indexEntry.setLength(len);
            if (transactionName.length() == 0) {
                this.indexVisitor.visitEntry(tar, indexEntry);
            } else {
                if (!transactionName.equals(this.lastUncommitted)) {
                    this.uncommittedTransaction.clear();
                    this.indexVisitor.visitTransaction(tar, transactionName);
                    this.lastUncommitted = transactionName;
                }
                this.uncommittedTransaction.add(indexEntry);
            }
        }
    }

    private NodeId parseId(String uuid) {
        try {
            return new NodeId(uuid);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }
}

