/*
 * Decompiled with CFR 0.152.
 */
package com.day.crx.persistence.tar.index;

import com.day.crx.persistence.tar.index.EndMark;
import com.day.crx.persistence.tar.index.Index;
import com.day.crx.persistence.tar.index.IndexEntry;
import com.day.crx.persistence.tar.index.IndexFile;
import com.day.crx.persistence.tar.index.IndexSet;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IndexMerger {
    private final IndexSet indexSet;
    private final ArrayList<Index> mergeFrom;
    private final boolean writeDeleted;
    private IndexFile mergeTo;
    private IndexSet.MergingIterator mergeIterator;
    private int mergeSize;
    private IndexEntry lastEntry;
    private boolean mergeCompleted;

    public IndexMerger(IndexSet indexSet, ArrayList<Index> mergeFrom, IndexFile mergeTo, boolean writeDeleted) throws IOException {
        this.indexSet = indexSet;
        this.mergeFrom = mergeFrom;
        this.mergeTo = mergeTo;
        this.writeDeleted = writeDeleted;
    }

    public void start() throws IOException {
        Iterator[] list = new Iterator[this.mergeFrom.size()];
        EndMark pos = new EndMark();
        for (int i = 0; i < this.mergeFrom.size(); ++i) {
            Index index = this.mergeFrom.get(i);
            pos.add(index.getToFile(), index.getToPos());
            this.mergeSize += index.size();
            list[i] = index.getAllEntries(null);
        }
        this.mergeIterator = new IndexSet.MergingIterator(list);
        this.mergeTo.openForWriting(this.mergeSize, pos.getToFile(), pos.getToPos());
    }

    private void mergeEnd() throws IOException {
        if (this.mergeCompleted) {
            return;
        }
        this.mergeCompleted = true;
        this.mergeTo.endWriting();
        IndexFile f = IndexFile.openIndexFile(this.indexSet, this.mergeTo.getMajor(), this.mergeTo.getMinor());
        f.openForReading(this.indexSet.isInMemory());
        this.indexSet.addIndex(f);
        for (int i = this.mergeFrom.size() - 1; i >= 0; --i) {
            Index from = this.mergeFrom.get(i);
            this.indexSet.removeIndex(from, true);
        }
        this.indexSet.checkSorted();
        this.lastEntry = null;
    }

    public String toString() {
        if (this.lastEntry != null) {
            return this.lastEntry.getUUID().toString();
        }
        StringBuilder buff = new StringBuilder();
        if (this.mergeTo != null && this.mergeFrom != null) {
            for (Index idx : this.mergeFrom) {
                if (buff.length() > 0) {
                    buff.append(" + ");
                }
                if (idx instanceof IndexFile) {
                    IndexFile f = (IndexFile)idx;
                    buff.append(f.getMajor() + "." + f.getMinor());
                    continue;
                }
                buff.append(idx.size());
            }
            buff.append(" => ").append(this.mergeTo.getMajor() + "." + this.mergeTo.getMinor());
        }
        return buff.toString();
    }

    boolean mergeBlock(int entries) throws IOException {
        for (int i = 0; i < entries; ++i) {
            IndexEntry entry;
            if (!this.mergeIterator.hasNext()) {
                this.mergeEnd();
                this.mergeTo = null;
                return false;
            }
            this.lastEntry = entry = this.mergeIterator.next();
            if (entry.getLength() == 0L && !this.writeDeleted) continue;
            this.mergeTo.append(entry);
        }
        return true;
    }

    public void mergeIndexComplete() throws IOException {
        while (this.mergeTo != null) {
            this.mergeBlock(64);
        }
    }

    void close() {
        for (Index from : this.mergeFrom) {
            from.close();
        }
        if (this.mergeTo != null) {
            this.mergeTo.close();
        }
    }

    IndexFile getMergeTo() {
        return this.mergeTo;
    }
}

