/*
 * Decompiled with CFR 0.152.
 */
package com.day.crx.persistence.tar.index;

import com.day.crx.persistence.tar.TarUtils;
import com.day.crx.persistence.tar.file.FileEntry;
import com.day.crx.persistence.tar.file.TarFile;
import com.day.crx.persistence.tar.index.IndexEntry;
import com.day.crx.persistence.tar.index.IndexFile;
import com.day.crx.persistence.tar.index.IndexSet;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Properties;
import org.apache.jackrabbit.core.id.NodeId;

public class IndexFileTree
extends IndexFile {
    static final String HEAD_CSV = "head.txt";
    static final int FAN_OUT = 64;
    private IndexEntry[] head;

    IndexFileTree(IndexSet set, int major, int minor) throws IOException {
        super(set, major, minor);
    }

    void endWriting() throws IOException {
        if (this.writePos > 0) {
            this.writeBuffer();
        }
        if (this.outIndex > this.maxEntries) {
            throw new AssertionError((Object)("expected max:" + this.maxEntries + " got:" + this.outIndex));
        }
        long newEntries = this.outIndex;
        long length = (long)this.outIndex * 64L;
        long time = System.currentTimeMillis();
        this.data.setLength(length, time);
        Properties prop = new Properties();
        prop.setProperty("version", "2.0");
        prop.setProperty("entries", Long.toString(newEntries));
        prop.setProperty("toFile", Integer.toString(this.toFile));
        prop.setProperty("toPos", Long.toString(this.toPos));
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        prop.store(out, "");
        long checksum = this.getChecksum(prop);
        prop.setProperty("checksum", "" + checksum);
        out = new ByteArrayOutputStream();
        prop.store(out, "");
        this.tar.appendEntry("index.properties", out.toByteArray(), System.currentTimeMillis());
        out = new ByteArrayOutputStream();
        int i = 0;
        while ((long)i < newEntries) {
            IndexEntry e = this.getEntry(i);
            e.write(this.writeBuffer, 0);
            out.write(this.writeBuffer, 0, 64);
            i += 64;
        }
        this.tar.appendEntry(HEAD_CSV, out.toByteArray(), System.currentTimeMillis());
        String newName = this.getFileName(false);
        this.tar.renameTo(newName);
        this.tar.close();
        this.tar = null;
    }

    void openForReading(boolean inMemory) throws IOException {
        this.tar = new TarFile(this.getFileName(false), this.major * 1000000 + this.minor, false, "r");
        this.tar.readEntries();
        FileEntry index = this.tar.getEntry("index.properties");
        if (index == null) {
            throw new IOException("Corrupted or incomplete file: " + this.tar.getFileName());
        }
        Properties prop = new Properties();
        InputStream in = index.getInputStream();
        prop.load(in);
        in.close();
        String checksumExpected = prop.getProperty("checksum", "0");
        String checksumGot = "" + this.getChecksum(prop);
        if (!checksumExpected.equals(checksumGot)) {
            throw new IOException("Checksum mismatch, got: " + checksumGot + " expected: " + checksumExpected);
        }
        String version = prop.getProperty("version", "0");
        if (!"2.0".equals(version)) {
            throw new IOException("Unsupported index version: " + version + " in file " + this.tar.getFileName());
        }
        this.entries = Long.parseLong(prop.getProperty("entries"));
        this.toFile = Integer.parseInt(prop.getProperty("toFile", "0"));
        this.toPos = Integer.parseInt(prop.getProperty("toPos", "0"));
        this.data = this.tar.getEntry("data.txt");
        this.checkIndexDataConsistency();
        FileEntry headCsv = this.tar.getEntry(HEAD_CSV);
        if (headCsv == null) {
            throw new IOException("Corrupted or incomplete file: " + this.tar.getFileName());
        }
        this.head = new IndexEntry[(int)(this.entries / 64L)];
        in = headCsv.getInputStream();
        for (int i = 0; i < this.head.length; ++i) {
            TarFile.readFully(in, this.readBuffer, 64);
            this.head[i] = IndexEntry.read(this.readBuffer, 0);
        }
        in.close();
    }

    private IndexEntry getEntry(int pos) throws IOException {
        byte[] buff = this.readBuffer;
        this.readFully((long)pos * 64L, buff, 64);
        return IndexEntry.read(buff, 0);
    }

    public IndexEntry getEntry(NodeId id, int type, boolean returnNext) throws IOException {
        IndexEntry read;
        block9: {
            TarUtils.check(!this.writing, "Trying to find an entry while the index is written");
            if (this.entries == 0L) {
                return null;
            }
            IndexEntry search = new IndexEntry(id, type);
            int pos = Arrays.binarySearch(this.head, search);
            if (pos >= 0) {
                if (!returnNext) {
                    return this.head[pos];
                }
            } else {
                pos = -pos + 1;
            }
            int guessId = (int)this.minMax(0L, pos * 64 + 32, this.entries - 1L);
            int pageSize = (int)Math.min(this.entries * 64L, (long)this.readBuffer.length);
            byte[] buff = this.readBuffer;
            ++this.readCount;
            boolean canGoDown = true;
            boolean canGoUp = true;
            long currentPage = -1L;
            while (true) {
                long page = (long)guessId * 64L / (long)pageSize;
                page = this.minMax(0L, page, this.entries * 64L / (long)pageSize);
                int currentOffset = (int)(64L * (long)guessId - page * (long)pageSize);
                if (currentPage != page) {
                    ++this.readFileCount;
                    long max = this.entries * 64L - page * (long)pageSize;
                    this.readFully(page * (long)pageSize, buff, (int)Math.min((long)pageSize, max));
                    currentPage = page;
                }
                ++this.readTransformCount;
                read = IndexEntry.read(buff, currentOffset);
                read.setIndexPos(page * (long)pageSize + (long)currentOffset);
                int compare = read.compareTo(search);
                if (compare > 0) {
                    canGoUp = false;
                    if (canGoDown && --guessId >= 0) continue;
                    if (!returnNext) {
                        return null;
                    }
                    break block9;
                }
                if (compare == 0) break block9;
                canGoDown = false;
                if (!canGoUp || (long)(++guessId) >= this.entries) break;
            }
            if (!returnNext) {
                return null;
            }
        }
        return read;
    }
}

