/*
 * Decompiled with CFR 0.152.
 */
package com.day.crx.persistence.tar.index;

import com.day.crx.persistence.tar.TarUtils;
import com.day.crx.persistence.tar.file.FileEntry;
import com.day.crx.persistence.tar.file.TarFile;
import com.day.crx.persistence.tar.index.Index;
import com.day.crx.persistence.tar.index.IndexEntry;
import com.day.crx.persistence.tar.index.IndexFileTree;
import com.day.crx.persistence.tar.index.IndexSet;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.SequenceInputStream;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Properties;
import java.util.zip.Adler32;
import org.apache.jackrabbit.core.id.NodeId;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IndexFile
implements Index,
Comparable<IndexFile> {
    public static final String INDEX_FILE_VERSION = "com.day.crx.persistence.tar.IndexFileVersion";
    public static final String INDEX_PROPERTIES_NAME = "index.properties";
    static final String DATA_CSV_NAME = "data.txt";
    private static final int READ_SIZE = 2048;
    private static final int DEFAULT_GROUP_BITS = 8;
    private static final long MAX_ENTRIES = 2000000000L;
    private static final int WRITE_BUFFER_SIZE = 64;
    private static final int MEMORY_BLOCK_SIZE = 0x100000;
    protected TarFile tar;
    protected boolean writing;
    protected final int major;
    protected final int minor;
    protected long entries;
    protected FileEntry data;
    protected ArrayList<byte[]> dataInMemory;
    protected int toFile;
    protected long toPos;
    protected final byte[] readBuffer = new byte[2048];
    protected int readCount;
    protected int readFileCount;
    protected int readTransformCount;
    protected int maxEntries;
    protected int outIndex;
    protected final byte[] writeBuffer = new byte[4096];
    protected int writePos;
    private final IndexSet indexSet;
    private int groupBits = 8;
    private long[] statOffset;
    private long[] statCount;
    private long[] statResult;
    private long sumOffset;
    private String suffix;
    private boolean deleteFiles = true;

    public IndexFile(IndexSet set, int major, int minor) throws IOException {
        this.indexSet = set;
        this.major = major;
        this.minor = minor;
    }

    static IndexFile openIndexFile(IndexSet set, int major, int minor) throws IOException {
        if (Integer.parseInt(System.getProperty(INDEX_FILE_VERSION, "1")) == 1) {
            return new IndexFile(set, major, minor);
        }
        return new IndexFileTree(set, major, minor);
    }

    protected String getFileName(boolean writing) {
        String fileName = this.indexSet.getDirectory() + "/" + "index_" + this.major + "_" + this.minor;
        if (writing) {
            if (this.suffix != null) {
                return fileName + this.suffix;
            }
            return fileName + ".new";
        }
        return fileName + ".tar";
    }

    void openForReading(boolean inMemory) throws IOException {
        this.tar = new TarFile(this.getFileName(false), this.major * 1000000 + this.minor, false, "r");
        this.tar.readEntries();
        FileEntry head = this.tar.getEntry(INDEX_PROPERTIES_NAME);
        if (head == null) {
            throw new IOException("Corrupted or incomplete file: " + this.tar.getFileName());
        }
        Properties prop = new Properties();
        InputStream in = head.getInputStream();
        prop.load(in);
        in.close();
        String checksumExpected = prop.getProperty("checksum", "0");
        String checksumGot = "" + this.getChecksum(prop);
        if (!checksumExpected.equals(checksumGot)) {
            throw new IOException("Checksum mismatch, got: " + checksumGot + " expected: " + checksumExpected);
        }
        String version = prop.getProperty("version", "0");
        if (!"1.0".equals(version)) {
            throw new IOException("Unsupported index version: " + version + " in file " + this.tar.getFileName());
        }
        this.entries = Long.parseLong(prop.getProperty("entries"));
        this.toFile = Integer.parseInt(prop.getProperty("toFile", "0"));
        this.toPos = Integer.parseInt(prop.getProperty("toPos", "0"));
        this.data = this.tar.getEntry(DATA_CSV_NAME);
        this.dataInMemory = inMemory ? this.readData() : null;
        this.groupBits = Integer.parseInt(prop.getProperty("groupBits", "0"));
        int offsetCount = 1 << this.groupBits;
        this.statOffset = new long[offsetCount];
        String offsets = prop.getProperty("offsets", "");
        String[] off = offsets.split(",", offsetCount);
        for (int i = 0; i < this.statOffset.length; ++i) {
            this.statOffset[i] = Long.parseLong(off[i]);
        }
        this.checkIndexDataConsistency();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ArrayList<byte[]> readData() throws IOException {
        long length = this.data.getLength();
        int blocks = (int)(length / 0x100000L) + 1;
        ArrayList<byte[]> list = new ArrayList<byte[]>(blocks);
        InputStream stream = this.data.getInputStream();
        try {
            int len;
            for (long remaining = length; remaining > 0L; remaining -= (long)len) {
                len = (int)Math.min(remaining, 0x100000L);
                byte[] buff = new byte[len];
                TarFile.readFully(stream, buff, len);
                list.add(buff);
            }
        }
        finally {
            stream.close();
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void readFully(long pos, byte[] buffer, int len) throws IOException {
        if (this.dataInMemory != null) {
            int blockStart = (int)(pos / 0x100000L);
            long offset = pos % 0x100000L;
            SequenceInputStream stream = new SequenceInputStream(new SkipCapableEnumeration(pos, blockStart, offset));
            try {
                TarFile.readFully(stream, buffer, len);
            }
            catch (RuntimeException re) {
                throw new IOException(re.getMessage());
            }
            finally {
                ((InputStream)stream).close();
            }
        }
        InputStream stream = this.data.getInputStream();
        try {
            IndexFile.skipFully(stream, pos);
            TarFile.readFully(stream, buffer, len);
        }
        finally {
            stream.close();
        }
    }

    private static void skipFully(InputStream in, long pos) throws IOException {
        while (pos > 0L) {
            long skipped = in.skip(pos);
            if (skipped < 0L) {
                throw new IOException("Error skipping " + pos + " bytes in " + in);
            }
            pos -= skipped;
        }
    }

    protected void checkIndexDataConsistency() throws IOException {
        Iterator<IndexEntry> it = this.getAllEntries(null);
        NodeId last = null;
        int checkAtMost = 128;
        for (int i = 0; it.hasNext() && i < checkAtMost; ++i) {
            IndexEntry entry = it.next();
            NodeId uuid = entry.getUUID();
            if (last != null && uuid.compareTo(last) < 0) {
                String msg = "The index file " + this.tar.getFileName() + " is inconsistent (probably created with an old, " + "incompatible UUID implementation is in the class path). " + "The file will be deleted and recreated.";
                throw new IOException(msg);
            }
            last = uuid;
        }
    }

    public void openForWriting(int maxEntries, int toFile, long toPos) throws IOException {
        int offsetCount;
        this.writing = true;
        this.tar = new TarFile(this.getFileName(true), this.major * 1000000 + this.minor, false, "rw");
        this.tar.readEntries();
        this.maxEntries = maxEntries;
        this.toFile = toFile;
        this.toPos = toPos;
        long length = (long)maxEntries * 64L;
        long now = System.currentTimeMillis();
        this.data = this.tar.appendEntry(DATA_CSV_NAME, length, now);
        this.dataInMemory = null;
        this.groupBits = 8;
        while ((long)(offsetCount = 1 << this.groupBits) * 1000L <= (long)maxEntries) {
            ++this.groupBits;
        }
        this.statOffset = new long[offsetCount];
        this.statCount = new long[offsetCount];
        this.statResult = new long[offsetCount];
        this.outIndex = 0;
    }

    void append(IndexEntry entry) throws IOException {
        int group;
        long high = entry.getUUID().getMostSignificantBits();
        int n = group = (int)this.getStatGroup(this.groupBits, high);
        this.statOffset[n] = this.statOffset[n] + this.calculateIndex(2000000000L, high);
        int n2 = group;
        this.statResult[n2] = this.statResult[n2] + (long)this.outIndex;
        int n3 = group;
        this.statCount[n3] = this.statCount[n3] + 1L;
        ++this.outIndex;
        entry.write(this.writeBuffer, this.writePos);
        this.writePos = (int)((long)this.writePos + 64L);
        if (this.writePos >= this.writeBuffer.length) {
            this.writeBuffer();
        }
    }

    protected void writeBuffer() throws IOException {
        this.tar.write(this.writeBuffer, 0, this.writePos);
        this.writePos = 0;
    }

    void endWriting() throws IOException {
        if (this.writePos > 0) {
            this.writeBuffer();
        }
        if (this.outIndex > this.maxEntries) {
            throw new AssertionError((Object)("expected max:" + this.maxEntries + " got:" + this.outIndex));
        }
        long newEntries = this.outIndex;
        long length = (long)this.outIndex * 64L;
        long time = System.currentTimeMillis();
        this.data.setLength(length, time);
        for (int i = 0; i < this.statOffset.length; ++i) {
            long count = this.statCount[i];
            if (count == 0L) {
                count = 1L;
            }
            BigInteger bi = new BigInteger(String.valueOf(this.statOffset[i]));
            bi = bi.multiply(new BigInteger(String.valueOf(newEntries)));
            bi = bi.divide(new BigInteger(String.valueOf(2000000000L)));
            long offset = bi.longValue();
            this.statOffset[i] = (offset - this.statResult[i]) / count;
        }
        Properties prop = new Properties();
        prop.setProperty("version", "1.0");
        prop.setProperty("entries", Long.toString(newEntries));
        prop.setProperty("toFile", Integer.toString(this.toFile));
        prop.setProperty("toPos", Long.toString(this.toPos));
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        prop.store(out, "");
        prop.setProperty("groupBits", Integer.toString(this.groupBits));
        StringBuffer buff = new StringBuffer();
        for (int i = 0; i < this.statOffset.length; ++i) {
            if (i > 0) {
                buff.append(",");
            }
            buff.append(Long.toString(this.statOffset[i]));
        }
        prop.setProperty("offsets", buff.toString());
        long checksum = this.getChecksum(prop);
        prop.setProperty("checksum", "" + checksum);
        out = new ByteArrayOutputStream();
        prop.store(out, "");
        this.tar.appendEntry(INDEX_PROPERTIES_NAME, out.toByteArray(), System.currentTimeMillis());
        String newName = this.getFileName(false);
        this.tar.renameTo(newName);
        this.tar.close();
        this.tar = null;
    }

    protected long getChecksum(Properties prop) throws IOException {
        Adler32 adler = new Adler32();
        Object[] list = prop.keySet().toArray();
        Arrays.sort(list);
        for (int i = 0; i < list.length; ++i) {
            String key = (String)list[i];
            if (key.equals("checksum")) continue;
            adler.update(key.getBytes("UTF8"));
            String value = prop.getProperty(key);
            adler.update(value.getBytes("UTF8"));
        }
        return adler.getValue();
    }

    @Override
    public void addOrUpdateEntry(boolean autoCommit, IndexEntry entry) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void close() {
        if (this.tar != null) {
            this.tar.close();
            this.tar = null;
        }
    }

    @Override
    public void commit() throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterator<IndexEntry> getAllEntries(NodeId after) throws IOException {
        TarUtils.check(!this.writing, "Can not get the list entries if the file is open for writing");
        return new EntryIterator(after);
    }

    private long calculateIndex(long entries, long mostSignificantBits) {
        long group = this.getStatGroup(31, mostSignificantBits);
        return group * entries / Integer.MAX_VALUE;
    }

    private long getStatGroup(int groupBits, long mostSignificantBits) {
        long x = mostSignificantBits >> (int)(64L - (long)groupBits);
        return x + (1L << (int)((long)groupBits - 1L));
    }

    protected long minMax(long min, long x, long max) {
        x = Math.max(min, x);
        x = Math.min(x, max);
        return x;
    }

    @Override
    public IndexEntry getEntry(NodeId id, int type, boolean returnNext) throws IOException {
        IndexEntry read;
        block7: {
            long guessId;
            TarUtils.check(!this.writing, "Trying to find an entry while the index is written");
            if (this.entries == 0L) {
                return null;
            }
            IndexEntry search = new IndexEntry(id, type);
            long high = id.getMostSignificantBits();
            long firstGuess = guessId = this.calculateIndex(this.entries, high);
            int group = (int)this.getStatGroup(this.groupBits, high);
            long offset = this.statOffset[group];
            guessId = this.minMax(0L, guessId - offset, this.entries - 1L);
            int pageSize = (int)Math.min(this.entries * 64L, (long)this.readBuffer.length);
            ++this.readCount;
            boolean canGoDown = true;
            boolean canGoUp = true;
            long currentPage = -1L;
            byte[] buff = this.readBuffer;
            while (true) {
                long page = guessId * 64L / (long)pageSize;
                page = this.minMax(0L, page, this.entries * 64L / (long)pageSize);
                int currentOffset = (int)(64L * guessId - page * (long)pageSize);
                if (currentPage != page) {
                    ++this.readFileCount;
                    long max = this.entries * 64L - page * (long)pageSize;
                    this.readFully(page * (long)pageSize, buff, (int)Math.min((long)pageSize, max));
                    currentPage = page;
                }
                ++this.readTransformCount;
                read = IndexEntry.read(buff, currentOffset);
                read.setIndexPos(page * (long)pageSize + (long)currentOffset);
                int compare = read.compareTo(search);
                if (compare > 0) {
                    canGoUp = false;
                    if (canGoDown && --guessId >= 0L) continue;
                    if (!returnNext) {
                        return null;
                    }
                    break block7;
                }
                if (compare == 0) {
                    this.sumOffset += Math.abs(firstGuess - guessId);
                    break block7;
                }
                canGoDown = false;
                if (!canGoUp || ++guessId >= this.entries) break;
            }
            if (!returnNext) {
                return null;
            }
        }
        return read;
    }

    @Override
    public int getToFile() {
        TarUtils.check(!this.writing, "Trying to get the last file while writing the index");
        return this.toFile;
    }

    @Override
    public long getToPos() {
        TarUtils.check(!this.writing, "Trying to get the last position while writing the index");
        return this.toPos;
    }

    @Override
    public void mergeIndex() throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void rollback() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void delete() throws IOException {
        if (this.tar != null) {
            if (this.indexSet.getDeleteFiles() && this.deleteFiles) {
                this.tar.deleteLater(false);
            } else {
                this.tar.deleteLater(true);
            }
            this.close();
        }
    }

    @Override
    public int compareTo(IndexFile other) {
        if (this.major != other.major) {
            return this.major > other.major ? 1 : -1;
        }
        if (this.minor != other.minor) {
            return this.minor > other.minor ? 1 : -1;
        }
        return 0;
    }

    int getMajor() {
        return this.major;
    }

    int getMinor() {
        return this.minor;
    }

    @Override
    public int size() {
        return (int)this.entries;
    }

    public String toString() {
        StringBuilder buff = new StringBuilder();
        buff.append(this.major).append('.').append(this.minor).append(' ').append(this.toFile).append('/').append(this.toPos);
        if (this.tar != null) {
            buff.append(' ').append(this.tar.toString());
        }
        return buff.toString();
    }

    void setSuffix(String suffix) {
        this.suffix = suffix;
    }

    public void setDeleteFiles(boolean delete) {
        this.deleteFiles = delete;
    }

    boolean getDeleteFiles() {
        return this.deleteFiles;
    }

    public String getFileName() {
        return this.tar.getFileName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readFully() throws IOException {
        if (this.tar != null) {
            byte[] buffer = new byte[4096];
            String fileName = this.tar.getFileName();
            FileInputStream in = new FileInputStream(fileName);
            try {
                while (in.read(buffer) >= 0) {
                }
            }
            finally {
                in.close();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class SkipCapableEnumeration
    implements Enumeration<ByteArrayInputStream> {
        private final long position;
        private int block;
        private long offset;

        public SkipCapableEnumeration(long position, int block, long offset) {
            this.position = position;
            this.block = block;
            this.offset = offset;
        }

        @Override
        public boolean hasMoreElements() {
            return this.block < IndexFile.this.dataInMemory.size();
        }

        @Override
        public ByteArrayInputStream nextElement() {
            byte[] buff = IndexFile.this.dataInMemory.get(this.block++);
            ByteArrayInputStream in = new ByteArrayInputStream(buff);
            while (this.offset > 0L) {
                long skipped = in.skip(this.offset);
                if (skipped < 0L) {
                    throw new RuntimeException("Error skipping " + this.position + " bytes in " + in);
                }
                if (skipped == 0L) break;
                this.offset -= skipped;
            }
            return in;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class EntryIterator
    implements Iterator<IndexEntry> {
        private long pos;
        private IndexEntry last;

        EntryIterator(NodeId after) throws IOException {
            if (after != null) {
                IndexEntry next = IndexFile.this.getEntry(after, 0, true);
                this.pos = next.getIndexPos() / 64L;
            }
        }

        @Override
        public boolean hasNext() {
            return this.pos < IndexFile.this.entries;
        }

        @Override
        public IndexEntry next() {
            IndexEntry next;
            while ((next = this.nextIndexEntry()) != null && this.last != null && this.last.equals(next)) {
            }
            this.last = next;
            return next;
        }

        private IndexEntry nextIndexEntry() {
            IndexEntry next = null;
            try {
                byte[] buff = IndexFile.this.readBuffer;
                IndexFile.this.readFully(this.pos * 64L, buff, 64);
                IndexEntry read = IndexEntry.read(buff, 0);
                ++this.pos;
                return read;
            }
            catch (Exception e) {
                next = null;
                return next;
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

