/*
 * Decompiled with CFR 0.152.
 */
package com.day.crx.persistence.tar.index;

import java.io.IOException;
import org.apache.jackrabbit.core.id.NodeId;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IndexEntry
implements Comparable<IndexEntry> {
    public static final int TYPE_NODE_BUNDLE = 0;
    public static final int TYPE_NODE_REFERENCES = 1;
    public static final int TYPE_COMMAND = 2;
    static final long RECORD_LENGTH = 64L;
    private static final byte[] HEX = "0123456789abcdef".getBytes();
    private NodeId id;
    private int type;
    private int fileId;
    private long indexPos;
    private long pos;
    private long length;

    public IndexEntry(NodeId id, int type) {
        this.id = id;
        this.type = type;
    }

    static IndexEntry read(byte[] data, int pos) throws IOException {
        try {
            int type;
            NodeId id = new NodeId(IndexEntry.readLong(data, pos), IndexEntry.readLong(data, pos + 16));
            char typeChar = (char)data[pos + 33];
            if (typeChar == 'n') {
                type = 0;
            } else if (typeChar == 'r') {
                type = 1;
            } else {
                throw new IOException("Unsupported type: " + typeChar);
            }
            IndexEntry entry = new IndexEntry(id, type);
            if (data[pos + 39] == 44) {
                entry.fileId = IndexEntry.readShort(data, pos + 35);
                entry.pos = IndexEntry.readInt(data, pos + 40);
                entry.length = IndexEntry.readInt(data, pos + 49);
            } else {
                entry.fileId = IndexEntry.readInt(data, pos + 35);
                entry.pos = IndexEntry.readInt(data, pos + 44);
                entry.length = IndexEntry.readInt(data, pos + 53);
            }
            return entry;
        }
        catch (NumberFormatException e) {
            IOException e2 = new IOException("Index data error: " + new String(data, pos + 0, 64));
            e2.initCause(e);
            throw e2;
        }
    }

    private static short readShort(byte[] data, int pos) {
        short x = 0;
        for (int i = 4; i > 0; --i) {
            byte c;
            x = (short)(x << 4);
            x = (short)(x | ((c = data[pos++]) >= 97 ? c - 97 + 10 : c - 48));
        }
        return x;
    }

    private static int readInt(byte[] data, int pos) {
        int x = 0;
        for (int i = 8; i > 0; --i) {
            byte c;
            x <<= 4;
            x |= (c = data[pos++]) >= 97 ? c - 97 + 10 : c - 48;
        }
        return x;
    }

    private static long readLong(byte[] data, int pos) {
        long x = 0L;
        for (int i = 16; i > 0; --i) {
            byte c;
            x <<= 4;
            x |= (c = data[pos++]) >= 97 ? (long)(c - 97 + 10) : (long)(c - 48);
        }
        return x;
    }

    public String toString() {
        return this.id + " pos:" + this.fileId + "/" + this.pos + " length: " + this.length;
    }

    void write(byte[] data, int off) {
        this.writeLong(data, off, this.id.getMostSignificantBits());
        this.writeLong(data, off + 16, this.id.getLeastSignificantBits());
        data[off + 32] = 44;
        if (this.type == 0) {
            data[off + 33] = 110;
        } else if (this.type == 1) {
            data[off + 33] = 114;
        } else {
            throw new AssertionError((Object)("type:" + this.type));
        }
        data[off + 34] = 44;
        this.writeInt(data, off + 35, this.fileId);
        data[off + 43] = 44;
        this.writeInt(data, off + 44, (int)this.pos);
        data[off + 52] = 44;
        this.writeInt(data, off + 53, (int)this.length);
        data[off + 61] = 32;
        data[off + 62] = 32;
        data[off + 63] = 10;
    }

    public void setPos(long pos) {
        this.pos = pos;
    }

    private void writeInt(byte[] data, int pos, int x) {
        byte[] hex = HEX;
        int i = 7;
        while (i >= 0) {
            data[pos + i] = hex[x & 0xF];
            --i;
            x >>>= 4;
        }
    }

    private void writeLong(byte[] data, int pos, long x) {
        byte[] hex = HEX;
        int i = 15;
        while (i >= 0) {
            data[pos + i] = hex[(int)(x & 0xFL)];
            --i;
            x >>>= 4;
        }
    }

    @Override
    public int compareTo(IndexEntry e) {
        int c = this.id.compareTo(e.id);
        return c == 0 ? this.type - e.type : c;
    }

    public NodeId getUUID() {
        return this.id;
    }

    public boolean equals(Object other) {
        if (!(other instanceof IndexEntry)) {
            return false;
        }
        IndexEntry e = (IndexEntry)other;
        return this.id.equals((Object)e.id) && this.type == e.type;
    }

    public int hashCode() {
        return this.id.hashCode() ^ this.type;
    }

    public int getType() {
        return this.type;
    }

    public long getPos() {
        return this.pos;
    }

    public int getFileId() {
        return this.fileId;
    }

    public long getLength() {
        return this.length;
    }

    public void setLength(long length) {
        this.length = length;
    }

    public void setFileId(int fileId) {
        this.fileId = fileId;
    }

    long getIndexPos() {
        return this.indexPos;
    }

    void setIndexPos(long indexPos) {
        this.indexPos = indexPos;
    }

    public static String convertBytesToString(byte[] value, int len) {
        char[] buff = new char[len + len];
        byte[] hex = HEX;
        for (int i = 0; i < len; ++i) {
            int c = value[i] & 0xFF;
            buff[i + i] = (char)hex[c >> 4];
            buff[i + i + 1] = (char)hex[c & 0xF];
        }
        return new String(buff);
    }

    public static byte[] convertStringToBytes(String s) {
        int len = s.length();
        if (len % 2 != 0) {
            throw new IllegalArgumentException(s);
        }
        byte[] buff = new byte[len /= 2];
        for (int i = 0; i < len; ++i) {
            buff[i] = (byte)Integer.parseInt(s.substring(i + i, i + i + 2), 16);
        }
        return buff;
    }
}

