/*
 * Decompiled with CFR 0.152.
 */
package com.day.crx.persistence.tar.file;

import com.day.crx.core.backup.LowDiskSpaceMonitor;
import com.day.crx.persistence.tar.OptimizeThread;
import com.day.crx.persistence.tar.TarUtils;
import com.day.crx.persistence.tar.file.FileEntry;
import com.day.crx.persistence.tar.file.TarInputStream;
import com.day.crx.persistence.tar.index.IndexEntryVisitor;
import com.day.crx.persistence.tar.index.IndexScanner;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.CRC32;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TarFile {
    private static Map<String, Throwable> unclosed;
    private static final int BLOCK_SIZE = 512;
    private static final int GZIP_HEADER_LENGTH = 10;
    private static final int GZIP_FOOTER_LENGTH = 8;
    private static final int POS_LENGTH = 124;
    private static final boolean CACHE_POSITION;
    private static final boolean EXTEND_WITH_WRITE;
    private static final byte[] LENGTH_TEMPLATE;
    private static final byte[] EMPTY_BUFFER;
    private static Logger log;
    private final int id;
    private final boolean compressed;
    private final Deflater deflater;
    private final Inflater inflater;
    private final CRC32 crc = new CRC32();
    private final byte[] buffer = new byte[512];
    private String fileName;
    private RandomAccessFile file;
    private HashMap<String, FileEntry> entries = new HashMap();
    private long appendPos = -1L;
    private long fileLengthCached;
    private String mode;
    private boolean sync;
    private boolean readOnly;
    private long lastOptimizeLog;
    private int scannedEntriesCount;
    private long optimizePos;
    private boolean needToOptimize;
    private long currentPos;

    public TarFile(String fileName, int id, boolean compressed, String mode) throws IOException {
        try {
            this.fileName = fileName;
            this.id = id;
            this.compressed = compressed;
            this.mode = mode;
            if (compressed) {
                this.deflater = new Deflater(1, true);
                this.inflater = new Inflater(true);
            } else {
                this.deflater = null;
                this.inflater = null;
            }
            this.open();
            this.fileLengthCached = this.file.length();
            if (this.fileLengthCached == 0L) {
                this.appendPos = 0L;
            }
        }
        catch (IOException e) {
            TarFile.handleDiskFull(e);
            this.close();
            throw e;
        }
    }

    public String toString() {
        return this.fileName + " id:" + this.id + " length:" + this.fileLengthCached + " append:" + this.appendPos + " " + System.identityHashCode(this);
    }

    public static Map<String, Throwable> collectUncloseFiles(boolean enabled) {
        Map<String, Throwable> old = unclosed;
        unclosed = enabled ? Collections.synchronizedMap(new HashMap()) : null;
        return old;
    }

    private void open() throws IOException {
        int shrink;
        File f = new File(this.fileName);
        if (f.exists() && !f.canWrite()) {
            this.mode = "r";
        }
        if ("r".equals(this.mode)) {
            this.readOnly = true;
        }
        if (this.mode.endsWith("+")) {
            this.mode = this.mode.substring(0, this.mode.length() - 1);
            this.sync = true;
        }
        this.file = TarFile.openFile(this.fileName, this.mode);
        if (unclosed != null) {
            String key = this.fileName + " " + System.identityHashCode(this);
            unclosed.put(key, new Exception(key + " " + this.mode));
        }
        this.currentPos = 0L;
        this.fileLengthCached = this.file.length();
        if (!this.compressed && (shrink = (int)(this.fileLengthCached % 512L)) > 0) {
            log.error("Truncating tar file " + this.fileName + " from " + this.fileLengthCached + " to " + (this.fileLengthCached - (long)shrink));
            this.setLength(this.fileLengthCached - (long)shrink);
        }
    }

    private static RandomAccessFile openFile(String fileName, String mode) throws IOException {
        IOException last = null;
        for (int i = 0; i < 16; ++i) {
            try {
                RandomAccessFile file = new RandomAccessFile(fileName, mode);
                return file;
            }
            catch (IOException e) {
                TarFile.handleDiskFull(e);
                if (!new File(fileName).exists() && mode.equals("r")) {
                    throw e;
                }
                last = e;
                log.debug("Can not open " + fileName + " (" + mode + ")", (Throwable)e);
                try {
                    Thread.sleep(i * i);
                }
                catch (InterruptedException e2) {
                    // empty catch block
                }
                continue;
            }
        }
        throw last;
    }

    synchronized long readFullyCompressed(byte[] buffer, long pos, int length) throws IOException {
        if (length == 0) {
            return pos;
        }
        this.seek(pos + 10L);
        this.inflater.reset();
        int p = 0;
        int blocksize = 128;
        byte[] readbuffer = new byte[blocksize];
        while (length > 0) {
            int len = blocksize;
            len = this.file.read(readbuffer, 0, len);
            this.currentPos += (long)len;
            if (len < 0) break;
            this.inflater.setInput(readbuffer, 0, len);
            len = length;
            try {
                len = this.inflater.inflate(buffer, p, len);
            }
            catch (DataFormatException e) {
                throw (IOException)new IOException("Error inflating pos: " + pos + " length: " + length + " error: " + e.toString() + " in " + this.fileName).initCause(e);
            }
            p += len;
            length -= len;
        }
        return pos + (long)this.inflater.getTotalIn() + 10L + 8L;
    }

    private String readEntryName(byte[] buffer) throws IOException {
        if (buffer[0] == 0) {
            return null;
        }
        String entryName = new String(buffer, 0, 100).trim();
        if (entryName.indexOf("..") >= 0) {
            throw new IOException("Insecure entry name: " + entryName + " in " + this.fileName);
        }
        for (int i = 0; i < entryName.length(); ++i) {
            char c = entryName.charAt(i);
            if (Character.isLetterOrDigit(c) || ".-_()[]{}+#@/".indexOf(c) >= 0) continue;
            throw new IOException("Invalid entry name: " + entryName + " in " + this.fileName + " pos: " + this.file.getFilePointer());
        }
        return entryName;
    }

    public synchronized long scanIndex(long pos, IndexEntryVisitor visitor, boolean all) throws IOException {
        long length;
        this.scannedEntriesCount = 0;
        IndexScanner scanner = new IndexScanner(visitor);
        this.fileLengthCached = length = this.file != null ? this.file.length() : 0L;
        if (pos >= length) {
            return -1L;
        }
        while (pos < length && !visitor.isStopped()) {
            block19: {
                String entryName;
                long posData;
                block18: {
                    if (this.compressed) {
                        try {
                            posData = this.readFullyCompressed(this.buffer, pos, 512);
                            break block18;
                        }
                        catch (IOException e) {
                            this.warnTruncate(visitor, "reading compressed entry", pos, e);
                            break;
                        }
                    }
                    this.seek(pos);
                    this.readFully(this.buffer);
                    posData = pos + 512L;
                }
                try {
                    entryName = this.readEntryName(this.buffer);
                }
                catch (IOException e) {
                    this.warnTruncate(visitor, "reading entry name", pos, e);
                    break;
                }
                if (entryName == null) {
                    if (pos + 1024L < length && !this.readOnly) {
                        e = new IOException("Empty entry at " + pos + " length: " + length);
                        this.warnTruncate(visitor, "reading entry name", pos, e);
                    }
                    this.appendPos = pos;
                    return -1L;
                }
                try {
                    this.checkHeaderChecksum();
                }
                catch (IOException e) {
                    this.warnTruncate(visitor, "header checksum", pos, e);
                    break;
                }
                long entryLength = this.readLong(124);
                FileEntry entry = new FileEntry(this, entryName, pos, entryLength);
                try {
                    scanner.visitEntry(this, entry);
                }
                catch (IOException e) {
                    this.warnTruncate(visitor, "reading entry", pos, e);
                    break;
                }
                long skipLength = TarFile.roundUp(entryLength, 512L);
                if (this.compressed) {
                    if (skipLength > 0L) {
                        try {
                            byte[] data = new byte[(int)skipLength];
                            pos = this.readFullyCompressed(data, posData, (int)skipLength);
                            break block19;
                        }
                        catch (IOException e) {
                            this.warnTruncate(visitor, "reading compressed entry", pos, e);
                            break;
                        }
                    }
                    pos = posData;
                } else {
                    pos = posData + skipLength;
                }
            }
            ++this.scannedEntriesCount;
            if (scanner.isTransactionPending() || all) continue;
            return pos;
        }
        this.writeEndBlocks(pos);
        return pos;
    }

    public int getScannedEntriesCount() {
        return this.scannedEntriesCount;
    }

    private void readFully(byte[] buffer) throws IOException {
        this.file.readFully(buffer);
        this.currentPos += (long)buffer.length;
    }

    private void warnTruncate(IndexEntryVisitor visitor, String message, long pos, IOException e) throws IOException {
        message = "Error " + message + " " + this.toString();
        if (visitor.getFailOnError()) {
            log.warn(message, (Throwable)e);
            throw e;
        }
        if (this.readOnly) {
            log.warn(message);
        } else {
            log.warn(message, (Throwable)e);
            String backupFileName = TarUtils.autoBackup(this.fileName);
            log.warn("Backed up up file " + this.fileName + " to " + backupFileName);
            log.error("Truncating tar file " + this.fileName + " from " + this.fileLengthCached + " to " + pos);
            if (!this.compressed && pos > 0L) {
                this.setLength(pos);
            }
        }
    }

    public synchronized HashMap<String, FileEntry> readEntries() throws IOException {
        long pos;
        long skipLength;
        if (this.compressed) {
            throw new IOException("Currently not supported in compressed mode in " + this.fileName);
        }
        this.entries = new HashMap();
        long length = this.file.length();
        for (pos = 0L; pos < length; pos += skipLength + 512L) {
            this.seek(pos);
            this.readFully(this.buffer);
            String entryName = this.readEntryName(this.buffer);
            if (entryName == null) break;
            this.checkHeaderChecksum();
            long entryLength = this.readLong(124);
            FileEntry entry = new FileEntry(this, entryName, pos, entryLength);
            this.entries.put(entryName, entry);
            skipLength = TarFile.roundUp(entryLength, 512L);
        }
        this.writeEndBlocks(pos);
        return this.entries;
    }

    private void checkHeaderChecksum() throws IOException {
        int checksum = this.getChecksum(157);
        long got = this.readLong(148);
        if (got != (long)checksum && got != (long)(checksum = this.getChecksum(512))) {
            throw new IOException("Header checksum mismatch, expected: " + checksum + " got: " + got + " in " + this.fileName);
        }
    }

    private void writeEndBlocks(long pos) throws IOException {
        this.appendPos = pos;
        if (this.readOnly) {
            return;
        }
        if (this.compressed) {
            this.seek(pos);
            Arrays.fill(this.buffer, (byte)0);
            this.writeData(this.buffer);
            this.fileLengthCached = this.writeData(this.buffer);
        } else {
            this.setLength(pos + 1024L);
        }
    }

    static long roundUp(long x, long blockSizePowerOf2) {
        return x + blockSizePowerOf2 - 1L & -blockSizePowerOf2;
    }

    public synchronized InputStream getInputStream(long posMetaData, long length) throws IOException {
        long posData = this.compressed ? this.readFullyCompressed(this.buffer, posMetaData, 512) : posMetaData + 512L;
        return TarInputStream.getInputStream(this, posData, length);
    }

    public static void readFully(InputStream in, byte[] b, int len) throws IOException {
        int off = 0;
        while (len > 0) {
            int l = Math.min(len, 4096);
            if ((l = in.read(b, off, l)) < 0) {
                throw new IOException("Unexpected EOF");
            }
            len -= l;
            off += l;
        }
    }

    synchronized void readFully(long pos, byte[] b, int off, int len) throws IOException {
        try {
            this.seek(pos);
            this.file.readFully(b, off, len);
            this.currentPos += (long)len;
        }
        catch (IOException e) {
            TarFile.handleDiskFull(e);
            this.currentPos = -1L;
            log.error("Failed to read, file " + this.toString() + " pos: " + pos + " length: " + len);
            throw e;
        }
    }

    private long readLong(int pos) {
        int b;
        int i;
        long value = 0L;
        if (this.buffer[pos] == -128) {
            for (int x = 1; x < 12; ++x) {
                value = value << 8 | (long)(this.buffer[x + pos] & 0xFF);
            }
            return value;
        }
        for (i = pos; i < pos + 12 && (b = this.buffer[i] & 0xFF) <= 48; ++i) {
        }
        while (i < pos + 12 && (b = this.buffer[i] & 0xFF) != 32 && b != 0) {
            value = value << 3 | (long)(b - 48);
            ++i;
        }
        return value;
    }

    private void writeLong(int pos, int length, long value) throws IOException {
        String octal = Long.toOctalString(value);
        if (octal.length() >= length) {
            if (value < 0L) {
                throw new IOException(this.fileName + " negative values not supported: " + value);
            }
            this.buffer[pos] = -128;
            for (int x = length - 1; x > 0; --x) {
                this.buffer[pos + x] = (byte)value;
                value >>= 8;
            }
        } else {
            Arrays.fill(this.buffer, pos, pos + length, (byte)32);
            int skip = length - octal.length() - 1;
            byte[] oct = octal.getBytes();
            System.arraycopy(oct, 0, this.buffer, pos + skip, oct.length);
        }
    }

    private void setLength(long newLength) throws IOException {
        try {
            if (EXTEND_WITH_WRITE && newLength > this.fileLengthCached && newLength <= this.fileLengthCached + (long)EMPTY_BUFFER.length) {
                long old = this.getFilePointer();
                this.seek(this.fileLengthCached);
                this.write(EMPTY_BUFFER, 0, (int)(newLength - this.fileLengthCached));
                this.seek(old);
            } else {
                this.file.setLength(newLength);
                this.sync();
            }
            this.fileLengthCached = newLength;
        }
        catch (IOException e) {
            TarFile.handleDiskFull(e);
            throw e;
        }
    }

    private void sync() throws IOException {
        if (this.sync) {
            this.file.getFD().sync();
        }
    }

    public void seek(long pos) throws IOException {
        if (this.file == null || this.currentPos == pos && CACHE_POSITION) {
            return;
        }
        this.file.seek(pos);
        this.currentPos = pos;
    }

    public synchronized FileEntry appendEntry(String entryName, long len, long time) throws IOException {
        if (this.compressed) {
            throw new IOException("Feature not supported in " + this.fileName);
        }
        long posStart = this.appendMetaData(entryName, len, time);
        if (len > 0L) {
            len = TarFile.roundUp(len, 512L);
        }
        FileEntry entry = new FileEntry(this, entryName, posStart, len);
        this.entries.put(entryName, entry);
        long pos = posStart + 512L + len;
        this.writeEndBlocks(pos);
        return entry;
    }

    public synchronized void appendEntry(String entryName, byte[] data, long time) throws IOException {
        long pos = this.append(entryName, data, time);
        FileEntry entry = new FileEntry(this, entryName, pos, data.length);
        this.entries.put(entryName, entry);
    }

    public synchronized long append(String entryName, byte[] data, long time) throws IOException {
        long posNext;
        int len = data.length;
        long posStart = this.appendMetaData(entryName, len, time);
        if (this.compressed) {
            if (len == 0) {
                posNext = this.getFilePointer();
            } else {
                len = (int)TarFile.roundUp(len, 512L);
                byte[] d2 = new byte[len];
                System.arraycopy(data, 0, d2, 0, data.length);
                posNext = this.writeData(d2);
            }
        } else if (len > 0) {
            posNext = this.writeData(data);
            int fillerLength = (int)(TarFile.roundUp(len, 512L) - (long)len);
            if (fillerLength > 0) {
                posNext += (long)fillerLength;
            }
        } else {
            posNext = posStart + 512L;
        }
        this.writeEndBlocks(posNext);
        return posStart;
    }

    private long getFilePointer() throws IOException {
        if (this.currentPos < 0L || !CACHE_POSITION) {
            this.currentPos = this.file.getFilePointer();
        }
        return this.currentPos;
    }

    private long writeData(byte[] data) throws IOException {
        try {
            if (this.compressed) {
                this.writeCompressed(data, 0, data.length);
            } else {
                this.write(data);
                this.sync();
            }
            return this.currentPos;
        }
        catch (IOException e) {
            TarFile.handleDiskFull(e);
            throw e;
        }
    }

    private void writeCompressed(byte[] data, int pos, int length) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        out.write(31);
        out.write(139);
        out.write(8);
        out.write(0);
        out.write(0);
        out.write(0);
        out.write(0);
        out.write(0);
        out.write(4);
        out.write(0);
        this.crc.reset();
        this.crc.update(data, pos, length);
        int crcValue = (int)this.crc.getValue();
        this.deflater.reset();
        this.deflater.setInput(data, pos, length);
        this.deflater.finish();
        byte[] output = new byte[length * 2];
        int compressed = this.deflater.deflate(output, 0, output.length);
        out.write(output, 0, compressed);
        out.write((byte)crcValue);
        out.write((byte)(crcValue >> 8));
        out.write((byte)(crcValue >> 16));
        out.write((byte)(crcValue >> 24));
        out.write((byte)length);
        out.write((byte)(length >> 8));
        out.write((byte)(length >> 16));
        out.write((byte)(length >>> 24));
        byte[] result = out.toByteArray();
        this.write(result);
        this.sync();
    }

    private long appendMetaData(String entryName, long len, long time) throws IOException {
        if (this.appendPos < 0L) {
            throw new IOException("File not scanned before appending in " + this.fileName);
        }
        long posStart = this.appendPos;
        this.seek(this.appendPos);
        Arrays.fill(this.buffer, (byte)0);
        if (entryName.length() > 100) {
            throw new IOException("entry name length > 100 not supported in " + this.fileName);
        }
        byte[] name = entryName.getBytes();
        System.arraycopy(name, 0, this.buffer, 0, name.length);
        this.updateLength(len, time);
        this.writeData(this.buffer);
        return posStart;
    }

    private void updateLength(long len, long time) throws IOException {
        System.arraycopy(LENGTH_TEMPLATE, 0, this.buffer, 100, 23);
        this.writeLong(124, 12, len);
        this.writeLong(136, 12, time / 1000L);
        Arrays.fill(this.buffer, 148, 156, (byte)32);
        this.buffer[156] = 48;
        int checksum = this.getChecksum(157);
        this.writeLong(148, 8, checksum);
    }

    private int getChecksum(int endIndex) {
        int i;
        int checksum = 256;
        for (i = 0; i < 148; ++i) {
            checksum += this.buffer[i];
        }
        for (i = 156; i < endIndex; ++i) {
            checksum += this.buffer[i];
        }
        return checksum;
    }

    private void write(byte[] data) throws IOException {
        try {
            this.file.write(data);
            this.currentPos += (long)data.length;
            this.fileLengthCached = Math.max(this.fileLengthCached, this.currentPos);
        }
        catch (IOException e) {
            TarFile.handleDiskFull(e);
            throw e;
        }
    }

    public synchronized void write(byte[] buffer, int off, int length) throws IOException {
        try {
            this.file.write(buffer, off, length);
            this.currentPos += (long)length;
            this.fileLengthCached = Math.max(this.fileLengthCached, this.currentPos);
            this.sync();
        }
        catch (IOException e) {
            TarFile.handleDiskFull(e);
            throw e;
        }
    }

    public synchronized void close() {
        if (this.file != null) {
            try {
                long len = this.file.length();
                this.file.close();
                if (unclosed != null) {
                    String key = this.fileName + " " + System.identityHashCode(this);
                    unclosed.remove(key);
                }
                if (len == 0L && !this.readOnly) {
                    TarUtils.deleteFileWithRetry(new File(this.fileName));
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.file = null;
        }
    }

    public synchronized FileEntry getEntry(String entryName) {
        return this.entries.get(entryName);
    }

    public String getFileName() {
        return this.fileName;
    }

    public int getId() {
        return this.id;
    }

    public synchronized void renameTo(String newFileName) throws IOException {
        this.close();
        TarUtils.deleteFileWithRetry(new File(newFileName));
        File oldFile = new File(this.fileName);
        File newFile = new File(newFileName);
        TarUtils.renameWithRetry(oldFile, newFile);
        this.fileName = newFileName;
        this.open();
    }

    public synchronized void deleteLater(boolean createDeleteFile) throws IOException {
        this.close();
        File file = new File(this.fileName);
        OptimizeThread.getInstance().deleteLater(file, createDeleteFile);
    }

    synchronized void updateEntryLength(long entryPos, long len, long time) throws IOException {
        this.seek(entryPos);
        this.readFully(this.buffer);
        this.updateLength(len, time);
        this.seek(entryPos);
        this.write(this.buffer);
        this.sync();
        long pos = entryPos + 512L + TarFile.roundUp(len, 512L);
        this.writeEndBlocks(pos);
    }

    public synchronized long getAppendPos() {
        return this.appendPos;
    }

    public synchronized void setAppendPos(long pos) {
        this.appendPos = pos;
    }

    public boolean getCompressed() {
        return this.compressed;
    }

    public synchronized long getOptimizePos() {
        return this.optimizePos;
    }

    public synchronized void setOptimizePos(long optimizePos) {
        if (optimizePos != this.optimizePos) {
            this.optimizePos = optimizePos;
            long now = System.currentTimeMillis();
            if (now > this.lastOptimizeLog + 10000L) {
                this.lastOptimizeLog = now;
                log.info(this.toString() + " optimize: " + optimizePos);
            }
        }
    }

    public synchronized long getFileLength() throws IOException {
        this.fileLengthCached = this.file.length();
        return this.fileLengthCached;
    }

    public long getFileLengthCached() {
        return this.fileLengthCached;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public boolean getNeedToOptimize() {
        return this.needToOptimize;
    }

    public void setNeedToOptimize(boolean needToOptimize) {
        this.needToOptimize = needToOptimize;
    }

    public void reopen(String mode) throws IOException {
        if (this.file != null) {
            this.file.close();
        }
        this.mode = mode;
        this.open();
    }

    public long getLastModified() {
        File f = new File(this.fileName);
        return f.lastModified();
    }

    public RandomAccessFile setRandomAccessFile(RandomAccessFile newInstance) {
        RandomAccessFile old = this.file;
        this.file = newInstance;
        return old;
    }

    public void setReadOnly() {
        File f;
        if (this.file != null) {
            try {
                this.file.close();
            }
            catch (IOException e) {
                TarFile.handleDiskFull(e);
                log.error("Closing the file failed: " + this.fileName, (Throwable)e);
            }
            this.file = null;
        }
        if (!(f = new File(this.fileName)).exists()) {
            log.error("Can not make read-only because the file doesn't exist: " + this.fileName);
        }
        if (!f.setReadOnly()) {
            log.error("Setting the read-only flag failed for " + this.fileName);
        }
        try {
            this.reopen("r");
        }
        catch (IOException e) {
            TarFile.handleDiskFull(e);
            log.error("Re-opening the file failed: " + this.fileName, (Throwable)e);
        }
    }

    private static void handleDiskFull(IOException e) {
        LowDiskSpaceMonitor.getInstance().handleDiskFull(e);
    }

    public void truncate(long pos) throws IOException {
        try {
            if (this.readOnly) {
                this.reopen("rw");
            }
            this.file.setLength(pos);
        }
        catch (IOException e) {
            TarFile.handleDiskFull(e);
            throw e;
        }
    }

    static {
        CACHE_POSITION = Boolean.valueOf(System.getProperty("com.day.crx.persistence.tar.CachePosition", "true"));
        EXTEND_WITH_WRITE = Boolean.valueOf(System.getProperty("com.day.crx.persistence.tar.ExtendWithWrite", "true"));
        LENGTH_TEMPLATE = "   777 \u0000     0 \u0000     0 ".getBytes();
        EMPTY_BUFFER = new byte[4096];
        log = LoggerFactory.getLogger(TarFile.class);
    }
}

